/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SharedUtils;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.Style;
import oracle.sdovis.util.JDBCUtil;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class Util {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String[] DDLKeys = new String[]{"CREATE ", "DROP ", "TRUNCATE ", "ALTER ", "ANALYZE ", "AUDIT ", "COMMENT ", "GRANT ", "NOAUDIT ", "RENAME ", "REVOKE ", "DELETE ", "INSERT ", "UPDATE ", "LOCK ", "CALL "};
    private static final double HalfPI = 1.5707963267948966;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] convert(String string) {
        int n = 0;
        double[] dArray = new double[string.length() / 2 + 1];
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string.trim()));
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(59, 59);
        try {
            while (streamTokenizer.nextToken() == -2) {
                dArray[n++] = streamTokenizer.nval;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            double[] dArray2 = null;
            return dArray2;
        }
        finally {
            streamTokenizer = null;
        }
        if (n == 0) {
            return null;
        }
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i];
        }
        dArray = null;
        return dArray3;
    }

    public static ArrayList splitBy(String string, String string2) {
        return (ArrayList)SharedUtils.splitBy(string, string2);
    }

    public static Shape getShape(double[] dArray, boolean bl) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
        for (int i = 1; i < dArray.length / 2; ++i) {
            generalPath.lineTo((float)dArray[i * 2], (float)dArray[i * 2 + 1]);
        }
        if (bl) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public static Rectangle2D.Double mbr(double[] dArray) {
        double d;
        double d2;
        double d3 = d2 = dArray[0];
        double d4 = d = dArray[1];
        for (int i = 1; i < dArray.length / 2; ++i) {
            if (d3 > dArray[i * 2]) {
                d3 = dArray[i * 2];
            }
            if (d2 < dArray[i * 2]) {
                d2 = dArray[i * 2];
            }
            if (d4 > dArray[i * 2 + 1]) {
                d4 = dArray[i * 2 + 1];
            }
            if (!(d < dArray[i * 2 + 1])) continue;
            d = dArray[i * 2 + 1];
        }
        return new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
    }

    public static byte[] readBinaryFromURL(URL uRL) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDefaultUseCaches(false);
            InputStream inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[4096];
            int n = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            n = inputStream.read(byArray);
            while (n > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            httpURLConnection.disconnect();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    public static byte[] readBinaryFromURL(String string) {
        try {
            URL uRL = new URL(string);
            return Util.readBinaryFromURL(uRL);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    public static byte[] readFile(String string) throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>(32);
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = 0;
        FileInputStream fileInputStream = new FileInputStream(string);
        while ((n = fileInputStream.read(byArray)) == 2048) {
            vector.addElement(byArray);
            byArray = new byte[2048];
        }
        fileInputStream.close();
        if (n <= 0) {
            return null;
        }
        byte[] byArray2 = new byte[vector.size() * 2048 + n];
        int n3 = 0;
        while (n3 < vector.size()) {
            System.arraycopy(vector.elementAt(n3), 0, byArray2, n2, 2048);
            ++n3;
            n2 += 2048;
        }
        System.arraycopy(byArray, 0, byArray2, n2, n);
        return byArray2;
    }

    public static Connection connect(String string, String string2, String string3, int n) {
        String string4 = "jdbc:oracle:oci8:@" + string3;
        Connection connection = null;
        if (n <= 0) {
            n = 32;
        }
        try {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            connection = DriverManager.getConnection(string4, string, string2);
            ((OracleConnection)connection).setDefaultRowPrefetch(n);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (Exception exception) {
            log.severe("Failed to connect using TNS name: " + string3);
            log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    public static Connection connect(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        String string7 = Util.getConnStr(string6, string, string3, string2);
        Connection connection = null;
        if (n <= 0) {
            n = 32;
        }
        try {
            if (!DriverManager.getDrivers().hasMoreElements()) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            connection = DriverManager.getConnection(string7, string4, string5);
            ((OracleConnection)connection).setDefaultRowPrefetch(n);
        }
        catch (SQLException sQLException) {
            log.log(Level.WARNING, sQLException.getMessage(), sQLException);
            log.warning("connecting to database using jdbc thin driver...");
            string7 = Util.getConnStr("thin", string, string3, string2);
            try {
                if (!DriverManager.getDrivers().hasMoreElements()) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                connection = DriverManager.getConnection(string7, string4, string5);
                ((OracleConnection)connection).setDefaultRowPrefetch(n);
            }
            catch (SQLException sQLException2) {
                log.log(Level.SEVERE, sQLException2.getMessage(), sQLException2);
                return null;
            }
        }
        catch (Error error) {
            log.log(Level.WARNING, error.getMessage(), error);
            log.warning("connecting to database using jdbc thin driver...");
            string7 = Util.getConnStr("thin", string, string3, string2);
            try {
                if (!DriverManager.getDrivers().hasMoreElements()) {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                connection = DriverManager.getConnection(string7, string4, string5);
                ((OracleConnection)connection).setDefaultRowPrefetch(n);
            }
            catch (SQLException sQLException) {
                log.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                return null;
            }
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return connection;
    }

    public static String getJDBCDriverVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDriverVersion();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            return null;
        }
    }

    public static String getDBVersion(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            return null;
        }
    }

    public static boolean isPre9i(Connection connection) {
        String string = Util.getDBVersion(connection);
        if (string.indexOf("Oracle8i") >= 0) {
            return true;
        }
        if (string.indexOf("Oracle9i") >= 0) {
            return false;
        }
        return string.indexOf("Oracle7") >= 0;
    }

    public static boolean is9i(Connection connection) {
        String string = Util.getDBVersion(connection);
        return string.indexOf("Oracle9i") >= 0;
    }

    public static boolean is10g(Connection connection) {
        String string = Util.getDBVersion(connection);
        return string.indexOf("Oracle10") >= 0 && string.indexOf(" 10.") > 0;
    }

    public static boolean is11g(Connection connection) {
        String string = Util.getDBVersion(connection);
        return string.indexOf(" 11.") > 0;
    }

    public static boolean is10gOrAfter(Connection connection) {
        String string = Util.getDBVersion(connection);
        return string.indexOf(" 10.") > 0 || string.indexOf(" 11.") > 0;
    }

    public static boolean is11gOrAfter(Connection connection) {
        String string = Util.getDBVersion(connection);
        return string.indexOf(" 11.") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentSchema(Connection connection, String string) {
        if (connection == null) {
            return null;
        }
        String string2 = "SELECT SYS_CONTEXT('USERENV','CURRENT_SCHEMA') from DUAL";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                String string3;
                String string4 = string3 = resultSet.getString(1);
                return string4;
            }
            log.warning("Empty result set when querying CURRENT_SCHEMA.");
            String string5 = null;
            return string5;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
            String string6 = null;
            return string6;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isGeodetic(int n) {
        return n > 0 && n < 32768;
    }

    public static String getConnStr(String string, String string2, String string3, String string4) {
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0 || string == null) {
            return "jdbc:oracle:oci8:@";
        }
        if (string.equalsIgnoreCase("default")) {
            return "jdbc:oracle:oci8:@";
        }
        if (string.equalsIgnoreCase("thin")) {
            return "jdbc:oracle:thin:@" + string2 + ":" + string3 + ":" + string4;
        }
        if (string.equalsIgnoreCase("oci8") || string.equalsIgnoreCase("oci")) {
            return "jdbc:oracle:oci8:@(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = (PROTOCOL = TCP)(HOST = " + string2 + ")(PORT = " + string3 + ")))" + "(CONNECT_DATA = (SID = " + string4 + ")))";
        }
        if (string.equalsIgnoreCase("kprb")) {
            return null;
        }
        return null;
    }

    public static void center(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        component.setLocation(n, n2);
    }

    static void which(String string) {
    }

    public static boolean isQueryAllowed(String string) {
        if (string == null || string.length() < 10) {
            return false;
        }
        string = string.toUpperCase();
        String[] stringArray = string.split("\\s");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) continue;
            string2 = string2 + " ";
            for (int j = 0; j < DDLKeys.length; ++j) {
                if (!DDLKeys[j].equals(string2) && !(";" + DDLKeys[j]).equals(string2)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] convertMBR(double[] dArray, int n, int n2, Connection connection) {
        if (dArray == null) {
            return null;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        if (Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4)) {
            return dArray;
        }
        double[] dArray2 = null;
        String string = "select sdo_cs.transform(MDSYS.SDO_GEOMETRY( 2003,?, NULL,MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3),MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?)),?) from dual";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setDouble(2, d);
            preparedStatement.setDouble(3, d2);
            preparedStatement.setDouble(4, d3);
            preparedStatement.setDouble(5, d4);
            preparedStatement.setInt(6, n2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                STRUCT sTRUCT = JDBCUtil.getOracleSTRUCT(resultSet, 1);
                JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
                dArray2 = jGeometry.getMBR();
            }
        }
        catch (Exception exception) {
            log.warning("Exception while transforming input MBR: " + exception);
            double[] dArray3 = null;
            return dArray3;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return dArray2;
    }

    public static Point2D getLinePoint(double[] dArray, double d) {
        double d2 = d;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (dArray == null || dArray.length < 4) {
            return null;
        }
        if (d < 0.0 || d > 1.0) {
            return null;
        }
        double d7 = 0.0;
        for (int i = 0; i < dArray.length / 2 - 1; ++i) {
            d3 = dArray[2 * i];
            d4 = dArray[2 * i + 1];
            d5 = dArray[2 * i + 2];
            d6 = dArray[2 * i + 3];
            d7 += Math.sqrt(Math.pow(d3 - d5, 2.0) + Math.pow(d4 - d6, 2.0));
        }
        double d8 = d7 * d;
        double d9 = 0.0;
        for (int i = 0; i < dArray.length / 2 - 1; ++i) {
            d5 = dArray[2 * i + 2];
            d3 = dArray[2 * i];
            double d10 = d5 - d3;
            d6 = dArray[2 * i + 3];
            d4 = dArray[2 * i + 1];
            double d11 = d6 - d4;
            double d12 = Math.sqrt(d10 * d10 + d11 * d11);
            if (!((d9 += d12) >= d8)) continue;
            double d13 = d8 - (d9 - d12);
            d2 = d13 / d12;
            break;
        }
        double d14 = d3 + (d5 - d3) * d2;
        double d15 = d4 + (d6 - d4) * d2;
        Point2D.Double double_ = new Point2D.Double(d14, d15);
        return double_;
    }

    public static double[] getLineSegment(double[] dArray, double d) {
        double d2 = d;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (dArray == null || dArray.length < 4) {
            return null;
        }
        if (d < 0.0 || d > 1.0) {
            return null;
        }
        double d7 = 0.0;
        for (int i = 0; i < dArray.length / 2 - 1; ++i) {
            d3 = dArray[2 * i];
            d4 = dArray[2 * i + 1];
            d5 = dArray[2 * i + 2];
            d6 = dArray[2 * i + 3];
            d7 += Math.sqrt(Math.pow(d3 - d5, 2.0) + Math.pow(d4 - d6, 2.0));
        }
        double d8 = d7 * d;
        double d9 = 0.0;
        for (int i = 0; i < dArray.length / 2 - 1; ++i) {
            d5 = dArray[2 * i + 2];
            d3 = dArray[2 * i];
            double d10 = d5 - d3;
            d6 = dArray[2 * i + 3];
            d4 = dArray[2 * i + 1];
            double d11 = d6 - d4;
            double d12 = Math.sqrt(d10 * d10 + d11 * d11);
            if (!((d9 += d12) >= d8)) continue;
            double[] dArray2 = new double[]{d3, d4, d5, d6};
            return dArray2;
        }
        return null;
    }

    public static double[] transform(Connection connection, double d, double d2, double d3, int n, int n2) {
        double d4 = d3 * 0.5;
        double[] dArray = Util.transform(connection, d - d4, d2 - d4, d + d4, d2 + d4, n, n2);
        if (dArray == null || dArray.length < 3) {
            return null;
        }
        double d5 = (dArray[0] + dArray[2]) * 0.5;
        double d6 = (dArray[1] + dArray[3]) * 0.5;
        double d7 = Math.abs(dArray[3] - dArray[1]);
        dArray[0] = d5;
        dArray[1] = d6;
        dArray[2] = d7;
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] transform(Connection connection, double d, double d2, double d3, double d4, int n, int n2) {
        String string = "SELECT sdo_cs.transform(MDSYS.SDO_GEOMETRY(2003, ?, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3),MDSYS.SDO_ORDINATE_ARRAY(?, ?, ?, ?)), ?) FROM dual";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setDouble(2, d);
            preparedStatement.setDouble(3, d2);
            preparedStatement.setDouble(4, d3);
            preparedStatement.setDouble(5, d4);
            preparedStatement.setInt(6, n2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                STRUCT sTRUCT = JDBCUtil.getOracleSTRUCT(resultSet, 1);
                JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
                double[] dArray = jGeometry.getMBR();
                double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3]};
                double[] dArray3 = dArray2;
                return dArray3;
            }
            double[] dArray = null;
            return dArray;
        }
        catch (Exception exception) {
            log.warning("unable to transform rectangle due to: " + exception.getMessage());
            double[] dArray = null;
            return dArray;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] transform(Connection connection, double d, double d2, int n, int n2) {
        String string = "SELECT sdo_cs.transform(MDSYS.SDO_GEOMETRY(2001, ?,MDSYS.SDO_POINT_TYPE(?,?,null),null,null), ?) FROM DUAL";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setDouble(2, d);
            preparedStatement.setDouble(3, d2);
            preparedStatement.setInt(4, n2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                JGeometry jGeometry = JGeometry.load((STRUCT)((STRUCT)resultSet.getObject(1)));
                double[] dArray = jGeometry.getMBR();
                double[] dArray2 = new double[]{dArray[0], dArray[1]};
                double[] dArray3 = dArray2;
                return dArray3;
            }
            double[] dArray = null;
            return dArray;
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            double[] dArray = null;
            return dArray;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSDOGeometry transform(Connection connection, JSDOGeometry jSDOGeometry, int n, int n2) {
        if (n == n2 || n2 == 0 || n == 0) {
            return jSDOGeometry;
        }
        String string = "select sdo_cs.transform(?, ?) from dual";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            JSDOGeometry jSDOGeometry2;
            preparedStatement = connection.prepareStatement(string);
            Object[] objectArray = Util.createDBGeomDescriptors(connection);
            STRUCT sTRUCT = JGeometry.store((JGeometry)jSDOGeometry, (Connection)connection, (Object[])objectArray);
            preparedStatement.setObject(1, sTRUCT);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            JSDOGeometry jSDOGeometry3 = jSDOGeometry2 = JDBCUtil.loadGeometry(resultSet, 1, false);
            return jSDOGeometry3;
        }
        catch (Exception exception) {
            log.severe("error transforming geometry: " + exception);
            JSDOGeometry jSDOGeometry4 = jSDOGeometry;
            return jSDOGeometry4;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final double dist(double[] dArray, double[] dArray2, double d, double d2, double d3) {
        double d4 = 1.5707963267948966 - Math.abs(dArray[1]) < 1.0E-10 ? dArray[1] : Math.atan(d2 * Math.tan(dArray[1]));
        double d5 = 1.5707963267948966 - Math.abs(dArray2[1]) < 1.0E-10 ? dArray2[1] : Math.atan(d2 * Math.tan(dArray2[1]));
        double d6 = (d4 + d5) / 2.0;
        double d7 = (d4 - d5) / 2.0;
        double d8 = Math.abs(dArray[0] - dArray2[0]);
        if (d8 > Math.PI) {
            d8 = Math.PI * 2 - d8;
        }
        if ((d8 /= 2.0) < 5.0E-8 && Math.abs(d7) < 5.0E-8) {
            return 0.0;
        }
        if (1.5707963267948966 - d8 < 5.0E-8 && Math.abs(d6) < 5.0E-8 || 1.5707963267948966 - Math.abs(d7) < 5.0E-8) {
            return -1.0;
        }
        double d9 = Math.sin(d6);
        double d10 = Math.cos(d6);
        double d11 = Math.sin(d7);
        double d12 = Math.cos(d7);
        double d13 = Math.sin(d8);
        double d14 = d11 * d11 + d13 * d13 * (d12 * d12 - d9 * d9);
        double d15 = Math.acos(1.0 - 2.0 * d14);
        double d16 = Math.sin(d15);
        double d17 = 2.0 * (1.0 - 2.0 * d14);
        double d18 = 2.0 * d9 * d9 * d12 * d12 / (1.0 - d14);
        double d19 = 2.0 * d11 * d11 * d10 * d10 / d14;
        double d20 = d18 + d19;
        double d21 = d18 - d19;
        double d22 = d15 / d16;
        double d23 = 4.0 * d22 * d22;
        double d24 = d23 * d17;
        return d * d16 * (d22 - d3 * (d22 * d20 - d21) / 4.0 + d3 * d3 * (d20 * (d24 + (d22 - (d24 - d17) / 2.0) * d20) - d21 * (2.0 * d23 + d17 * d21) + d23 * d20 * d21) / 64.0);
    }

    public static Field getFieldFromResultSet(int n, ResultSet resultSet, int n2) throws SQLException, IOException {
        Field field = new Field();
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                field.setString(resultSet.getString(n2));
                return field;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                if (resultSet.getObject(n2) == null) {
                    return field;
                }
                field.setDouble(resultSet.getDouble(n2));
                return field;
            }
            case 4: {
                if (resultSet.getObject(n2) == null) {
                    return field;
                }
                field.setInt(resultSet.getInt(n2));
                return field;
            }
            case 6: {
                if (resultSet.getObject(n2) == null) {
                    return field;
                }
                field.setFloat(resultSet.getFloat(n2));
                return field;
            }
            case -5: {
                if (resultSet.getObject(n2) == null) {
                    return field;
                }
                field.setLong(resultSet.getLong(n2));
                return field;
            }
            case 5: {
                if (resultSet.getObject(n2) == null) {
                    return field;
                }
                field.setShort(resultSet.getShort(n2));
                return field;
            }
            case 16: {
                if (resultSet.getObject(n2) == null) {
                    return field;
                }
                field.setBoolean(resultSet.getBoolean(n2));
                return field;
            }
            case 91: {
                field.setDate(resultSet.getDate(n2).getTime());
                return field;
            }
            case 92: {
                field.setDate(resultSet.getTime(n2).getTime());
                return field;
            }
            case 93: {
                field.setDate(resultSet.getTimestamp(n2).getTime());
                return field;
            }
            case 2005: {
                field.setString(Util.getClobContents(resultSet.getClob(n2)));
                return field;
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getClobContents(Clob clob) throws SQLException, IOException {
        if (clob == null) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            int n = ((CLOB)clob).getChunkSize();
            StringBuffer stringBuffer = new StringBuffer(n);
            char[] cArray = new char[n];
            bufferedReader = new BufferedReader(clob.getCharacterStream());
            int n2 = -1;
            while ((n2 = bufferedReader.read(cArray, 0, n)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public static final void putClobContents(Clob clob, String string) throws SQLException, IOException {
        Writer writer = clob.setCharacterStream(1L);
        writer.write(string);
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBlobContents(Blob blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            inputStream = blob.getBinaryStream();
            int n = -1;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static final void putBlobContents(Blob blob, byte[] byArray) throws SQLException, IOException {
        OutputStream outputStream = blob.setBinaryStream(1L);
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
    }

    public static final Style getStyle(String string, StyleCache styleCache, Hashtable hashtable) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase();
        Style style = null;
        if (hashtable != null) {
            style = (Style)hashtable.get(string);
        }
        if (style == null && styleCache != null) {
            style = styleCache.get(string);
        }
        return style;
    }

    public static final boolean isBindingParameterAllowed(Object object) {
        return true;
    }

    public static Object[] createDBGeomDescriptors(Connection connection) throws SQLException {
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
        StructDescriptor structDescriptor2 = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)connection);
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)connection);
        ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)connection);
        return new Object[]{structDescriptor, structDescriptor2, arrayDescriptor, arrayDescriptor2};
    }

    public static JGeometry processSRIDConversion(String string, JGeometry jGeometry, int n) throws Exception {
        if (jGeometry == null) {
            return null;
        }
        if (jGeometry.getSRID() <= 0 || n <= 0) {
            return jGeometry;
        }
        if (jGeometry.isPoint()) {
            double[] dArray = jGeometry.getPoint();
            double[] dArray2 = Util.processPointSRIDConversion(string, jGeometry.getSRID() + "", n + "", dArray[0], dArray[1]);
            if (dArray2 == null) {
                return null;
            }
            return new JGeometry(dArray2[0], dArray2[1], n);
        }
        String string2 = "select sdo_cs.transform(?,?) from dual";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(string, null);
            if (connection.isClosed()) {
                log.severe("connection obtained is already closed!");
                throw new Exception("error obtaining connection!");
            }
            statement = connection.prepareStatement(string2);
            STRUCT sTRUCT = null;
            Object[] objectArray = Util.createDBGeomDescriptors(connection);
            sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)connection, (Object[])objectArray);
            statement.setObject(1, sTRUCT);
            statement.setInt(2, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                JGeometry jGeometry2;
                STRUCT sTRUCT2 = JDBCUtil.getOracleSTRUCT(resultSet, 1);
                JGeometry jGeometry3 = jGeometry2 = JGeometry.load((STRUCT)sTRUCT2);
                return jGeometry3;
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            throw new Exception("error while processing info_request.", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return null;
    }

    private static double[] processPointSRIDConversion(String string, String string2, String string3, double d, double d2) throws Exception {
        double[] dArray = null;
        if (string2 == null || string3 == null || string2.equals(string3) || string2.equals("0") || string3.equals("0")) {
            dArray = new double[]{d, d2};
            return dArray;
        }
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        JGeometry jGeometry = JGeometry.createPoint((double[])new double[]{d, d2}, (int)2, (int)n);
        String string4 = "select sdo_cs.transform(\nMDSYS.SDO_GEOMETRY(2001, ?, MDSYS.SDO_POINT_TYPE(?,?,null), null, null), ?)\nfrom dual";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(string, null);
            if (connection.isClosed()) {
                log.severe("connection obtained is already closed!");
                throw new Exception("error obtaining connection!");
            }
            STRUCT sTRUCT = null;
            statement = connection.prepareStatement(string4);
            statement.setInt(1, n);
            statement.setDouble(2, d);
            statement.setDouble(3, d2);
            statement.setInt(4, n2);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                double[] dArray2;
                sTRUCT = JDBCUtil.getOracleSTRUCT(resultSet, 1);
                JGeometry jGeometry2 = JGeometry.load((STRUCT)sTRUCT);
                double[] dArray3 = dArray2 = jGeometry2.getPoint();
                return dArray3;
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            dArray = null;
            throw new Exception("error while processing info_request.", exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int EPSGsrid_To_Oraclesrid(String string, int n) {
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        String string2 = "select sdo_cs.map_epsg_srid_to_oracle(?) from dual";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(string, null);
            if (connection == null) {
                int n3 = 0;
                return n3;
            }
            statement = connection.prepareStatement(string2);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            log.severe("Unable to convert EPSG SRID to SDO: " + exception.getMessage());
            n2 = 0;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                DSUtil.closeDBConnection(connection, string);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int Oraclesrid_To_EPSGsrid(String string, int n) {
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        String string2 = "select sdo_cs.map_oracle_srid_to_epsg(?) from dual";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(string, null);
            if (connection == null) {
                int n3 = 0;
                return n3;
            }
            statement = connection.prepareStatement(string2);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            log.severe("Unable to convert Oracle SRID to EPSG: " + exception.getMessage());
            n2 = 0;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                DSUtil.closeDBConnection(connection, string);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsOracleSRID(String string, int n) {
        if (string == null) {
            return false;
        }
        String string2 = "select cs_name from cs_srs where srid = ?";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(string, null);
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string2);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            log.severe("Exception in exitsOracleSRID: " + exception.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                DSUtil.closeDBConnection(connection, string);
            }
        }
        return false;
    }

    public static String issueHttpGetRequest(String string) throws IOException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        InputStream inputStream = null;
        String string2 = null;
        URL uRL = null;
        BufferedReader bufferedReader = null;
        String string3 = "";
        try {
            uRL = new URL(string);
            inputStream = uRL.openStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = string3 + string2 + "\n";
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                inputStream.close();
            }
            uRL = null;
        }
        return string3;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    public static JGeometry linearizeCircle(JGeometry jGeometry) {
        double[] dArray = jGeometry.getMBR();
        double d = (dArray[2] - dArray[0]) / 2.0;
        double d2 = d / 20.0;
        return jGeometry.densifyArcs(d2);
    }

    public static Field getField(String string, Field[] fieldArray) {
        if (string == null || fieldArray == null) {
            return null;
        }
        Field field = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            String string2 = fieldArray[i].getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            field = fieldArray[i];
            break;
        }
        return field;
    }

    public static boolean isFullExtent(double d, double d2, double d3, double d4) {
        return Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getColumnTypeName(String string, String string2, String string3) {
        if (string == null) return null;
        if (string2 == null) return null;
        if (string3 == null) {
            return null;
        }
        String string4 = "select data_type from all_tab_columns where owner = ? and table_name = ? and column_name = ?";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string5;
            AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(string);
            if (abstractDBDataSource == null) {
                String string6 = null;
                return string6;
            }
            String string7 = abstractDBDataSource.getUser();
            connection = abstractDBDataSource.getConnection();
            if (connection == null) {
                String string8 = null;
                return string8;
            }
            String string9 = string7;
            String string10 = string2;
            int n = string2.indexOf(".");
            if (n > -1) {
                string9 = string2.substring(0, n);
                string10 = string2.substring(n + 1, string2.length());
            } else {
                string5 = Util.getCurrentSchema(connection, null);
                if (string5 != null) {
                    string9 = string5;
                }
            }
            statement = connection.prepareStatement(string4);
            statement.setString(1, string9.toUpperCase());
            statement.setString(2, string10.toUpperCase());
            statement.setString(3, string3.toUpperCase());
            resultSet = statement.executeQuery();
            if (!resultSet.next()) return null;
            string5 = resultSet.getString(1);
            return string5;
        }
        catch (Exception exception) {
            log.severe("Exception in getColumnTypeName: " + exception.getMessage());
            return null;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isSTGeometryType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.toUpperCase();
        return string2.equals("ST_GEOMETRY") || string2.equals("MDSYS.ST_GEOMETRY") || string2.equals("ST_POINT") || string2.equals("MDSYS.ST_POINT") || string2.equals("ST_LINESTRING") || string2.equals("MDSYS.ST_LINESTRING") || string2.equals("ST_POLYGON") || string2.equals("MDSYS.ST_POLYGON") || string2.equals("ST_GEOMCOLLECTION") || string2.equals("MDSYS.ST_GEOMCOLLECTION") || string2.equals("ST_CURVE") || string2.equals("MDSYS.ST_CURVE") || string2.equals("ST_SURFACE") || string2.equals("MDSYS.ST_SURFACE") || string2.equals("ST_CIRCULARSTRING") || string2.equals("MDSYS.ST_CIRCULARSTRING") || string2.equals("ST_COMPOUNDCURVE") || string2.equals("MDSYS.ST_COMPOUNDCURVE") || string2.equals("ST_MULTIPOINT") || string2.equals("MDSYS.ST_MULTIPOINT") || string2.equals("ST_MULTILINESTRING") || string2.equals("MDSYS.ST_MULTILINESTRING") || string2.equals("ST_MULTIPOLYGON") || string2.equals("MDSYS.ST_MULTIPOLYGON") || string2.equals("ST_MULTICURVE") || string2.equals("MDSYS.ST_MULTICURVE") || string2.equals("ST_MULTISURFACE") || string2.equals("MDSYS.ST_MULTISURFACE") || string2.equals("ST_CURVEPOLYGON") || string2.equals("MDSYS.ST_CURVEPOLYGON");
    }

    public static Point2D rotatePoint(double d, double d2, double d3, double d4, double d5) {
        if (d5 < -360.0 || d5 > 360.0) {
            return null;
        }
        double d6 = Math.PI;
        double d7 = d5 * d6 / 180.0;
        double d8 = d3;
        double d9 = d4;
        double d10 = d - d8;
        double d11 = d2 - d9;
        double d12 = d10 * Math.cos(d7) - d11 * Math.sin(d7) + d8;
        double d13 = d10 * Math.sin(d7) + d11 * Math.cos(d7) + d9;
        return new Point2D.Double(d12, d13);
    }

    public static double[] rotateMBR(double d, double d2, double d3, double d4, double d5) {
        double d6 = (d + d3) / 2.0;
        double d7 = (d2 + d4) / 2.0;
        double[] dArray = new double[4];
        Point2D point2D = Util.rotatePoint(d, d2, d6, d7, d5);
        if (point2D == null) {
            return null;
        }
        dArray[0] = point2D.getX();
        dArray[1] = point2D.getY();
        dArray[2] = point2D.getX();
        dArray[3] = point2D.getY();
        Point2D point2D2 = Util.rotatePoint(d, d4, d6, d7, d5);
        if (point2D2 == null) {
            return null;
        }
        dArray[0] = Math.min(dArray[0], point2D2.getX());
        dArray[1] = Math.min(dArray[1], point2D2.getY());
        dArray[2] = Math.max(dArray[2], point2D2.getX());
        dArray[3] = Math.max(dArray[3], point2D2.getY());
        Point2D point2D3 = Util.rotatePoint(d3, d4, d6, d7, d5);
        if (point2D3 == null) {
            return null;
        }
        dArray[0] = Math.min(dArray[0], point2D3.getX());
        dArray[1] = Math.min(dArray[1], point2D3.getY());
        dArray[2] = Math.max(dArray[2], point2D3.getX());
        dArray[3] = Math.max(dArray[3], point2D3.getY());
        Point2D point2D4 = Util.rotatePoint(d3, d2, d6, d7, d5);
        if (point2D4 == null) {
            return null;
        }
        dArray[0] = Math.min(dArray[0], point2D4.getX());
        dArray[1] = Math.min(dArray[1], point2D4.getY());
        dArray[2] = Math.max(dArray[2], point2D4.getX());
        dArray[3] = Math.max(dArray[3], point2D4.getY());
        return dArray;
    }

    public static JGeometry rotateGeometry(JGeometry jGeometry, double d, double d2, double d3) {
        if (jGeometry == null) {
            return null;
        }
        JGeometry jGeometry2 = new JGeometry(1, 0, new int[]{1, 1, 1}, new double[]{d, d2});
        JGeometry jGeometry3 = null;
        try {
            jGeometry3 = jGeometry.affineTransforms(false, 0.0, 0.0, 0.0, false, null, 0.0, 0.0, 0.0, true, jGeometry2, null, d3 * Math.PI / 180.0, -1, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
        return jGeometry3;
    }

    public static JGeometry scaleGeometry(JGeometry jGeometry, double d, double d2, double d3, double d4, double d5) {
        if (jGeometry == null || d3 < 0.0 || d4 < 0.0 || d5 < 0.0) {
            return null;
        }
        JGeometry jGeometry2 = new JGeometry(1, 0, new int[]{1, 1, 1}, new double[]{d, d2});
        JGeometry jGeometry3 = null;
        try {
            jGeometry3 = jGeometry.affineTransforms(false, 0.0, 0.0, 0.0, true, jGeometry2, d3, d4, d5, false, null, null, 0.0, 0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            return null;
        }
        return jGeometry3;
    }

    public static String getRatioScale(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        int n = 0;
        String string4 = null;
        int n2 = string2.indexOf(":");
        string4 = n2 == -1 ? string2 : string2.substring(n2 + 1, string2.length());
        double d = 0.0;
        try {
            n = Integer.parseInt(string4);
            d = Double.parseDouble(string3);
        }
        catch (Exception exception) {
            return null;
        }
        SRSCache sRSCache = DSManager.getSRSCache(string);
        if (sRSCache == null) {
            return null;
        }
        SRS sRS = sRSCache.get(n);
        if (sRS == null) {
            return null;
        }
        double d2 = sRS.getRatioScale(d, null);
        if (d2 <= 0.0) {
            return null;
        }
        return String.valueOf((long)(d2 + 0.5));
    }

    public static Point2D[] getJavaPointsForGeometryCollection(JSDOGeometry jSDOGeometry) {
        if (jSDOGeometry == null) {
            return null;
        }
        if (jSDOGeometry.getType() != 4) {
            return null;
        }
        double[] dArray = jSDOGeometry.getOrdinatesArray();
        int[] nArray = jSDOGeometry.getElemInfo();
        int n = jSDOGeometry.getDimensions();
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        for (int i = 0; i < nArray.length; i += 3) {
            int n2 = nArray[i + 1] % 10;
            if (n2 != 1) continue;
            int n3 = nArray[i + 2];
            int n4 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                Point2D.Double double_ = new Point2D.Double(dArray[n4 - 1 + j * n], dArray[n4 + j * n]);
                vector.add(double_);
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new Point2D[vector.size()]);
    }

    public static boolean gotoWorkspace(Connection connection, String string) throws Exception {
        try {
            return Util.gotoWorkspace(connection, string, null, null, null, null, false);
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static boolean gotoWorkspaceSavedPoint(Connection connection, String string, String string2) throws Exception {
        try {
            return Util.gotoWorkspace(connection, string, string2, null, null, null, false);
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static boolean gotoWorkspaceDate(Connection connection, String string, String string2, String string3, String string4, boolean bl) throws Exception {
        try {
            return Util.gotoWorkspace(connection, string, null, string2, string3, string4, bl);
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static boolean gotoWorkspace(Connection connection, String string, String string2, String string3, String string4, String string5, boolean bl) throws Exception {
        if (connection == null) {
            return false;
        }
        Statement statement = null;
        if (string != null) {
            try {
                String string6 = "{ call dbms_wm.GotoWorkspace('" + string + "') }";
                statement = connection.prepareCall(string6);
                statement.execute();
                statement.close();
                if (string2 != null) {
                    string6 = "{ call dbms_wm.GotoSavepoint('" + string2 + "') }";
                    statement = connection.prepareCall(string6);
                    statement.execute();
                    statement.close();
                }
                if (string3 != null) {
                    string6 = "{ call dbms_wm.GotoDate('" + string3 + "','" + string4 + "'";
                    string6 = string5 != null ? string6 + ",'" + string5 + "'," + bl + ") }" : string6 + ",null," + bl + ") }";
                    statement = connection.prepareCall(string6);
                    statement.execute();
                    statement.close();
                }
                boolean bl2 = true;
                return bl2;
            }
            catch (Exception exception) {
                throw new Exception(exception);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static final byte[] int2bytes(int n) {
        return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
    }

    public static final int bytes2int(byte[] byArray) {
        return (byArray[0] << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
    }
}

