/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class TopThemeQueries {
    public static final int MAX_ENTRIES = 25;
    private static Hashtable topList = new Hashtable(31);
    private static Entry lowestTimer = null;

    public static final synchronized boolean add(long l, String string, String string2, String string3, String string4) {
        String string5;
        Entry entry;
        if (string2 == null) {
            string2 = "nullds";
        }
        if (string3 == null) {
            string3 = "nullquery";
        }
        if ((entry = (Entry)topList.get(string5 = string2.toUpperCase() + "#.#" + string.toUpperCase())) != null) {
            if (entry.processTime < l) {
                entry.processTime = l;
                entry.query = string3;
                entry.info = string4;
                if (lowestTimer != null && lowestTimer == entry && topList.size() > 1) {
                    TopThemeQueries.updateLowestTimer();
                }
            }
            return true;
        }
        if (topList.size() < 25) {
            topList.put(string5, new Entry(l, string, string2, string3, string4));
            TopThemeQueries.updateLowestTimer();
            return true;
        }
        if (l > TopThemeQueries.lowestTimer.processTime) {
            topList.remove(lowestTimer);
            lowestTimer = null;
            topList.put(string5, new Entry(l, string, string2, string3, string4));
            TopThemeQueries.updateLowestTimer();
            return true;
        }
        return false;
    }

    private static void updateLowestTimer() {
        Enumeration enumeration = topList.elements();
        while (enumeration.hasMoreElements()) {
            Entry entry = (Entry)enumeration.nextElement();
            if (lowestTimer == null) {
                lowestTimer = entry;
                continue;
            }
            if (TopThemeQueries.lowestTimer.processTime <= entry.processTime) continue;
            lowestTimer = entry;
        }
    }

    public static synchronized Entry[] report() {
        int n = topList.size();
        if (n == 0) {
            return new Entry[0];
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>(n);
        Entry[] entryArray = topList.elements();
        while (entryArray.hasMoreElements()) {
            Entry entry = (Entry)entryArray.nextElement();
            arrayList.add(entry);
        }
        Collections.sort(arrayList);
        entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            entryArray[n - i - 1] = (Entry)arrayList.get(i);
        }
        arrayList = null;
        return entryArray;
    }

    public static synchronized String reportAsXML() {
        Entry[] entryArray = TopThemeQueries.report();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<top_theme_queries>\n");
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            stringBuffer.append("  <theme id=\"" + i + "\">\n");
            stringBuffer.append("    <name>" + entry.theme + "</name>\n");
            stringBuffer.append("    <data_source>" + entry.dataSource + "</data_source>\n");
            stringBuffer.append("    <time unit=\"ms\">" + entry.processTime + "</time>\n");
            stringBuffer.append("    <query><![CDATA[\n" + entry.query + "\n           ]]>\n    </query>\n");
            stringBuffer.append("    <note><![CDATA[" + entry.info + "]]></note>\n");
            stringBuffer.append("  </theme>\n");
        }
        stringBuffer.append("</top_theme_queries>\n");
        return stringBuffer.toString();
    }

    public static synchronized void reset() {
        topList.clear();
        lowestTimer = null;
    }

    public static class Entry
    implements Comparable {
        public long processTime = 0L;
        public String query = "";
        public String theme = "";
        public String dataSource = "";
        public String info = "";

        public Entry(long l, String string, String string2, String string3, String string4) {
            this.processTime = l;
            this.theme = string;
            this.dataSource = string2;
            this.query = string3;
            this.info = string4;
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            return this.processTime > entry.processTime ? 1 : (this.processTime < entry.processTime ? -1 : 0);
        }
    }
}

