/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.MapTable;
import oracle.sdovis.ThemeTable;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Base64InputStream;
import oracle.sdovis.util.Util;

public class MMImport {
    static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String delim = "|";
    static String ESC = "&#124;";
    static String DS_NAME = "MMImport_temp_ds";

    public static void main(String[] stringArray) throws Exception {
        log.setLevel(Level.FINEST);
        if (stringArray.length != 6) {
            System.out.println("Usage: java MMImport <metadata> <host> <sid> <port> <user> <password>");
            System.exit(1);
        }
        System.out.println("connecting to " + stringArray[1] + "...");
        DSManager.registerOracleJdbcDS(DS_NAME, stringArray[1], stringArray[3], stringArray[2], stringArray[4], stringArray[5], "thin", 3);
        System.out.println("connected.");
        MMImport.importAll(stringArray);
        DSManager.remove(DS_NAME);
    }

    public static void importAll(String[] stringArray) throws IOException {
        byte[] byArray = Util.readFile(stringArray[0]);
        String string = new String(byArray);
        int n = string.indexOf("--------STYLES END--------");
        String string2 = n > 0 ? string.substring(28, n) : null;
        n = string.indexOf("--------THEMES BEGIN--------");
        int n2 = string.indexOf("--------THEMES END--------");
        String string3 = n >= 0 && n2 > 0 ? string.substring(n + 28, n2) : null;
        n = string.indexOf("--------MAPS BEGIN--------");
        n2 = string.indexOf("--------MAPS END--------");
        String string4 = n >= 0 && n2 > 0 ? string.substring(n + 26, n2) : null;
        try {
            if (string2 != null) {
                MMImport.importStyles(string2);
            }
            if (string3 != null) {
                MMImport.importThemes(string3);
            }
            if (string4 != null) {
                MMImport.importMaps(string4);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
        log.info("import of map metadata done. ");
    }

    public static boolean importMetadata(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (string == null || string2 == null) {
            return false;
        }
        if (DSManager.get(string) == null) {
            return false;
        }
        DS_NAME = string;
        byte[] byArray = Util.readFile(string2);
        String string3 = new String(byArray);
        int n = string3.indexOf("--------STYLES END--------");
        String string4 = bl && n > 0 ? string3.substring(28, n) : null;
        n = string3.indexOf("--------THEMES BEGIN--------");
        int n2 = string3.indexOf("--------THEMES END--------");
        String string5 = bl2 && n >= 0 && n2 > 0 ? string3.substring(n + 28, n2) : null;
        n = string3.indexOf("--------MAPS BEGIN--------");
        n2 = string3.indexOf("--------MAPS END--------");
        String string6 = bl3 && n >= 0 && n2 > 0 ? string3.substring(n + 26, n2) : null;
        try {
            if (string4 != null) {
                MMImport.importStyles(string4);
            }
            if (string5 != null) {
                MMImport.importThemes(string5);
            }
            if (string6 != null) {
                MMImport.importMaps(string6);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            return false;
        }
        log.info("import of map metadata done. ");
        return true;
    }

    public static void importStyles(String string) throws SQLException, IOException {
        log.info("importing styles...");
        StyleTable styleTable = new StyleTable(DS_NAME, "USER_SDO_STYLES");
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, delim);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                String string4 = MMImport.descape(stringTokenizer.nextToken().trim());
                if (string4.equals("null")) {
                    string4 = null;
                }
                String string5 = MMImport.descape(stringTokenizer.nextToken().trim());
                String string6 = stringTokenizer.nextToken().trim();
                if (string3 == null || string3.equalsIgnoreCase("null")) {
                    log.info("Null type for style " + string2 + ". Style ignored");
                    continue;
                }
                byte[] byArray = null;
                if (!string6.equals("null")) {
                    byte[] byArray2;
                    byte[] byArray3 = string6.getBytes();
                    Base64InputStream base64InputStream = new Base64InputStream(new ByteArrayInputStream(byArray3));
                    int n2 = base64InputStream.read(byArray2 = new byte[byArray3.length]);
                    if (n2 <= 0) continue;
                    byArray = new byte[n2];
                    System.arraycopy(byArray2, 0, byArray, 0, n2);
                }
                log.finest("Importing style " + string2 + " of type " + string3);
                styleTable.setName(string2);
                styleTable.setType(string3);
                styleTable.setDescription(string4);
                styleTable.setDefinition(new StringBuffer(string5));
                styleTable.setImage(byArray);
                styleTable.insert();
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
                break;
            }
        }
        log.info("# Styles imported: " + n);
    }

    public static void importThemes(String string) throws SQLException {
        log.info("importing themes...");
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, delim);
        ThemeTable themeTable = new ThemeTable(DS_NAME, "user_sdo_themes");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = MMImport.descape(stringTokenizer.nextToken().trim());
                if (string3.equals("null")) {
                    string3 = null;
                }
                String string4 = stringTokenizer.nextToken().trim();
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = MMImport.descape(stringTokenizer.nextToken().trim());
                themeTable.setName(string2);
                themeTable.setDescription(string3);
                themeTable.setBaseTable(string4);
                themeTable.setSpatialColumn(string5);
                themeTable.setStylingRules(string6);
                log.finest("Importing theme: " + string2);
                themeTable.insert();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            ++n;
        }
        log.info("# of Themes imported: " + n);
    }

    public static void importMaps(String string) throws SQLException {
        log.info("importing maps...");
        int n = 0;
        MapTable mapTable = new MapTable(DS_NAME, "user_sdo_maps");
        StringTokenizer stringTokenizer = new StringTokenizer(string, delim);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.equals("null")) {
                    string3 = null;
                }
                String string4 = stringTokenizer.nextToken().trim();
                log.finest("Importing base map: " + string2);
                mapTable.setName(string2);
                mapTable.setDescription(string3);
                mapTable.setMapDefinition(string4);
                mapTable.insert();
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
                break;
            }
        }
        log.info("# of Base maps imported: " + n);
    }

    static String descape(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("&#124;", "\\|");
    }
}

