/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.JDBCUtil;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class GeomMetaTable
extends DBTable {
    String mSpatialTableName;
    String mSpatialColumnName;
    int mSRID;
    int mDimensions;
    double mXMin;
    double mYMin;
    double mXMax;
    double mYMax;
    double mXTolerance;
    double mYTolerance;
    public static final String DEFAULT_TABLE_NAME = "ALL_SDO_GEOM_METADATA";

    public GeomMetaTable(String string) {
        super(string, DEFAULT_TABLE_NAME);
    }

    public double getXMin() {
        return this.mXMin;
    }

    public double getYMin() {
        return this.mYMin;
    }

    public double getXMax() {
        return this.mXMax;
    }

    public double getYMax() {
        return this.mYMax;
    }

    public double getXTolerance() {
        return this.mXTolerance;
    }

    public double getYTolerance() {
        return this.mYTolerance;
    }

    public int getSRID() {
        return this.mSRID;
    }

    public int getDimensions() {
        return this.mDimensions;
    }

    public String getSpatialTableName() {
        return this.mSpatialTableName;
    }

    public String getSpatialColumnName() {
        return this.mSpatialColumnName;
    }

    public String getUserName() {
        return this.mUser;
    }

    public int getId() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTablesAndColumns() {
        Statement statement = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(512);
        try {
            AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = abstractDBDataSource.getConnection();
            statement = this.mConnection.prepareStatement("select table_name, column_name from " + this.mTableName);
            this.query((PreparedStatement)statement);
            while (this.mResultSet.next()) {
                String string = this.mResultSet.getString(1);
                String string2 = this.mResultSet.getString(2);
                hashtable.put(string, string2);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            Hashtable hashtable2 = null;
            return hashtable2;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        return hashtable;
    }

    public int getSRID(String string, String string2) {
        if (this.query(string, string2)) {
            return this.mSRID;
        }
        return 0;
    }

    public int update() throws SQLException {
        return 0;
    }

    public int insert() throws SQLException {
        return 0;
    }

    public int delete() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean query(String string, String string2) {
        Statement statement = null;
        this.mSRID = 0;
        this.mDimensions = 2;
        this.mYMax = 0.0;
        this.mXMax = 0.0;
        this.mYMin = 0.0;
        this.mXMin = 0.0;
        if (string != null) {
            string = string.toUpperCase();
        }
        if (string2 != null) {
            string2 = string2.toUpperCase();
        }
        AbstractDBDataSource abstractDBDataSource = null;
        try {
            abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = abstractDBDataSource.getConnection();
            String string3 = "SELECT table_name, column_name, diminfo, srid FROM " + this.mTableName + " WHERE TABLE_NAME=?" + " and COLUMN_NAME=?" + " and OWNER=?";
            statement = this.mConnection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setString(3, this.mUser);
            this.query((PreparedStatement)statement);
            this.next();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            try {
                this.closeQuery();
            }
            catch (Exception exception) {
                System.err.println("cannot query metadata from " + this.mTableName + " for " + string + ":" + string2);
            }
            try {
                if (this.mConnection == null) {
                    this.mConnection = abstractDBDataSource.getConnection();
                }
                String string4 = "SELECT table_name, column_name, diminfo, srid FROM user_sdo_geom_metadata WHERE TABLE_NAME=? and COLUMN_NAME=?";
                statement = this.mConnection.prepareStatement(string4);
                statement.setString(1, string);
                statement.setString(2, string2);
                this.query((PreparedStatement)statement);
                this.next();
                boolean bl = true;
                return bl;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace(System.err);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryForTheme(String string) {
        Statement statement = null;
        this.mSRID = 0;
        this.mDimensions = 2;
        this.mYMax = 0.0;
        this.mXMax = 0.0;
        this.mYMin = 0.0;
        this.mXMin = 0.0;
        AbstractDBDataSource abstractDBDataSource = null;
        try {
            abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = abstractDBDataSource.getConnection();
            String string2 = "SELECT table_name, column_name, diminfo, srid FROM " + this.mTableName + ", USER_SDO_THEMES b " + " WHERE upper(b.NAME) =?" + " and TABLE_NAME=BASE_TABLE and (COLUMN_NAME=GEOMETRY_COLUMN " + " OR COLUMN_NAME = (GEOMETRY_COLUMN || '.SPATIALEXTENT')" + " OR COLUMN_NAME = (GEOMETRY_COLUMN || '.PRIVATEENVELOPE')) " + " and OWNER=:2";
            statement = this.mConnection.prepareStatement(string2);
            statement.setString(1, string.toUpperCase());
            statement.setString(2, this.mUser);
            this.query((PreparedStatement)statement);
            this.next();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (SQLException sQLException2) {
                System.err.println("cannot query metadata from " + this.mTableName + " for " + string);
            }
            try {
                if (this.mConnection == null) {
                    this.mConnection = abstractDBDataSource.getConnection();
                }
                System.err.println("looking at USER_SDO_GEOM_METADATA for theme " + string);
                String string3 = "SELECT table_name, column_name, diminfo, srid FROM USER_SDO_GEOM_METADATA , USER_SDO_THEMES b  WHERE upper(b.NAME) =? and TABLE_NAME=BASE_TABLE and (COLUMN_NAME=GEOMETRY_COLUMN  OR COLUMN_NAME = (GEOMETRY_COLUMN || '.SPATIALEXTENT') OR COLUMN_NAME = (GEOMETRY_COLUMN || '.PRIVATEENVELOPE'))";
                statement = this.mConnection.prepareStatement(string3);
                statement.setString(1, string.toUpperCase());
                this.query((PreparedStatement)statement);
                this.next();
                boolean bl = true;
                return bl;
            }
            catch (SQLException sQLException3) {
                sQLException3.printStackTrace(System.err);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void initDeleteStatement() throws SQLException {
    }

    protected void initInsertStatement() throws SQLException {
    }

    protected void initUpdateStatement() throws SQLException {
    }

    protected void updateLocalData() throws SQLException {
        this.mSpatialTableName = this.mResultSet.getString(1);
        this.mSpatialColumnName = this.mResultSet.getString(2);
        ARRAY aRRAY = null;
        try {
            aRRAY = JDBCUtil.safeCastARRAY(this.mResultSet.getObject(3));
        }
        catch (Exception exception) {
            throw new SQLException("Cannot get dim array.");
        }
        this.mSRID = this.mResultSet.getInt(4);
        Datum[] datumArray = aRRAY.getOracleArray();
        this.mDimensions = datumArray.length;
        STRUCT sTRUCT = (STRUCT)datumArray[0];
        Datum[] datumArray2 = sTRUCT.getOracleAttributes();
        sTRUCT = (STRUCT)datumArray[1];
        Datum[] datumArray3 = sTRUCT.getOracleAttributes();
        this.mXMin = datumArray2[1].doubleValue();
        this.mYMin = datumArray3[1].doubleValue();
        this.mXMax = datumArray2[2].doubleValue();
        this.mYMax = datumArray3[2].doubleValue();
        this.mXTolerance = datumArray2[3].doubleValue();
        this.mYTolerance = datumArray3[3].doubleValue();
    }
}

