/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme.edit;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.style.TextStyleModel;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.spatial.edit.index.annotationtext.IndexedAnnotationTextSet;
import oracle.spatial.edit.model.AbstractFeature;
import oracle.spatial.geometry.JGeometry;

public class EditAnnotationTextThemeProducer
extends AnnotationTextThemeProducer {
    private IndexedAnnotationTextSet editSet = null;
    private boolean editingMode = false;
    private StyleColor transparent = new StyleColor(new Color(0, 0, 0, 0));
    private StyleColor anchorColor = new StyleColor(Color.red);

    public EditAnnotationTextThemeProducer(Theme theme) {
        super(theme);
        this.anchorColor.setStrokeColor(Color.red);
        this.anchorColor.setStrokeWidth(1.0f);
    }

    public void setIndexedAnnotationTextSet(IndexedAnnotationTextSet indexedAnnotationTextSet) {
        this.editSet = indexedAnnotationTextSet;
    }

    public IndexedAnnotationTextSet getIndexedAnnotationTextSet() {
        return this.editSet;
    }

    public boolean isEditingMode() {
        return this.editingMode;
    }

    public void setEditingMode(boolean bl) {
        this.editingMode = bl;
    }

    protected AnnotationText loadAnnotation(String string, ResultSet resultSet, String string2) {
        AnnotationText annotationText = null;
        if (this.editSet != null && this.editSet.getAnnotationTextSet() != null) {
            if (this.editSet.getAnnotationTextSet().isRemovedFeature(string)) {
                return null;
            }
            annotationText = (AnnotationText)this.editSet.getAnnotationTextSet().getFeatureSpatialAttribute(string);
            if (annotationText != null) {
                return annotationText;
            }
        }
        return super.loadAnnotation(string, resultSet, string2);
    }

    protected void loadNewFeatures(ArrayList arrayList, StyleText styleText, boolean bl) {
        if (arrayList == null || this.editSet == null || this.editSet.getAnnotationTextSet() == null || styleText == null) {
            return;
        }
        String[] stringArray = this.editSet.getAnnotationTextSet().getNewFeatures();
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        String[] stringArray2 = this.owner.getRenderingStyles();
        String string = "C.RED";
        if (stringArray2 != null && stringArray2.length > 0) {
            string = stringArray2[0];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            AnnotationTextElement[] annotationTextElementArray;
            AnnotationText annotationText = (AnnotationText)this.editSet.getAnnotationTextSet().getFeatureSpatialAttribute(stringArray[i]);
            if (annotationText == null || (annotationTextElementArray = annotationText.getElements()) == null || annotationTextElementArray.length == 0) continue;
            String string2 = this.def.getMetadataExpression();
            for (int j = 0; j < annotationTextElementArray.length; ++j) {
                StyledFeatureI styledFeatureI;
                Object object;
                String string3 = annotationTextElementArray[j].getValue();
                if (string3 == null) {
                    string3 = string2;
                } else {
                    string2 = string3;
                }
                if (string3 == null) continue;
                JGeometry jGeometry = annotationTextElementArray[j].getLocation();
                if (jGeometry != null) {
                    object = EditAnnotationTextThemeProducer.getTextStyle(annotationTextElementArray[j].getAttributes());
                    if (object == null) {
                        object = (StyleText)styleText.clone();
                    }
                    if (!bl && !Double.isNaN(this.def.getMapBaseScale()) && this.def.getMapBaseScale() > 0.0) {
                        double d = this.def.getMapBaseScale() * 0.0254 / (double)SRS.getDPI();
                        float f = ((StyleText)object).getFont().getSize2D();
                        SizeDefinition sizeDefinition = new SizeDefinition(f *= (float)d, "m");
                        if (sizeDefinition != null) {
                            ((TextStyleModel)((StyleText)object).getModel()).setFontSize((float)sizeDefinition.getValue(), sizeDefinition.getUnit());
                        }
                    }
                    styledFeatureI = this.getNewStyledFeatureInstance();
                    JSDOGeometry jSDOGeometry = JSDOGeometry.recast(jGeometry);
                    styledFeatureI.setGeometry(jSDOGeometry);
                    styledFeatureI.setFeatureStyle(this.transparent);
                    styledFeatureI.setLabel(string3);
                    styledFeatureI.setLabelStyle((Style)object);
                    styledFeatureI.setForceLabel(true);
                    styledFeatureI.setLabelAsOrientedPoint(true);
                    styledFeatureI.setDataSource(this.def.getDataSourceName());
                    styledFeatureI.setID(stringArray[i]);
                    styledFeatureI.setElementPosition(j);
                    arrayList.add(styledFeatureI);
                    this.addAnchorLocationFeature(arrayList, jSDOGeometry);
                }
                if ((object = annotationTextElementArray[j].getLeaderLine()) == null) continue;
                styledFeatureI = this.getNewStyledFeatureInstance();
                styledFeatureI.setGeometry(JSDOGeometry.recast((JGeometry)object));
                styledFeatureI.setFeatureStyleName(this.def.getLeaderLineStyle());
                styledFeatureI.setDataSource(this.def.getDataSourceName());
                styledFeatureI.setID(stringArray[i]);
                styledFeatureI.setElementPosition(j);
                arrayList.add(styledFeatureI);
            }
        }
    }

    protected void loadEditFeatures(Rectangle2D rectangle2D, ArrayList arrayList, StyleText styleText) {
        String string;
        String[] stringArray;
        if (this.editSet == null || this.editSet.getAnnotationTextSet() == null || arrayList == null || rectangle2D == null || styleText == null) {
            return;
        }
        String string2 = this.editSet.getAnnotationTextSet().getKeyColumn();
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = (String[])arrayList.get(i);
            if (stringArray == null || stringArray.getID() == null || (string = this.editSet.getAnnotationTextSet().getRealKeyValue(string2, stringArray.getID())) == null) continue;
            hashtable.put(string, stringArray);
        }
        Vector vector = this.editSet.getFeatures(rectangle2D);
        if (vector != null) {
            stringArray = this.owner.getRenderingStyles();
            string = "C.RED";
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            for (int i = 0; i < vector.size(); ++i) {
                AnnotationTextElement[] annotationTextElementArray;
                AnnotationText annotationText;
                Field field = ((AbstractFeature)vector.get(i)).getAttribute(string2);
                if (field == null || field.getValue() == null || hashtable.get(field.getValue().toString()) != null || (annotationText = (AnnotationText)this.editSet.getAnnotationTextSet().getFeatureSpatialAttribute(field.getValue().toString())) == null || (annotationTextElementArray = annotationText.getElements()) == null || annotationTextElementArray.length == 0) continue;
                String string3 = this.def.getMetadataExpression();
                for (int j = 0; j < annotationTextElementArray.length; ++j) {
                    StyledFeatureI styledFeatureI;
                    Object object;
                    String string4 = annotationTextElementArray[j].getValue();
                    if (string4 == null) {
                        string4 = string3;
                    } else {
                        string3 = string4;
                    }
                    if (string4 == null) continue;
                    JGeometry jGeometry = annotationTextElementArray[j].getLocation();
                    if (jGeometry != null) {
                        object = EditAnnotationTextThemeProducer.getTextStyle(annotationTextElementArray[j].getAttributes());
                        if (object == null) {
                            object = (StyleText)styleText.clone();
                        }
                        if (!Double.isNaN(this.def.getMapBaseScale()) && this.def.getMapBaseScale() > 0.0) {
                            double d = this.def.getMapBaseScale() * 0.0254 / (double)SRS.getDPI();
                            float f = ((StyleText)object).getFont().getSize2D();
                            SizeDefinition sizeDefinition = new SizeDefinition(f *= (float)d, "m");
                            if (sizeDefinition != null) {
                                ((TextStyleModel)((StyleText)object).getModel()).setFontSize((float)sizeDefinition.getValue(), sizeDefinition.getUnit());
                            }
                        }
                        styledFeatureI = this.getNewStyledFeatureInstance();
                        JSDOGeometry jSDOGeometry = JSDOGeometry.recast(jGeometry);
                        styledFeatureI.setGeometry(jSDOGeometry);
                        styledFeatureI.setFeatureStyle(this.transparent);
                        styledFeatureI.setLabel(string4);
                        styledFeatureI.setLabelStyle((Style)object);
                        styledFeatureI.setForceLabel(true);
                        styledFeatureI.setLabelAsOrientedPoint(true);
                        styledFeatureI.setDataSource(this.def.getDataSourceName());
                        styledFeatureI.setID(field.getValue().toString());
                        styledFeatureI.setElementPosition(j);
                        arrayList.add(styledFeatureI);
                        this.addAnchorLocationFeature(arrayList, jSDOGeometry);
                    }
                    if ((object = annotationTextElementArray[j].getLeaderLine()) == null) continue;
                    styledFeatureI = this.getNewStyledFeatureInstance();
                    styledFeatureI.setGeometry(JSDOGeometry.recast((JGeometry)object));
                    styledFeatureI.setFeatureStyleName(this.def.getLeaderLineStyle());
                    styledFeatureI.setDataSource(this.def.getDataSourceName());
                    styledFeatureI.setID(field.getValue().toString());
                    styledFeatureI.setElementPosition(j);
                    arrayList.add(styledFeatureI);
                }
            }
        }
    }

    protected void addAnchorLocationFeature(ArrayList arrayList, JSDOGeometry jSDOGeometry) {
        if (jSDOGeometry == null || jSDOGeometry.getType() != 1 && jSDOGeometry.getType() != 2) {
            return;
        }
        StyledFeatureI styledFeatureI = this.getNewStyledFeatureInstance();
        styledFeatureI.setGeometry(jSDOGeometry);
        styledFeatureI.setFeatureStyle(this.anchorColor);
        styledFeatureI.setDataSource(this.def.getDataSourceName());
        arrayList.add(styledFeatureI);
        if (jSDOGeometry.getType() == 2) {
            int n = jSDOGeometry.getDimensions();
            double[] dArray = jSDOGeometry.getOrdinatesArray();
            if (dArray == null) {
                return;
            }
            int n2 = dArray.length / n;
            double[] dArray2 = new double[]{dArray[0], dArray[1]};
            JGeometry jGeometry = JGeometry.createPoint((double[])dArray2, (int)n, (int)jSDOGeometry.getSRID());
            StyledFeatureI styledFeatureI2 = this.getNewStyledFeatureInstance();
            styledFeatureI2.setGeometry(JSDOGeometry.recast(jGeometry));
            styledFeatureI2.setFeatureStyle(this.anchorColor);
            styledFeatureI2.setDataSource(this.def.getDataSourceName());
            arrayList.add(styledFeatureI2);
            double[] dArray3 = new double[]{dArray[(n2 - 1) * n], dArray[(n2 - 1) * n + 1]};
            JGeometry jGeometry2 = JGeometry.createPoint((double[])dArray3, (int)n, (int)jSDOGeometry.getSRID());
            StyledFeatureI styledFeatureI3 = this.getNewStyledFeatureInstance();
            styledFeatureI3.setGeometry(JSDOGeometry.recast(jGeometry2));
            styledFeatureI3.setFeatureStyle(this.anchorColor);
            styledFeatureI3.setDataSource(this.def.getDataSourceName());
            arrayList.add(styledFeatureI3);
        }
    }
}

