/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.VectorThemeDefinition;

public class TopologyThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static final int YIELD_COUNT = 20;
    boolean passThrough;
    String topoOwner;
    String topologyName;
    int topologyId;
    double tolerance;
    String featureTable;
    String topoColumn;
    int tgLayerId;
    String tgLayerType;
    int tgLayerLevel;
    int childLayerId;
    String tableOwner;
    int cachingMode;
    String cacheSubRegionName;
    String cacheGeomGroup;
    Hashtable sridGeomCache;
    String cacheEdgeGroup;
    Hashtable sridEdgeCache;
    String cacheNodeGroup;
    Hashtable sridNodeCache;
    String mQuery;
    boolean mPre9i;
    boolean predefined;
    String mKeyColumn;
    PreparedStatement pstmt;
    String currentKey;
    StylingRule[] mStyleRules;
    String renderStyleName;
    String labelColumnName;
    String labelStyleName;
    String edgeSpatialColumn;
    String nodeSpatialColumn;
    String edgeStyle;
    String edgeLabelStyle;
    String edgeMarkerStyle;
    int edgeMarkerSize;
    String nodeStyle;
    String nodeLabelStyle;
    int nodeMarkerSize;
    String faceStyle;
    String faceLabelStyle;
    boolean debugTheme;
    protected double minDistBetweenNodes;
    int[] hierLayers;
    String topoView;
    String topoViewColumn;
    String connectionUser;

    public TopologyThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        this.passThrough = true;
        this.topoOwner = null;
        this.topologyName = null;
        this.topologyId = 0;
        this.tolerance = 0.0;
        this.featureTable = null;
        this.topoColumn = null;
        this.tgLayerId = 0;
        this.tgLayerType = null;
        this.tgLayerLevel = 0;
        this.childLayerId = 0;
        this.tableOwner = null;
        this.cachingMode = 1;
        this.cacheSubRegionName = null;
        this.cacheGeomGroup = null;
        this.sridGeomCache = new Hashtable(5);
        this.cacheEdgeGroup = null;
        this.sridEdgeCache = new Hashtable(5);
        this.cacheNodeGroup = null;
        this.sridNodeCache = new Hashtable(5);
        this.mQuery = null;
        this.mPre9i = false;
        this.predefined = false;
        this.mKeyColumn = "ROWID";
        this.pstmt = null;
        this.currentKey = null;
        this.mStyleRules = null;
        this.renderStyleName = null;
        this.labelColumnName = null;
        this.labelStyleName = null;
        this.edgeSpatialColumn = "geometry";
        this.nodeSpatialColumn = "geometry";
        this.edgeStyle = null;
        this.edgeLabelStyle = null;
        this.edgeMarkerStyle = null;
        this.edgeMarkerSize = 8;
        this.nodeStyle = null;
        this.nodeLabelStyle = null;
        this.nodeMarkerSize = 8;
        this.faceStyle = null;
        this.faceLabelStyle = null;
        this.debugTheme = false;
        this.minDistBetweenNodes = 0.5;
        this.hierLayers = null;
        this.topoView = null;
        this.topoViewColumn = null;
        this.connectionUser = null;
        this.name = string;
        this.dataSource = string2;
        this.mQuery = string3;
        if (!this.readMetadata(string2, string5, string6, string7)) {
            return;
        }
        this.passThrough = bl;
        this.renderStyleName = string8;
        this.labelColumnName = string9;
        this.labelStyleName = string10;
        int n = 0;
        try {
            n = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            log.warning("Invalid SRID (0 is assigned).");
            n = 0;
        }
        this.srid = n;
    }

    public TopologyThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        this.passThrough = true;
        this.topoOwner = null;
        this.topologyName = null;
        this.topologyId = 0;
        this.tolerance = 0.0;
        this.featureTable = null;
        this.topoColumn = null;
        this.tgLayerId = 0;
        this.tgLayerType = null;
        this.tgLayerLevel = 0;
        this.childLayerId = 0;
        this.tableOwner = null;
        this.cachingMode = 1;
        this.cacheSubRegionName = null;
        this.cacheGeomGroup = null;
        this.sridGeomCache = new Hashtable(5);
        this.cacheEdgeGroup = null;
        this.sridEdgeCache = new Hashtable(5);
        this.cacheNodeGroup = null;
        this.sridNodeCache = new Hashtable(5);
        this.mQuery = null;
        this.mPre9i = false;
        this.predefined = false;
        this.mKeyColumn = "ROWID";
        this.pstmt = null;
        this.currentKey = null;
        this.mStyleRules = null;
        this.renderStyleName = null;
        this.labelColumnName = null;
        this.labelStyleName = null;
        this.edgeSpatialColumn = "geometry";
        this.nodeSpatialColumn = "geometry";
        this.edgeStyle = null;
        this.edgeLabelStyle = null;
        this.edgeMarkerStyle = null;
        this.edgeMarkerSize = 8;
        this.nodeStyle = null;
        this.nodeLabelStyle = null;
        this.nodeMarkerSize = 8;
        this.faceStyle = null;
        this.faceLabelStyle = null;
        this.debugTheme = false;
        this.minDistBetweenNodes = 0.5;
        this.hierLayers = null;
        this.topoView = null;
        this.topoViewColumn = null;
        this.connectionUser = null;
        this.name = string;
        this.dataSource = string2;
        this.mQuery = null;
        this.topologyName = string4;
        this.featureTable = string5;
        this.passThrough = bl;
        this.edgeStyle = string6;
        this.nodeStyle = string9;
        this.faceStyle = string11;
        this.edgeLabelStyle = string8;
        this.edgeMarkerStyle = string7;
        this.edgeMarkerSize = n;
        this.nodeLabelStyle = string10;
        this.faceLabelStyle = string12;
        this.debugTheme = true;
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            log.warning("Invalid SRID (0 is assigned).");
            n2 = 0;
        }
        this.srid = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TopologyThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, StylingRule[] stylingRuleArray, int n, int n2) {
        int n3;
        block17: {
            this.passThrough = true;
            this.topoOwner = null;
            this.topologyName = null;
            this.topologyId = 0;
            this.tolerance = 0.0;
            this.featureTable = null;
            this.topoColumn = null;
            this.tgLayerId = 0;
            this.tgLayerType = null;
            this.tgLayerLevel = 0;
            this.childLayerId = 0;
            this.tableOwner = null;
            this.cachingMode = 1;
            this.cacheSubRegionName = null;
            this.cacheGeomGroup = null;
            this.sridGeomCache = new Hashtable(5);
            this.cacheEdgeGroup = null;
            this.sridEdgeCache = new Hashtable(5);
            this.cacheNodeGroup = null;
            this.sridNodeCache = new Hashtable(5);
            this.mQuery = null;
            this.mPre9i = false;
            this.predefined = false;
            this.mKeyColumn = "ROWID";
            this.pstmt = null;
            this.currentKey = null;
            this.mStyleRules = null;
            this.renderStyleName = null;
            this.labelColumnName = null;
            this.labelStyleName = null;
            this.edgeSpatialColumn = "geometry";
            this.nodeSpatialColumn = "geometry";
            this.edgeStyle = null;
            this.edgeLabelStyle = null;
            this.edgeMarkerStyle = null;
            this.edgeMarkerSize = 8;
            this.nodeStyle = null;
            this.nodeLabelStyle = null;
            this.nodeMarkerSize = 8;
            this.faceStyle = null;
            this.faceLabelStyle = null;
            this.debugTheme = false;
            this.minDistBetweenNodes = 0.5;
            this.hierLayers = null;
            this.topoView = null;
            this.topoViewColumn = null;
            this.connectionUser = null;
            if (stylingRuleArray == null || stylingRuleArray.length < 1) {
                log.warning("There are no styling rules defined for this theme");
                return;
            }
            this.dataSource = string2;
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string2);
            if (dBDataSource == null) {
                log.severe("Could not get data source: " + string2);
                return;
            }
            this.mPre9i = dBDataSource.isPre9i();
            this.predefined = true;
            this.name = string;
            this.srid = n;
            this.mStyleRules = stylingRuleArray;
            if (string6 != null) {
                this.mKeyColumn = string6;
            }
            this.passThrough = false;
            if (!this.readMetadata(string2, string3, string4, string5)) {
                return;
            }
            this.cachingMode = n2;
            if (n2 != 1 && n2 != 1 && n2 != 3) {
                this.cachingMode = 1;
            }
            this.cacheGeomGroup = string3 + "_" + string4 + "_" + string5 + "_PDT_TOPO";
            this.cacheEdgeGroup = string3 + "_" + string4 + "_" + string5 + "_PDT_EDGE_TOPO";
            this.cacheNodeGroup = string3 + "_" + string4 + "_" + string5 + "_PDT_NODE_TOPO";
            Connection connection = null;
            boolean bl = this.cachingMode == 2;
            connection = dBDataSource.getConnection();
            this.cacheSubRegionName = CacheMgr2.getSubRegionName(connection);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.cacheGeomGroup, 0, bl);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.cacheEdgeGroup, 0, bl);
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, this.cacheNodeGroup, 0, bl);
            Object var15_13 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (Exception exception) {
                    log.severe(exception.getMessage());
                    Object var15_14 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block17;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if ((n3 = 0) < stylingRuleArray.length) {
            this.renderStyleName = stylingRuleArray[n3].getFeatureStyleName();
            this.labelColumnName = stylingRuleArray[n3].getLabelColumn();
            this.labelStyleName = stylingRuleArray[n3].getLabelStyleName();
        }
        this.mQuery = this.createPredefinedQueryString();
        log.finer("[Predefined Query - Topology Theme] " + this.mQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean readMetadata(String string, String string2, String string3, String string4) {
        block49: {
            Exception exception322;
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            Connection connection;
            block44: {
                int n;
                block40: {
                    Exception exception2222;
                    boolean bl;
                    block41: {
                        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(string);
                        if (abstractDBDataSource == null) {
                            log.severe("Could not get data source: " + string);
                            return false;
                        }
                        this.connectionUser = abstractDBDataSource.getUser();
                        connection = null;
                        String string5 = string2;
                        String string6 = this.connectionUser;
                        int n2 = string2.indexOf(".");
                        if (n2 > -1) {
                            string6 = string2.substring(0, n2);
                            string5 = string2.substring(n2 + 1, string2.length());
                        }
                        String string7 = this.connectionUser;
                        String string8 = string3;
                        n = string3.indexOf(".");
                        if (n > -1) {
                            string7 = string3.substring(0, n);
                            string8 = string3.substring(n + 1, string3.length());
                        }
                        String string9 = "select * from all_sdo_topo_metadata where topology = ?  and table_name = ?  and column_name = ?  and table_owner = ?  and owner = ?";
                        log.info("[Topology Metadata Query] " + string9);
                        preparedStatement = null;
                        resultSet = null;
                        connection = abstractDBDataSource.getConnection();
                        preparedStatement = connection.prepareStatement(string9);
                        preparedStatement.setString(1, string5.toUpperCase());
                        preparedStatement.setString(2, string8.toUpperCase());
                        preparedStatement.setString(3, string4.toUpperCase());
                        preparedStatement.setString(4, string7.toUpperCase());
                        preparedStatement.setString(5, string6.toUpperCase());
                        resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) break block40;
                        log.severe("Unable to load Topology " + string5 + ", Table Name " + string8 + ", Column Name " + string4 + ", Table Owner " + string7 + ", Topology Owner " + string6);
                        bl = false;
                        Object var21_19 = null;
                        if (resultSet == null) break block41;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception2222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                this.topoOwner = resultSet.getString("owner");
                this.topologyName = resultSet.getString("topology");
                this.topologyId = resultSet.getInt("topology_id");
                this.tolerance = resultSet.getDouble("tolerance");
                this.featureTable = n < 0 ? resultSet.getString("table_name") : string3.substring(0, n) + "." + resultSet.getString("table_name");
                this.topoColumn = resultSet.getString("column_name");
                this.tgLayerId = resultSet.getInt("tg_layer_id");
                this.tgLayerType = resultSet.getString("tg_layer_type");
                this.tgLayerLevel = resultSet.getInt("tg_layer_level");
                this.childLayerId = resultSet.getInt("child_layer_id");
                this.tableOwner = resultSet.getString("table_owner");
                if (this.tgLayerLevel > 0) {
                    this.hierLayers = new int[this.tgLayerLevel + 1];
                    if (this.tgLayerLevel == 1) {
                        this.hierLayers[1] = this.tgLayerId;
                        this.hierLayers[0] = this.childLayerId;
                    } else {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        String string10 = "select tg_layer_id, child_layer_id from all_sdo_topo_metadata where topology_id = ? and owner = ?";
                        preparedStatement = connection.prepareStatement(string10);
                        preparedStatement.setInt(1, this.topologyId);
                        preparedStatement.setString(2, this.topoOwner);
                        resultSet = preparedStatement.executeQuery();
                        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
                        while (resultSet.next()) {
                            if (resultSet.getString(2) == null) continue;
                            hashtable.put(resultSet.getString(1), resultSet.getString(2));
                        }
                        int n3 = this.tgLayerId;
                        int n4 = this.tgLayerLevel;
                        this.hierLayers[n4] = n3;
                        while (n4 > 0) {
                            n3 = Integer.parseInt(hashtable.get(String.valueOf(n3)).toString());
                            this.hierLayers[--n4] = n3;
                        }
                    }
                }
                Object var21_20 = null;
                if (resultSet == null) break block44;
                try {
                    resultSet.close();
                }
                catch (Exception exception322) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception322) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception322) {}
            }
            break block49;
            {
                catch (Exception exception4) {
                    Exception exception5222;
                    log.severe("Topology load metadata Exception: " + exception4.getMessage());
                    boolean bl = false;
                    Object var21_21 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Exception exception6222;
                Object var21_22 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception6222) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception6222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception6222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return true;
    }

    public void setASIS(boolean bl) {
        this.passThrough = bl;
    }

    public boolean getASIS() {
        return this.passThrough;
    }

    public String getKeyColumn() {
        return this.mKeyColumn;
    }

    public String getCurrentKey() {
        return this.currentKey;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public String getCacheGeomGroupName(int n) {
        Integer n2 = new Integer(n);
        Object v = this.sridGeomCache.get(n2);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public Hashtable getSRidGeomCache() {
        return this.sridGeomCache;
    }

    public void createCacheGeomGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.sridGeomCache.get(n2) != null) {
            log.info("Cache group for SRid " + n + " already exists.");
            return;
        }
        String string = this.topologyName + "_" + this.featureTable + "_" + this.topoColumn + "_" + n + "_PDT_TOPO";
        log.finer("Cache group: " + string);
        boolean bl = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, string, 0, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        this.sridGeomCache.put(n2, string);
    }

    public String getCacheEdgeGroupName(int n) {
        Integer n2 = new Integer(n);
        Object v = this.sridEdgeCache.get(n2);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public Hashtable getSRidEdgeCache() {
        return this.sridEdgeCache;
    }

    public void createCacheEdgeGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.sridEdgeCache.get(n2) != null) {
            log.info("Edge Cache group for SRid " + n + " already exists.");
            return;
        }
        String string = this.topologyName + "_" + this.featureTable + "_" + this.topoColumn + "_" + n + "_PDT_EDGE_TOPO";
        log.finer("Edge Cache group: " + string);
        boolean bl = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, string, 0, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        this.sridEdgeCache.put(n2, string);
    }

    public String getCacheNodeGroupName(int n) {
        Integer n2 = new Integer(n);
        Object v = this.sridNodeCache.get(n2);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public Hashtable getSRidNodeCache() {
        return this.sridNodeCache;
    }

    public void createCacheNodeGroup(int n) {
        Integer n2 = new Integer(n);
        if (this.sridNodeCache.get(n2) != null) {
            log.info("Node Cache group for SRid " + n + " already exists.");
            return;
        }
        String string = this.topologyName + "_" + this.featureTable + "_" + this.topoColumn + "_" + n + "_PDT_EDGE_TOPO";
        log.finer("Node Cache group: " + string);
        boolean bl = this.cachingMode == 2;
        try {
            CacheMgr2.createGeomGroup(this.cacheSubRegionName, string, 0, bl);
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
        }
        this.sridNodeCache.put(n2, string);
    }

    private String createPredefinedQueryString() {
        int n;
        String string;
        Object object;
        String string2 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>(8);
        if (this.mStyleRules != null) {
            if (this.mStyleRules.length > 1) {
                log.warning("Topology theme uses just first styling rule. All other rules are ignored.");
            }
            for (int i = 0; i < 1; ++i) {
                RenderingRule[] renderingRuleArray;
                String[] stringArray = this.mStyleRules[i].getAttributeColumnsAsArray();
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = stringArray[j].toUpperCase();
                        if (arrayList.contains(string3)) continue;
                        arrayList.add(string3);
                    }
                }
                if ((renderingRuleArray = this.mStyleRules[i].getRenderingRules()) == null) continue;
                for (int j = 0; j < renderingRuleArray.length; ++j) {
                    Object object2;
                    object = renderingRuleArray[j].getStyleColumns();
                    if (object != null) {
                        for (int k = 0; k < ((String[])object).length; ++k) {
                            object2 = object[k].toUpperCase();
                            if (arrayList.contains(object2)) continue;
                            arrayList.add(object2);
                        }
                    }
                    string = renderingRuleArray[j].getSubStyleName();
                    object2 = renderingRuleArray[j].getSubStyleColumns();
                    if (object2 == null) continue;
                    for (int k = 0; k < ((String[])object2).length; ++k) {
                        String string4 = object2[k].toUpperCase();
                        if (arrayList.contains(string4)) continue;
                        arrayList.add(string4);
                    }
                }
            }
        }
        if (this.getIdentifiableColumns() != null) {
            Field[] fieldArray = this.getIdentifiableColumns();
            for (int i = 0; i < fieldArray.length; ++i) {
                int n2 = arrayList.indexOf(fieldArray[i].getName());
                if (n2 >= 0) continue;
                arrayList.add(fieldArray[i].getName());
            }
        }
        String string5 = this.featureTable;
        String string6 = this.topoColumn;
        if (this.topoView != null && this.topoViewColumn != null) {
            string5 = this.topoView;
            string6 = this.topoViewColumn;
        }
        String string7 = "";
        for (n = 0; n < arrayList.size(); ++n) {
            string7 = string7 + ", " + arrayList.get(n);
        }
        if (this.mStyleRules == null || this.mStyleRules.length < 1) {
            string2 = "SELECT " + string6 + ", null, null, null, -1" + string7 + " FROM " + string5;
            return string2;
        }
        string2 = "";
        for (n = 0; n < 1; ++n) {
            object = this.mStyleRules[n];
            string = "SELECT " + string6 + ", '" + ((StylingRule)object).getFeatureStyleName() + "', " + ((StylingRule)object).getLabelColumn() + ", '" + ((StylingRule)object).getLabelStyleName() + "', " + ((StylingRule)object).getLabelFunction() + string7 + " FROM " + string5;
            if (this.mStyleRules[n].getFeatureCond() != null) {
                string = string + " WHERE " + this.mStyleRules[n].getFeatureCond();
            }
            if (this.mStyleRules.length == 1) {
                string2 = string;
                continue;
            }
            if (n > 0) {
                string2 = string2 + " UNION ALL ";
            }
            string2 = string2 + string;
        }
        return string2;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public int getTopologyID() {
        return this.topologyId;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public String getTopologyOwner() {
        return this.topoOwner;
    }

    public String getFeatureTable() {
        return this.featureTable;
    }

    public String getTopoGeometryColumn() {
        return this.topoColumn;
    }

    public int getTopoLayerID() {
        return this.tgLayerId;
    }

    public String getTopoLayerType() {
        return this.tgLayerType;
    }

    public int getTopoLayerLevel() {
        return this.tgLayerLevel;
    }

    public int getChildLayerID() {
        return this.childLayerId;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public boolean isPre9i() {
        return this.mPre9i;
    }

    public String getQuery() {
        return this.mQuery;
    }

    public String getRenderStyle() {
        return this.renderStyleName;
    }

    public String getLabelColumn() {
        return this.labelColumnName;
    }

    public String getLabelStyle() {
        return this.labelStyleName;
    }

    public String getEdgeGeometryColumn() {
        return this.edgeSpatialColumn;
    }

    public String getNodeGeometryColumn() {
        return this.nodeSpatialColumn;
    }

    public String getEdgeStyle() {
        return this.edgeStyle;
    }

    public String getEdgeLabelStyle() {
        return this.edgeLabelStyle;
    }

    public String getEdgeMarkerStyle() {
        return this.edgeMarkerStyle;
    }

    public int getEdgeMarkerSize() {
        return this.edgeMarkerSize;
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public String getNodeLabelStyle() {
        return this.nodeLabelStyle;
    }

    public int getNodeMarkerSize() {
        return this.nodeMarkerSize;
    }

    public String getFaceStyle() {
        return this.faceStyle;
    }

    public String getFaceLabelStyle() {
        return this.faceLabelStyle;
    }

    public boolean getDebugTheme() {
        return this.debugTheme;
    }

    public int getCachingMode() {
        return this.cachingMode;
    }

    public String getCacheSubRegion() {
        return this.cacheSubRegionName;
    }

    public String getCacheGeomGroup() {
        return this.cacheGeomGroup;
    }

    public String getCacheEdgeGroup() {
        return this.cacheEdgeGroup;
    }

    public String getCacheNodeGroup() {
        return this.cacheNodeGroup;
    }

    public double getMinDistBetweenNodes() {
        return this.minDistBetweenNodes;
    }

    public void setMinDistBetweenNodes(double d) {
        this.minDistBetweenNodes = d;
    }

    public int[] getLayersHierarchy() {
        return this.hierLayers;
    }

    public String getThemeType() {
        return "TOPOLOGY";
    }

    public String getXMLDefinition() {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<styling_rules");
        this.getCommonAttributes(stringBuffer);
        stringBuffer.append(this.getAttributes());
        stringBuffer.append(">\n");
        this.getInfoFields(stringBuffer);
        StylingRule[] stylingRuleArray = this.mStyleRules;
        if (stylingRuleArray != null) {
            for (int i = 0; i < stylingRuleArray.length; ++i) {
                StylingRule stylingRule = stylingRuleArray[i];
                stringBuffer.append("  <rule" + PredGeomThemeDefinition.getRuleAttributes(stylingRule) + ">\n");
                stringBuffer.append(PredGeomThemeDefinition.getRuleFeatures(stylingRule));
                stringBuffer.append(PredGeomThemeDefinition.getRuleLabel(stylingRule));
                stringBuffer.append("  </rule>\n");
            }
        }
        stringBuffer.append("</styling_rules>");
        return stringBuffer.toString();
    }

    public String getAttributes() {
        String string = "";
        if (this.topologyName != null) {
            string = string + " topology_name=\"" + this.topologyName + "\"";
        }
        if (this.debugTheme) {
            string = string + " mode=\"debug\"";
        }
        return string;
    }

    void getCommonAttributes(StringBuffer stringBuffer) {
        String string;
        String string2 = this.getThemeType();
        if (string2 != null && string2.trim().length() > 0) {
            stringBuffer.append(" theme_type=\"" + string2 + "\"");
        }
        if ((string = this.getKeyColumn()) != null && string.trim().length() > 0) {
            stringBuffer.append(" key_column=\"" + string + "\"");
        }
        int n = this.getCachingMode();
        String string3 = "normal";
        if (n == 2) {
            string3 = "all";
        } else if (n == 3) {
            string3 = "none";
        }
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(" caching=\"" + string3 + "\"");
        }
    }

    void getInfoFields(StringBuffer stringBuffer) {
        if (this.identifiableColumns == null || this.identifiableColumns.length == 0) {
            return;
        }
        stringBuffer.append("  <hidden_info>\n");
        for (int i = 0; i < this.identifiableColumns.length; ++i) {
            stringBuffer.append("    <field column=\"" + this.identifiableColumns[i].getName() + "\"" + " name=\"" + this.identifiableColumns[i].getDisplayName() + "\"/>\n");
        }
        stringBuffer.append("  </hidden_info>\n");
    }

    public String getTopoView() {
        return this.topoView;
    }

    public String getTopoViewColumn() {
        return this.topoViewColumn;
    }

    public void setTopoViewParameters(String string, String string2) {
        this.topoView = string;
        this.topoViewColumn = string2;
        if (this.predefined && this.topoView != null && this.topoViewColumn != null) {
            this.mQuery = this.createPredefinedQueryString();
            log.finer("[Predefined Query - Topology Theme] " + this.mQuery);
        }
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public StylingRule[] getStylingRules() {
        return this.mStyleRules;
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.featureTable);
        basicThemeInfo.setType("TOPOLOGY");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.topoColumn);
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        if (this.renderStyleName == null) {
            return null;
        }
        String[] stringArray = new String[]{this.renderStyleName.toUpperCase()};
        return stringArray;
    }

    public String[] getLabelingStyles() {
        if (this.labelStyleName == null) {
            return null;
        }
        String[] stringArray = new String[]{this.labelStyleName.toUpperCase()};
        return stringArray;
    }
}

