/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.DirectionalLight;
import oracle.sdovis.raytracing.Group;
import oracle.sdovis.raytracing.LightSource;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.PerspectiveCamera;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;

public class ShadedReliefThemeDefinition
extends ThemeDefinition {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private GeoRasterThemeDefinition grdef;
    private int dispW;
    private int dispH;
    private int bounces;
    private int weight;
    private String rtParams;
    private Camera cam;
    private Group gr;
    private Vector3d camDirection;
    private Vector3d camUp;
    private Vector3d bkgColor;
    private Vector3d bkgAmbientLight;
    private LightSource[] lights;
    private Material[] materials;

    public ShadedReliefThemeDefinition(String string, GeoRasterThemeDefinition geoRasterThemeDefinition, Vector3d vector3d, double d, int n, int n2) {
        this.name = string;
        this.grdef = geoRasterThemeDefinition;
        this.bounces = n;
        this.weight = n2;
        this.setStandardRTParams();
        this.cam = new PerspectiveCamera(vector3d, this.camDirection, this.camUp, d);
        this.materials = null;
        this.gr = null;
    }

    public ShadedReliefThemeDefinition(String string, GeoRasterThemeDefinition geoRasterThemeDefinition, Vector3d vector3d, double d, int n, int n2, int n3, int n4) {
        this.name = string;
        this.grdef = geoRasterThemeDefinition;
        this.dispW = n;
        this.dispH = n2;
        this.bounces = n3;
        this.weight = n4;
        this.setStandardRTParams();
        this.cam = new PerspectiveCamera(vector3d, this.camDirection, this.camUp, d);
        this.materials = null;
        this.gr = null;
    }

    public ShadedReliefThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Vector3d vector3d, double d, int n, int n2, int n3, int n4) {
        this.name = string;
        this.grdef = new GeoRasterThemeDefinition(string, string2, string3, string4, string5, string6, string7, string8);
        this.dispW = n;
        this.dispH = n2;
        this.bounces = n3;
        this.weight = n4;
        this.setStandardRTParams();
        this.cam = new PerspectiveCamera(vector3d, this.camDirection, this.camUp, d);
        this.materials = null;
        this.gr = null;
    }

    public void setStandardRTParams() {
        this.camDirection = new Vector3d(0.0, -1.0, 0.0);
        this.camUp = new Vector3d(0.0, 0.0, 1.0);
        this.bkgColor = new Vector3d(0.5, 0.5, 0.5);
        this.bkgAmbientLight = new Vector3d(0.3, 0.3, 0.3);
        this.lights = new LightSource[1];
        Vector3d vector3d = new Vector3d(0.0, -1.0, -1.0);
        Vector3d vector3d2 = new Vector3d(0.3, 0.3, 0.3);
        this.lights[0] = new DirectionalLight(vector3d, vector3d2);
    }

    public int getWeight() {
        return this.weight;
    }

    public int getBounces() {
        return this.bounces;
    }

    public int getDispW() {
        return this.dispW;
    }

    public int getDispH() {
        return this.dispH;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public Group getGroup() {
        return this.gr;
    }

    public Vector3d getBackgroundColor() {
        return this.bkgColor;
    }

    public String getThemeType() {
        return "SHADED_RELIEF";
    }

    public Vector3d getAmbientLight() {
        return this.bkgAmbientLight;
    }

    public LightSource[] getLights() {
        return this.lights;
    }

    public LightSource getLight(int n) {
        return this.lights[n];
    }

    public Material[] getMaterials() {
        return this.materials;
    }

    public Material getMaterial(int n) {
        return this.materials[n];
    }

    public ThemeDefinition getGeorDef() {
        return this.grdef;
    }

    public String getXMLDefinition() {
        return "";
    }

    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.grdef.getBaseTable());
        basicThemeInfo.setType("SHADED_RELIEF");
        basicThemeInfo.setKeyColumn(this.grdef.mKeyColumn);
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.grdef.getGeoRasterColumn());
        return basicThemeInfo;
    }

    public String[] getRenderingStyles() {
        return null;
    }

    public String[] getLabelingStyles() {
        return null;
    }
}

