/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.Proj;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;

public class LocalThemeDataProducer
implements ThemeDataProducer {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected StyledFeatureI[] styledFeatures = null;
    protected double[] dataMBR = null;
    protected Theme theme = null;

    private LocalThemeDataProducer() {
    }

    public LocalThemeDataProducer(Theme theme) {
        this.theme = theme;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public int size() {
        return this.styledFeatures != null ? this.styledFeatures.length : 0;
    }

    public StyledFeatureI getStyledFeature(int n) {
        if (this.styledFeatures == null) {
            return null;
        }
        try {
            return this.styledFeatures[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public double[] getDataMBR() {
        if (this.styledFeatures == null || this.styledFeatures.length == 0) {
            return null;
        }
        if (this.dataMBR != null) {
            return this.dataMBR;
        }
        double[] dArray = null;
        RectangularShape rectangularShape = null;
        for (int i = 0; i < this.styledFeatures.length; ++i) {
            dArray = this.getStyledFeature(i).getGeomMBR();
            if (rectangularShape == null) {
                rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)rectangularShape).add(dArray[0], dArray[1]);
            }
            if (dArray.length == 4) {
                ((Rectangle2D)rectangularShape).add(dArray[2], dArray[3]);
                continue;
            }
            ((Rectangle2D)rectangularShape).add(dArray[3], dArray[4]);
        }
        this.dataMBR = new double[4];
        this.dataMBR[0] = rectangularShape.getMinX();
        this.dataMBR[1] = rectangularShape.getMinY();
        this.dataMBR[2] = rectangularShape.getMaxX();
        this.dataMBR[3] = rectangularShape.getMaxY();
        return this.dataMBR;
    }

    public StyledFeatureI[] getStyledFeatures() {
        return this.styledFeatures;
    }

    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
        this.styledFeatures = styledFeatureIArray;
    }

    public void setStyledFeatures(List list) {
        this.styledFeatures = list != null ? list.toArray(new StyledFeatureI[list.size()]) : new StyledFeature[0];
    }

    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        int n;
        if (this.styledFeatures == null) {
            return 0;
        }
        Proj proj = visContext.getProjection();
        double d = visContext.getCurrentScale();
        this.getTheme().setShowLabels(true);
        if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
            SRS sRS = visContext.getSrs();
            if (sRS != null) {
                if (rectangle2D == null) {
                    d = sRS.getRatioScale(d, null);
                } else {
                    double d2 = rectangle2D.getCenterX();
                    double d3 = rectangle2D.getCenterY();
                    d = sRS.getRatioScale(d, new Point2D.Double(d2, d3));
                }
                log.finer("Ratio scale to compare: " + d);
            } else {
                log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                return 0;
            }
        }
        if (!this.getTheme().getDecorator().withinScaleLimits(d)) {
            log.fine("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
            return 0;
        }
        if (!this.getTheme().getDecorator().withinLabelScaleLimits(d)) {
            log.info("Label Scale definition for theme " + this.getTheme().getName() + " is out of range. Labels will not be rendered.");
            this.getTheme().setShowLabels(false);
        }
        for (n = 0; n < this.styledFeatures.length; ++n) {
            JGeometry jGeometry;
            JSDOGeometry jSDOGeometry = this.styledFeatures[n].getGeometry();
            if (jSDOGeometry == null) continue;
            if (jSDOGeometry.getSRID() > 0 && visContext.getMasterSRID() > 0 && jSDOGeometry.getSRID() != visContext.getMasterSRID() && this.styledFeatures[n].getDataSource() != null) {
                jGeometry = null;
                try {
                    jGeometry = Util.processSRIDConversion(this.styledFeatures[n].getDataSource(), jSDOGeometry, visContext.getMasterSRID());
                }
                catch (Exception exception) {
                    continue;
                }
                if (jGeometry == null) continue;
                jSDOGeometry = JSDOGeometry.recast(jGeometry);
            }
            if (visContext.getRotation() != 0.0) {
                jGeometry = Util.rotateGeometry(jSDOGeometry, rectangle2D.getCenterX(), rectangle2D.getCenterY(), visContext.getRotation());
                if (jGeometry == null) continue;
                jSDOGeometry = JSDOGeometry.recast(jGeometry);
            }
            if ((jSDOGeometry = visContext.getSrs().shift(jSDOGeometry, visContext.getQueryWindow())) == null || proj != null && (jSDOGeometry = SRS.proj(jSDOGeometry, proj, 0)) == null) continue;
            this.styledFeatures[n].setGeometry(jSDOGeometry);
        }
        for (n = 0; n < this.styledFeatures.length; ++n) {
            this.styledFeatures[n].resetRenderableShape();
        }
        return this.styledFeatures.length;
    }

    public void postPreparation(VisContext visContext) {
        if (this.theme.getDecorator().isSortingNeeded() && this.styledFeatures != null && this.styledFeatures.length > 0) {
            this.sortFeatures(visContext);
        }
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        StyledFeatureI[] styledFeatureIArray = this.getSelectedFeatures(rectangle2D);
        if (styledFeatureIArray == null || styledFeatureIArray.length <= 0) {
            return null;
        }
        StyledFeatureI[] styledFeatureIArray2 = new StyledFeatureI[styledFeatureIArray.length];
        System.arraycopy(styledFeatureIArray, 0, styledFeatureIArray2, 0, styledFeatureIArray.length);
        LocalTheme localTheme = new LocalTheme(string, styledFeatureIArray2);
        return localTheme;
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        int n;
        GeneralPath generalPath = null;
        Point2D point2D = null;
        ArrayList<StyledFeatureI> arrayList = new ArrayList<StyledFeatureI>();
        StyledFeature[] styledFeatureArray = null;
        for (n = 0; n < this.styledFeatures.length; ++n) {
            if (this.styledFeatures[n].getShape() != null) {
                generalPath = new GeneralPath(this.styledFeatures[n].getShape());
                if (this.styledFeatures[n].getGeomType() == 2 || this.styledFeatures[n].getGeomType() == 6) {
                    Rectangle2D rectangle2D2 = generalPath.getBounds2D();
                    double d = rectangle2D2.getWidth();
                    double d2 = rectangle2D2.getHeight();
                    if (d == 0.0 && d2 == 0.0 && rectangle2D.contains(rectangle2D2.getCenterX(), rectangle2D2.getCenterY())) {
                        arrayList.add(this.styledFeatures[n]);
                        continue;
                    }
                    if (!rectangle2D.contains(rectangle2D2) && !ShapeUtil.intersects(generalPath, rectangle2D)) continue;
                    arrayList.add(this.styledFeatures[n]);
                    continue;
                }
                if (!generalPath.intersects(rectangle2D)) continue;
                arrayList.add(this.styledFeatures[n]);
                continue;
            }
            point2D = this.styledFeatures[n].getPoint();
            if (point2D == null || !rectangle2D.contains(point2D)) continue;
            arrayList.add(this.styledFeatures[n]);
        }
        if (arrayList.size() > 0) {
            styledFeatureArray = new StyledFeature[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                styledFeatureArray[n] = (StyledFeatureI)arrayList.get(n);
            }
        }
        return styledFeatureArray;
    }

    public void sortFeatures(VisContext visContext) {
        int n;
        int n2;
        StyledFeatureI styledFeatureI = this.styledFeatures[0];
        BucketStyle bucketStyle = null;
        try {
            bucketStyle = (BucketStyle)styledFeatureI.getFeatureStyle();
            if (bucketStyle == null && (bucketStyle = (BucketStyle)visContext.getDynamicStyle(styledFeatureI.getFeatureStyleName())) == null) {
                DataSourceI dataSourceI = DSManager.get(this.theme.getDataSourceName());
                StyleCache styleCache = dataSourceI.getStyleCache();
                bucketStyle = (BucketStyle)styleCache.get(styledFeatureI.getFeatureStyleName());
            }
            if (bucketStyle == null) {
                log.warning("cannot find style in sortFeatures()");
                return;
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Failure sorting features.", exception);
            return;
        }
        int n3 = this.styledFeatures.length;
        int n4 = bucketStyle.getNumBuckets();
        if (n4 <= 0) {
            return;
        }
        String string = this.theme != null ? this.theme.getName() : null;
        log.finest("Sorting features for theme " + string + " by order of buckets...");
        ArrayList[] arrayListArray = new ArrayList[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            arrayListArray[n2] = new ArrayList(n3 / n4);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            styledFeatureI = this.styledFeatures[n2];
            n = -1;
            try {
                Field field = styledFeatureI.getRenderableAttribute(0);
                n = bucketStyle.getBucketIndex(field);
                Style style = bucketStyle.chooseStyle(field);
                styledFeatureI.setFeatureStyle(style);
                String string2 = styledFeatureI.getFeatureStyleName();
                styledFeatureI.setFeatureStyleName(null);
                Style style2 = bucketStyle.chooseLabelStyle(field);
                if (style2 != null) {
                    styledFeatureI.setLabelStyle(style2);
                    styledFeatureI.setLabelStyleName(null);
                } else if (string2 != null && string2.equalsIgnoreCase(styledFeatureI.getLabelStyleName()) || styledFeatureI.getLabelStyle() == bucketStyle) {
                    styledFeatureI.setLabel(null);
                    styledFeatureI.setLabelStyle(null);
                    styledFeatureI.setLabelStyleName(null);
                    styledFeatureI.setForceLabel(false);
                }
                arrayListArray[n].add(styledFeatureI);
                continue;
            }
            catch (Exception exception) {
                arrayListArray[n4 - 1].add(styledFeatureI);
            }
        }
        this.styledFeatures = new StyledFeature[n3];
        n = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            System.arraycopy(arrayListArray[n2].toArray(new StyledFeature[arrayListArray[n2].size()]), 0, this.styledFeatures, n, arrayListArray[n2].size());
            n += arrayListArray[n2].size();
        }
    }

    public boolean isTextLabelPresent() {
        if (this.styledFeatures == null) {
            return false;
        }
        for (int i = 0; i < this.styledFeatures.length; ++i) {
            StyledFeatureI styledFeatureI = this.styledFeatures[i];
            Style style = styledFeatureI.getLabelStyle();
            String string = styledFeatureI.getLabelStyleName();
            if (style == null && string == null || string == null && (style == null || !(style instanceof StyleText))) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }

    public void abort() {
    }

    public StyledFeatureI getNewStyledFeatureInstance() {
        return new StyledFeature();
    }
}

