/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.MapMaker;
import oracle.sdovis.RSBundle;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.georaster.JGeoRaster;
import oracle.spatial.georaster.SubLayerInfo;
import oracle.spatial.georaster.image.GeoRasterImageProcessUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoRasterThemeProducer
implements ThemeDataProducer {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected Theme owner;
    protected GeoRasterThemeDefinition def;
    double[][] mbrs = null;
    HashMap renderImages = new HashMap();
    private Hashtable<String, Double> imgRotations = new Hashtable();
    private Hashtable<String, Point2D> imgRotRefPoint = new Hashtable();
    private Hashtable<String, Boolean> imgRotFlip = new Hashtable();
    private Hashtable<String, JSDOGeometry> imgRotMask = new Hashtable();
    private Hashtable<String, Integer> imgTransf = new Hashtable();
    private JSDOGeometry themePolyMask = null;
    private Hashtable<String, Vector<JSDOGeometry>> themePolygonMasks = new Hashtable();
    private Vector<String> georasterIds = new Vector();
    private Object[] bindingParameters = null;
    private String[] overoperationNames = null;
    private Hashtable overoperationParameters = null;
    private Hashtable overbitmapMasks = null;
    private double screenResolution = 0.0;

    public GeoRasterThemeProducer() {
    }

    public GeoRasterThemeProducer(Theme theme) {
        this.owner = theme;
        this.def = (GeoRasterThemeDefinition)theme.getDefinition();
    }

    public GeoRasterThemeProducer(Theme theme, Object[] objectArray) {
        this.owner = theme;
        this.def = (GeoRasterThemeDefinition)theme.getDefinition();
        this.bindingParameters = objectArray;
    }

    @Override
    public Theme getTheme() {
        return this.owner;
    }

    public void setBindingParameters(Object[] objectArray) {
        this.bindingParameters = objectArray;
    }

    public Object[] getBindingParameters() {
        return this.bindingParameters;
    }

    @Override
    public int size() {
        return this.mbrs == null ? 0 : this.mbrs.length;
    }

    @Override
    public void setStyledFeatures(StyledFeatureI[] styledFeatureIArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int prepareData(Rectangle2D var1_1, VisContext var2_2) throws DataException {
        block253: {
            block220: {
                block254: {
                    block217: {
                        this.destroy();
                        if (this.def.getImageQuery() == null && this.def.getRasterId() == null) {
                            GeoRasterThemeProducer.log.warning("Unable to prepare data. GeoRaster query or raster id must be defined.");
                            return 0;
                        }
                        if (this.def.getSrid() == 0) {
                            GeoRasterThemeProducer.log.warning("GeoRaster SRID can not be 0.");
                            return 0;
                        }
                        var3_3 = var1_1.getMinX();
                        var5_4 = var1_1.getMinY();
                        var7_5 = var1_1.getMaxX();
                        var9_6 = var1_1.getMaxY();
                        var11_7 = false;
                        if (var3_3 == -Infinity || var5_4 == -Infinity || var7_5 == Infinity || var9_6 == Infinity) {
                            var11_7 = true;
                        }
                        var12_8 = null;
                        try {
                            var12_8 = DSUtil.getDBConnection(this.def.getDataSourceName(), var2_2);
                        }
                        catch (Exception var13_9) {
                            GeoRasterThemeProducer.log.warning(var13_9.getMessage());
                            throw new DataException("cannot obtain a connection to database.");
                        }
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                if (this.getTheme().getDecorator().getWorkspaceName() == null) break block217;
                                if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                    Util.gotoWorkspaceDate(var12_8, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceDate(), this.getTheme().getDecorator().getWorkspaceDateFormat(), this.getTheme().getDecorator().getWorkspaceDateNlsParam(), this.getTheme().getDecorator().isWorkspaceDateTsWtz());
                                    break block217;
                                }
                                if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                    Util.gotoWorkspaceSavedPoint(var12_8, this.getTheme().getDecorator().getWorkspaceName(), this.getTheme().getDecorator().getWorkspaceSavedPoint());
                                } else {
                                    Util.gotoWorkspace(var12_8, this.getTheme().getDecorator().getWorkspaceName());
                                }
                            }
                            catch (Exception var13_10) {
                                var14_12 = "Cannot go to workspace " + this.getTheme().getDecorator().getWorkspaceName();
                                if (this.getTheme().getDecorator().getWorkspaceDate() != null) {
                                    var14_12 = var14_12 + ", Date " + this.getTheme().getDecorator().getWorkspaceDate();
                                } else if (this.getTheme().getDecorator().getWorkspaceSavedPoint() != null) {
                                    var14_12 = var14_12 + ", Saved Point " + this.getTheme().getDecorator().getWorkspaceSavedPoint();
                                }
                                GeoRasterThemeProducer.log.log(Level.SEVERE, var14_12, var13_10);
                                throw new DataException(var14_12);
                            }
                        }
                    }
                    var13_11 = DSManager.getSRSCache(this.def.getDataSourceName());
                    var14_13 = var13_11.get(this.def.getSrid());
                    var15_14 = false;
                    var16_15 = null;
                    if (var14_13 != null) {
                        var15_14 = var14_13.isGeodetic();
                        var16_15 = var14_13.getUnit();
                    } else if (this.def.getSrid() > 0) {
                        GeoRasterThemeProducer.log.warning("cannot locate an SRS object for srid: " + this.def.getSrid());
                    }
                    var17_16 = var3_3;
                    var19_17 = var7_5;
                    var21_18 = var5_4;
                    var23_19 = var9_6;
                    var25_20 = var2_2.getCurrentScale();
                    if (var2_2.getMasterSRID() > 0 && this.def.getSrid() > 0 && this.def.getSrid() != var2_2.getMasterSRID() && this.def.getSrid() != 999999 && this.def.getSrid() != 262148 && var25_20 != Infinity && var25_20 != -Infinity) {
                        var27_21 = new double[4];
                        var27_21[0] = var3_3;
                        var27_21[1] = var5_4;
                        var27_21[2] = var7_5;
                        var27_21[3] = var9_6;
                        var28_22 = Util.convertMBR((double[])var27_21, var2_2.getMasterSRID(), this.def.getSrid(), var12_8);
                        if (var28_22 != null) {
                            var3_3 = var28_22[0];
                            var5_4 = var28_22[1];
                            var7_5 = var28_22[2];
                            var9_6 = var28_22[3];
                        } else {
                            GeoRasterThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01024"));
                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                try {
                                    Util.gotoWorkspace(var12_8, "LIVE");
                                }
                                catch (Exception var29_24) {
                                    GeoRasterThemeProducer.log.warning(var29_24.getMessage());
                                }
                            }
                            try {
                                if (var12_8 == null) return 0;
                                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                return 0;
                            }
                            catch (Exception var29_25) {
                                GeoRasterThemeProducer.log.warning(var29_25.getMessage());
                            }
                            return 0;
                        }
                    }
                    this.themePolyMask = this.def.getPolygonMask();
                    var27_21 = this.def.getPolygonMask();
                    var28_23 = 0;
                    if (var27_21 == null) break block254;
                    var28_23 = var27_21.getSRID();
                    if (var27_21 == null || var2_2.getMasterSRID() <= 0 || var28_23 <= 0 || var28_23 == var2_2.getMasterSRID() || var28_23 == 999999 || var28_23 == 262148) break block220;
                    var29_26 = "NULL";
                    if (var28_23 != 0) {
                        var29_26 = String.valueOf(var28_23);
                    }
                    var30_27 = "MDSYS.SDO_GEOMETRY(2003, " + (String)var29_26 + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 1), " + "MDSYS.SDO_ORDINATE_ARRAY(";
                    var31_29 = this.def.getPolygonMask().getOrdinatesArray();
                    for (var32_31 = 0; var32_31 < var31_29.length; ++var32_31) {
                        var30_27 = var32_31 > 0 ? var30_27 + "," + var31_29[var32_31] : var30_27 + var31_29[var32_31];
                    }
                    var30_27 = var30_27 + "))";
                    var32_32 = "select sdo_cs.transform(" + var30_27 + "," + var2_2.getMasterSRID() + ") from dual";
                    var33_34 = null;
                    var34_36 = null;
                    try {
                        var33_34 = var12_8.prepareStatement(var32_32);
                        var34_36 = var33_34.executeQuery();
                        if (var34_36.next()) {
                            this.themePolyMask = var35_38 = JDBCUtil.loadGeometry((ResultSet)var34_36, 1, false);
                        } else {
                            GeoRasterThemeProducer.log.warning("No conversion record returned. Mask will be ignored.");
                        }
                    }
                    catch (Exception var35_39) {
                        GeoRasterThemeProducer.log.warning(var35_39.getMessage());
                        GeoRasterThemeProducer.log.warning("Conversion of polygon mask was not successfull. Mask will be ignored.");
                        this.themePolyMask = null;
                        var37_44 = null;
                        try {
                            if (var34_36 != null) {
                                var34_36.close();
                            }
                        }
                        catch (Exception var38_46) {
                            GeoRasterThemeProducer.log.warning(var38_46.getMessage());
                        }
                        try {
                            if (var33_34 != null) {
                                var33_34.close();
                            }
                            break block220;
                        }
                        catch (Exception var38_46) {
                            GeoRasterThemeProducer.log.warning(var38_46.getMessage());
                        }
                        break block220;
                    }
                    var37_44 = null;
                    {
                        block256: {
                            catch (Throwable var36_49) {
                                block255: {
                                    var37_45 = null;
                                    ** try [egrp 6[TRYBLOCK] [8 : 1215->1230)] { 
lbl144:
                                    // 1 sources

                                    if (var34_36 != null) {
                                        var34_36.close();
                                    }
                                    break block255;
lbl147:
                                    // 1 sources

                                    catch (Exception var38_47) {
                                        GeoRasterThemeProducer.log.warning(var38_47.getMessage());
                                    }
                                }
                                ** try [egrp 7[TRYBLOCK] [9 : 1243->1258)] { 
lbl151:
                                // 1 sources

                                if (var33_34 == null) throw var36_49;
                                var33_34.close();
                                throw var36_49;
lbl154:
                                // 1 sources

                                catch (Exception var38_47) {
                                    GeoRasterThemeProducer.log.warning(var38_47.getMessage());
                                }
                                throw var36_49;
                            }
                            ** try [egrp 6[TRYBLOCK] [8 : 1215->1230)] { 
lbl158:
                            // 1 sources

                            if (var34_36 != null) {
                                var34_36.close();
                            }
                            break block256;
lbl161:
                            // 1 sources

                            catch (Exception var38_46) {
                                GeoRasterThemeProducer.log.warning(var38_46.getMessage());
                            }
                        }
                        try {}
                        catch (Exception var38_46) {}
                        GeoRasterThemeProducer.log.warning(var38_46.getMessage());
                        break block220;
                        if (var33_34 != null) {
                            var33_34.close();
                        }
                        break block220;
                    }
                }
                if (this.def.getPolygonMaskTable() != null && this.def.getPolygonMaskGeometryColumn() != null) {
                    this.processPolygonMasks(var12_8, var3_3, var5_4, var7_5, var9_6, var2_2.getMasterSRID());
                }
            }
            var29_26 = null;
            var30_28 = 0;
            var31_30 = 0;
            var32_33 = 1;
            var33_35 = 2;
            if (this.def.mBands != null) {
                var34_36 = Util.splitBy(this.def.mBands, ",");
                var29_26 = var34_36.toArray(new String[var34_36.size()]);
                try {
                    var30_28 = var29_26.length;
                    if (var29_26.length == 1) {
                        var32_33 = var31_30 = Integer.parseInt(var29_26[0]);
                        var33_35 = var31_30;
                    } else {
                        block88: for (var35_40 = 0; var35_40 < var29_26.length; ++var35_40) {
                            switch (var35_40) {
                                case 0: {
                                    var31_30 = Integer.parseInt(var29_26[var35_40]);
                                    continue block88;
                                }
                                case 1: {
                                    var32_33 = Integer.parseInt(var29_26[var35_40]);
                                    continue block88;
                                }
                                case 2: {
                                    var33_35 = Integer.parseInt(var29_26[var35_40]);
                                    continue block88;
                                }
                            }
                        }
                    }
                }
                catch (Exception var35_41) {
                    GeoRasterThemeProducer.log.warning(var35_41.getMessage());
                    GeoRasterThemeProducer.log.warning("Invalid band number. " + var35_41.getMessage());
                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                        try {
                            Util.gotoWorkspace(var12_8, "LIVE");
                        }
                        catch (Exception var36_50) {
                            GeoRasterThemeProducer.log.warning(var36_50.getMessage());
                        }
                    }
                    if (var12_8 == null) return 0;
                    try {
                        DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                        return 0;
                    }
                    catch (Exception var36_51) {
                        GeoRasterThemeProducer.log.warning(var36_51.getMessage());
                    }
                    return 0;
                }
                GeoRasterThemeProducer.log.finest("Bands: Red - " + var31_30 + " Green - " + var32_33 + " Blue - " + var33_35);
            }
            GeoRasterThemeProducer.log.finer("Original query window: " + var3_3 + "," + var5_4 + "," + var7_5 + "," + var9_6);
            var34_37 = false;
            if (!this.def.passThrough) {
                if (MapMaker.isSpecial(var3_3, var5_4, var7_5, var9_6) && var2_2.getRotation() != 0.0) {
                    GeoRasterThemeProducer.log.warning("Rotation is currently ignored for full extent.");
                } else if (var2_2.getRotation() != 0.0 && !MapMaker.isSpecial(var3_3, var5_4, var7_5, var9_6)) {
                    if (var2_2.getRotation() < -360.0 && var2_2.getRotation() > 360.0) {
                        GeoRasterThemeProducer.log.warning("Rotation value must be in between -360 to 360 degrees. ignored");
                    } else {
                        var35_42 = Util.rotateMBR(var3_3, var5_4, var7_5, var9_6, var2_2.getRotation());
                        if (var35_42 != null) {
                            var3_3 = Math.min(var35_42[0], var3_3);
                            var5_4 = Math.min(var35_42[1], var5_4);
                            var7_5 = Math.max(var35_42[2], var7_5);
                            var9_6 = Math.max(var35_42[3], var9_6);
                            GeoRasterThemeProducer.log.finest("Rotation angle: " + var2_2.getRotation());
                            GeoRasterThemeProducer.log.finest("Search window for rotation: " + var3_3 + "," + var5_4 + "," + var7_5 + "," + var9_6);
                            var34_37 = true;
                        } else {
                            GeoRasterThemeProducer.log.info("Rotated MBR is null. Rotation ignored.");
                        }
                    }
                }
            }
            var35_43 = this.def.getImageQuery();
            if (this.def.getRasterId() == null) {
                var35_43 = this.def.predefined != false ? this.getPredefinedQuery(var3_3, var5_4, var7_5, var9_6, var15_14) : this.rewriteQuery(var3_3, var5_4, var7_5, var9_6, var15_14);
            }
            if (var35_43 == null) {
                GeoRasterThemeProducer.log.severe("PrepareData - Invalid query: null.");
                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                    try {
                        Util.gotoWorkspace(var12_8, "LIVE");
                    }
                    catch (Exception var36_52) {
                        // empty catch block
                    }
                }
                if (var12_8 == null) return 0;
                try {
                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                    return 0;
                }
                catch (Exception var36_53) {
                    // empty catch block
                }
                return 0;
            }
            GeoRasterThemeProducer.log.finer("[Query] " + var35_43);
            var36_54 = null;
            var37_44 = null;
            var38_48 = 0;
            var39_55 = new Vector<double[]>(3);
            try {
                block257: {
                    block258: {
                        var36_54 = var12_8.prepareStatement(var35_43);
                        var40_56 = 0;
                        if (this.def.getRasterId() == null) {
                            if (!this.isFullExtent(this.def.passThrough, var3_3, var5_4, var7_5, var9_6)) {
                                var40_56 = 4;
                                var36_54.setDouble(1, var3_3);
                                var36_54.setDouble(2, var5_4);
                                var36_54.setDouble(3, var7_5);
                                var36_54.setDouble(4, var9_6);
                            }
                        } else {
                            var41_58 = this.def.getRasterId();
                            var42_61 = this.def.getRasterTable();
                            var36_54.setDouble(1, Double.parseDouble(var41_58));
                            if (var42_61 != null) {
                                var36_54.setString(2, var42_61.toUpperCase());
                            }
                        }
                        if (!this.def.predefined || this.bindingParameters == null || this.bindingParameters == null) break block257;
                        var41_59 = this.countBindingVariables(var35_43);
                        if (var41_59 <= 0 || this.bindingParameters.length >= var41_59) break block258;
                        GeoRasterThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01031"));
                        if (var12_8 != null) {
                            try {
                                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                            }
                            catch (Exception var42_62) {
                                GeoRasterThemeProducer.log.warning(var42_62.getMessage());
                            }
                        }
                        var42_63 = 0;
                        var129_66 = null;
                        if (this.getTheme().getDecorator().getWorkspaceName() == null) ** GOTO lbl664
                        ** GOTO lbl658
                    }
                    if (var41_59 > 0) {
                        for (var42_64 = 0; var42_64 < var41_59; ++var42_64) {
                            this.setBindingVariable(var36_54, this.bindingParameters[var42_64], var40_56 + var42_64 + 1);
                        }
                    }
                }
                var36_54.setFetchSize(this.owner.getFetchSize());
                GeoRasterThemeProducer.log.finer("Fetch size: " + var36_54.getFetchSize());
                var37_44 = var36_54.executeQuery();
                GeoRasterThemeProducer.log.finer("Query executed");
                var41_60 = 0;
                var3_3 = var17_16;
                var5_4 = var21_18;
                var7_5 = var19_17;
                var9_6 = var23_19;
                var42_65 = true;
                while (var37_44.next()) {
                    block264: {
                        block263: {
                            block262: {
                                block261: {
                                    block260: {
                                        block259: {
                                            var43_86 = null;
                                            var44_87 = JDBCUtil.getOracleSTRUCT(var37_44, 1);
                                            var45_88 = new JGeoRaster(var44_87);
                                            if (this.themePolygonMasks.size() > 0 && this.def.getPolygonMaskGeoRasterJoinColumn() != null) {
                                                var43_86 = var37_44.getString(this.def.getPolygonMaskGeoRasterJoinColumn());
                                                this.georasterIds.add(var43_86);
                                            }
                                            var46_89 = 1L;
                                            if (var45_88.getMetadataObject().getRasterInfo().getDimensionSize(2) != null) {
                                                var46_89 = var45_88.getMetadataObject().getRasterInfo().getDimensionSize(2);
                                            }
                                            var48_90 = var45_88.getMetadataObject().getRasterInfo().getCellDepthBits();
                                            var49_91 = var45_88.getMetadataObject().getRasterInfo().getInterleaving();
                                            var50_92 = var45_88.getRasterID();
                                            var51_93 = var50_92.doubleValue();
                                            var53_94 = var45_88.getRasterDataTable();
                                            var54_95 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelSRID();
                                            GeoRasterThemeProducer.log.finest("Data SRID: " + var54_95);
                                            if (!var42_65 || this.isDataWithinScale(var12_8, var2_2, var25_20, var11_7, var54_95, var17_16, var21_18, var19_17, var23_19)) break block259;
                                            var55_97 = 0;
                                            ** GOTO lbl686
                                        }
                                        var55_96 = 0L;
                                        if (var45_88.getMetadataObject().getRasterInfo().getULTCoordinate(1) != null) {
                                            var55_96 = var45_88.getMetadataObject().getRasterInfo().getULTCoordinate(1);
                                        }
                                        var57_98 = 0L;
                                        if (var45_88.getMetadataObject().getRasterInfo().getULTCoordinate(0) != null) {
                                            var57_98 = var45_88.getMetadataObject().getRasterInfo().getULTCoordinate(0);
                                        }
                                        GeoRasterThemeProducer.log.finer("ULT offset: [row] " + var57_98 + ", [column] " + var55_96);
                                        var59_99 = var45_88.getSpatialExtent().getMBR();
                                        if (var59_99 != null) break block260;
                                        GeoRasterThemeProducer.log.severe(RSBundle.getMsg("MAPVIEWER-01032") + " [id=" + var51_93 + "]");
                                        var60_101 = 0;
                                        ** GOTO lbl716
                                    }
                                    var60_100 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate(0.0, 0.0, 0L);
                                    if (var60_100 != null) break block261;
                                    GeoRasterThemeProducer.log.severe("GeoRaster data extent for raster Id " + var51_93 + " is null.");
                                    var61_103 = 0;
                                    ** GOTO lbl746
                                }
                                var61_102 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate(0.0, 1.0, 0L);
                                var62_104 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate(1.0, 0.0, 0L);
                                var63_105 = new double[2];
                                var64_106 = var61_102[0] - var60_100[0];
                                var66_107 = var61_102[1] - var60_100[1];
                                var63_105[0] = Math.sqrt(var64_106 * var64_106 + var66_107 * var66_107);
                                var64_106 = var62_104[0] - var60_100[0];
                                var66_107 = var62_104[1] - var60_100[1];
                                var63_105[1] = Math.sqrt(var64_106 * var64_106 + var66_107 * var66_107);
                                if (var63_105 != null) break block262;
                                GeoRasterThemeProducer.log.severe("GeoRaster spatial resolution for raster Id " + var51_93 + " is null.");
                                var68_109 = 0;
                                ** GOTO lbl776
                            }
                            GeoRasterThemeProducer.log.finer("Original spatial resolution: " + var63_105[0] + "," + var63_105[1]);
                            var60_100[0] = var60_100[0] + (double)var55_96 * var63_105[0];
                            var60_100[1] = var60_100[1] - (double)var57_98 * var63_105[1];
                            GeoRasterThemeProducer.log.finest("Upper Left Model Coordinate: " + var60_100[0] + " , " + var60_100[1]);
                            var68_108 = var45_88.getMetadataObject().getRasterInfo().getDimensionSize(1);
                            var70_110 = var45_88.getMetadataObject().getRasterInfo().getDimensionSize(0);
                            if (var2_2.getMasterSRID() > 0 && var54_95 > 0 && var54_95 != var2_2.getMasterSRID() && var54_95 != 999999 && this.def.getSrid() != 262148) {
                                if (var25_20 != Infinity && var25_20 != -Infinity && var41_60 != var54_95) {
                                    var72_112 = new double[]{var17_16, var21_18, var19_17, var23_19};
                                    var73_113 = Util.convertMBR(var72_112, var2_2.getMasterSRID(), var54_95, var12_8);
                                    var41_60 = var54_95;
                                    if (var73_113 != null) {
                                        var3_3 = var73_113[0];
                                        var5_4 = var73_113[1];
                                        var7_5 = var73_113[2];
                                        var9_6 = var73_113[3];
                                    } else {
                                        GeoRasterThemeProducer.log.finest("Unable to convert query window to data SRID " + var54_95 + ". Conversion ignored");
                                        var3_3 = var17_16;
                                        var5_4 = var21_18;
                                        var7_5 = var19_17;
                                        var9_6 = var23_19;
                                    }
                                }
                            } else {
                                var3_3 = var17_16;
                                var5_4 = var21_18;
                                var7_5 = var19_17;
                                var9_6 = var23_19;
                            }
                            if (var34_37 && (var72_112 = Util.rotateMBR(var3_3, var5_4, var7_5, var9_6, var2_2.getRotation())) != null) {
                                var3_3 = Math.min(var72_112[0], var3_3);
                                var5_4 = Math.min(var72_112[1], var5_4);
                                var7_5 = Math.max(var72_112[2], var7_5);
                                var9_6 = Math.max(var72_112[3], var9_6);
                            }
                            if (var11_7 && this.def.getOriginalPyramidLevel() == null) {
                                this.screenResolution = (double)var70_110 * var63_105[1] / var2_2.getDeviceWindow().getHeight();
                            }
                            if ((var72_111 = this.computePyramidLevel(var45_88, var63_105)) != -1L) break block263;
                            GeoRasterThemeProducer.log.severe("Unable to compute the best pyramid level.");
                            var74_115 = 0;
                            ** GOTO lbl806
                        }
                        GeoRasterThemeProducer.log.finest("Pyramid level to use: " + var72_111 + " , GeoRaster: " + var51_93 + " , screen resolution: " + this.screenResolution);
                        var63_105[0] = var63_105[0] * Math.pow(2.0, var72_111);
                        var63_105[1] = var63_105[1] * Math.pow(2.0, var72_111);
                        if (var63_105 != null) break block264;
                        GeoRasterThemeProducer.log.severe("GeoRaster spatial resolution for raster Id " + var51_93 + " is null.");
                        var74_116 = 0;
                        ** GOTO lbl836
                    }
                    GeoRasterThemeProducer.log.finer("Spatial resolution to use: " + var63_105[0] + "," + var63_105[1]);
                    var74_114 = (long)Math.pow(2.0, var72_111);
                    GeoRasterThemeProducer.log.finer("GeoRaster Dimension: width= " + var45_88.getMetadataObject().getRasterInfo().getDimensionSize(1) + " height= " + var45_88.getMetadataObject().getRasterInfo().getDimensionSize(0));
                    var76_117 = var45_88.getMetadataObject().getRasterInfo().getDimensionSize(1) / var74_114 - 1L;
                    var78_118 = var45_88.getMetadataObject().getRasterInfo().getDimensionSize(0) / var74_114 - 1L;
                    GeoRasterThemeProducer.log.finer("[DimX] " + var76_117 + "[DimY] " + var78_118);
                    var80_119 = 0L;
                    var82_120 = 0L;
                    var84_121 = var76_117;
                    var86_122 = var78_118;
                    var88_123 = new double[2];
                    var88_123[1] = 0.0;
                    var88_123[0] = 0.0;
                    if (var55_96 != 0L || var57_98 != 0L) {
                        var88_123 = var45_88.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(var60_100[0], var60_100[1], var72_111);
                        GeoRasterThemeProducer.log.finer("[Pyramid level] " + var72_111 + " [Offset (row,column)] " + (long)var88_123[0] + "," + (long)var88_123[1]);
                    }
                    if (!var11_7) {
                        var89_124 /* !! */  = this.computeCellCoordinate(var45_88, var72_111, var3_3, var5_4, var7_5, var9_6, var88_123);
                        var82_120 = var89_124 /* !! */ [0] < 0L ? 0L : var89_124 /* !! */ [0];
                        var80_119 = var89_124 /* !! */ [1] < 0L ? 0L : var89_124 /* !! */ [1];
                        var86_122 = var89_124 /* !! */ [2] > var78_118 ? var78_118 : var89_124 /* !! */ [2];
                        var84_121 = var89_124 /* !! */ [3] > var76_117 ? var76_117 : var89_124 /* !! */ [3];
                    }
                    if (var80_119 > var76_117 || var82_120 > var78_118) {
                        GeoRasterThemeProducer.log.warning("Query window  is out of GeoRaster area, for raster Id " + var51_93);
                        var45_88 = null;
                        continue;
                    }
                    if (var84_121 < 0L || var86_122 < 0L) {
                        GeoRasterThemeProducer.log.warning("Query window  is out of GeoRaster area, for raster Id " + var51_93);
                        var45_88 = null;
                        continue;
                    }
                    if (this.def.mBands != null) {
                        var45_88.getGeoRasterImageObject().setRed(var31_30 + 1);
                        var45_88.getGeoRasterImageObject().setGreen(var32_33 + 1);
                        if (var30_28 != 2) {
                            var45_88.getGeoRasterImageObject().setBlue(var33_35 + 1);
                        }
                    }
                    if (this.def.getAlphaBand() >= 0) {
                        var45_88.getGeoRasterImageObject().setAlpha(this.def.getAlphaBand() + 1);
                    }
                    if (this.def.isNODATATransparent() && (var89_124 /* !! */  = (long[])var45_88.getMetadataObject().getLayerInfo()) != null) {
                        var90_125 /* !! */  = (long[])var89_124 /* !! */ .getObjectLayer();
                        if (var90_125 /* !! */  != null) {
                            this.processNodata(var45_88, (SubLayerInfo)var90_125 /* !! */ );
                        }
                        if ((var91_127 = var89_124 /* !! */ .getSubLayer((long)(var31_30 + 1))) != null) {
                            this.processNodata(var45_88, (SubLayerInfo)var91_127);
                        }
                        if (var30_28 == 2) {
                            var91_127 = var89_124 /* !! */ .getSubLayer((long)(var32_33 + 1));
                            if (var91_127 != null) {
                                this.processNodata(var45_88, (SubLayerInfo)var91_127);
                            }
                        } else if (var30_28 == 3) {
                            var91_127 = var89_124 /* !! */ .getSubLayer((long)(var32_33 + 1));
                            if (var91_127 != null) {
                                this.processNodata(var45_88, (SubLayerInfo)var91_127);
                            }
                            if ((var91_127 = var89_124 /* !! */ .getSubLayer((long)(var33_35 + 1))) != null) {
                                this.processNodata(var45_88, (SubLayerInfo)var91_127);
                            }
                        }
                    }
                    var89_124 /* !! */  = null;
                    var90_125 /* !! */  = new long[4];
                    try {
                        var91_127 = null;
                        var91_127 = this.overbitmapMasks == null ? this.def.getBitmapMask("" + (long)var51_93 + ":" + var53_94) : (GeoRasterBitmapMask)this.overbitmapMasks.get("" + (long)var51_93 + ":" + var53_94);
                        if (var91_127 == null) {
                            GeoRasterThemeProducer.log.finer("Calling JGeoRaster.getRasterImage - area: " + var80_119 + " , " + var82_120 + " , " + " , " + var84_121 + " , " + var86_122);
                            var89_124 /* !! */  = (long[])var45_88.getGeoRasterImageObject().getRasterImage((int)var72_111, var82_120, var80_119, var86_122, var84_121, var90_125 /* !! */ );
                            if (var89_124 /* !! */  == null) {
                                GeoRasterThemeProducer.log.warning("JGeoRaster.getRasterImage returned null image.");
                            }
                            GeoRasterThemeProducer.log.finer("End of JGeoRaster.getRasterImage call.");
                        } else {
                            var92_129 = new Vector<Integer>();
                            var93_131 /* !! */  = var91_127.getLayers();
                            for (var94_132 = false; var94_132 < var93_131 /* !! */ .length; var94_132 += 1) {
                                var92_129.add(new Integer(var93_131 /* !! */ [var94_132]));
                            }
                            GeoRasterThemeProducer.log.finer("Calling JGeoRaster.getRasterImageWithMask - area: " + var80_119 + " , " + var82_120 + " , " + " , " + var84_121 + " , " + var86_122);
                            var89_124 /* !! */  = (long[])var45_88.getGeoRasterImageObject().getRasterImageWithMask((int)var72_111, var82_120, var80_119, var86_122, var84_121, var92_129, var91_127.getZeroMapping(), var91_127.getOneMapping(), var90_125 /* !! */ );
                            if (var89_124 /* !! */  == null) {
                                GeoRasterThemeProducer.log.warning("JGeoRaster.getRasterImageWithMask returned null image.");
                            }
                            GeoRasterThemeProducer.log.finer("End of JGeoRaster.getRasterImageWithMask call.");
                        }
                    }
                    catch (Exception var91_128) {
                        GeoRasterThemeProducer.log.log(Level.SEVERE, "Exception in getRasterImage procedure: ", var91_128);
                        var92_130 = 0;
                        var129_73 = null;
                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                            try {
                                Util.gotoWorkspace(var12_8, "LIVE");
                            }
                            catch (Exception var130_83) {
                                GeoRasterThemeProducer.log.warning(var130_83.getMessage());
                            }
                        }
                        if (var37_44 != null) {
                            try {
                                var37_44.close();
                            }
                            catch (Exception var130_83) {
                                GeoRasterThemeProducer.log.warning(var130_83.getMessage());
                            }
                        }
                        if (var36_54 != null) {
                            try {
                                var36_54.close();
                            }
                            catch (Exception var130_83) {
                                GeoRasterThemeProducer.log.warning(var130_83.getMessage());
                            }
                        }
                        if (var12_8 == null) return var92_130;
                        try {
                            DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                            return var92_130;
                        }
                        catch (Exception var130_83) {
                            GeoRasterThemeProducer.log.warning(var130_83.getMessage());
                        }
                        return var92_130;
                    }
                    var91_126 = 0.0;
                    var93_131 /* !! */  = null;
                    var94_132 = false;
                    var95_133 = 0;
                    var96_134 = null;
                    var97_135 /* !! */  = new double[4];
                    if (var54_95 == 999999 || var54_95 == 0 || this.def.getSrid() == 262148) {
                        var97_135 /* !! */ [0] = var60_100[0] + (double)var80_119 * var63_105[0];
                        var97_135 /* !! */ [1] = var60_100[1] - (double)(var86_122 + 1L) * var63_105[1];
                        var97_135 /* !! */ [2] = var60_100[0] + (double)(var84_121 + 1L) * var63_105[0];
                        var97_135 /* !! */ [3] = var60_100[1] - (double)var82_120 * var63_105[1];
                    } else {
                        var98_136 = var45_88.getMetadataObject().getSpatialReferenceInfo().getFunctionalFittingModel().getRowNumerator();
                        var99_137 = var45_88.getMetadataObject().getSpatialReferenceInfo().getFunctionalFittingModel().getColNumerator();
                        var100_138 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)var82_120, (double)var80_119, var72_111);
                        var101_139 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)(var86_122 + 1L), (double)(var84_121 + 1L), var72_111);
                        var102_140 = Math.min(var100_138[0], var101_139[0]);
                        var104_141 = Math.max(var100_138[0], var101_139[0]);
                        var106_142 = Math.min(var100_138[1], var101_139[1]);
                        var108_143 = Math.max(var100_138[1], var101_139[1]);
                        var110_144 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)(var86_122 + 1L), (double)var80_119, var72_111);
                        var102_140 = Math.min(var102_140, var110_144[0]);
                        var104_141 = Math.max(var104_141, var110_144[0]);
                        var106_142 = Math.min(var106_142, var110_144[1]);
                        var108_143 = Math.max(var108_143, var110_144[1]);
                        var111_145 = var45_88.getMetadataObject().getSpatialReferenceInfo().getModelCoordinate((double)var82_120, (double)(var84_121 + 1L), var72_111);
                        var102_140 = Math.min(var102_140, var111_145[0]);
                        var104_141 = Math.max(var104_141, var111_145[0]);
                        var106_142 = Math.min(var106_142, var111_145[1]);
                        var108_143 = Math.max(var108_143, var111_145[1]);
                        var97_135 /* !! */ [0] = var102_140 + (double)var55_96 * var63_105[0];
                        var97_135 /* !! */ [1] = var106_142 - (double)var57_98 * var63_105[1];
                        var97_135 /* !! */ [2] = var104_141 + (double)var55_96 * var63_105[0];
                        var97_135 /* !! */ [3] = var108_143 - (double)var57_98 * var63_105[1];
                        var112_146 = var45_88.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(var97_135 /* !! */ [0], var97_135 /* !! */ [3], var72_111);
                        var116_150 = new double[]{var112_146[1], -1.0 * var112_146[0], (var113_147 = var45_88.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(var97_135 /* !! */ [2], var97_135 /* !! */ [3], var72_111))[1], -1.0 * var113_147[0], (var114_148 = var45_88.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(var97_135 /* !! */ [2], var97_135 /* !! */ [1], var72_111))[1], -1.0 * var114_148[0], (var115_149 = var45_88.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(var97_135 /* !! */ [0], var97_135 /* !! */ [1], var72_111))[1], -1.0 * var115_149[0], var112_146[1], -1.0 * var112_146[0]};
                        if (!this.isClockwise(var116_150)) {
                            var94_132 = true;
                        }
                        if (Double.valueOf(var98_136.get(5).toString()) != 0.0 || Double.valueOf(var99_137.get(6).toString()) != 0.0) {
                            var117_151 = var112_146[1];
                            var119_152 = var112_146[0];
                            var121_153 = var113_147[1];
                            var123_154 = var113_147[0];
                            var91_126 = this.computeRotation(var117_151, var119_152, var121_153, var123_154);
                            if (var91_126 == 0.0) {
                                // empty if block
                            }
                            if (var91_126 != 0.0) {
                                var95_133 = 1;
                                var125_155 = this.computeRotation(var117_151, var119_152, var115_149[1], var115_149[0]);
                                if ((int)(Math.abs(var125_155 - var91_126) + 0.5) != 90) {
                                    var95_133 = 3;
                                }
                                if (var95_133 == 1) {
                                    var127_156 = var45_88.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(var97_135 /* !! */ [0] + (var97_135 /* !! */ [2] - var97_135 /* !! */ [0]) / 2.0, var97_135 /* !! */ [1] + (var97_135 /* !! */ [3] - var97_135 /* !! */ [1]) / 2.0, var72_111);
                                    var93_131 /* !! */  = (int[])new Point2D.Double(var127_156[1], var127_156[0]);
                                }
                                if (var94_132) {
                                    var91_126 = -1.0 * var91_126;
                                }
                                var96_134 = this.changeMaskSRID(var12_8, JSDOGeometry.recast(var45_88.getSpatialExtent()), var2_2.getMasterSRID());
                            }
                        }
                    }
                    if (var2_2.getMasterSRID() > 0 && var54_95 > 0 && var54_95 != var2_2.getMasterSRID() && var54_95 != 999999 && var54_95 != 262148) {
                        var98_136 = Util.convertMBR(var97_135 /* !! */ , var54_95, var2_2.getMasterSRID(), var12_8);
                        var97_135 /* !! */  = (double[])var98_136;
                    }
                    if ((var98_136 = this.def.getImageProcessNames()) != null || this.overoperationNames != null) {
                        var89_124 /* !! */  = (long[])this.performImageProcessing((RenderedImage)var89_124 /* !! */ );
                    }
                    if (var89_124 /* !! */  != null) {
                        var39_55.add(var97_135 /* !! */ );
                        this.renderImages.put(String.valueOf(var38_48), var89_124 /* !! */ );
                        if (var94_132) {
                            this.imgRotFlip.put(String.valueOf(var38_48), new Boolean(var94_132));
                        }
                        if (var91_126 != 0.0) {
                            this.imgRotations.put(String.valueOf(var38_48), new Double(var91_126));
                            this.imgTransf.put(String.valueOf(var38_48), new Integer(var95_133));
                            if (var93_131 /* !! */  != null) {
                                this.imgRotRefPoint.put(String.valueOf(var38_48), (Point2D)var93_131 /* !! */ );
                            }
                            if (var96_134 != null) {
                                this.imgRotMask.put(String.valueOf(var38_48), var96_134);
                            }
                        }
                        ++var38_48;
                    }
                    var45_88 = null;
                    var42_65 = false;
                }
                ** GOTO lbl866
            }
            catch (Exception var40_57) {
                GeoRasterThemeProducer.log.log(Level.SEVERE, "GeoRaster load Exception: ", var40_57);
                throw new DataException("GeoRaster load Exception: " + var40_57.getMessage());
            }
            {
                block252: {
                    block251: {
                        block250: {
                            block249: {
                                block248: {
                                    block247: {
                                        block246: {
                                            block245: {
                                                block244: {
                                                    block243: {
                                                        block242: {
                                                            block241: {
                                                                block240: {
                                                                    block239: {
                                                                        block238: {
                                                                            block237: {
                                                                                block236: {
                                                                                    block235: {
                                                                                        block234: {
                                                                                            block233: {
                                                                                                block232: {
                                                                                                    block231: {
                                                                                                        block230: {
                                                                                                            block265: {
                                                                                                                catch (Throwable var128_157) {
                                                                                                                    block229: {
                                                                                                                        block228: {
                                                                                                                            block227: {
                                                                                                                                var129_75 = null;
                                                                                                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                                                                                                    ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl631:
                                                                                                                                    // 1 sources

                                                                                                                                    Util.gotoWorkspace(var12_8, "LIVE");
                                                                                                                                    break block227;
lbl634:
                                                                                                                                    // 1 sources

                                                                                                                                    catch (Exception var130_85) {
                                                                                                                                        GeoRasterThemeProducer.log.warning(var130_85.getMessage());
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                            if (var37_44 != null) {
                                                                                                                                ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl639:
                                                                                                                                // 1 sources

                                                                                                                                var37_44.close();
                                                                                                                                break block228;
lbl641:
                                                                                                                                // 1 sources

                                                                                                                                catch (Exception var130_85) {
                                                                                                                                    GeoRasterThemeProducer.log.warning(var130_85.getMessage());
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (var36_54 != null) {
                                                                                                                            ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl646:
                                                                                                                            // 1 sources

                                                                                                                            var36_54.close();
                                                                                                                            break block229;
lbl648:
                                                                                                                            // 1 sources

                                                                                                                            catch (Exception var130_85) {
                                                                                                                                GeoRasterThemeProducer.log.warning(var130_85.getMessage());
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (var12_8 == null) throw var128_157;
                                                                                                                    ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl653:
                                                                                                                    // 1 sources

                                                                                                                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                                                                                    throw var128_157;
lbl655:
                                                                                                                    // 1 sources

                                                                                                                    catch (Exception var130_85) {
                                                                                                                        GeoRasterThemeProducer.log.warning(var130_85.getMessage());
                                                                                                                    }
                                                                                                                    throw var128_157;
                                                                                                                }
lbl658:
                                                                                                                // 1 sources

                                                                                                                ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl659:
                                                                                                                // 1 sources

                                                                                                                Util.gotoWorkspace(var12_8, "LIVE");
                                                                                                                break block265;
lbl662:
                                                                                                                // 1 sources

                                                                                                                catch (Exception var130_76) {
                                                                                                                    GeoRasterThemeProducer.log.warning(var130_76.getMessage());
                                                                                                                }
                                                                                                            }
                                                                                                            if (var37_44 != null) {
                                                                                                                ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl667:
                                                                                                                // 1 sources

                                                                                                                var37_44.close();
                                                                                                                break block230;
lbl669:
                                                                                                                // 1 sources

                                                                                                                catch (Exception var130_76) {
                                                                                                                    GeoRasterThemeProducer.log.warning(var130_76.getMessage());
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                        if (var36_54 != null) {
                                                                                                            ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl674:
                                                                                                            // 1 sources

                                                                                                            var36_54.close();
                                                                                                            break block231;
lbl676:
                                                                                                            // 1 sources

                                                                                                            catch (Exception var130_76) {
                                                                                                                GeoRasterThemeProducer.log.warning(var130_76.getMessage());
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    if (var12_8 == null) return var42_63;
                                                                                                    ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl681:
                                                                                                    // 1 sources

                                                                                                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                                                                    return var42_63;
lbl683:
                                                                                                    // 1 sources

                                                                                                    catch (Exception var130_76) {
                                                                                                        GeoRasterThemeProducer.log.warning(var130_76.getMessage());
                                                                                                    }
                                                                                                    return var42_63;
lbl686:
                                                                                                    // 1 sources

                                                                                                    var129_67 = null;
                                                                                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                                                                        ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl689:
                                                                                                        // 1 sources

                                                                                                        Util.gotoWorkspace(var12_8, "LIVE");
                                                                                                        break block232;
lbl692:
                                                                                                        // 1 sources

                                                                                                        catch (Exception var130_77) {
                                                                                                            GeoRasterThemeProducer.log.warning(var130_77.getMessage());
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                if (var37_44 != null) {
                                                                                                    ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl697:
                                                                                                    // 1 sources

                                                                                                    var37_44.close();
                                                                                                    break block233;
lbl699:
                                                                                                    // 1 sources

                                                                                                    catch (Exception var130_77) {
                                                                                                        GeoRasterThemeProducer.log.warning(var130_77.getMessage());
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            if (var36_54 != null) {
                                                                                                ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl704:
                                                                                                // 1 sources

                                                                                                var36_54.close();
                                                                                                break block234;
lbl706:
                                                                                                // 1 sources

                                                                                                catch (Exception var130_77) {
                                                                                                    GeoRasterThemeProducer.log.warning(var130_77.getMessage());
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (var12_8 == null) return var55_97;
                                                                                        ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl711:
                                                                                        // 1 sources

                                                                                        DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                                                        return var55_97;
lbl713:
                                                                                        // 1 sources

                                                                                        catch (Exception var130_77) {
                                                                                            GeoRasterThemeProducer.log.warning(var130_77.getMessage());
                                                                                        }
                                                                                        return var55_97;
lbl716:
                                                                                        // 1 sources

                                                                                        var129_68 = null;
                                                                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                                                            ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl719:
                                                                                            // 1 sources

                                                                                            Util.gotoWorkspace(var12_8, "LIVE");
                                                                                            break block235;
lbl722:
                                                                                            // 1 sources

                                                                                            catch (Exception var130_78) {
                                                                                                GeoRasterThemeProducer.log.warning(var130_78.getMessage());
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (var37_44 != null) {
                                                                                        ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl727:
                                                                                        // 1 sources

                                                                                        var37_44.close();
                                                                                        break block236;
lbl729:
                                                                                        // 1 sources

                                                                                        catch (Exception var130_78) {
                                                                                            GeoRasterThemeProducer.log.warning(var130_78.getMessage());
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (var36_54 != null) {
                                                                                    ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl734:
                                                                                    // 1 sources

                                                                                    var36_54.close();
                                                                                    break block237;
lbl736:
                                                                                    // 1 sources

                                                                                    catch (Exception var130_78) {
                                                                                        GeoRasterThemeProducer.log.warning(var130_78.getMessage());
                                                                                    }
                                                                                }
                                                                            }
                                                                            if (var12_8 == null) return var60_101;
                                                                            ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl741:
                                                                            // 1 sources

                                                                            DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                                            return var60_101;
lbl743:
                                                                            // 1 sources

                                                                            catch (Exception var130_78) {
                                                                                GeoRasterThemeProducer.log.warning(var130_78.getMessage());
                                                                            }
                                                                            return var60_101;
lbl746:
                                                                            // 1 sources

                                                                            var129_69 = null;
                                                                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                                                ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl749:
                                                                                // 1 sources

                                                                                Util.gotoWorkspace(var12_8, "LIVE");
                                                                                break block238;
lbl752:
                                                                                // 1 sources

                                                                                catch (Exception var130_79) {
                                                                                    GeoRasterThemeProducer.log.warning(var130_79.getMessage());
                                                                                }
                                                                            }
                                                                        }
                                                                        if (var37_44 != null) {
                                                                            ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl757:
                                                                            // 1 sources

                                                                            var37_44.close();
                                                                            break block239;
lbl759:
                                                                            // 1 sources

                                                                            catch (Exception var130_79) {
                                                                                GeoRasterThemeProducer.log.warning(var130_79.getMessage());
                                                                            }
                                                                        }
                                                                    }
                                                                    if (var36_54 != null) {
                                                                        ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl764:
                                                                        // 1 sources

                                                                        var36_54.close();
                                                                        break block240;
lbl766:
                                                                        // 1 sources

                                                                        catch (Exception var130_79) {
                                                                            GeoRasterThemeProducer.log.warning(var130_79.getMessage());
                                                                        }
                                                                    }
                                                                }
                                                                if (var12_8 == null) return var61_103;
                                                                ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl771:
                                                                // 1 sources

                                                                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                                return var61_103;
lbl773:
                                                                // 1 sources

                                                                catch (Exception var130_79) {
                                                                    GeoRasterThemeProducer.log.warning(var130_79.getMessage());
                                                                }
                                                                return var61_103;
lbl776:
                                                                // 1 sources

                                                                var129_70 = null;
                                                                if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                                    ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl779:
                                                                    // 1 sources

                                                                    Util.gotoWorkspace(var12_8, "LIVE");
                                                                    break block241;
lbl782:
                                                                    // 1 sources

                                                                    catch (Exception var130_80) {
                                                                        GeoRasterThemeProducer.log.warning(var130_80.getMessage());
                                                                    }
                                                                }
                                                            }
                                                            if (var37_44 != null) {
                                                                ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl787:
                                                                // 1 sources

                                                                var37_44.close();
                                                                break block242;
lbl789:
                                                                // 1 sources

                                                                catch (Exception var130_80) {
                                                                    GeoRasterThemeProducer.log.warning(var130_80.getMessage());
                                                                }
                                                            }
                                                        }
                                                        if (var36_54 != null) {
                                                            ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl794:
                                                            // 1 sources

                                                            var36_54.close();
                                                            break block243;
lbl796:
                                                            // 1 sources

                                                            catch (Exception var130_80) {
                                                                GeoRasterThemeProducer.log.warning(var130_80.getMessage());
                                                            }
                                                        }
                                                    }
                                                    if (var12_8 == null) return var68_109;
                                                    ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl801:
                                                    // 1 sources

                                                    DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                                    return var68_109;
lbl803:
                                                    // 1 sources

                                                    catch (Exception var130_80) {
                                                        GeoRasterThemeProducer.log.warning(var130_80.getMessage());
                                                    }
                                                    return var68_109;
lbl806:
                                                    // 1 sources

                                                    var129_71 = null;
                                                    if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                                        ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl809:
                                                        // 1 sources

                                                        Util.gotoWorkspace(var12_8, "LIVE");
                                                        break block244;
lbl812:
                                                        // 1 sources

                                                        catch (Exception var130_81) {
                                                            GeoRasterThemeProducer.log.warning(var130_81.getMessage());
                                                        }
                                                    }
                                                }
                                                if (var37_44 != null) {
                                                    ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl817:
                                                    // 1 sources

                                                    var37_44.close();
                                                    break block245;
lbl819:
                                                    // 1 sources

                                                    catch (Exception var130_81) {
                                                        GeoRasterThemeProducer.log.warning(var130_81.getMessage());
                                                    }
                                                }
                                            }
                                            if (var36_54 != null) {
                                                ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl824:
                                                // 1 sources

                                                var36_54.close();
                                                break block246;
lbl826:
                                                // 1 sources

                                                catch (Exception var130_81) {
                                                    GeoRasterThemeProducer.log.warning(var130_81.getMessage());
                                                }
                                            }
                                        }
                                        if (var12_8 == null) return var74_115;
                                        ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl831:
                                        // 1 sources

                                        DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                                        return var74_115;
lbl833:
                                        // 1 sources

                                        catch (Exception var130_81) {
                                            GeoRasterThemeProducer.log.warning(var130_81.getMessage());
                                        }
                                        return var74_115;
lbl836:
                                        // 1 sources

                                        var129_72 = null;
                                        if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                            ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl839:
                                            // 1 sources

                                            Util.gotoWorkspace(var12_8, "LIVE");
                                            break block247;
lbl842:
                                            // 1 sources

                                            catch (Exception var130_82) {
                                                GeoRasterThemeProducer.log.warning(var130_82.getMessage());
                                            }
                                        }
                                    }
                                    if (var37_44 != null) {
                                        ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl847:
                                        // 1 sources

                                        var37_44.close();
                                        break block248;
lbl849:
                                        // 1 sources

                                        catch (Exception var130_82) {
                                            GeoRasterThemeProducer.log.warning(var130_82.getMessage());
                                        }
                                    }
                                }
                                if (var36_54 != null) {
                                    ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl854:
                                    // 1 sources

                                    var36_54.close();
                                    break block249;
lbl856:
                                    // 1 sources

                                    catch (Exception var130_82) {
                                        GeoRasterThemeProducer.log.warning(var130_82.getMessage());
                                    }
                                }
                            }
                            if (var12_8 == null) return var74_116;
                            ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl861:
                            // 1 sources

                            DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
                            return var74_116;
lbl863:
                            // 1 sources

                            catch (Exception var130_82) {
                                GeoRasterThemeProducer.log.warning(var130_82.getMessage());
                            }
                            return var74_116;
lbl866:
                            // 1 sources

                            var129_74 = null;
                            if (this.getTheme().getDecorator().getWorkspaceName() != null) {
                                ** try [egrp 17[TRYBLOCK] [36 : 6137->6148)] { 
lbl869:
                                // 1 sources

                                Util.gotoWorkspace(var12_8, "LIVE");
                                break block250;
lbl872:
                                // 1 sources

                                catch (Exception var130_84) {
                                    GeoRasterThemeProducer.log.warning(var130_84.getMessage());
                                }
                            }
                        }
                        if (var37_44 != null) {
                            ** try [egrp 18[TRYBLOCK] [37 : 6166->6176)] { 
lbl877:
                            // 1 sources

                            var37_44.close();
                            break block251;
lbl879:
                            // 1 sources

                            catch (Exception var130_84) {
                                GeoRasterThemeProducer.log.warning(var130_84.getMessage());
                            }
                        }
                    }
                    if (var36_54 != null) {
                        ** try [egrp 19[TRYBLOCK] [38 : 6194->6204)] { 
lbl884:
                        // 1 sources

                        var36_54.close();
                        break block252;
lbl886:
                        // 1 sources

                        catch (Exception var130_84) {
                            GeoRasterThemeProducer.log.warning(var130_84.getMessage());
                        }
                    }
                }
                if (var12_8 == null) break block253;
                ** try [egrp 20[TRYBLOCK] [39 : 6222->6237)] { 
lbl891:
                // 1 sources

                DSUtil.closeDBConnection(var12_8, this.def.getDataSourceName());
lbl893:
                // 1 sources

                catch (Exception var130_84) {}
                GeoRasterThemeProducer.log.warning(var130_84.getMessage());
            }
        }
        this.mbrs = new double[var39_55.size()][];
        var40_56 = 0;
        while (true) {
            if (var40_56 >= this.mbrs.length) {
                var39_55.clear();
                var39_55 = null;
                GeoRasterThemeProducer.log.finest("# image loaded: " + this.mbrs.length);
                return this.mbrs.length;
            }
            this.mbrs[var40_56] = (double[])var39_55.get(var40_56);
            ++var40_56;
        }
    }

    private double computeRotation(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        if (Math.abs(d5) > Math.abs(d6)) {
            d6 /= Math.abs(d5);
            d5 /= Math.abs(d5);
        } else {
            d5 /= Math.abs(d6);
            d6 /= Math.abs(d6);
        }
        double d7 = Math.atan2(d6, d5);
        double d8 = 180.0 * d7 / Math.PI;
        return d8;
    }

    public JSDOGeometry getPolygonMask() {
        return this.themePolyMask;
    }

    public Hashtable<String, Vector<JSDOGeometry>> getPolygonMasks() {
        return this.themePolygonMasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSDOGeometry changeMaskSRID(Connection connection, JSDOGeometry jSDOGeometry, int n) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        int n2;
        block22: {
            JSDOGeometry jSDOGeometry2;
            if (jSDOGeometry == null) {
                return null;
            }
            n2 = jSDOGeometry.getSRID();
            if (n <= 0 || n2 <= 0 || n2 == n || n2 == 999999 || n2 == 262148) return jSDOGeometry;
            String string = "NULL";
            if (n2 != 0) {
                string = String.valueOf(n2);
            }
            String string2 = "MDSYS.SDO_GEOMETRY(2003, " + string + ", NULL, " + "MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 1), " + "MDSYS.SDO_ORDINATE_ARRAY(";
            double[] dArray = jSDOGeometry.getOrdinatesArray();
            for (int i = 0; i < dArray.length; ++i) {
                string2 = i > 0 ? string2 + "," + dArray[i] : string2 + dArray[i];
            }
            string2 = string2 + "))";
            String string3 = "select sdo_cs.transform(" + string2 + "," + n + ") from dual";
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block22;
            JSDOGeometry jSDOGeometry3 = jSDOGeometry2 = JDBCUtil.loadGeometry(resultSet, 1, false);
            Object var14_15 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (preparedStatement == null) return jSDOGeometry3;
                preparedStatement.close();
                return jSDOGeometry3;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return jSDOGeometry3;
        }
        log.finest("Polygon mask SRID convertion (" + n2 + " to " + n + " returned null value.");
        Object var14_16 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (preparedStatement == null) return null;
            preparedStatement.close();
            return null;
        }
        catch (Exception exception) {}
        return null;
        {
            catch (Exception exception) {
                log.warning(exception.getMessage());
                Object var14_17 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (preparedStatement == null) return null;
                    preparedStatement.close();
                    return null;
                }
                catch (Exception exception2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (preparedStatement == null) throw throwable;
                preparedStatement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    @Override
    public void postPreparation(VisContext visContext) {
    }

    @Override
    public StyledFeatureI getStyledFeature(int n) {
        return null;
    }

    @Override
    public double[] getDataMBR() {
        if (this.mbrs == null || this.mbrs.length == 0) {
            return null;
        }
        RectangularShape rectangularShape = null;
        for (int i = 0; i < this.mbrs.length; ++i) {
            double[] dArray = this.mbrs[i];
            if (rectangularShape == null) {
                rectangularShape = new Rectangle2D.Double(dArray[0], dArray[1], 0.0, 0.0);
            } else {
                ((Rectangle2D)rectangularShape).add(dArray[0], dArray[1]);
            }
            ((Rectangle2D)rectangularShape).add(dArray[2], dArray[3]);
        }
        double[] dArray = new double[]{rectangularShape.getMinX(), rectangularShape.getMinY(), rectangularShape.getMaxX(), rectangularShape.getMaxY()};
        return dArray;
    }

    @Override
    public StyledFeatureI[] getStyledFeatures() {
        return null;
    }

    @Override
    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        return null;
    }

    @Override
    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        return null;
    }

    public double[][] getMBRs() {
        return this.mbrs;
    }

    public void setImageMBRs(double[][] dArray) {
        this.mbrs = dArray;
    }

    public Vector<String> getGeoRasterIds() {
        return this.georasterIds;
    }

    private long[] computeCellCoordinate(JGeoRaster jGeoRaster, long l, double d, double d2, double d3, double d4, double[] dArray) {
        log.finer("Converting to cell coordinate: [pyramidLevel] " + l + " [Xl] " + d + " [Yl] " + d2);
        double[] dArray2 = jGeoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(d, d2, l);
        log.finer("Cell coordinates: Row=" + dArray2[0] + ", Column=" + dArray2[1]);
        long l2 = (long)(dArray2[1] + 0.5) - (long)dArray[1];
        long l3 = (long)(dArray2[0] + 0.5) - (long)dArray[0];
        long l4 = l2;
        long l5 = l3;
        log.finer("Converting to cell coordinate: [pyramidLevel] " + l + " [Xl] " + d + " [Yh] " + d4);
        dArray2 = jGeoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(d, d4, l);
        log.finer("Cell coordinates: Row=" + dArray2[0] + ", Column=" + dArray2[1]);
        l2 = Math.min(l2, (long)(dArray2[1] + 0.5) - (long)dArray[1]);
        l5 = Math.min(l5, (long)(dArray2[0] + 0.5) - (long)dArray[0]);
        l4 = Math.max(l4, (long)(dArray2[1] + 0.5) - (long)dArray[1]);
        l3 = Math.max(l3, (long)(dArray2[0] + 0.5) - (long)dArray[0]);
        log.finer("Converting to cell coordinate: [pyramidLevel] " + l + " [Xh] " + d3 + " [Yh] " + d4);
        dArray2 = jGeoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(d3, d4, l);
        log.finer("Cell coordinates: Row=" + dArray2[0] + ", Column=" + dArray2[1]);
        l2 = Math.min(l2, (long)(dArray2[1] + 0.5) - (long)dArray[1]);
        l5 = Math.min(l5, (long)(dArray2[0] + 0.5) - (long)dArray[0]);
        l4 = Math.max(l4, (long)(dArray2[1] + 0.5) - (long)dArray[1]);
        l3 = Math.max(l3, (long)(dArray2[0] + 0.5) - (long)dArray[0]);
        log.finer("Converting to cell coordinate: [pyramidLevel] " + l + " [Xh] " + d3 + " [Yl] " + d2);
        dArray2 = jGeoRaster.getMetadataObject().getSpatialReferenceInfo().getCellCoordinate(d3, d2, l);
        log.finer("Cell coordinates: Row=" + dArray2[0] + ", Column=" + dArray2[1]);
        l2 = Math.min(l2, (long)(dArray2[1] + 0.5) - (long)dArray[1]);
        l5 = Math.min(l5, (long)(dArray2[0] + 0.5) - (long)dArray[0]);
        l4 = Math.max(l4, (long)(dArray2[1] + 0.5) - (long)dArray[1]);
        l3 = Math.max(l3, (long)(dArray2[0] + 0.5) - (long)dArray[0]);
        long[] lArray = new long[]{l5, l2, l3, l4};
        return lArray;
    }

    @Override
    public void destroy() {
        if (this.mbrs != null) {
            for (int i = 0; i < this.mbrs.length; ++i) {
                this.mbrs[i] = null;
            }
        }
        this.mbrs = null;
        if (this.renderImages.size() > 0) {
            Object[] objectArray = this.renderImages.values().toArray();
            this.renderImages.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof BufferedImage) {
                    BufferedImage bufferedImage = (BufferedImage)objectArray[i];
                    bufferedImage.flush();
                }
                objectArray[i] = null;
            }
            objectArray = null;
        }
        if (this.imgRotations.size() > 0) {
            this.imgRotations.clear();
        }
        if (this.imgRotRefPoint.size() > 0) {
            this.imgRotRefPoint.clear();
        }
        if (this.imgRotFlip.size() > 0) {
            this.imgRotFlip.clear();
        }
        if (this.imgRotMask.size() > 0) {
            this.imgRotMask.clear();
        }
        if (this.imgTransf.size() > 0) {
            this.imgTransf.clear();
        }
        this.themePolyMask = null;
        this.themePolygonMasks.clear();
        this.georasterIds.clear();
    }

    @Override
    public void abort() {
    }

    protected String rewriteQuery(double d, double d2, double d3, double d4, boolean bl) {
        String string = this.def.getImageQuery();
        if (string == null) {
            return null;
        }
        if (this.def.passThrough || d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || d3 == Double.POSITIVE_INFINITY || d4 == Double.POSITIVE_INFINITY) {
            return string;
        }
        String string2 = this.getFilter(this.def.getGeoRasterColumn(), this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl);
        return "SELECT * FROM ( " + string + " ) grt WHERE " + string2;
    }

    final String getFilter(String string, int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (!bl2) {
            stringBuffer.append("MDSYS.SDO_FILTER(grt." + string + ".spatialextent, " + "MDSYS.SDO_GEOMETRY(2003, ");
            if (n == 0) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(n);
            }
            stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?)), 'querytype=WINDOW') = 'TRUE'");
        } else {
            stringBuffer.append("MDSYS.SDO_ANYINTERACT(grt." + string + ".spatialextent, " + "MDSYS.SDO_GEOMETRY(2003, ");
            if (n == 0) {
                stringBuffer.append("NULL");
            } else {
                stringBuffer.append(n);
            }
            stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(?,?,?,?))) = 'TRUE'");
        }
        return stringBuffer.toString();
    }

    final String getPolygonMaskFilter(String string, int n, double d, double d2, double d3, double d4) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("MDSYS.SDO_FILTER(pmasktb." + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")), " + "'querytype=WINDOW') = 'TRUE'");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processPolygonMasks(Connection connection, double d, double d2, double d3, double d4, int n) {
        block32: {
            this.themePolygonMasks.clear();
            if (connection == null || this.def.getPolygonMaskTable() == null || this.def.getPolygonMaskGeometryColumn() == null) {
                return;
            }
            String string = null;
            if (!this.def.passThrough && d != Double.NEGATIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY && d3 != Double.POSITIVE_INFINITY && d4 != Double.POSITIVE_INFINITY) {
                string = this.getPolygonMaskFilter(this.def.getPolygonMaskGeometryColumn(), n, d, d2, d3, d4);
            }
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            int n2 = 0;
            String string2 = "select srid from user_sdo_geom_metadata where table_name = ? and column_name = ?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, this.def.getPolygonMaskTable().toUpperCase());
            preparedStatement.setString(2, this.def.getPolygonMaskGeometryColumn().toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && resultSet.getObject(1) != null) {
                n2 = resultSet.getInt(1);
            }
            log.info("Polygon mask table [" + this.def.getPolygonMaskTable().toUpperCase() + "] geometry column [" + this.def.getPolygonMaskGeometryColumn().toUpperCase() + "] SRID=" + n2);
            resultSet.close();
            preparedStatement.close();
            String string3 = "select ";
            string3 = n > 0 && n2 > 0 && n2 != n && n2 != 999999 && n2 != 262148 ? string3 + "sdo_cs.transform(pmasktb." + this.def.getPolygonMaskGeometryColumn() + "," + n + ") " : string3 + "pmasktb." + this.def.getPolygonMaskGeometryColumn();
            if (this.def.getPolygonMaskGeometryJoinColumn() != null) {
                string3 = string3 + ", pmasktb." + this.def.getPolygonMaskGeometryJoinColumn();
            }
            string3 = string3 + " from " + this.def.getPolygonMaskTable() + " pmasktb";
            if (string != null) {
                string3 = string3 + " where " + string;
                if (this.def.getPolygonmaskQueryCondition() != null) {
                    string3 = string3 + " and " + this.def.getPolygonmaskQueryCondition();
                }
            } else if (this.def.getPolygonmaskQueryCondition() != null) {
                string3 = string3 + " where " + this.def.getPolygonmaskQueryCondition();
            }
            log.info("Polygon mask query:\n" + string3);
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Vector<Object> vector;
                JSDOGeometry jSDOGeometry = JDBCUtil.loadGeometry(resultSet, 1, false);
                if (jSDOGeometry == null) continue;
                if (this.def.getPolygonMaskGeometryJoinColumn() != null) {
                    vector = resultSet.getObject(2);
                    if (vector == null) continue;
                    Vector<JSDOGeometry> vector2 = null;
                    vector2 = this.themePolygonMasks.get(((Object)vector).toString());
                    if (vector2 == null) {
                        vector2 = new Vector();
                        this.themePolygonMasks.put(((Object)vector).toString(), vector2);
                    }
                    vector2.add(jSDOGeometry);
                    continue;
                }
                vector = null;
                if (this.themePolygonMasks.size() == 0) {
                    vector = new Vector();
                    this.themePolygonMasks.put("1", vector);
                } else {
                    vector = this.themePolygonMasks.get("1");
                }
                vector.add(jSDOGeometry);
            }
            Object var21_17 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                break block32;
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
            break block32;
            {
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                    log.warning("Polygon masks from table will be ignored.");
                    this.themePolygonMasks.clear();
                    Object var21_18 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception2) {
                        log.warning(exception2.getMessage());
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        break block32;
                    }
                    catch (Exception exception2) {
                        log.warning(exception2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_19 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (Exception exception) {
                    log.warning(exception.getMessage());
                }
                throw throwable;
            }
        }
    }

    private String getPredefinedQuery(double d, double d2, double d3, double d4, boolean bl) {
        String string;
        String string2 = "select grt." + this.def.getGeoRasterColumn() + ", grt." + this.def.getGeoRasterColumn() + ".metadata.getClobVal()";
        if (this.themePolygonMasks.size() > 0 && this.def.hasPolygonMaskJoinColumns()) {
            string2 = string2 + ", grt." + this.def.getPolygonMaskGeoRasterJoinColumn();
        }
        string2 = string2 + " from " + this.def.mBaseTable + " grt";
        String string3 = null;
        if (!this.def.passThrough && d != Double.NEGATIVE_INFINITY && d2 != Double.NEGATIVE_INFINITY && d3 != Double.POSITIVE_INFINITY && d4 != Double.POSITIVE_INFINITY) {
            string3 = this.getFilter(this.def.getGeoRasterColumn(), this.def.getSrid(), d, d2, d3, d4, this.def.is9i(), bl);
        }
        String string4 = string = this.def.mSRule != null ? this.def.mSRule.getFeatureCond() : null;
        if (string3 != null) {
            string2 = string2 + " WHERE " + string3;
            if (string != null) {
                string2 = string2 + " AND " + string;
            }
        } else if (string != null) {
            string2 = string2 + " WHERE " + string;
        }
        return string2;
    }

    public HashMap getRenderedImages() {
        return this.renderImages;
    }

    public Hashtable getImagesRotation() {
        return this.imgRotations;
    }

    public RenderedImage getRenderedImage(int n) {
        if (this.renderImages == null) {
            return null;
        }
        if (n < 0 || n > this.renderImages.size() - 1) {
            return null;
        }
        return (RenderedImage)this.renderImages.get(String.valueOf(n));
    }

    public double getImageRotation(int n) {
        if (this.imgRotations == null) {
            return 0.0;
        }
        if (n < 0 || n > this.imgRotations.size() - 1) {
            return 0.0;
        }
        Double d = this.imgRotations.get(String.valueOf(n));
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public int getImageTransformation(int n) {
        if (this.imgTransf == null) {
            return 0;
        }
        if (n < 0 || n > this.imgTransf.size() - 1) {
            return 0;
        }
        Integer n2 = this.imgTransf.get(String.valueOf(n));
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public Point2D getImageRotationRefPoint(int n) {
        if (this.imgRotRefPoint == null) {
            return null;
        }
        if (n < 0 || n > this.imgRotRefPoint.size() - 1) {
            return null;
        }
        Point2D point2D = this.imgRotRefPoint.get(String.valueOf(n));
        return point2D;
    }

    public JSDOGeometry getImageRotationMask(int n) {
        if (this.imgRotMask == null) {
            return null;
        }
        if (n < 0 || n > this.imgRotMask.size() - 1) {
            return null;
        }
        JSDOGeometry jSDOGeometry = this.imgRotMask.get(String.valueOf(n));
        return jSDOGeometry;
    }

    public boolean isImageFlipped(int n) {
        if (this.imgRotFlip == null) {
            return false;
        }
        if (n < 0 || n > this.imgRotFlip.size() - 1) {
            return false;
        }
        Boolean bl = this.imgRotFlip.get(String.valueOf(n));
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public RenderedImage performImageProcessing(RenderedImage renderedImage) {
        Object object = renderedImage;
        String[] stringArray = this.def.getImageProcessNames();
        Hashtable hashtable = this.def.getImageProcessParameters();
        if (this.overoperationNames != null) {
            stringArray = this.overoperationNames;
            hashtable = this.overoperationParameters;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object2;
                Object object3;
                log.finer("Operation name: " + stringArray[i]);
                Hashtable hashtable2 = null;
                if (hashtable != null) {
                    hashtable2 = (Hashtable)hashtable.get(stringArray[i]);
                }
                if (stringArray[i].equalsIgnoreCase("NORMALIZE")) {
                    log.finer("Normalize operation.");
                    object3 = new GeoRasterImageProcessUtil((RenderedImage)object);
                    RenderedImage renderedImage2 = object3.amplitudeRescaling();
                    object3.setImage(renderedImage2);
                    renderedImage2 = object3.normalize();
                    if (renderedImage2 == null) {
                        log.info("Unable to normalize image.");
                    } else {
                        object = renderedImage2;
                    }
                    object3 = null;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("EQUALIZE")) {
                    log.finer("Equalize operation");
                    object3 = new GeoRasterImageProcessUtil((RenderedImage)object);
                    RenderedImage renderedImage3 = object3.amplitudeRescaling();
                    object3.setImage(renderedImage3);
                    renderedImage3 = object3.equalize();
                    if (renderedImage3 == null) {
                        log.info("Unable to equalize image.");
                    } else {
                        object = renderedImage3;
                    }
                    object3 = null;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("PIECEWISELINEARSTRETCH")) {
                    log.finer("Piecewise operation");
                    object3 = new GeoRasterImageProcessUtil((RenderedImage)object);
                    RenderedImage renderedImage4 = object3.amplitudeRescaling();
                    object3.setImage(renderedImage4);
                    renderedImage4 = object3.piecewiseLinearStretch();
                    if (renderedImage4 == null) {
                        log.info("Unable to perform piecewise operation on image.");
                    } else {
                        object = renderedImage4;
                    }
                    object3 = null;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("LINEARSTRETCH")) {
                    int n;
                    int n2;
                    GeoRasterImageProcessUtil geoRasterImageProcessUtil;
                    block56: {
                        block55: {
                            Object object4;
                            log.finer("Linear stretch operation");
                            object3 = null;
                            if (hashtable2 != null) {
                                object3 = (String)hashtable2.get("autostretch");
                            }
                            if (object3 == null || ((String)object3).trim().length() < 1 || !((String)object3).trim().equals("false")) {
                                log.finer("Performing automatic linear stretch.");
                                geoRasterImageProcessUtil = new GeoRasterImageProcessUtil((RenderedImage)object);
                                object4 = geoRasterImageProcessUtil.amplitudeRescaling();
                                if (object4 == null) {
                                    log.info("Unable to perform automatic linear stretch on image.");
                                } else {
                                    object = object4;
                                }
                                geoRasterImageProcessUtil = null;
                                continue;
                            }
                            log.finer("Performing manual linear stretch.");
                            geoRasterImageProcessUtil = new GeoRasterImageProcessUtil((RenderedImage)object);
                            object4 = (String)hashtable2.get("lowstretch");
                            n2 = 0;
                            if (object4 != null) {
                                try {
                                    int n3 = Integer.parseInt((String)object4);
                                    if (n3 >= 0 && n3 <= 256) {
                                        n2 = n3;
                                    }
                                    break block55;
                                }
                                catch (Exception exception) {
                                    log.severe(RSBundle.getMsg("MAPVIEWER-01033"));
                                    continue;
                                }
                            }
                            log.info("Low stretch value not defined: 0 is assumed.");
                        }
                        String string = (String)hashtable2.get("highstretch");
                        n = 100;
                        if (string != null) {
                            try {
                                int n4 = Integer.parseInt(string);
                                if (n4 >= 0 && n4 <= 256) {
                                    n = n4;
                                }
                                break block56;
                            }
                            catch (Exception exception) {
                                log.severe(RSBundle.getMsg("MAPVIEWER-01034"));
                                continue;
                            }
                        }
                        log.info("High stretch value not defined: 100 is assumed.");
                    }
                    object2 = geoRasterImageProcessUtil.amplitudeRescaling((double)n2, (double)n);
                    if (object2 == null) {
                        log.info("Unable to perform manual linear stretch on image.");
                    } else {
                        object = object2;
                    }
                    geoRasterImageProcessUtil = null;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("BRIGHTNESS")) {
                    if (hashtable2 == null) {
                        log.info("Parameter element for brightness must be defined.");
                        continue;
                    }
                    object3 = (String)hashtable2.get("value");
                    int n = 0;
                    if (object3 != null && ((String)object3).trim().length() > 0) {
                        try {
                            int n5 = Integer.parseInt((String)object3);
                            log.info("Brightness value: " + n5);
                            if (n5 >= 0 && n5 <= 256) {
                                n = n5;
                            }
                            log.finer("Changing brightness.");
                            GeoRasterImageProcessUtil geoRasterImageProcessUtil = new GeoRasterImageProcessUtil((RenderedImage)object);
                            RenderedImage renderedImage5 = geoRasterImageProcessUtil.changeBrightness(n);
                            if (renderedImage5 == null) {
                                log.info("Unable to change image brightness.");
                            } else {
                                object = renderedImage5;
                            }
                            geoRasterImageProcessUtil = null;
                        }
                        catch (Exception exception) {
                            log.severe(RSBundle.getMsg("MAPVIEWER-01035"));
                        }
                        continue;
                    }
                    log.severe(RSBundle.getMsg("MAPVIEWER-01036"));
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("CONTRAST")) {
                    if (hashtable2 == null) {
                        log.info("Parameter element for contrast must be defined.");
                        continue;
                    }
                    object3 = (String)hashtable2.get("value");
                    int n = 256;
                    if (object3 != null && ((String)object3).trim().length() > 0) {
                        try {
                            int n6;
                            n = n6 = Integer.parseInt((String)object3);
                            log.finer("Changing contrast.");
                            GeoRasterImageProcessUtil geoRasterImageProcessUtil = new GeoRasterImageProcessUtil((RenderedImage)object);
                            RenderedImage renderedImage6 = geoRasterImageProcessUtil.changeContrast((double)n);
                            if (renderedImage6 == null) {
                                log.info("Unable to change image contrast.");
                            } else {
                                object = renderedImage6;
                            }
                            geoRasterImageProcessUtil = null;
                        }
                        catch (Exception exception) {
                            log.severe(RSBundle.getMsg("MAPVIEWER-01037"));
                        }
                        continue;
                    }
                    log.severe(RSBundle.getMsg("MAPVIEWER-01038"));
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("CHANGETHRESHOLD")) continue;
                if (hashtable2 == null) {
                    log.info("Parameter elements for threshold must be defined.");
                    continue;
                }
                object3 = (String)hashtable2.get("threshold");
                double d = 0.0;
                if (object3 != null) {
                    try {
                        double d2;
                        d = d2 = Double.parseDouble((String)object3);
                    }
                    catch (Exception exception) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01039"));
                        continue;
                    }
                }
                String string = (String)hashtable2.get("lowthreshold");
                double d3 = 0.0;
                if (string != null) {
                    try {
                        double d4;
                        d3 = d4 = Double.parseDouble(string);
                    }
                    catch (Exception exception) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01040"));
                        continue;
                    }
                }
                object2 = (String)hashtable2.get("highthreshold");
                double d5 = 0.0;
                if (object2 != null) {
                    try {
                        double d6;
                        d5 = d6 = Double.parseDouble((String)object2);
                    }
                    catch (Exception exception) {
                        log.severe(RSBundle.getMsg("MAPVIEWER-01041"));
                        continue;
                    }
                }
                log.finer("Changing threshold");
                GeoRasterImageProcessUtil geoRasterImageProcessUtil = new GeoRasterImageProcessUtil((RenderedImage)object);
                RenderedImage renderedImage7 = geoRasterImageProcessUtil.changeThreshold(d3, d5, d);
                if (renderedImage7 == null) {
                    log.info("Unable to change image threshold.");
                } else {
                    object = renderedImage7;
                }
                geoRasterImageProcessUtil = null;
            }
        }
        return object;
    }

    private int countBindingVariables(String string) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl) {
                int n2;
                if (c == '\'') {
                    bl = true;
                    continue;
                }
                if (c != ':') continue;
                ++n;
                for (n2 = i + 1; n2 < string.length() && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                    ++n2;
                }
                i = n2;
                continue;
            }
            if (c != '\'') continue;
            if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            bl = false;
        }
        return n;
    }

    private void setBindingVariable(PreparedStatement preparedStatement, Object object, int n) throws SQLException, IllegalArgumentException {
        if (object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (object instanceof Short) {
            preparedStatement.setShort(n, (Short)object);
        } else if (object instanceof Byte) {
            preparedStatement.setByte(n, (Byte)object);
        } else if (object instanceof BigDecimal) {
            preparedStatement.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof byte[]) {
            preparedStatement.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            preparedStatement.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            preparedStatement.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            preparedStatement.setTimestamp(n, (Timestamp)object);
        } else {
            throw new IllegalArgumentException("Binding data type not supported:" + object.getClass().toString());
        }
    }

    private boolean isFullExtent(boolean bl, double d, double d2, double d3, double d4) {
        return bl || Double.isInfinite(d) || Double.isNaN(d) || Double.isInfinite(d2) || Double.isNaN(d2) || Double.isInfinite(d3) || Double.isNaN(d3) || Double.isInfinite(d4) || Double.isNaN(d4);
    }

    private boolean isDataWithinScale(Connection connection, VisContext visContext, double d, boolean bl, int n, double d2, double d3, double d4, double d5) {
        if (n == 0) {
            log.warning("Data SRID is equal 0. Can not verify if theme is within scale limits.");
            return false;
        }
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
            if (visContext.getMasterSRID() > 0 && n > 0 && n != visContext.getMasterSRID() && n != 999999 && n != 262148 && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                double[] dArray = new double[]{d2, d3, d4, d5};
                double[] dArray2 = Util.convertMBR(dArray, visContext.getMasterSRID(), n, connection);
                if (dArray2 != null) {
                    d6 = dArray2[0];
                    d7 = dArray2[1];
                    d8 = dArray2[2];
                    d9 = dArray2[3];
                } else {
                    log.finest("Unable to convert query window to data SRID " + n + ".");
                    return false;
                }
            }
            double d10 = Math.abs(d9 - d7) / Math.abs(d5 - d3);
            log.finer("[Master scale] " + d + " [Scale factor for theme " + this.getTheme().getName() + "] " + d10);
            double d11 = d * d10;
            if (this.getTheme().getDecorator().getScaleType() == "RATIO") {
                double d12;
                double d13;
                SRSCache sRSCache = DSManager.getSRSCache(this.def.getDataSourceName());
                SRS sRS = sRSCache.get(n);
                if (visContext.getMasterSRID() > 0 && n > 0 && n != visContext.getMasterSRID() && visContext.isTileRequest()) {
                    sRS = sRSCache.get(visContext.getMasterSRID());
                    d13 = (d2 + d4) / 2.0;
                    d12 = (d3 + d5) / 2.0;
                    d10 = 1.0;
                } else {
                    d13 = (d6 + d8) / 2.0;
                    d12 = (d7 + d9) / 2.0;
                }
                if (visContext.isTileRequest() && sRS.isGeodetic()) {
                    d13 = 0.0;
                    d12 = 0.0;
                }
                if (sRS != null) {
                    d11 = sRS.getRatioScale(d * d10, new Point2D.Double(d13, d12));
                    log.finer("Ratio scale to compare: " + d11);
                } else {
                    log.severe(RSBundle.getMsg("MAPVIEWER-01025"));
                    return false;
                }
            }
            if (!this.getTheme().getDecorator().withinScaleLimits(d11)) {
                log.warning("Scale definition for theme " + this.getTheme().getName() + " is out of range.");
                return false;
            }
        }
        if (!bl) {
            this.screenResolution = Math.abs(d9 - d7) / visContext.getDeviceWindow().getHeight();
            log.info("Screen resolution: " + this.screenResolution);
        }
        return true;
    }

    public long computePyramidLevel(JGeoRaster jGeoRaster, double[] dArray) {
        if (jGeoRaster == null || dArray == null) {
            return -1L;
        }
        long l = this.def.getPyramidLevel();
        if (this.screenResolution <= 0.0 || this.def.getOriginalPyramidLevel() != null) {
            return l;
        }
        long l2 = 0L;
        Long l3 = jGeoRaster.getMetadataObject().getRasterInfo().getPyramidMaxLevel();
        if (l3 != null) {
            l2 = l3;
        }
        if (this.screenResolution <= dArray[1]) {
            l = 0L;
        } else if (this.screenResolution >= dArray[1] * Math.pow(2.0, l2)) {
            l = l2;
        } else {
            double d = dArray[1];
            int n = 1;
            while ((long)n <= l2) {
                double d2 = dArray[1] * Math.pow(2.0, n);
                if (this.screenResolution <= d2) {
                    double d3 = this.screenResolution - d;
                    double d4 = d2 - this.screenResolution;
                    if (d3 < d4) {
                        l = n - 1;
                        break;
                    }
                    l = n;
                    break;
                }
                d = d2;
                ++n;
            }
        }
        return l;
    }

    private boolean isClockwise(double[] dArray) {
        if (dArray == null) {
            return true;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dArray[0];
        double d5 = dArray[1];
        for (int i = 2; i < dArray.length - 1; i += 2) {
            double d6 = dArray[i];
            double d7 = dArray[i + 1];
            d += d4 * d7;
            d2 += d5 * d6;
            d4 = d6;
            d5 = d7;
        }
        d3 = (d2 - d) / 2.0;
        return !(d3 < 0.0);
    }

    @Override
    public StyledFeatureI getNewStyledFeatureInstance() {
        return null;
    }

    public void OverwriteImageProcess(String[] stringArray, Hashtable hashtable) {
        this.overoperationNames = stringArray;
        this.overoperationParameters = hashtable;
    }

    public void ClearOverwriteImageProcess() {
        this.overoperationNames = null;
        this.overoperationParameters = null;
    }

    public void OverwriteBitmapMasks(GeoRasterBitmapMask[] geoRasterBitmapMaskArray) {
        if (geoRasterBitmapMaskArray == null || geoRasterBitmapMaskArray.length == 0) {
            this.overbitmapMasks = null;
            return;
        }
        this.overbitmapMasks = new Hashtable();
        for (int i = 0; i < geoRasterBitmapMaskArray.length; ++i) {
            int n = geoRasterBitmapMaskArray[i].getRasterId();
            String string = geoRasterBitmapMaskArray[i].getRasterDataTableName();
            this.overbitmapMasks.put("" + n + ":" + string.toUpperCase(), geoRasterBitmapMaskArray[i]);
        }
    }

    public void ClearOverwriteBitmapMasks() {
        this.overbitmapMasks = null;
    }

    private void processNodata(JGeoRaster jGeoRaster, SubLayerInfo subLayerInfo) {
        Vector vector;
        if (jGeoRaster == null || subLayerInfo == null) {
            return;
        }
        Vector vector2 = subLayerInfo.getNODATAValue();
        if (vector2 != null && vector2.size() > 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                Double d = (Double)vector2.get(i);
                jGeoRaster.getGeoRasterImageObject().addNodataMapping(d.doubleValue(), null, true);
            }
        }
        if ((vector = subLayerInfo.getNODATARange()) != null && vector.size() > 0) {
            for (int i = 0; i < vector.size() / 2; ++i) {
                Double d = (Double)vector.get(2 * i);
                Double d2 = (Double)vector.get(2 * i + 1);
                jGeoRaster.getGeoRasterImageObject().addNodataMapping(d.doubleValue(), d2.doubleValue(), null, true);
            }
        }
    }
}

