/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonThemeAttrs {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public int cacheMode = 1;
    public String keyColumn = "ROWID";
    public StylingRule[] styleRules = null;
    public String[] identifiableColumns = null;
    public String[] identifiableNames = null;
    public String table_Alias = null;
    public Vector tagNames = new Vector();
    public Vector tagValues = new Vector();
    public String highlightStyleName = null;
    public int fetchSize = 100;
    public String resourceClass = null;

    public void reset() {
        this.cacheMode = 1;
        this.keyColumn = "ROWID";
        this.styleRules = null;
        this.identifiableColumns = null;
        this.identifiableNames = null;
        this.table_Alias = null;
        this.fetchSize = 100;
        this.tagNames.clear();
        this.tagValues.clear();
        this.highlightStyleName = null;
        this.resourceClass = null;
    }

    public void getAttributes(String string, XMLDOMParser xMLDOMParser, Node node, String string2, String string3) {
        Node node2;
        Object object;
        int n;
        Node node3;
        this.reset();
        String string4 = XMLDOMParser.getAttribute(node, "key_column");
        if (string4 != null && string4.length() > 0) {
            this.keyColumn = string4;
            log.finest("key_column specified by user: " + this.keyColumn);
        } else {
            log.finest("key_column using default: " + this.keyColumn);
        }
        string4 = XMLDOMParser.getAttribute(node, "caching");
        if (string4 != null && string4.length() > 0) {
            if ("none".equalsIgnoreCase(string4)) {
                this.cacheMode = 3;
            } else if ("all".equalsIgnoreCase(string4)) {
                this.cacheMode = 2;
            }
        }
        if ((string4 = XMLDOMParser.getAttribute(node, "table_alias")) != null && string4.trim().length() > 0) {
            this.table_Alias = string4.trim();
        }
        if ((string4 = XMLDOMParser.getAttribute(node, "highlight_style")) != null && string4.trim().length() > 0) {
            this.highlightStyleName = string4.trim().toUpperCase();
        }
        if ((string4 = XMLDOMParser.getAttribute(node, "fetch_size")) != null && string4.trim().length() > 0) {
            try {
                this.fetchSize = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                this.fetchSize = 100;
            }
        }
        if ((node3 = xMLDOMParser.getElementNode("resource_bundle")) != null) {
            this.resourceClass = XMLDOMParser.getElementValue(node3);
        }
        node = xMLDOMParser.getElementNode("info");
        NodeList nodeList = xMLDOMParser.getElementNodes("field");
        if (nodeList.getLength() > 0) {
            this.identifiableColumns = new String[nodeList.getLength()];
            this.identifiableNames = new String[nodeList.getLength()];
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = nodeList.item(n);
                this.identifiableColumns[n] = XMLDOMParser.getAttribute((Node)object, "column");
                this.identifiableNames[n] = XMLDOMParser.getAttribute((Node)object, "name");
                if (this.identifiableNames[n] != null && this.identifiableNames[n].length() != 0) continue;
                this.identifiableNames[n] = this.identifiableColumns[n];
            }
        }
        if ((nodeList = xMLDOMParser.getElementNodes("rule")).getLength() > 0) {
            this.styleRules = new StylingRule[nodeList.getLength()];
            for (n = 0; n < nodeList.getLength(); ++n) {
                this.styleRules[n] = new StylingRule(string2, string3, xMLDOMParser, nodeList.item(n));
            }
        }
        if ((node2 = xMLDOMParser.getElementNode("custom_tags")) != null && (object = xMLDOMParser.getElementNodes("tag")) != null && object.getLength() > 0) {
            for (int i = 0; i < object.getLength(); ++i) {
                Node node4 = object.item(i);
                NodeList nodeList2 = node4.getChildNodes();
                if (nodeList2 == null) continue;
                String string5 = null;
                String string6 = null;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node5 = nodeList2.item(j);
                    if (node5 != null && node5.getNodeName().equalsIgnoreCase("name")) {
                        string5 = node5.getChildNodes().item(0).getNodeValue();
                        if (string5 == null || string5.trim().length() >= 1) continue;
                        string5 = null;
                        continue;
                    }
                    if (node5 == null || !node5.getNodeName().equalsIgnoreCase("value") || (string6 = node5.getChildNodes().item(0).getNodeValue()) == null || string6.trim().length() >= 1) continue;
                    string6 = null;
                }
                if (string5 == null || string6 == null) continue;
                this.tagNames.add(string5.trim());
                this.tagValues.add(string6.trim());
            }
        }
    }

    public void updateThemeDefinitionCustomTags(ThemeDefinition themeDefinition) {
        themeDefinition.clearCustomTags();
        if (themeDefinition == null) {
            return;
        }
        if (this.tagNames.size() == 0 || this.tagValues.size() == 0 || this.tagNames.size() != this.tagValues.size()) {
            return;
        }
        for (int i = 0; i < this.tagNames.size(); ++i) {
            themeDefinition.addCustomTag(this.tagNames.get(i).toString(), this.tagValues.get(i).toString());
        }
    }
}

