/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.theme;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.BasicThemeInfo;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTextThemeDefinition
extends VectorThemeDefinition {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String baseTable = null;
    protected String baseColumn = null;
    protected String keyColumn = "ROWID";
    protected String query = null;
    protected StylingRule[] styleRules = null;
    protected boolean isPredefined = false;
    protected String metadataExpression = null;
    protected String metadataAttributes = null;
    protected double metadataMapBaseScale = Double.NaN;
    protected boolean passThrough = false;
    protected String leaderLineStyle = null;
    protected String baseColumnAlias = null;
    protected ArrayList<String> tableColumns = null;
    protected String defaultTextExprColumn = null;

    public AnnotationTextThemeDefinition(String string, String string2, String string3, String string4, String string5, StylingRule[] stylingRuleArray, int n) {
        this.name = string;
        this.dataSource = string2;
        this.baseTable = string3;
        this.baseColumn = string4;
        if (string5 != null) {
            this.keyColumn = string5;
        }
        this.styleRules = stylingRuleArray;
        this.srid = n;
        this.isPredefined = true;
        if (stylingRuleArray != null && stylingRuleArray.length > 0) {
            this.passThrough = stylingRuleArray[0].isQueryPassThrough();
            this.setLeaderLineStyle(stylingRuleArray[0].getFeatureStyleName());
        }
        this.readMetadata();
    }

    public AnnotationTextThemeDefinition(String string, String string2, String string3, String string4, String string5, int n, boolean bl) {
        this.name = string;
        this.dataSource = string2;
        this.baseTable = string4;
        this.query = string3;
        this.baseColumn = string5;
        if (this.query != null && this.baseColumn != null && this.baseColumn.indexOf(46) > -1) {
            this.query = this.query.toLowerCase();
            this.baseColumn = this.baseColumn.toLowerCase().trim();
            int n2 = this.baseColumn.indexOf(" ");
            if (n2 < 0) {
                this.baseColumnAlias = "mv_antext_alias";
                this.query = this.query.replaceFirst(this.baseColumn, this.baseColumn + " " + this.baseColumnAlias);
            } else {
                this.baseColumnAlias = this.baseColumn.substring(n2 + 1, this.baseColumn.length()).trim();
                this.baseColumn = this.baseColumn.substring(0, n2);
            }
        }
        this.srid = n;
        this.passThrough = bl;
        this.readMetadata();
    }

    public AnnotationTextThemeDefinition(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) {
        this(string, string2, string3, string4, string5, n, bl);
        this.defaultTextExprColumn = string6;
    }

    public String getDefaultTextExpressionColumn() {
        if (this.isPredefined) {
            return null;
        }
        return this.defaultTextExprColumn;
    }

    public String getQuery() {
        String string;
        if (!this.isPredefined) {
            return this.query;
        }
        String string2 = "select " + this.keyColumn + "," + this.baseColumn + " from " + this.baseTable;
        if (this.styleRules != null && this.styleRules.length > 0 && (string = this.styleRules[0].getFeatureCond()) != null) {
            string2 = string2 + " where " + string;
        }
        return string2;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getTextColumn() {
        return this.baseColumn;
    }

    public void setTextColumn(String string) {
        this.baseColumn = string;
    }

    @Override
    public String getXMLDefinition() {
        return null;
    }

    public void setKeyColumn(String string) {
        this.keyColumn = string;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getMetadataExpression() {
        return this.metadataExpression;
    }

    public void setMetadataExpression(String string) {
        this.metadataExpression = string;
    }

    public String getMetadataAttributes() {
        return this.metadataAttributes;
    }

    public void setMetadataAtributes(String string) {
        this.metadataAttributes = string;
    }

    public boolean refreshMetadata() {
        return this.readMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readMetadata() {
        if (this.dataSource == null || this.baseTable == null || this.baseColumn == null) {
            return false;
        }
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (abstractDBDataSource == null) {
            log.severe("Could not get data source: " + this.dataSource);
            return false;
        }
        String string = abstractDBDataSource.getUser();
        Connection connection = null;
        String string2 = this.baseTable;
        String string3 = string;
        int n = string2.indexOf(".");
        if (n > -1) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1, string2.length());
        }
        String string4 = "select * from all_annotation_text_metadata where table_name = ?  and column_name = ?  and owner = ?";
        log.finest("[Annotation Text Metadata Query] " + string4);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            connection = abstractDBDataSource.getConnection();
            if (n < 0 && (object = Util.getCurrentSchema(connection, null)) != null) {
                string3 = object;
            }
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.setString(1, string2.toUpperCase());
            preparedStatement.setString(2, this.baseColumn.toUpperCase());
            preparedStatement.setString(3, string3.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                log.severe("Unable to load Annotation metadata for Table Name " + string2 + ", Column Name " + this.baseColumn + ", Annotation Owner " + string3);
                boolean bl = false;
                return bl;
            }
            this.metadataExpression = resultSet.getString("text_expression");
            this.metadataAttributes = resultSet.getString("text_attributes");
            if (resultSet.getObject("map_base_scale") != null) {
                this.metadataMapBaseScale = resultSet.getDouble("map_base_scale");
            }
            resultSet.close();
            preparedStatement.close();
            string4 = "select * from " + this.baseTable + " where rownum < 1";
            preparedStatement = connection.prepareStatement(string4);
            resultSet = preparedStatement.executeQuery();
            object = resultSet.getMetaData();
            int n2 = object.getColumnCount();
            this.tableColumns = new ArrayList();
            for (int i = 1; i <= n2; ++i) {
                String string5 = object.getColumnName(i);
                this.tableColumns.add(string5);
            }
        }
        catch (Exception exception) {
            log.finest("Table name: " + string2.toUpperCase());
            log.finest("Column name: " + this.baseColumn.toUpperCase());
            log.info("Owner: " + string3.toUpperCase());
            log.severe("Annotation load metadata Exception: " + exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public boolean getFilterUse() {
        return this.passThrough;
    }

    public StylingRule[] getStylingRules() {
        return this.styleRules;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public String getLeaderLineStyle() {
        return this.leaderLineStyle;
    }

    public void setLeaderLineStyle(String string) {
        this.leaderLineStyle = string;
        if (this.styleRules != null && this.styleRules.length > 0) {
            this.styleRules[0].setFeatureStyleName(string);
        }
    }

    @Override
    public String getThemeType() {
        return "ANNOTATION";
    }

    public double getMapBaseScale() {
        return this.metadataMapBaseScale;
    }

    public void setMapBaseScales(double d) {
        this.metadataMapBaseScale = d;
    }

    public String getBaseColumnAlias() {
        return this.baseColumnAlias;
    }

    @Override
    public BasicThemeInfo getBasicThemeInfo() {
        BasicThemeInfo basicThemeInfo = new BasicThemeInfo();
        basicThemeInfo.setName(this.getName());
        basicThemeInfo.setBaseTable(this.baseTable);
        basicThemeInfo.setType("ANNOTATION");
        basicThemeInfo.setKeyColumn(this.getKeyColumn());
        basicThemeInfo.setSrid(this.getSrid());
        basicThemeInfo.setSpatialColumn(this.baseColumn);
        return basicThemeInfo;
    }

    @Override
    public String[] getRenderingStyles() {
        if (this.leaderLineStyle != null) {
            String[] stringArray = new String[]{this.leaderLineStyle};
            return stringArray;
        }
        return null;
    }

    @Override
    public String[] getLabelingStyles() {
        return null;
    }

    public ArrayList<String> getTableColumns() {
        return this.tableColumns;
    }
}

