/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.SizeDefinition;
import oracle.sdovis.DataException;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class StylingRule
implements Serializable {
    private String mBaseTable = null;
    private String mLabelCol = null;
    private String mLabelFunc = null;
    private int[] mLabelRange = null;
    private String mLabelStyleName = null;
    private Style mLabelStyle = null;
    private boolean labeled = true;
    private String mFeatureStyleName = null;
    private Style mFeatureStyle = null;
    private String mFeatureCond = null;
    private boolean mIsFullQuery = false;
    private boolean mIsPassThrough = false;
    private String mSpatialCol = null;
    private String[] mAttrColumns = null;
    private int[] hiddenInfoColumns = null;
    private String[] hiddenInfoNames = null;
    private boolean hasHiddenInfo = false;
    private boolean simpleFlag = false;
    private String linkStyle = null;
    private String nodeStyle = null;
    private String directionStyle = null;
    private String bidirectionStyle = null;
    private SizeDefinition dirStyleSize = new SizeDefinition(8.0, null);
    private double dirPosition = 0.75;
    private boolean multipleMarker = false;
    private SizeDefinition nodeStyleSize = new SizeDefinition(5.0, null);
    private String pathStyles = null;
    private String idPaths = null;
    private String linkLabelStyle = null;
    private String linkLabelColumn = null;
    private String nodeLabelStyle = null;
    private String nodeLabelColumn = null;
    private String pathLabelStyle = null;
    private String pathLabelColumn = null;
    private String orderByColumns = null;
    private String sortOrder = null;
    private boolean starColumn = false;
    private RenderingRule[] renderRules = null;

    public StylingRule() {
        this.labeled = false;
        this.simpleFlag = true;
        this.mFeatureStyle = new StyleColor(null, Color.gray);
    }

    public StylingRule(Color color, Color color2) {
        this.labeled = false;
        this.simpleFlag = true;
        this.mFeatureStyle = new StyleColor(color, color2);
    }

    public StylingRule(String string, String string2, XMLDOMParser xMLDOMParser, Node node) {
        this.mAttrColumns = null;
        this.mBaseTable = string;
        this.mSpatialCol = string2;
        this.simpleFlag = false;
        this.parseRuleNode(xMLDOMParser, node);
    }

    public String getLabelColumn() {
        return this.mLabelCol;
    }

    public void setLabelColumn(String string) {
        this.mLabelCol = string;
    }

    public int[] getLabelRange() {
        return this.mLabelRange;
    }

    public void setLabelRange(int[] nArray) {
        this.mLabelRange = nArray;
    }

    public String getFeatureStyleName() {
        if (this.renderRules == null || this.renderRules.length == 0) {
            return this.mFeatureStyleName;
        }
        return this.renderRules[0].getStyleName();
    }

    public void setFeatureStyleName(String string) {
        this.mFeatureStyleName = string;
    }

    public Style getFeatureStyle() {
        return this.mFeatureStyle;
    }

    public void setFeaturestyle(Style style) {
        this.mFeatureStyle = style;
    }

    public boolean getLabeled() {
        return this.labeled;
    }

    public void setLabeled(boolean bl) {
        this.labeled = bl;
    }

    public String getLabelFunction() {
        if (this.labeled && this.mLabelFunc != null) {
            return this.mLabelFunc;
        }
        return "-1";
    }

    public void setLabeFunction(String string) {
        this.mLabelFunc = string;
    }

    public String getLabelStyleName() {
        return this.mLabelStyleName;
    }

    public void setLabelStyleName(String string) {
        this.mLabelStyleName = string;
    }

    public Style getLabelStyle() {
        return this.mLabelStyle;
    }

    public void setLabelStyle(Style style) {
        this.mLabelStyle = style;
    }

    public String[] getAttributeColumnsAsArray() {
        return this.mAttrColumns;
    }

    public void setAttributeColumns(String[] stringArray) {
        this.mAttrColumns = stringArray;
    }

    public String getAttributeColumns() {
        String string = "";
        if (this.mAttrColumns == null || this.mAttrColumns.length == 0) {
            return string;
        }
        string = this.mAttrColumns[0];
        for (int i = 1; i < this.mAttrColumns.length; ++i) {
            string = string + "," + this.mAttrColumns[i];
        }
        return string;
    }

    public String getFeatureCond() {
        return this.simpleFlag ? null : this.mFeatureCond;
    }

    public void setFeatureCond(String string) {
        this.mFeatureCond = string;
    }

    public boolean getIsSimpleRule() {
        return this.simpleFlag;
    }

    public void setIsSimpleRule(boolean bl) {
        this.simpleFlag = bl;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public void setBaseTable(String string) {
        this.mBaseTable = string;
    }

    public String getSpatialColumn() {
        return this.mSpatialCol;
    }

    public void setSpatialColumn(String string) {
        this.mSpatialCol = string;
    }

    public void loadAllStyles(StyleTable styleTable) throws DataException {
        if (this.simpleFlag) {
            return;
        }
        if (this.mFeatureStyleName != null) {
            this.mFeatureStyle = styleTable.getStyleObject(this.mFeatureStyleName);
        }
        if (this.mLabelStyleName != null) {
            this.mLabelStyle = styleTable.getStyleObject(this.mLabelStyleName);
        }
    }

    public boolean isCompleteSQLQuery() {
        return this.mIsFullQuery;
    }

    public void setIsCompleteSQLQuery(boolean bl) {
        this.mIsFullQuery = bl;
    }

    public boolean isQueryPassThrough() {
        return this.mIsPassThrough;
    }

    public void setIsQueryPassThrough(boolean bl) {
        this.mIsPassThrough = bl;
    }

    private void parseRuleNode(XMLDOMParser xMLDOMParser, Node node) {
        Node node2;
        int n;
        Object object;
        Object object2;
        Node node3;
        String string = null;
        Object var4_4 = null;
        string = XMLDOMParser.getAttribute(node, "column");
        ArrayList<String> arrayList = null;
        if (string != null) {
            if (!string.equals("*")) {
                arrayList = Util.splitBy(string, ", \t\n\r\f");
                this.starColumn = false;
            } else {
                this.starColumn = true;
            }
        } else {
            this.starColumn = false;
        }
        this.orderByColumns = null;
        string = XMLDOMParser.getAttribute(node, "order_by");
        if (string != null && string.length() > 0) {
            this.orderByColumns = string;
        }
        this.sortOrder = null;
        string = XMLDOMParser.getAttribute(node, "sort_order");
        if (string != null && string.length() > 0) {
            if ("ASC".equalsIgnoreCase(string) || "DESC".equalsIgnoreCase(string)) {
                this.sortOrder = string.toUpperCase();
            } else {
                System.err.println("sort_order value must be ASC or DESC.");
            }
        }
        if ((node3 = XMLDOMParser.getSubElement(node, "features")) == null) {
            throw new NullPointerException("no <features> element in styling rule.");
        }
        string = XMLDOMParser.getAttribute(node3, "asis");
        try {
            if (string != null) {
                this.mIsPassThrough = new Boolean(string);
            }
        }
        catch (Exception exception) {
            System.err.println("unrecognized value for attribute \"asis\".");
        }
        if (this.parseNetworkFeatures(xMLDOMParser, node3)) {
            Node node4 = XMLDOMParser.getSubElement(node, "label");
            if (node4 == null) {
                this.labeled = false;
            } else {
                this.parseNetworkLabels(xMLDOMParser, node4);
            }
            return;
        }
        string = XMLDOMParser.getAttribute(node3, "style");
        if (string == null) {
            string = XMLDOMParser.getAttribute(node3, "style_id");
        }
        if (string != null) {
            this.mFeatureStyleName = string.trim();
        }
        this.mFeatureCond = XMLDOMParser.getElementValue(node3);
        if (this.mFeatureCond != null && this.mFeatureCond.length() > 0) {
            object2 = this.mFeatureCond.toUpperCase();
            if (((String)object2).indexOf("SELECT ") == 0 && ((String)object2).indexOf("FROM ") > 0) {
                this.mIsFullQuery = true;
            } else if (!this.mFeatureCond.startsWith("(") || !this.mFeatureCond.endsWith(")")) {
                this.mFeatureCond = "(" + this.mFeatureCond + ")";
            }
        } else {
            this.mFeatureCond = null;
        }
        object2 = XMLDOMParser.getSubElement(node, "label");
        if (object2 == null) {
            this.labeled = false;
        } else {
            this.labeled = true;
            this.mLabelCol = XMLDOMParser.getAttribute((Node)object2, "column");
            string = XMLDOMParser.getAttribute((Node)object2, "style");
            if (string == null) {
                string = XMLDOMParser.getAttribute((Node)object2, "style_id");
            }
            if (string != null) {
                this.mLabelStyleName = string.trim();
            }
            this.mLabelFunc = (string = XMLDOMParser.getElementValue((Node)object2)) != null ? new String(string) : "1";
            object = XMLDOMParser.getAttribute((Node)object2, "range");
            if (object != null) {
                n = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(44)));
                int n2 = Integer.parseInt(((String)object).substring(((String)object).indexOf(44) + 1, ((String)object).length()));
                this.mLabelRange = new int[2];
                this.mLabelRange[0] = n;
                this.mLabelRange[1] = n2;
            } else {
                this.mLabelRange = null;
            }
        }
        object = XMLDOMParser.getSubNodesWithTagName(node, "hidden_info");
        if (object == null || ((Vector)object).size() == 0) {
            this.hasHiddenInfo = false;
        } else {
            this.hasHiddenInfo = true;
            this.hiddenInfoColumns = new int[((Vector)object).size()];
            this.hiddenInfoNames = new String[((Vector)object).size()];
            if (arrayList == null) {
                arrayList = new ArrayList<String>(((Vector)object).size());
            }
            for (n = 0; n < ((Vector)object).size(); ++n) {
                Node node5 = (Node)((Vector)object).get(n);
                String string2 = XMLDOMParser.getAttribute(node5, "column");
                string = XMLDOMParser.getAttribute(node5, "name");
                this.hiddenInfoNames[n] = string == null ? string2 : string;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((String)arrayList.get(n)).equalsIgnoreCase(string2)) continue;
                    this.hiddenInfoColumns[n] = i;
                }
                this.hiddenInfoColumns[n] = arrayList.size();
                arrayList.add(string2);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            this.mAttrColumns = arrayList.toArray(new String[arrayList.size()]);
        }
        if ((node2 = XMLDOMParser.getSubElement(node, "rendering")) != null) {
            this.renderRules = StylingRule.getRenderRules(xMLDOMParser, node2);
        }
    }

    private boolean parseNetworkFeatures(XMLDOMParser xMLDOMParser, Node node) {
        Node node2;
        Node node3;
        String string = null;
        boolean bl = false;
        Node node4 = XMLDOMParser.getSubElement(node, "link");
        if (node4 != null) {
            bl = true;
            string = XMLDOMParser.getAttribute(node4, "style");
            if (string != null && string.trim().length() > 0) {
                this.linkStyle = string;
            }
            if ((string = XMLDOMParser.getAttribute(node4, "direction_style")) != null && string.trim().length() > 0) {
                this.directionStyle = string;
            }
            if ((string = XMLDOMParser.getAttribute(node4, "bidirection_style")) != null && string.trim().length() > 0) {
                this.bidirectionStyle = string;
            }
            if ((string = XMLDOMParser.getAttribute(node4, "direction_position")) != null && string.trim().length() > 0) {
                try {
                    this.dirPosition = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    this.dirPosition = 0.75;
                }
            }
            if ((string = XMLDOMParser.getAttribute(node4, "direction_markersize")) != null && string.trim().length() > 0) {
                this.dirStyleSize = SizeDefinition.parse(string.trim());
                if (this.dirStyleSize == null) {
                    this.dirStyleSize = new SizeDefinition(8.0, null);
                }
            }
            if ((string = XMLDOMParser.getAttribute(node4, "direction_multimarker")) != null && string.trim().length() > 0 && string.trim().equalsIgnoreCase("true")) {
                this.multipleMarker = true;
            }
        }
        if ((node3 = XMLDOMParser.getSubElement(node, "node")) != null) {
            bl = true;
            string = XMLDOMParser.getAttribute(node3, "style");
            if (string != null && string.trim().length() > 0) {
                this.nodeStyle = string;
            }
            if ((string = XMLDOMParser.getAttribute(node3, "markersize")) != null && string.trim().length() > 0) {
                this.nodeStyleSize = SizeDefinition.parse(string.trim());
                if (this.nodeStyleSize == null) {
                    this.nodeStyleSize = new SizeDefinition(8.0, null);
                }
            }
        }
        if ((node2 = XMLDOMParser.getSubElement(node, "path")) != null) {
            bl = true;
            string = XMLDOMParser.getAttribute(node2, "ids");
            if (string != null && string.trim().length() > 0) {
                this.idPaths = string;
            }
            if ((string = XMLDOMParser.getAttribute(node2, "styles")) != null && string.trim().length() > 0) {
                this.pathStyles = string;
            }
        }
        return bl;
    }

    private void parseNetworkLabels(XMLDOMParser xMLDOMParser, Node node) {
        Node node2;
        Node node3;
        String string = null;
        Node node4 = XMLDOMParser.getSubElement(node, "link");
        if (node4 != null) {
            string = XMLDOMParser.getAttribute(node4, "column");
            if (string != null && string.trim().length() > 0) {
                this.linkLabelColumn = string;
            }
            if ((string = XMLDOMParser.getAttribute(node4, "style")) != null && string.trim().length() > 0) {
                this.linkLabelStyle = string;
            }
            this.labeled = true;
        }
        if ((node3 = XMLDOMParser.getSubElement(node, "node")) != null) {
            string = XMLDOMParser.getAttribute(node3, "column");
            if (string != null && string.trim().length() > 0) {
                this.nodeLabelColumn = string;
            }
            if ((string = XMLDOMParser.getAttribute(node3, "style")) != null && string.trim().length() > 0) {
                this.nodeLabelStyle = string;
            }
            this.labeled = true;
        }
        if ((node2 = XMLDOMParser.getSubElement(node, "path")) != null) {
            string = XMLDOMParser.getAttribute(node2, "column");
            if (string != null && string.trim().length() > 0) {
                this.pathLabelColumn = string;
            }
            if ((string = XMLDOMParser.getAttribute(node2, "style")) != null && string.trim().length() > 0) {
                this.pathLabelStyle = string;
            }
            this.labeled = true;
        }
    }

    public String getLinkStyle() {
        return this.linkStyle;
    }

    public void setLinkStyle(String string) {
        this.linkStyle = string;
    }

    public String getNodeStyle() {
        return this.nodeStyle;
    }

    public void setNodeStyle(String string) {
        this.nodeStyle = string;
    }

    public String getDirectionStyle() {
        return this.directionStyle;
    }

    public void setDirectionStyle(String string) {
        this.directionStyle = string;
    }

    public String getBiDirectionStyle() {
        return this.bidirectionStyle;
    }

    public void setBiDirectionStyle(String string) {
        this.bidirectionStyle = string;
    }

    public SizeDefinition getDirectionStyleSize() {
        return this.dirStyleSize;
    }

    public int getDirectionStyleintSize() {
        return (int)this.dirStyleSize.getValue();
    }

    public double getDirectionStyleDoubleSize() {
        return this.dirStyleSize.getValue();
    }

    public void setDirectionStyleSize(int n) {
        this.dirStyleSize.setValue(n);
    }

    public void setDirectionStyleSize(SizeDefinition sizeDefinition) {
        this.dirStyleSize = sizeDefinition == null ? new SizeDefinition(8.0, null) : sizeDefinition;
    }

    public String getDirectionStyleUnit() {
        return this.dirStyleSize.getUnit();
    }

    public double getDirectionPosition() {
        return this.dirPosition;
    }

    public void setDirectionPosition(double d) {
        this.dirPosition = d;
        if (d < 0.0) {
            this.dirPosition = 0.0;
        } else if (d > 1.0) {
            this.dirPosition = 1.0;
        }
    }

    public boolean hasMultipleDirectionMarkers() {
        return this.multipleMarker;
    }

    public void setMultipleDirectionMarkers(boolean bl) {
        this.multipleMarker = bl;
    }

    public SizeDefinition getNodeStyleSize() {
        return this.nodeStyleSize;
    }

    public int getNodeStyleIntSize() {
        return (int)this.nodeStyleSize.getValue();
    }

    public double getNodeStyleDoubleSize() {
        return this.nodeStyleSize.getValue();
    }

    public void setNodeStyleSize(int n) {
        this.nodeStyleSize.setValue(n);
    }

    public void setNodeStyleSize(SizeDefinition sizeDefinition) {
        this.nodeStyleSize = sizeDefinition == null ? new SizeDefinition(8.0, null) : sizeDefinition;
    }

    public String getNodeStyleUnit() {
        return this.nodeStyleSize.getUnit();
    }

    public String getPathStyles() {
        return this.pathStyles;
    }

    public void setPathStyles(String string) {
        this.pathStyles = string;
    }

    public String getPathIds() {
        return this.idPaths;
    }

    public void setPathIds(String string) {
        this.idPaths = string;
    }

    public String getLinkLabelStyle() {
        return this.linkLabelStyle;
    }

    public void setLinkLabelStyle(String string) {
        this.linkLabelStyle = string;
    }

    public String getLinkLabelColumn() {
        return this.linkLabelColumn;
    }

    public void setLinkLabelColumn(String string) {
        this.linkLabelColumn = string;
    }

    public String getNodeLabelStyle() {
        return this.nodeLabelStyle;
    }

    public void setNodeLabelStyle(String string) {
        this.nodeLabelStyle = string;
    }

    public String getNodeLabelColumn() {
        return this.nodeLabelColumn;
    }

    public void setNodeLabelColumn(String string) {
        this.nodeLabelColumn = string;
    }

    public String getPathLabelStyle() {
        return this.pathLabelStyle;
    }

    public void setPathLabelStyle(String string) {
        this.pathLabelStyle = string;
    }

    public String getPathLabelColumn() {
        return this.pathLabelColumn;
    }

    public void setPathLabelColumn(String string) {
        this.pathLabelColumn = string;
    }

    public String getOrderByColumns() {
        return this.orderByColumns;
    }

    public void setOrderByColumns(String string) {
        this.orderByColumns = string;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String string) {
        this.sortOrder = string == null || !string.equalsIgnoreCase("ASC") && !string.equalsIgnoreCase("DESC") ? "ASC" : string;
    }

    public boolean getStarColumn() {
        return this.starColumn;
    }

    public void setStarColumn(boolean bl) {
        this.starColumn = bl;
    }

    public static RenderingRule[] getRenderRules(XMLDOMParser xMLDOMParser, Node node) {
        if (xMLDOMParser == null && node == null) {
            return null;
        }
        if (!node.getNodeName().equalsIgnoreCase("rendering")) {
            return null;
        }
        ArrayList<RenderingRule> arrayList = new ArrayList<RenderingRule>();
        ArrayList arrayList2 = XMLDOMParser.getSubElements(node, "style");
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                String[] stringArray;
                Object object;
                String string;
                Node node2 = (Node)arrayList2.get(i);
                RenderingRule renderingRule = new RenderingRule();
                String string2 = XMLDOMParser.getAttribute(node2, "name");
                if (string2 != null && string2.trim().length() > 0) {
                    renderingRule.setStyleName(string2.trim());
                }
                if ((string = XMLDOMParser.getAttribute(node2, "value_columns")) != null && string.trim().length() > 0) {
                    object = Util.splitBy(string, ",");
                    stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
                    if (stringArray != null) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            stringArray[j] = stringArray[j].trim();
                        }
                    }
                    renderingRule.setStyleColumns(stringArray);
                }
                if ((object = XMLDOMParser.getSubElement(node2, "substyle")) != null) {
                    Object object2;
                    String string3;
                    stringArray = XMLDOMParser.getAttribute((Node)object, "name");
                    if (stringArray != null && stringArray.trim().length() > 0) {
                        renderingRule.setSubStyleName(stringArray.trim());
                    }
                    if ((string3 = XMLDOMParser.getAttribute((Node)object, "value_columns")) != null && string3.trim().length() > 0) {
                        object2 = Util.splitBy(string3, ",");
                        String[] stringArray2 = ((ArrayList)object2).toArray(new String[((ArrayList)object2).size()]);
                        if (stringArray2 != null) {
                            for (int j = 0; j < stringArray2.length; ++j) {
                                stringArray2[j] = stringArray2[j].trim();
                            }
                        }
                        renderingRule.setSubStyleColumns(stringArray2);
                    }
                    if ((object2 = XMLDOMParser.getAttribute((Node)object, "changes")) != null && ((String)object2).trim().length() > 0) {
                        renderingRule.setSubStyleChangeProperty(((String)object2).trim());
                    }
                }
                arrayList.add(renderingRule);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new RenderingRule[arrayList.size()]);
    }

    public void setRenderingRules(RenderingRule[] renderingRuleArray) {
        this.renderRules = renderingRuleArray;
    }

    public RenderingRule[] getRenderingRules() {
        return this.renderRules;
    }
}

