/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.LabelHelper;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.MarkerStyleModifiers;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.svg.SVGDomUtil;
import oracle.sdovis.svg.ShapeConverter;
import oracle.sdovis.util.Base64OutputStream;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.GIFMaker;
import oracle.sdovis.util.ImageUtils;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;

public class StyleMarker
implements Style {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final AffineTransform idTransform = new AffineTransform();
    static final FontRenderContext frc = new FontRenderContext(null, true, false);
    MarkerStyleModel bean = null;
    transient Shape markerShp = null;
    private transient Image image = null;
    transient StyleColor styColor = null;
    transient Rectangle2D mbr = null;
    private transient Image urlImage = null;
    private transient String currentUrl = null;
    private transient GraphicsNode svgRootNode = null;

    public StyleMarker() {
        this.bean = new MarkerStyleModel();
    }

    public StyleMarker(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof MarkerStyleModel)) {
            throw new IllegalArgumentException("Not a valid Marker style model");
        }
        this.bean = (MarkerStyleModel)styleModel;
        this.refreshThis();
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public StyleMarker(String string) throws StyleException {
        this.bean = new MarkerStyleModel();
        if (!this.parseMarker(string)) {
            throw new StyleException("Invalid marker style definition.");
        }
    }

    public StyleMarker(int n, byte[] byArray, String string) throws StyleException {
        this.bean = new MarkerStyleModel();
        this.bean.setMarkerType(5);
        this.bean.setMarkerImageBinary(byArray);
        this.bean.setMarkerImageType(n);
        this.recreateImageMarker();
        if (string != null && !this.parseMarker(string)) {
            throw new StyleException("Invalid marker style definition.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMarker(Image image, String string) {
        this.bean = new MarkerStyleModel();
        this.bean.setMarkerType(5);
        ImageUtils.waitForImage(image);
        this.image = image;
        this.mbr = new Rectangle2D.Double(0.0, 0.0, image.getWidth(null), image.getHeight(null));
        this.bean.setForcedWidth(image.getWidth(null));
        this.bean.setForcedHeight(image.getHeight(null));
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = (BufferedImage)image;
        }
        catch (ClassCastException classCastException) {
            bufferedImage = ImageUtils.makeBufferedImage(image);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            GIFMaker gIFMaker = new GIFMaker(bufferedOutputStream);
            gIFMaker.encode(bufferedImage);
            this.bean.setMarkerImageBinary(byteArrayOutputStream.toByteArray());
            this.bean.setMarkerImageType(0);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        finally {
            ImageUtils.removeImageFromTracker(image);
        }
        if (string != null && string.length() > 0) {
            this.parseMarker(string);
        }
    }

    public StyleMarker(Font font, char c) {
        this.bean = new MarkerStyleModel();
        this.bean.setMarkerType(6);
        this.bean.setTruetypeFont(font);
        this.bean.setGlyphCharCode(c);
    }

    public Object clone() {
        try {
            StyleMarker styleMarker = (StyleMarker)super.clone();
            styleMarker.setModel((StyleModel)this.bean.clone());
            return styleMarker;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    private void recreateImageMarker() {
        if (this.bean.getUrl() != null) {
            try {
                if (this.urlImage == null || this.bean.getUrl() != this.currentUrl) {
                    byte[] byArray = Util.readBinaryFromURL(this.bean.getUrl());
                    if (byArray == null) {
                        log.warning("cannot load url-based marker: " + this.bean.getUrl());
                        this.urlImage = null;
                        return;
                    }
                    Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                    ImageUtils.waitForImage(image);
                    this.urlImage = ImageUtils.makeBufferedImage(image, 2);
                    ImageUtils.removeImageFromTracker(image);
                    this.currentUrl = this.bean.getUrl();
                }
                this.mbr = new Rectangle2D.Double(0.0, 0.0, this.urlImage.getWidth(null), this.urlImage.getHeight(null));
                if (this.bean.getForcedWidth() == 0 || this.bean.getForcedHeight() == 0) {
                    this.bean.setForcedWidth(this.urlImage.getWidth(null));
                    this.bean.setForcedHeight(this.urlImage.getHeight(null));
                }
                return;
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "cannot load url-based marker: " + this.bean.getUrl(), exception);
                this.urlImage = null;
                return;
            }
        }
        Image image = Toolkit.getDefaultToolkit().createImage(this.bean.getMarkerImageBinary());
        ImageUtils.waitForImage(image);
        this.image = image;
        this.mbr = new Rectangle2D.Double(0.0, 0.0, image.getWidth(null), image.getHeight(null));
        if (this.bean.getForcedWidth() == 0 || this.bean.getForcedHeight() == 0) {
            this.bean.setForcedWidth(image.getWidth(null));
            this.bean.setForcedHeight(image.getHeight(null));
        }
        ImageUtils.removeImageFromTracker(image);
    }

    private void recreateSVGMarker() {
        String string = this.bean.getRawSVGString();
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            Document document = SVGDomUtil.parseSVGFromString(string);
            double[] dArray = SVGDomUtil.getSVGPreferredSize(document);
            this.mbr = new Rectangle2D.Double(0.0, 0.0, dArray[0], dArray[1]);
            this.svgRootNode = SVGDomUtil.getGraphicsRootNode(document);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean parseMarker(String string) {
        Object object;
        this.bean.setRotation(0.0);
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (!xMLDOMParser.parse(string)) {
            return false;
        }
        String string2 = xMLDOMParser.getAttribute("g", "class");
        if (string2 == null) {
            return false;
        }
        if (!string2.toUpperCase().equals("MARKER")) {
            log.warning("svg error: wrong type (expecting MARKER)");
            return false;
        }
        String string3 = xMLDOMParser.getAttribute("g", "style");
        this.extractCommonAttributes(string3, xMLDOMParser);
        String string4 = null;
        string4 = xMLDOMParser.getAttribute("polygon", "points");
        if (string4 != null) {
            this.bean.setMarkerType(1);
        } else {
            string4 = xMLDOMParser.getAttribute("polyline", "points");
            if (string4 != null) {
                this.bean.setMarkerType(2);
            } else {
                string4 = xMLDOMParser.getAttribute("circle", "r");
                if (string4 != null || xMLDOMParser.getElementNode("circle") != null) {
                    this.bean.setMarkerType(3);
                } else {
                    string4 = xMLDOMParser.getAttribute("rect", "points");
                    if (string4 != null) {
                        this.bean.setMarkerType(4);
                    } else {
                        string4 = xMLDOMParser.getAttribute("image", "width");
                        if (string4 != null) {
                            this.bean.setMarkerType(5);
                        } else {
                            string4 = xMLDOMParser.getAttribute("ttfSymbol", "fontName");
                            if (string4 != null) {
                                this.bean.setMarkerType(6);
                            } else if (xMLDOMParser.getElementNode("svgSymbol") != null) {
                                this.bean.setMarkerType(7);
                            }
                        }
                    }
                }
            }
        }
        if (xMLDOMParser.getElementNode("svgSymbol") != null) {
            string4 = xMLDOMParser.getElementValue("svgSymbol");
            if (string4 != null) {
                string4 = string4.trim();
            }
            return this.parseSVGSymbol(string4);
        }
        if (string4 != null && string4.length() > 0 && this.bean.getMarkerType() != 6 && this.bean.getMarkerType() != 5) {
            object = Util.convert(string4);
            if (((double[])object).length < 1) {
                return false;
            }
            this.bean.setVector((double[])object);
        }
        this.recreateVectorMarker();
        try {
            this.styColor = new StyleColor(string);
            if (this.styColor.getFillColor() == null && this.styColor.getStrokeColor() == null) {
                this.styColor = null;
            } else {
                this.bean.setVectorFillColor(this.styColor.getFillColor());
                this.bean.setVectorStrokeColor(this.styColor.getStrokeColor());
                this.bean.setVectorStrokeWidth(this.styColor.getStrokeWidth());
            }
        }
        catch (Exception exception) {
            this.styColor = null;
        }
        try {
            if (this.bean.getMarkerType() == 6) {
                this.bean.setTruetypeFontName(xMLDOMParser.getAttribute("ttfSymbol", "fontName"));
                this.bean.setGlyphCharCode(Integer.parseInt(xMLDOMParser.getAttribute("ttfSymbol", "charCode")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (this.bean.getMarkerType() == 5) {
            String string5;
            object = xMLDOMParser.getAttribute("image", "markerType");
            if (object != null && object.trim().length() > 0) {
                this.bean.setUrlMarkerImageFormat(object.trim());
            }
            if ((string5 = xMLDOMParser.getAttribute("image", "href")) != null && !string5.equalsIgnoreCase("dummy.gif")) {
                this.bean.setUrl(string5);
                this.recreateImageMarker();
            }
        }
        return true;
    }

    private boolean parseSVGSymbol(String string) {
        try {
            Document document = SVGDomUtil.parseSVGFromString(string);
            double[] dArray = SVGDomUtil.getSVGPreferredSize(document);
            this.mbr = new Rectangle2D.Double(0.0, 0.0, dArray[0], dArray[1]);
            if (this.bean.getSVGNaturalSize() == null) {
                this.bean.setSVGNaturalSize(dArray);
            }
            if (this.bean.getForcedWidth() == 0 || this.bean.getForcedHeight() == 0) {
                this.bean.setForcedWidth((int)dArray[0]);
                this.bean.setForcedHeight((int)dArray[1]);
            }
            this.bean.setMarkerType(7);
            this.bean.setRawSVGString(string);
            this.svgRootNode = SVGDomUtil.getGraphicsRootNode(document);
            return true;
        }
        catch (Exception exception) {
            log.warning("Error parsing embedded SVG symbol doc: " + exception.getMessage());
            return false;
        }
    }

    public void recreateColorStyle() {
        this.styColor = new StyleColor(this.bean.getVectorFillColor(), this.bean.getVectorStrokeColor());
        this.styColor.setStrokeWidth(this.bean.getVectorStrokeWidth());
    }

    public void recreateVectorMarker() {
        int n = this.bean.getMarkerType();
        if (n == 6 || n == 5 || n == 0) {
            return;
        }
        double[] dArray = this.bean.getVector();
        if (dArray == null) {
            log.warning("Unable to create vector representation due to undefined vector value(s)");
            return;
        }
        switch (n) {
            case 1: 
            case 2: {
                GeneralPath generalPath = new GeneralPath(0);
                generalPath.moveTo((float)dArray[0], (float)dArray[1]);
                for (int i = 0; i < dArray.length / 2; ++i) {
                    generalPath.lineTo((float)dArray[i * 2 + 0], (float)dArray[i * 2 + 1]);
                }
                if (n == 1) {
                    generalPath.closePath();
                }
                this.markerShp = generalPath;
                this.mbr = Util.mbr(dArray);
                if (this.mbr.getMinX() != 0.0 || this.mbr.getMinY() != 0.0) {
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.mbr.getMinX(), -this.mbr.getMinY());
                    this.markerShp = affineTransform.createTransformedShape(generalPath);
                }
                this.mbr = this.markerShp.getBounds2D();
                break;
            }
            case 3: {
                int n2 = 16;
                Ellipse2D.Float float_ = new Ellipse2D.Float(0.0f, 0.0f, n2, n2);
                this.markerShp = float_;
                this.mbr = new Rectangle2D.Double(0.0, 0.0, n2, n2);
                break;
            }
            case 4: {
                this.markerShp = new Rectangle2D.Float((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
                this.mbr = this.markerShp.getBounds2D();
                if (this.mbr.getMinX() == 0.0 && this.mbr.getMinY() == 0.0) break;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.mbr.getMinX(), -this.mbr.getMinY());
                this.markerShp = affineTransform.createTransformedShape(this.markerShp);
            }
        }
    }

    public Rectangle2D getMBR() {
        return this.mbr;
    }

    public int getDesiredWidth() {
        if (this.bean.getForcedWidth() > 0) {
            return this.bean.getForcedWidth();
        }
        return -1;
    }

    public int getDesiredHeight() {
        if (this.bean.getForcedHeight() > 0) {
            return this.bean.getForcedHeight();
        }
        return -1;
    }

    public void setDesiredWidth(int n) {
        this.bean.setForcedWidth(n);
    }

    public void setDesiredHeight(int n) {
        this.bean.setForcedHeight(n);
    }

    public void setDesiredWidth(double d) {
        this.bean.setMarkerWidth(d);
    }

    public double getDoubleDesiredWidth() {
        return this.bean.getMarkerWidth();
    }

    public void setDesiredHeight(double d) {
        this.bean.setMarkerHeight(d);
    }

    public double getDoubleDesiredHeight() {
        return this.bean.getMarkerHeight();
    }

    public void setDesiredUnit(String string) {
        this.bean.setMarkerSizeUnit(string);
    }

    public double setOrientation(double d, double d2, double d3) {
        return this.bean.setOrientation(d, d2, d3);
    }

    public double getOrientation() {
        return this.bean.getRotation();
    }

    public void setOrientation(double d) {
        this.bean.setRotation(d);
    }

    public void resetOrientation() {
        this.bean.resetOrientation();
    }

    private void extractCommonAttributes(String string, XMLDOMParser xMLDOMParser) {
        String string2;
        if (string == null) {
            return;
        }
        String string3 = StyleUtils.getNamedString(string, "width");
        String string4 = StyleUtils.getNamedString(string, "height");
        if (string3 != null && string4 != null) {
            this.bean.setMarkerSize(SizeDefinition2D.parse(string3, string4));
        } else {
            this.bean.setMarkerSize(new SizeDefinition2D(16.0, 16.0, null));
        }
        String string5 = null;
        String string6 = null;
        string5 = xMLDOMParser.getAttribute("anchor", "x");
        string6 = xMLDOMParser.getAttribute("anchor", "y");
        if (string5 != null || string6 != null) {
            int n;
            if (string5 != null && (n = (int)Double.parseDouble(string5)) >= 0) {
                this.bean.setAnchorX(n);
            }
            if (string6 != null && (n = (int)Double.parseDouble(string6)) >= 0) {
                this.bean.setAnchorY(n);
            }
        }
        SizeDefinition sizeDefinition = null;
        SizeDefinition sizeDefinition2 = null;
        String string7 = StyleUtils.getNamedString(string, "text-offset-x");
        if (string7 != null && string7.length() > 0 && (sizeDefinition = SizeDefinition.parse(string7)) != null) {
            this.bean.setLabelOffsetSizeX(sizeDefinition.getValue());
            this.bean.setLabelOffsetUnit(sizeDefinition.getUnit());
        }
        if ((string2 = StyleUtils.getNamedString(string, "text-offset-y")) != null && string2.length() > 0 && (sizeDefinition2 = SizeDefinition.parse(string2)) != null) {
            this.bean.setLabelOffsetSizeY(sizeDefinition2.getValue());
            if (sizeDefinition == null) {
                this.bean.setLabelOffsetUnit(sizeDefinition2.getUnit());
            }
        }
        String string8 = StyleUtils.getNamedString(string, "font-family");
        String string9 = StyleUtils.getNamedString(string, "font-size");
        String string10 = StyleUtils.getNamedString(string, "font-weight");
        String string11 = StyleUtils.getNamedString(string, "font-style");
        String string12 = StyleUtils.getNamedString(string, "font-fill");
        if (string12 == null || string12.length() == 0) {
            string12 = StyleUtils.getNamedString(string, "fill");
        }
        if (string12 != null) {
            String string13 = StyleUtils.getNamedString(string, "font-fill");
            if (string13 != null && string13.length() > 0) {
                this.bean.setLabelFontColor(StyleUtils.getColor("font-fill", string));
            } else {
                this.bean.setLabelFontColor(StyleUtils.getColor("fill", string));
            }
        }
        int n = 0;
        if (string11 != null && string11.toUpperCase().equals("ITALIC")) {
            n = 2;
        }
        if (string10 != null && string10.toUpperCase().equals("BOLD")) {
            n = n == 2 ? (n |= 1) : 1;
        }
        int n2 = 12;
        SizeDefinition sizeDefinition3 = SizeDefinition.parse(string9);
        if (sizeDefinition3 != null) {
            n2 = (int)sizeDefinition3.getValue();
            this.bean.setLabelFontSizeValue((float)sizeDefinition3.getValue());
            this.bean.setLabelFontSizeUnit(sizeDefinition3.getUnit());
        }
        this.bean.setLabelFont(new Font(string8, n, n2));
    }

    public String drawMarker(SVGMap sVGMap, double d, double d2, double d3, double d4, String string, String string2, int n, boolean bl, String string3) {
        double d5;
        double d6;
        double d7;
        double d8;
        int n2 = this.bean.getForcedWidth();
        int n3 = this.bean.getForcedHeight();
        if (n2 > 0) {
            d3 = (double)n2 / sVGMap.getScale(n);
        }
        if (n3 > 0) {
            d4 = (double)n3 / sVGMap.getScale(n);
        }
        if ((d8 = this.bean.getRotation()) == 0.0) {
            d8 = 0.0;
        }
        double d9 = 0.0;
        double d10 = 0.0;
        if (d8 != 0.0) {
            d7 = Math.cos(d8);
            d6 = Math.sin(d8);
            double d11 = d3 * d7 / 2.0 - d4 * d6 / 2.0;
            d5 = d3 * d6 / 2.0 + d4 * d7 / 2.0;
            d9 = d11 - d3 / 2.0;
            d10 = d5 - d4 / 2.0;
        }
        if (!sVGMap.renderLayersOnly()) {
            d7 = d - d3 / 2.0 - d9;
            d6 = d2 - d4 / 2.0 - d10;
        } else {
            d7 = d;
            d6 = d2;
        }
        if (this.bean.getMarkerType() == 5) {
            String string4 = sVGMap.getPredefinedId(this);
            if (string4 == null) {
                string4 = sVGMap.addPredefinedMarker(this);
            }
            double d12 = this.image.getWidth(null);
            double d13 = this.image.getHeight(null);
            sVGMap.drawPredefinedShape(string4, d7, d6, d8, (int)d3, (int)d4, d3 * 1.0 / d12, d4 * 1.0 / d13, string, string2, n, bl, string3);
        } else if (this.styColor != null) {
            String string5 = sVGMap.getPredefinedId(this);
            if (string5 == null) {
                string5 = sVGMap.addPredefinedMarker(this);
            }
            Shape shape = this.markerShp;
            if (this.bean.getMarkerType() == 3 && (d3 > shape.getBounds2D().getWidth() || d4 > shape.getBounds2D().getHeight())) {
                Ellipse2D.Float float_ = new Ellipse2D.Float(0.0f, 0.0f, (float)d3, (float)d4);
                this.markerShp = float_;
                this.mbr = new Rectangle2D.Double(0.0, 0.0, d3, d4);
            }
            sVGMap.drawPredefinedShape(string5, d7, d6, d8, (int)d3, (int)d4, d3 * 1.0 / shape.getBounds2D().getWidth(), d4 * 1.0 / shape.getBounds2D().getHeight(), string, string2, n, bl, string3);
        }
        if (string != null) {
            StyleText styleText = null;
            styleText = this.bean.getLabelFont() != null ? new StyleText(this.bean.getLabelFont(), this.bean.getLabelFontColor()) : new StyleText();
            Rectangle2D rectangle2D = styleText.getVisualBounds(string, null);
            if (rectangle2D == null) {
                return null;
            }
            d5 = rectangle2D.getMinX() / sVGMap.getScale(n);
            double d14 = rectangle2D.getMinY() / sVGMap.getScale(n);
            double d15 = d - rectangle2D.getWidth() / (2.0 * sVGMap.getScale(n));
            double d16 = d2 + rectangle2D.getHeight() / (2.0 * sVGMap.getScale(n));
            sVGMap.drawText(string, d15 -= d5, d16, 0.0, styleText.getFont(), styleText.getColor(), n);
        }
        return null;
    }

    private String getImageTypeString() {
        if (this.bean.getMarkerImageType() == 0) {
            return "GIF";
        }
        if (this.bean.getMarkerImageType() == 1) {
            return "JPEG";
        }
        return "PNG";
    }

    public String toSVG(String string, boolean bl) {
        if (this.bean.getMarkerType() == 5) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                Base64OutputStream base64OutputStream = new Base64OutputStream(byteArrayOutputStream);
                base64OutputStream.write(this.bean.getMarkerImageBinary());
                base64OutputStream.flush();
                return "<image id=\"" + string + "\" width=\"" + this.image.getWidth(null) + "\" height=\"" + this.image.getHeight(null) + "\" xlink:href=\"data:image/" + this.getImageTypeString() + ";base64," + byteArrayOutputStream.toString() + "\" />";
            }
            catch (Exception exception) {
                return null;
            }
        }
        Color color = Color.black;
        float f = 1.0f;
        Color color2 = null;
        if (this.styColor != null) {
            color = this.styColor.getStrokeColor();
            f = this.styColor.getStrokeWidth();
            color2 = this.styColor.getFillColor();
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        String string2 = "";
        string2 = bl ? SVGMap.getSelectedStrokeFillString(color, f, color2) : SVGMap.getStrokeFillString(color, f, color2);
        if (this.markerShp instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)this.markerShp;
            if (ellipse2D.getWidth() == ellipse2D.getHeight()) {
                stringBuffer.append("<circle id=\"" + string + "\" cx=\"" + ellipse2D.getWidth() / 2.0 + "\" cy=\"" + ellipse2D.getWidth() / 2.0 + "\" r=\"" + ellipse2D.getWidth() / 2.0 + "\" ");
                stringBuffer.append(string2);
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append("<g id=\"" + string + "\" transform=\"scale(1," + ellipse2D.getHeight() / ellipse2D.getWidth() + ")\">");
                stringBuffer.append("<circle cx=\"" + ellipse2D.getWidth() / 2.0 + "\" cy=\"" + ellipse2D.getHeight() / 2.0 + "\" r=\"" + ellipse2D.getWidth() / 2.0 + "\" ");
                stringBuffer.append(string2);
                stringBuffer.append("/>\n</g>\n");
            }
        } else {
            stringBuffer.append("<path id=\"" + string + "\" d=\"");
            ShapeConverter.appendShapeString(stringBuffer, this.markerShp, null, 1.0, 1.0, 0, 0, 1.0);
            stringBuffer.append("\" ");
            stringBuffer.append(string2);
            stringBuffer.append("/>\n");
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.refreshThis();
    }

    public void refreshThis() {
        if (this.bean.getMarkerType() == 5) {
            this.recreateImageMarker();
        } else if (this.bean.getMarkerType() == 7) {
            this.recreateSVGMarker();
        } else {
            this.recreateVectorMarker();
            this.recreateColorStyle();
            this.getGlyphShape();
        }
    }

    private void drawTTFMarker(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, int n2, double d) {
        if (this.bean.getMarkerType() == 6 && rectangle2D != null) {
            int n3 = (int)rectangle2D.getCenterX();
            int n4 = (int)rectangle2D.getCenterY();
            int n5 = (int)rectangle2D.getWidth();
            int n6 = (int)rectangle2D.getHeight();
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            Font font = graphics2D.getFont();
            Font font2 = this.bean.getTruetypeFont().getFont().deriveFont((float)n2);
            char[] cArray = new char[]{(char)this.bean.getGlyphCharCode()};
            GlyphVector glyphVector = font2.createGlyphVector(frc, cArray);
            Shape shape = glyphVector.getGlyphOutline(0);
            Rectangle2D rectangle2D2 = shape.getBounds2D();
            Color color2 = Color.blue;
            if (this.styColor != null && (color2 = this.styColor.getFillColor()) == null) {
                color2 = this.styColor.getStrokeColor();
            }
            graphics2D.setColor(color2);
            graphics2D.setFont(font2);
            int n7 = 0;
            n7 = (int)(((double)n5 - rectangle2D2.getWidth()) / 2.0 - rectangle2D2.getMinX() + 0.5);
            int n8 = 0;
            n8 = rectangle2D2.getMinY() < 0.0 ? (int)((double)n6 - Math.abs(rectangle2D2.getMinY()) - ((double)n6 - rectangle2D2.getHeight()) / 2.0 + 0.5) : (int)(((double)n6 - rectangle2D2.getHeight()) / 2.0 - rectangle2D2.getMinY() + 0.5);
            graphics2D.translate(n7 + (int)rectangle2D.getMinX(), n6 - n8 + (int)rectangle2D.getMinY());
            if (d != 0.0) {
                graphics2D.rotate(d, n5 / 2 - n7, -(n6 / 2) + n8);
            }
            graphics2D.drawString(Character.toString(cArray[0]), 0, 0);
            graphics2D.setTransform(affineTransform);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
        }
    }

    private void drawMarker(Graphics2D graphics2D) {
        if (this.bean.getUrl() != null) {
            if (this.urlImage == null) {
                log.warning("URL image is null. Check http address of image URL.");
                return;
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.urlImage != null) {
                graphics2D.drawImage(this.urlImage, null, null);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            return;
        }
        if (this.bean.getMarkerType() == 5) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.image != null) {
                graphics2D.drawImage(this.image, null, null);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            return;
        }
        if (this.markerShp != null) {
            if (this.bean.getMarkerType() == 6) {
                log.finest("We should never be here!");
                Color color = Color.blue;
                if (this.styColor != null && (color = this.styColor.getFillColor()) == null) {
                    color = this.styColor.getStrokeColor();
                }
                graphics2D.setColor(color);
                graphics2D.fill(this.markerShp);
            } else {
                this.drawVectorMarker(graphics2D);
            }
            return;
        }
        if (this.bean.getMarkerType() == 7) {
            if (this.svgRootNode == null) {
                log.warning("SVG graphics node does not exist!");
                return;
            }
            this.svgRootNode.paint(graphics2D);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawVectorMarker(Graphics2D graphics2D) {
        Shape shape = this.markerShp;
        AffineTransform affineTransform = graphics2D.getTransform();
        if (affineTransform != null && shape != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        graphics2D.setTransform(VisContext.ID_TRANSFORM);
        try {
            if (this.styColor != null) {
                this.styColor.apply(graphics2D, shape);
            } else {
                graphics2D.draw(shape);
            }
        }
        catch (Exception exception) {
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    private void getGlyphShape() {
        if (this.markerShp != null) {
            return;
        }
        TruetypeFont truetypeFont = this.bean.getTruetypeFont();
        if (truetypeFont == null || this.bean.getGlyphCharCode() == 0) {
            return;
        }
        Font font = truetypeFont.getFont();
        if (font == null) {
            return;
        }
        char[] cArray = new char[]{(char)this.bean.getGlyphCharCode()};
        GlyphVector glyphVector = font.createGlyphVector(frc, cArray);
        this.markerShp = glyphVector.getGlyphOutline(0);
        this.mbr = this.markerShp.getBounds2D();
        if (this.mbr.getMinX() != 0.0 || this.mbr.getMinY() != 0.0) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.mbr.getMinX(), -this.mbr.getMinY());
            this.markerShp = affineTransform.createTransformedShape(this.markerShp);
        }
        this.mbr = this.markerShp.getBounds2D();
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        TruetypeFont truetypeFont;
        if (this.markerShp != null) {
            return true;
        }
        if (this.bean.getMarkerType() == 6 && this.bean.getTruetypeFont() != null && this.bean.getTruetypeFont().getFont() == null && (truetypeFont = styleCache.getFont(this.bean.getTruetypeFontName())) != null) {
            this.bean.setTruetypeFont(truetypeFont.getFont());
        }
        this.getGlyphShape();
        return true;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)((double)f - this.mbr.getWidth() / 2.0), (float)((double)f2 - this.mbr.getHeight() / 2.0), (float)this.mbr.getWidth(), (float)this.mbr.getHeight());
        this.apply(null, graphics2D, (Rectangle2D)float_, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Cloneable cloneable;
        int n = this.bean.getForcedWidth();
        int n2 = this.bean.getForcedHeight();
        double d = this.bean.getRotation();
        if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
            n = ((MarkerStyleModifiers)styleModifiers).getWidth();
            n2 = ((MarkerStyleModifiers)styleModifiers).getHeight();
            d = ((MarkerStyleModifiers)styleModifiers).getOrientationAngle();
        }
        if (this.bean.getMarkerType() == 6) {
            this.drawTTFMarker(graphics2D, rectangle2D, n, n2, d);
            return;
        }
        int n3 = (int)rectangle2D.getCenterX();
        int n4 = (int)rectangle2D.getCenterY();
        int n5 = (int)rectangle2D.getWidth();
        int n6 = (int)rectangle2D.getHeight();
        if (this.bean.getMarkerType() == 7) {
            double[] dArray = this.bean.getSVGNaturalSize();
        } else {
            if (n > 0) {
                n5 = n;
            }
            if (n2 > 0) {
                n6 = n2;
            }
        }
        double d2 = (double)n5 / this.mbr.getWidth();
        double d3 = (double)n6 / this.mbr.getHeight();
        double d4 = (double)n3 - (this.mbr.getMinX() + (double)(n5 / 2));
        double d5 = (double)n4 - (this.mbr.getMinY() + (double)(n6 / 2));
        Rectangle2D rectangle2D2 = this.mbr;
        boolean bl = false;
        if (this.bean.getMarkerType() == 3 && (d2 > 1.0 || d3 > 1.0)) {
            cloneable = new Ellipse2D.Float(0.0f, 0.0f, n5, n6);
            this.markerShp = cloneable;
            this.mbr = new Rectangle2D.Double(0.0, 0.0, n5, n6);
            d2 = 1.0;
            d3 = 1.0;
            bl = true;
        }
        cloneable = graphics2D.getTransform();
        graphics2D.transform(AffineTransform.getTranslateInstance(d4, d5));
        graphics2D.transform(AffineTransform.getScaleInstance(d2, d3));
        if (d != 0.0) {
            graphics2D.rotate(d, this.mbr.getWidth() / 2.0, this.mbr.getHeight() / 2.0);
        }
        this.drawMarker(graphics2D);
        graphics2D.setTransform((AffineTransform)cloneable);
        if (bl) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(0.0f, 0.0f, (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
            this.markerShp = float_;
            this.mbr = rectangle2D2;
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        if (shape != null && shape instanceof Rectangle2D) {
            this.apply(null, graphics2D, (Rectangle2D)shape, styleModifiers);
            return;
        }
        if (shape != null && (n == 2 || n == 6)) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            this.apply(null, graphics2D, (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), styleModifiers);
            return;
        }
        if (n != 3 && n != 7) {
            throw new StyleNotApplicableException("cannot apply MARKER to gtype " + n);
        }
        double d = this.getDesiredWidth();
        double d2 = this.getDesiredHeight();
        if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
            d = ((MarkerStyleModifiers)styleModifiers).getWidth();
            d2 = ((MarkerStyleModifiers)styleModifiers).getHeight();
        }
        float[] fArray = LabelHelper.findLoc4RectInPolygon(shape, d, d2, null, true, true);
        try {
            this.apply(null, graphics2D, (Rectangle2D)new Rectangle2D.Float(fArray[0], (float)((double)fArray[1] - d2), (float)d, (float)d2), styleModifiers);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        AffineTransform affineTransform = graphics2D.getTransform();
        float[] fArray = null;
        if (point2D != null) {
            this.apply(null, graphics2D, (float)point2D.getX(), (float)point2D.getY(), styleModifiers);
            return;
        }
        if (shape != null && shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            this.apply(null, graphics2D, rectangle2D, styleModifiers);
            if (conflictResolver != null) {
                conflictResolver.insert(rectangle2D);
            }
            fArray = new float[]{(float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY()};
        } else {
            if (shape != null && (n == 2 || n == 6)) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                this.apply(null, graphics2D, (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), styleModifiers);
                return;
            }
            if (shape != null && n == 1) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                this.apply(null, graphics2D, (float)rectangle2D.getCenterX(), (float)rectangle2D.getCenterY(), styleModifiers);
            } else if (shape != null && (n == 3 || n == 7)) {
                double d = this.getDesiredWidth();
                double d3 = this.getDesiredHeight();
                if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
                    d = ((MarkerStyleModifiers)styleModifiers).getWidth();
                    d3 = ((MarkerStyleModifiers)styleModifiers).getHeight();
                }
                fArray = LabelHelper.findLoc4RectInPolygon(shape, d, d3, null, true, true);
                Rectangle2D.Float float_ = new Rectangle2D.Float(fArray[0], (float)((double)fArray[1] - d3), (float)d, (float)d3);
                this.apply(null, graphics2D, (Rectangle2D)float_, styleModifiers);
                if (conflictResolver != null) {
                    conflictResolver.insert(float_);
                }
                fArray[0] = (float)((double)fArray[0] + d / 2.0);
                fArray[1] = (float)((double)fArray[1] - d3 / 2.0);
            }
        }
        if (string != null) {
            graphics2D.setTransform(idTransform);
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            StyleText styleText = null;
            if (this.bean.getLabelFont() != null) {
                if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
                    Font font = new Font(this.bean.getLabelFont().getFamily(), this.bean.getLabelFont().getStyle(), ((MarkerStyleModifiers)styleModifiers).getFontSize());
                    styleText = new StyleText(font, this.bean.getLabelFontColor());
                } else {
                    styleText = new StyleText(this.bean.getLabelFont(), this.bean.getLabelFontColor());
                }
            } else {
                styleText = new StyleText();
                graphics2D.setColor(Color.white);
            }
            int n2 = this.bean.getLabelOffsetX();
            int n3 = this.bean.getLabelOffsetY();
            if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
                n2 = ((MarkerStyleModifiers)styleModifiers).getLabelOffsetX();
                n3 = ((MarkerStyleModifiers)styleModifiers).getLabelOffsetY();
            }
            styleText.apply(graphics2D, fArray[0] + (float)n2, fArray[1] - (float)n3, string, styleModifiers);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        graphics2D.setTransform(affineTransform);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.drawMarker(sVGMap, f, f2, this.getDesiredWidth(), this.getDesiredHeight(), null, null, -1, false, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.drawMarker(sVGMap, rectangle2D.getCenterX(), rectangle2D.getCenterY(), rectangle2D.getWidth(), rectangle2D.getHeight(), null, null, -1, false, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Rectangle2D rectangle2D = null;
        rectangle2D = shape instanceof Rectangle2D ? (Rectangle2D)shape : shape.getBounds2D();
        this.drawMarker(sVGMap, rectangle2D.getCenterX(), rectangle2D.getCenterY(), rectangle2D.getWidth(), rectangle2D.getHeight(), string, null, -1, false, null);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(null, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        this.drawMarker(sVGMap, rectangle2D2.getCenterX(), rectangle2D2.getCenterY(), rectangle2D2.getWidth(), rectangle2D2.getHeight(), string, string2, -1, bl, string3);
        return null;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, int n2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        this.drawMarker(sVGMap, rectangle2D2.getCenterX(), rectangle2D2.getCenterY(), rectangle2D2.getWidth(), rectangle2D2.getHeight(), string, string2, n2, bl, string3);
        return null;
    }

    public void applyToSVG(SVGMap sVGMap, Shape shape, String string, Rectangle2D rectangle2D, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) {
        String string4;
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        double d2 = rectangle2D2.getCenterX();
        double d3 = rectangle2D2.getCenterY();
        double d4 = rectangle2D2.getWidth();
        double d5 = rectangle2D2.getHeight();
        int n = this.bean.getForcedWidth();
        int n2 = this.bean.getForcedHeight();
        if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
            n = ((MarkerStyleModifiers)styleModifiers).getWidth();
            n2 = ((MarkerStyleModifiers)styleModifiers).getHeight();
        }
        if (n > 0) {
            d4 = n;
        }
        if (n2 > 0) {
            d5 = n2;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string4 = sVGMap.getPredefinedId(this)) == null) {
            string4 = sVGMap.addPredefinedMarker(this);
        }
        double d6 = 7.0;
        double d7 = 7.0;
        if (this.bean.getMarkerType() == 5) {
            d6 = this.image.getWidth(null);
            d7 = this.image.getHeight(null);
        } else if (this.styColor != null) {
            d7 = this.markerShp.getBounds2D().getHeight();
            d6 = this.markerShp.getBounds2D().getWidth();
        }
        double d8 = this.bean.getRotation();
        if (styleModifiers != null && styleModifiers instanceof MarkerStyleModifiers) {
            d8 = ((MarkerStyleModifiers)styleModifiers).getOrientationAngle();
        }
        if (d8 == 0.0) {
            d8 = 0.0;
        }
        for (int i = 0; i < sVGMap.getZoomLevels(); ++i) {
            if (sVGMap.isTiny()) {
                i = -1;
            }
            double d9 = sVGMap.getScale(i);
            d4 = d6 / d9;
            d5 = d7 / d9;
            if (n > 0) {
                d4 = (double)n / d9;
            }
            if (n2 > 0) {
                d5 = (double)n2 / d9;
            }
            double d10 = d4 / this.mbr.getWidth();
            double d11 = d5 / this.mbr.getHeight();
            double d12 = d2 - (this.mbr.getX() + this.mbr.getWidth() * d10 / 2.0);
            double d13 = d3 - (this.mbr.getY() + this.mbr.getHeight() * d11 / 2.0);
            double d14 = 0.0;
            double d15 = 0.0;
            if (d8 != 0.0) {
                double d16 = Math.cos(d8);
                double d17 = Math.sin(d8);
                double d18 = d4 * d16 / 2.0 - d5 * d17 / 2.0;
                double d19 = d4 * d17 / 2.0 + d5 * d16 / 2.0;
                d14 = d18 - d4 / 2.0;
                d15 = d19 - d5 / 2.0;
            }
            sVGMap.drawPredefinedShape(string4, d2 - d4 / 2.0 - d14, d3 - d5 / 2.0 - d15, d8, (int)d4, (int)d5, d4 * 1.0 / d6, d5 * 1.0 / d6, string, string2, i, bl, string3);
            rectangle2D2 = new Rectangle2D.Double(d12 - d4 / 2.0, d13 - d5 / 2.0, d4, d5);
            if (i == -1) {
                LabelHelper.insertRectIntoRectArrays(sVGMap.getCoverLists(), rectangle2D2);
                break;
            }
            sVGMap.getCoverList(i).insert(rectangle2D2);
        }
    }

    public void setMarkerShp(Shape shape) {
        this.markerShp = shape;
    }

    public Shape getMarkerShp() {
        return this.markerShp;
    }

    public StyleColor getColorStyle() {
        return this.styColor;
    }

    public void setColorStyle(StyleColor styleColor) {
        if (styleColor.getFillColor() == null && styleColor.getStrokeColor() == null) {
            this.styColor = null;
            this.bean.setVectorFillColor(null);
            this.bean.setVectorStrokeColor(null);
        } else {
            this.styColor = styleColor;
            this.bean.setVectorFillColor(this.styColor.getFillColor());
            this.bean.setVectorStrokeColor(this.styColor.getStrokeColor());
            this.bean.setVectorStrokeWidth(this.styColor.getStrokeWidth());
        }
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.bean.getMarkerSize().isPixelUnit() && this.isPixelUnit(this.bean.getLabelFontSizeUnit()) && this.bean.getLabelOffsetSize().isPixelUnit()) {
            return null;
        }
        MarkerStyleModifiers markerStyleModifiers = new MarkerStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            SizeDefinition2D sizeDefinition2D;
            SizeDefinition2D sizeDefinition2D2 = this.bean.getMarkerSize();
            if (sizeDefinition2D2.isPixelUnit()) {
                markerStyleModifiers.setWidth((int)this.bean.getMarkerWidth());
                markerStyleModifiers.setHeight((int)this.bean.getMarkerHeight());
            }
            if (this.isPixelUnit(this.bean.getLabelFontSizeUnit())) {
                if (this.bean.getLabelFont() != null) {
                    markerStyleModifiers.setFontSize(this.bean.getLabelFont().getSize());
                } else {
                    markerStyleModifiers.setFontSize(12);
                }
            }
            if ((sizeDefinition2D = this.bean.getLabelOffsetSize()).isPixelUnit()) {
                markerStyleModifiers.setLabelOffsetX((int)this.bean.getLabelOffsetSizeX());
                markerStyleModifiers.setLabelOffsetY((int)this.bean.getLabelOffsetSizeY());
            }
        } else {
            double d;
            double d2;
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d3 = rectangle2D2.getWidth() / rectangle2D.getWidth();
            d3 = d2 = rectangle2D2.getHeight() / rectangle2D.getHeight();
            Double d4 = null;
            SizeDefinition2D sizeDefinition2D = this.bean.getMarkerSize();
            if (sizeDefinition2D.getUnit() != null) {
                d4 = SRS.getDistanceConversionFactor(sizeDefinition2D.getUnit());
            }
            if (sizeDefinition2D.isPixelUnit()) {
                markerStyleModifiers.setWidth((int)this.bean.getMarkerWidth());
                markerStyleModifiers.setHeight((int)this.bean.getMarkerHeight());
            } else if (d4 == null) {
                markerStyleModifiers.setWidth(8);
                markerStyleModifiers.setHeight(8);
            } else {
                d = this.bean.getMarkerWidth() * d4;
                double d5 = this.bean.getMarkerHeight() * d4;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    double d6 = SphereCG.convertRadius(0.0, 0.0, d);
                    markerStyleModifiers.setWidth((int)(d6 / d3 + 0.5));
                    double d7 = SphereCG.convertRadius(0.0, 0.0, d5);
                    markerStyleModifiers.setHeight((int)(d7 / d2 + 0.5));
                } else {
                    markerStyleModifiers.setWidth((int)(d / d3 + 0.5));
                    markerStyleModifiers.setHeight((int)(d5 / d2 + 0.5));
                }
            }
            if (this.isPixelUnit(this.bean.getLabelFontSizeUnit())) {
                if (this.bean.getLabelFont() != null) {
                    markerStyleModifiers.setFontSize(this.bean.getLabelFont().getSize());
                } else {
                    markerStyleModifiers.setFontSize(12);
                }
            } else {
                d = 12.0;
                d4 = null;
                if (this.bean.getLabelFontSizeUnit() != null) {
                    d4 = SRS.getDistanceConversionFactor(this.bean.getLabelFontSizeUnit());
                }
                if (this.bean.getLabelFont() != null && d4 != null) {
                    d = (double)this.bean.getLabelFont().getSize() * d4;
                    if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                        d = SphereCG.convertRadius(0.0, 0.0, d);
                        markerStyleModifiers.setFontSize((int)(d / d2 + 0.5));
                    } else {
                        markerStyleModifiers.setFontSize((int)(d / d2 + 0.5));
                    }
                } else {
                    markerStyleModifiers.setFontSize(12);
                }
            }
            SizeDefinition2D sizeDefinition2D3 = this.bean.getLabelOffsetSize();
            d4 = null;
            if (sizeDefinition2D3.getUnit() != null) {
                d4 = SRS.getDistanceConversionFactor(sizeDefinition2D3.getUnit());
            }
            if (sizeDefinition2D3.isPixelUnit()) {
                markerStyleModifiers.setLabelOffsetX((int)this.bean.getLabelOffsetSizeX());
                markerStyleModifiers.setLabelOffsetY((int)this.bean.getLabelOffsetSizeY());
            } else if (d4 == null) {
                markerStyleModifiers.setLabelOffsetX(0);
                markerStyleModifiers.setLabelOffsetY(0);
            } else {
                double d8 = this.bean.getLabelOffsetSizeX() * d4;
                double d9 = this.bean.getLabelOffsetSizeY() * d4;
                if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                    double d10 = SphereCG.convertRadius(0.0, 0.0, d8);
                    markerStyleModifiers.setLabelOffsetX((int)(d10 / d3 + 0.5));
                    double d11 = SphereCG.convertRadius(0.0, 0.0, d9);
                    markerStyleModifiers.setLabelOffsetY((int)(d11 / d2 + 0.5));
                } else {
                    markerStyleModifiers.setLabelOffsetX((int)(d8 / d3 + 0.5));
                    markerStyleModifiers.setLabelOffsetY((int)(d9 / d2 + 0.5));
                }
            }
        }
        return markerStyleModifiers;
    }

    private boolean isPixelUnit(String string) {
        return string == null || string.equalsIgnoreCase("px") || string.equalsIgnoreCase("pt");
    }
}

