/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mapviewer.share.util.SphereCG;
import oracle.sdovis.SRS;
import oracle.sdovis.SVGMap;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.style.LineStyleModifiers;
import oracle.sdovis.style.MarkerStroke;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleModifiers;
import oracle.sdovis.style.StyleNotApplicableException;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.util.ConflictResolver;
import oracle.sdovis.util.RenderingUtils;
import oracle.sdovis.util.ShapeUtil;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Node;

public class StyleLine
implements Style {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static final long serialVersionUID = -9142054770024138861L;
    LineStyleModel bean;
    transient Stroke parallelStroke = null;
    transient Stroke overallFillStroke = null;
    transient Stroke centerLineStroke = null;
    transient Stroke hashMarkStroke = null;
    transient MarkerStroke mpStroke = null;
    transient StyleMarker[] mpMarkerStyles = null;
    transient StyleMarker markerStyle = null;

    public StyleLine() {
        this.bean = new LineStyleModel();
    }

    public StyleLine(StyleModel styleModel) {
        this.setModel(styleModel);
    }

    public StyleLine(String string) throws StyleException {
        this.bean = new LineStyleModel();
        if (!this.parseLineStyles(string)) {
            throw new StyleException("Invalid line style definition.");
        }
    }

    public String getDefinition() {
        return this.bean.toXMLString();
    }

    public Object clone() {
        try {
            StyleLine styleLine = (StyleLine)super.clone();
            styleLine.setModel((StyleModel)this.bean.clone());
            return styleLine;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    private boolean parseLineStyles(String string) {
        SizeDefinition sizeDefinition;
        Object object;
        Object object2;
        String string2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string3;
        String string4;
        SizeDefinition sizeDefinition2;
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (!xMLDOMParser.parse(string)) {
            return false;
        }
        String string5 = xMLDOMParser.getAttribute("g", "cased");
        if (string5 != null && string5.length() > 0) {
            this.bean.setCased("true".equalsIgnoreCase(string5));
        }
        if ((sizeDefinition2 = StyleUtils.getStrokeWidthSize(string4 = xMLDOMParser.getAttribute("g", "style"))) != null) {
            this.bean.setLineWidth((float)sizeDefinition2.getValue());
            this.bean.setLineWidthUnit(sizeDefinition2.getUnit());
        } else {
            this.bean.setLineWidth(0.0f);
            this.bean.setLineWidthUnit(null);
        }
        String string6 = StyleUtils.getNamedString(string4, "marker-name");
        if (string6 != null) {
            this.bean.setMarkerStyleName(string6.toUpperCase());
            string3 = StyleUtils.getNamedString(string4, "marker-position");
            if (string3 != null) {
                if (string3.equalsIgnoreCase(LineStyleModel.MULTIMARKER_END_POINTS) || string3.equalsIgnoreCase(LineStyleModel.MULTIMARKER_ALL_POINTS)) {
                    this.bean.setMultipleMarkerPosition(string3);
                } else {
                    try {
                        this.bean.setMarkerPosition(Double.parseDouble(string3));
                    }
                    catch (Exception exception) {
                        this.bean.setMarkerPosition(0.75);
                    }
                    this.bean.setMultipleMarkerPosition(LineStyleModel.MULTIMARKER_ALONG_PATH);
                    object6 = StyleUtils.getNamedString(string4, "multiple-marker");
                    if (object6 != null && ((String)object6).trim().equalsIgnoreCase("true")) {
                        this.bean.setMultipleMarker(true);
                    } else {
                        this.bean.setMultipleMarker(false);
                    }
                }
            }
            if ((object6 = StyleUtils.getNamedString(string4, "marker-size")) != null) {
                object5 = SizeDefinition.parse((String)object6);
                if (object5 != null) {
                    this.bean.setMarkerWidth(((SizeDefinition)object5).getValue());
                    this.bean.setMarkerHeight(((SizeDefinition)object5).getValue());
                    this.bean.setMarkerSizeUnit(((SizeDefinition)object5).getUnit());
                } else {
                    this.bean.setMarkerWidth(-1.0);
                    this.bean.setMarkerHeight(-1.0);
                    this.bean.setMarkerSizeUnit(null);
                }
            } else {
                SizeDefinition sizeDefinition3;
                double d = -1.0;
                object4 = null;
                String string7 = StyleUtils.getNamedString(string4, "marker-width");
                if (string7 != null && (sizeDefinition3 = SizeDefinition.parse(string7)) != null) {
                    d = sizeDefinition3.getValue();
                    object4 = sizeDefinition3.getUnit();
                }
                double d2 = -1.0;
                String string8 = StyleUtils.getNamedString(string4, "marker-height");
                if (string8 != null && (object3 = SizeDefinition.parse(string8)) != null) {
                    d2 = ((SizeDefinition)object3).getValue();
                    if (object4 == null) {
                        object4 = ((SizeDefinition)object3).getUnit();
                    }
                }
                this.bean.setMarkerWidth(d);
                this.bean.setMarkerHeight(d2);
                this.bean.setMarkerSizeUnit((String)object4);
            }
        } else {
            this.bean.setMarkerStyleName(null);
        }
        string3 = null;
        object6 = xMLDOMParser.getElementNodes("line");
        if (object6 == null) {
            return false;
        }
        object5 = null;
        Node node = null;
        object4 = null;
        for (int i = 0; i < object6.getLength(); ++i) {
            Node node2 = object6.item(i);
            string3 = XMLDOMParser.getAttribute(node2, "class");
            if (string3.toUpperCase().equals("BASE")) {
                object5 = node2;
                continue;
            }
            if (string3.toUpperCase().equals("PARALLEL")) {
                node = node2;
                continue;
            }
            if (!string3.toUpperCase().equals("HASHMARK")) continue;
            object4 = node2;
        }
        if (object5 == null && node == null && object4 == null) {
            return false;
        }
        Object var12_15 = null;
        String string9 = StyleUtils.getNamedString(string4, "stroke-linecap");
        if (string9 != null) {
            if ((string9 = string9.toUpperCase()).equals("BUTT")) {
                this.bean.setCap(0);
            } else if (string9.equals("ROUND")) {
                this.bean.setCap(1);
            } else if (string9.equals("SQUARE")) {
                this.bean.setCap(2);
            }
        }
        if ((string2 = StyleUtils.getNamedString(string4, "stroke-linejoin")) != null) {
            if ((string2 = string2.toUpperCase()).equals("BEVEL")) {
                this.bean.setJoin(2);
            } else if (string2.equals("MITER")) {
                this.bean.setJoin(0);
            } else if (string2.equals("ROUND")) {
                this.bean.setJoin(1);
            }
        }
        if (object5 != null) {
            boolean bl = false;
            string3 = XMLDOMParser.getAttribute((Node)object5, "dash");
            if (string3 != null) {
                bl = true;
                object3 = Util.splitBy(string3, ",");
                object2 = null;
                if (object3 != null && ((ArrayList)object3).size() > 0) {
                    object = new float[((ArrayList)object3).size()];
                    for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                        sizeDefinition = SizeDefinition.parse((String)((ArrayList)object3).get(i));
                        object[i] = sizeDefinition != null ? (Object)((float)sizeDefinition.getValue()) : 0.0f;
                        if (sizeDefinition.getUnit() == null) continue;
                        object2 = sizeDefinition.getUnit();
                    }
                    this.bean.setCenterLineDashPattern((float[])object);
                    this.bean.setCenterLineDashPatternUnit((String)object2);
                    var12_15 = null;
                }
            }
            if ((string3 = XMLDOMParser.getAttribute((Node)object5, "phase")) != null) {
                bl = true;
                this.bean.setCenterLinePhase(Float.valueOf(string3).floatValue());
            } else {
                this.bean.setCenterLinePhase(0.0f);
            }
            string3 = XMLDOMParser.getAttribute((Node)object5, "style");
            if (string3 != null) {
                bl = true;
                object3 = StyleUtils.getStrokeWidthSize(string3);
                if (object3 == null) {
                    this.bean.setCenterLineWidth(0.0f);
                    this.bean.setCenterLineWidthUnit(null);
                } else {
                    this.bean.setCenterLineWidth((float)((SizeDefinition)object3).getValue());
                    this.bean.setCenterLineWidthUnit(((SizeDefinition)object3).getUnit());
                }
                this.bean.setCenterLineColor(StyleUtils.getColor("fill", string3));
            }
            if (this.bean.getCenterLineColor() == null) {
                this.bean.setCenterLineColor(StyleUtils.getColor("fill", string4));
            }
            if ((double)this.bean.getCenterLineWidth() == 0.0) {
                object3 = StyleUtils.getStrokeWidthSize(string4);
                if (object3 != null) {
                    this.bean.setCenterLineWidth((float)((SizeDefinition)object3).getValue());
                    this.bean.setCenterLineWidthUnit(((SizeDefinition)object3).getUnit());
                } else {
                    this.bean.setCenterLineWidth(0.0f);
                    this.bean.setCenterLineWidthUnit(null);
                }
            }
            if (bl) {
                this.centerLineStroke = new BasicStroke(this.bean.getCenterLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getCenterLineDashPattern(), this.bean.getCenterLinePhase());
            }
        } else {
            this.centerLineStroke = null;
        }
        if (node != null) {
            string3 = XMLDOMParser.getAttribute(node, "dash");
            if (string3 != null) {
                ArrayList arrayList = Util.splitBy(string3, ",");
                object3 = null;
                if (arrayList != null && arrayList.size() > 0) {
                    object2 = new float[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        SizeDefinition sizeDefinition4 = SizeDefinition.parse((String)arrayList.get(i));
                        object2[i] = sizeDefinition4 != null ? (Object)((float)sizeDefinition4.getValue()) : (Object)0.0f;
                        if (sizeDefinition4.getUnit() == null) continue;
                        object3 = sizeDefinition4.getUnit();
                    }
                    this.bean.setWingDashPattern((float[])object2);
                    this.bean.setWingDashPatternUnit((String)object3);
                    var12_15 = null;
                }
            }
            if ((string3 = XMLDOMParser.getAttribute(node, "phase")) != null) {
                this.bean.setWingPhase(Float.valueOf(string3).floatValue());
            } else {
                this.bean.setWingPhase(0.0f);
            }
            string3 = XMLDOMParser.getAttribute(node, "style");
            if (string3 != null) {
                SizeDefinition sizeDefinition5 = StyleUtils.getStrokeWidthSize(string3);
                if (sizeDefinition5 == null) {
                    this.bean.setWingWidth(0.0f);
                    this.bean.setWingWidthUnit(null);
                } else {
                    this.bean.setWingWidth((float)sizeDefinition5.getValue());
                    this.bean.setWingWidthUnit(sizeDefinition5.getUnit());
                }
                this.bean.setWingColor(StyleUtils.getColor("fill", string3));
            }
            if (this.bean.getWingColor() == null) {
                this.bean.setWingColor(StyleUtils.getColor("stroke", string4));
            }
            this.parallelStroke = new BasicStroke(this.bean.getLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        } else if (string5 != null && string5.length() > 0 && "true".equalsIgnoreCase(string5)) {
            this.setParallelLineStyle(null, 0.0f, null, 0.0f);
        }
        if (object4 != null) {
            this.bean.setHashMarkEnabled(true);
            Object var15_24 = null;
            object3 = null;
            string3 = XMLDOMParser.getAttribute((Node)object4, "dash");
            if (string3 != null) {
                object2 = Util.splitBy(string3, ",");
                if (object2 != null && ((ArrayList)object2).size() > 0) {
                    SizeDefinition sizeDefinition6;
                    object = SizeDefinition.parse((String)((ArrayList)object2).get(0));
                    if (object != null) {
                        this.bean.setHashMarkGap((float)((SizeDefinition)object).getValue());
                        if (((SizeDefinition)object).getUnit() != null) {
                            object3 = ((SizeDefinition)object).getUnit();
                        }
                    } else {
                        this.bean.setHashMarkGap(8.5f);
                    }
                    if ((sizeDefinition6 = SizeDefinition.parse((String)((ArrayList)object2).get(1))) != null) {
                        this.bean.setHashMarkLength((float)sizeDefinition6.getValue());
                        if (sizeDefinition6.getUnit() != null) {
                            object3 = sizeDefinition6.getUnit();
                        }
                    } else {
                        this.bean.setHashMarkLength(3.0f);
                    }
                    if (((ArrayList)object2).size() > 2) {
                        sizeDefinition = SizeDefinition.parse((String)((ArrayList)object2).get(2));
                        if (sizeDefinition != null) {
                            this.bean.setHashMarkWidth((float)sizeDefinition.getValue());
                            if (sizeDefinition.getUnit() != null) {
                                object3 = sizeDefinition.getUnit();
                            }
                        } else {
                            this.bean.setHashMarkWidth(1.0f);
                        }
                    }
                    var12_15 = null;
                }
                this.bean.setHashMarkUnit((String)object3);
                if (this.isPixelUnit(this.bean.getHashMarkUnit())) {
                    this.hashMarkStroke = new BasicStroke(this.bean.getHashMarkWidth());
                }
            }
            if ((string3 = XMLDOMParser.getAttribute((Node)object4, "style")) != null) {
                this.bean.setHashMarkColor(StyleUtils.getColor("fill", string3));
            }
            if (this.bean.getHashMarkColor() == null) {
                this.bean.setHashMarkColor(StyleUtils.getColor("stroke", string4));
            }
        }
        if (string4 != null) {
            float f;
            this.bean.setFillColor(StyleUtils.getColor("fill", string4));
            this.overallFillStroke = (double)this.bean.getLineWidth() >= 1.0 && this.bean.getLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getWingDashPatternUnit()) ? ((f = this.bean.getLineWidth() - this.bean.getWingWidth() * 2.0f) > 0.0f ? new BasicStroke(f, this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase()) : null) : null;
        } else {
            this.bean.setFillColor(Color.red);
        }
        Node node3 = xMLDOMParser.getElementNode("marker-pattern");
        if (node3 != null) {
            Serializable serializable;
            object3 = XMLDOMParser.getAttribute(node3, "offset");
            if (object3 != null) {
                object2 = SizeDefinition.parse((String)object3);
                if (object2 != null) {
                    this.bean.setMpStartingOffset((float)((SizeDefinition)object2).getValue());
                    this.bean.setMpStartingOffsetUnit(((SizeDefinition)object2).getUnit());
                } else {
                    this.bean.setMpStartingOffset(0.0f);
                    this.bean.setMpStartingOffsetUnit(null);
                }
            }
            if ((object3 = XMLDOMParser.getAttribute(node3, "interval")) != null) {
                object2 = SizeDefinition.parse((String)object3);
                if (object2 != null) {
                    this.bean.setMpInterval((float)((SizeDefinition)object2).getValue());
                    this.bean.setMpIntervalUnit(((SizeDefinition)object2).getUnit());
                } else {
                    this.bean.setMpInterval(5.0f);
                    this.bean.setMpIntervalUnit(null);
                }
            }
            object2 = null;
            double d = -1.0;
            object3 = XMLDOMParser.getAttribute(node3, "width");
            if (object3 != null && (sizeDefinition = SizeDefinition.parse((String)object3)) != null) {
                d = sizeDefinition.getValue();
                object2 = sizeDefinition.getUnit();
            }
            double d3 = -1.0;
            object3 = XMLDOMParser.getAttribute(node3, "height");
            if (object3 != null && (serializable = SizeDefinition.parse((String)object3)) != null) {
                d3 = ((SizeDefinition)serializable).getValue();
                object2 = ((SizeDefinition)serializable).getUnit();
            }
            this.bean.setMpMarkerSize(new SizeDefinition2D(d, d3, (String)object2));
            serializable = XMLDOMParser.getSubElements(node3, "marker");
            if (serializable == null || ((ArrayList)serializable).size() == 0) {
                throw new IllegalArgumentException("Marker pattern is missing <marker> element.");
            }
            String[] stringArray = new String[((ArrayList)serializable).size()];
            for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                Node node4 = (Node)((ArrayList)serializable).get(i);
                stringArray[i] = XMLDOMParser.getElementValue(node4);
            }
            this.bean.setMpMarkerStyles(stringArray);
        }
        return true;
    }

    private void createStrokes() {
        float f;
        if (this.bean.getLineWidth() > 0.0f && this.bean.getLineWidthSize().isPixelUnit() && this.bean.getWingWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getWingDashPatternUnit())) {
            this.parallelStroke = new BasicStroke(this.bean.getLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        }
        if (this.bean.getCenterLineWidth() > 0.0f && this.bean.getCenterLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getCenterLineDashPatternUnit())) {
            this.centerLineStroke = new BasicStroke(this.bean.getCenterLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getCenterLineDashPattern(), this.bean.getCenterLinePhase());
        }
        if (this.bean.getLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getWingWidthUnit()) && this.isPixelUnit(this.bean.getWingDashPatternUnit()) && (f = this.bean.getLineWidth() - this.bean.getWingWidth() * 2.0f) > 0.0f) {
            this.overallFillStroke = new BasicStroke(f, this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        }
        if (this.bean.getHashMarkWidth() > 0.0f && this.isPixelUnit(this.bean.getHashMarkUnit())) {
            this.hashMarkStroke = new BasicStroke(this.bean.getHashMarkWidth());
        }
    }

    public void setOverallStyle(Color color, float f, int n, int n2) {
        this.overallFillStroke = null;
        this.bean.setOverallStyle(color, f, n, n2);
    }

    public void setCenterLineStyle(Color color, float f, float[] fArray, float f2) {
        this.centerLineStroke = null;
        this.bean.setCenterLineStyle(color, f, fArray, f2);
        if (f > 0.0f) {
            this.centerLineStroke = new BasicStroke(this.bean.getCenterLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getCenterLineDashPattern(), this.bean.getCenterLinePhase());
        }
    }

    public void setParallelLineStyle(Color color, float f, float[] fArray, float f2) {
        this.parallelStroke = null;
        this.overallFillStroke = null;
        this.bean.setWingLineStyle(color, f, fArray, f2);
        if (this.bean.getLineWidth() > 0.0f) {
            this.parallelStroke = new BasicStroke(this.bean.getLineWidth(), this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
        }
    }

    private Stroke prepareFillStroke(StyleModifiers styleModifiers) {
        if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
            LineStyleModifiers lineStyleModifiers = (LineStyleModifiers)styleModifiers;
            float f = lineStyleModifiers.getLineWidth() - lineStyleModifiers.getWingWidth() * 2.0f;
            if (f > 0.0f) {
                return new BasicStroke(f, this.bean.getCap(), this.bean.getJoin(), 1.0f, lineStyleModifiers.getWingDashPattern(), lineStyleModifiers.getWingPhase());
            }
            return null;
        }
        if (this.overallFillStroke == null) {
            float f = this.bean.getLineWidth() - this.bean.getWingWidth() * 2.0f;
            if (f > 0.0f) {
                this.overallFillStroke = new BasicStroke(f, this.bean.getCap(), this.bean.getJoin(), 1.0f, this.bean.getWingDashPattern(), this.bean.getWingPhase());
                return this.overallFillStroke;
            }
            return null;
        }
        return this.overallFillStroke;
    }

    private MarkerStroke prepareMPStroke(StyleModifiers styleModifiers) {
        if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
            LineStyleModifiers lineStyleModifiers = (LineStyleModifiers)styleModifiers;
            StyleMarker[] styleMarkerArray = this.cloneMPStyles();
            if (lineStyleModifiers.getMpWidth() > 0 || lineStyleModifiers.getMpHeight() > 0) {
                for (int i = 0; i < styleMarkerArray.length; ++i) {
                    if (lineStyleModifiers.getMpWidth() > 0) {
                        styleMarkerArray[i].setDesiredWidth(lineStyleModifiers.getMpWidth());
                    }
                    if (lineStyleModifiers.getMpHeight() <= 0) continue;
                    styleMarkerArray[i].setDesiredHeight(lineStyleModifiers.getMpHeight());
                }
            }
            return new MarkerStroke(styleMarkerArray, lineStyleModifiers.getMpInterval(), lineStyleModifiers.getMpStartingOffset());
        }
        if (this.mpStroke == null) {
            StyleMarker[] styleMarkerArray = this.cloneMPStyles();
            if (this.bean.getMpMarkerWidth() > 0.0 || this.bean.getMpMarkerHeight() > 0.0) {
                for (int i = 0; i < styleMarkerArray.length; ++i) {
                    styleMarkerArray[i].setDesiredWidth((int)this.bean.getMpMarkerWidth());
                    styleMarkerArray[i].setDesiredHeight((int)this.bean.getMpMarkerHeight());
                }
            }
            this.mpStroke = new MarkerStroke(styleMarkerArray, this.bean.getMpInterval(), this.bean.getMpStartingOffset());
            return this.mpStroke;
        }
        return this.mpStroke;
    }

    private StyleMarker[] cloneMPStyles() {
        if (this.mpMarkerStyles == null) {
            return null;
        }
        StyleMarker[] styleMarkerArray = new StyleMarker[this.mpMarkerStyles.length];
        for (int i = 0; i < this.mpMarkerStyles.length; ++i) {
            styleMarkerArray[i] = (StyleMarker)this.mpMarkerStyles[i].clone();
        }
        return styleMarkerArray;
    }

    public void setHashMarkStyle(Color color, float f, float f2, float f3) {
        this.bean.setHashMarkStyle(color, f, f2, f3);
        this.hashMarkStroke = new BasicStroke(f);
    }

    public StyleMarker getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerStyle(StyleMarker styleMarker) {
        this.markerStyle = styleMarker;
    }

    public StyleMarker[] getMarkerPatternStyles() {
        return this.mpMarkerStyles;
    }

    public void setMarkerPatternStyles(StyleMarker[] styleMarkerArray) {
        this.mpMarkerStyles = styleMarkerArray;
    }

    public boolean hasParallelLine() {
        return this.parallelStroke != null;
    }

    public boolean hasCenterLine() {
        return this.centerLineStroke != null;
    }

    public boolean hasFill() {
        return this.bean.getFillColor() != null && this.bean.getLineWidth() > this.bean.getWingWidth() * 2.0f;
    }

    public boolean supportCasedLine() {
        return this.bean.isCased() && this.hasParallelLine() && this.hasFill();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createStrokes();
    }

    public StyleModel getModel() {
        return this.bean;
    }

    public void setModel(StyleModel styleModel) {
        if (!(styleModel instanceof LineStyleModel)) {
            throw new IllegalArgumentException("Not a LineStyleModel instance .");
        }
        this.bean = (LineStyleModel)styleModel;
        this.createStrokes();
    }

    public boolean resolveStyles(StyleCache styleCache, Hashtable hashtable) {
        String[] stringArray;
        boolean bl = true;
        String string = this.bean.getMarkerStyleName();
        if (string != null && this.markerStyle == null) {
            this.markerStyle = (StyleMarker)Util.getStyle(string, styleCache, hashtable);
            if (this.markerStyle == null) {
                bl = false;
            }
        }
        if ((stringArray = this.bean.getMpMarkerStyles()) != null && this.mpMarkerStyles == null) {
            this.mpMarkerStyles = new StyleMarker[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.mpMarkerStyles[i] = (StyleMarker)Util.getStyle(stringArray[i], styleCache, hashtable);
                if (this.mpMarkerStyles[i] != null) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("cannot apply LINE style to a point");
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        GeneralPath generalPath = new GeneralPath();
        float f = (float)(rectangle2D.getMinX() + 5.0);
        float f2 = (float)rectangle2D.getCenterY();
        generalPath.moveTo(f, f2);
        float f3 = (float)(rectangle2D.getMaxX() - 5.0);
        float f4 = f2;
        generalPath.lineTo(f3, f4);
        this.apply(visContext, graphics2D, (Shape)generalPath, 2, null, null, null, null, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(visContext, graphics2D, shape, n, null, null, null, null, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.casedFill1(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        this.casedFill2(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
        this.casedFill3(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void apply(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, Style style, String[] stringArray2, String string2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(visContext, graphics2D, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public void casedFill1(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        LineStyleModifiers lineStyleModifiers;
        float f;
        this.prepareFillStroke(styleModifiers);
        Stroke stroke = this.parallelStroke;
        if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers && (f = (lineStyleModifiers = (LineStyleModifiers)styleModifiers).getLineWidth()) > 0.0f) {
            stroke = new BasicStroke(f, this.bean.getCap(), this.bean.getJoin(), 1.0f, lineStyleModifiers.getWingDashPattern(), lineStyleModifiers.getWingPhase());
        }
        if (this.bean.getWingColor() != null) {
            graphics2D.setColor(this.bean.getWingColor());
        }
        if (stroke != null && this.bean.getWingColor() != null) {
            graphics2D.setStroke(stroke);
            RenderingUtils.smartDraw(shape, graphics2D, visContext);
        }
    }

    public void casedFill2(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        Stroke stroke = this.prepareFillStroke(styleModifiers);
        if (this.bean.getFillColor() != null && stroke != null) {
            graphics2D.setColor(this.bean.getFillColor());
            graphics2D.setStroke(stroke);
            RenderingUtils.smartDraw(shape, graphics2D, visContext);
        }
    }

    public void casedFill3(VisContext visContext, Graphics2D graphics2D, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        MarkerStroke markerStroke;
        block22: {
            int n2;
            int n3;
            block23: {
                Object object;
                float f;
                Stroke stroke = this.centerLineStroke;
                if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers && (f = ((LineStyleModifiers)(object = (LineStyleModifiers)styleModifiers)).getCenterLineWidth()) > 0.0f) {
                    stroke = new BasicStroke(f, this.bean.getCap(), this.bean.getJoin(), 10.0f, ((LineStyleModifiers)object).getCenterLineDashPattern(), ((LineStyleModifiers)object).getCenterLinePhase());
                }
                if (stroke != null) {
                    graphics2D.setColor(this.bean.getCenterLineColor());
                    graphics2D.setStroke(stroke);
                    RenderingUtils.smartDraw(shape, graphics2D, visContext);
                }
                object = this.hashMarkStroke;
                if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
                    LineStyleModifiers lineStyleModifiers = (LineStyleModifiers)styleModifiers;
                    object = new BasicStroke(lineStyleModifiers.getHashMarkWidth());
                }
                if (this.bean.isHashMarkEnabled() && object != null) {
                    f = this.bean.getHashMarkGap();
                    float f2 = this.bean.getHashMarkLength();
                    if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
                        f = ((LineStyleModifiers)styleModifiers).getHashMarkGap();
                        f2 = ((LineStyleModifiers)styleModifiers).getHashMarkLength();
                    }
                    graphics2D.setColor(this.bean.getHashMarkColor());
                    graphics2D.setStroke((Stroke)object);
                    ShapeUtil.drawHashmarksOnShape(graphics2D, this.bean.getHashMarkColor(), shape, f, f2);
                }
                if (this.bean.getMarkerStyleName() == null || this.markerStyle == null) break block22;
                n3 = (int)this.bean.getMarkerWidth();
                n2 = (int)this.bean.getMarkerHeight();
                if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
                    n3 = ((LineStyleModifiers)styleModifiers).getMarkerWidth();
                    n2 = ((LineStyleModifiers)styleModifiers).getMarkerHeight();
                }
                if (!this.bean.isMultipleMarker() || !this.bean.getMultipleMarkerPosition().equalsIgnoreCase(LineStyleModel.MULTIMARKER_ALL_POINTS) && !this.bean.getMultipleMarkerPosition().equalsIgnoreCase(LineStyleModel.MULTIMARKER_END_POINTS)) break block23;
                double[] dArray = ShapeUtil.lrSegmentPoints(shape);
                boolean bl = true;
                if (this.bean.getMultipleMarkerPosition().equalsIgnoreCase(LineStyleModel.MULTIMARKER_END_POINTS)) {
                    bl = false;
                }
                if (dArray == null || dArray.length <= 0) break block22;
                StyleMarker styleMarker = (StyleMarker)this.markerStyle.clone();
                if (n3 > 0) {
                    styleMarker.setDesiredWidth(n3);
                }
                if (n2 > 0) {
                    styleMarker.setDesiredHeight(n2);
                }
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                for (int i = 0; i < dArray.length / 4; ++i) {
                    Rectangle2D.Double double_;
                    if (i > 0) {
                        if (dArray[4 * i] != d3 || dArray[4 * i + 1] != d4) {
                            double_ = new Rectangle2D.Double(d3 + 0.5 - (double)(n3 / 2), d4 + 0.5 - (double)(n2 / 2), n3, n2);
                            styleMarker.apply(visContext, graphics2D, (Rectangle2D)double_, null);
                        }
                    } else {
                        d = dArray[4 * i];
                        d2 = dArray[4 * i + 1];
                    }
                    d5 = dArray[4 * i + 2] - dArray[4 * i];
                    d6 = dArray[4 * i + 3] - dArray[4 * i + 1];
                    styleMarker.setOrientation(d5, -d6, 0.0);
                    if (bl || !bl && (d3 != dArray[4 * i] || d4 != dArray[4 * i + 1])) {
                        double_ = new Rectangle2D.Double(dArray[4 * i] + 0.5 - (double)(n3 / 2), dArray[4 * i + 1] + 0.5 - (double)(n2 / 2), n3, n2);
                        styleMarker.apply(visContext, graphics2D, (Rectangle2D)double_, null);
                    }
                    d3 = dArray[4 * i + 2];
                    d4 = dArray[4 * i + 3];
                }
                if (d == d3 && d2 == d4) break block22;
                Rectangle2D.Double double_ = new Rectangle2D.Double(d3 + 0.5 - (double)(n3 / 2), d4 + 0.5 - (double)(n2 / 2), n3, n2);
                styleMarker.apply(visContext, graphics2D, (Rectangle2D)double_, null);
                break block22;
            }
            if ((double)n3 < 0.75 * ShapeUtil.lengthOf(shape)) {
                StyleMarker styleMarker = (StyleMarker)this.markerStyle.clone();
                if (n3 > 0) {
                    styleMarker.setDesiredWidth(n3);
                }
                if (n2 > 0) {
                    styleMarker.setDesiredHeight(n2);
                }
                float[] fArray = new float[2];
                for (double d = this.bean.getMarkerPosition(); d >= 0.0 && d <= 1.0; d += this.bean.getMarkerPosition()) {
                    if (ShapeUtil.lrPoint(shape, d, fArray)) {
                        double[] dArray = new double[4];
                        ShapeUtil.lrSegmentPoints(shape, d, dArray);
                        double d7 = dArray[2] - dArray[0];
                        double d8 = dArray[3] - dArray[1];
                        styleMarker.setOrientation(d7, -d8, 0.0);
                        Rectangle2D.Double double_ = new Rectangle2D.Double((double)fArray[0] + 0.5 - (double)(n3 / 2), (double)fArray[1] + 0.5 - (double)(n2 / 2), n3, n2);
                        styleMarker.apply(visContext, graphics2D, (Rectangle2D)double_, null);
                    }
                    if (!this.bean.isMultipleMarker() || d == 0.0 || d == 1.0) break;
                }
            }
        }
        if (this.bean.getMpMarkerStyles() != null && (markerStroke = this.prepareMPStroke(styleModifiers)) != null) {
            try {
                MarkerStroke.MarkerPosition[] markerPositionArray = markerStroke.placeMarkers(shape);
                markerStroke.drawMarkers(graphics2D, markerPositionArray);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void apply(VisContext visContext, SVGMap sVGMap, float f, float f2, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        throw new StyleNotApplicableException("cannot apply LINE style to a point");
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Rectangle2D rectangle2D, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        double d = rectangle2D.getCenterX();
        double d2 = rectangle2D.getCenterY();
        double d3 = rectangle2D.getWidth();
        float[] fArray = this.bean.getCenterLineDashPattern();
        float f = this.bean.getCenterLineWidth();
        if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
            fArray = ((LineStyleModifiers)styleModifiers).getCenterLineDashPattern();
            f = ((LineStyleModifiers)styleModifiers).getCenterLineWidth();
        }
        Color color = null;
        color = this.bean.getFillColor() != null ? this.bean.getFillColor() : (this.bean.getWingColor() != null ? this.bean.getWingColor() : (fArray != null ? this.bean.getCenterLineColor() : Color.black));
        sVGMap.drawLine(d - d3 / 2.0, d2, d + d3 / 2.0, d2, color, f, fArray);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.applyToSVG(null, sVGMap, shape, n, fieldArray, null, string, null, null, 0.0, false, null, styleModifiers);
    }

    public void apply(VisContext visContext, SVGMap sVGMap, Shape shape, int n, String string, Point2D point2D, ConflictResolver conflictResolver, Field[] fieldArray, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.apply(visContext, sVGMap, shape, n, string, point2D, conflictResolver, fieldArray, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        this.prepareFillStroke(styleModifiers);
        Color color = null;
        color = this.bean.getFillColor() != null ? this.bean.getFillColor() : (this.bean.getWingColor() != null ? this.bean.getWingColor() : (this.bean.getCenterLineColor() != null ? this.bean.getCenterLineColor() : Color.black));
        if (d < 0.0) {
            d = 1.0;
        }
        float f = 1.0f;
        float f2 = this.bean.getCenterLineWidth();
        float f3 = this.bean.getLineWidth();
        float[] fArray = this.bean.getCenterLineDashPattern();
        if (styleModifiers != null && styleModifiers instanceof LineStyleModifiers) {
            f2 = ((LineStyleModifiers)styleModifiers).getCenterLineWidth();
            f3 = ((LineStyleModifiers)styleModifiers).getLineWidth();
            fArray = ((LineStyleModifiers)styleModifiers).getCenterLineDashPattern();
        }
        f = this.bean.getFillColor() == null && f2 > 0.0f ? f2 : f3;
        String string4 = null;
        if (style instanceof StyleText) {
            StyleText styleText = (StyleText)style;
            string4 = sVGMap.drawLineString(shape, rectangle2D, color, f, fArray, string, styleText.getFont(), styleText.getColor(), string2, d, bl, string3);
        } else {
            string4 = sVGMap.drawLineString(shape, rectangle2D, color, f, fArray, string, null, null, string2, d, bl, string3);
        }
        return string4;
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public String applyToSVG(VisContext visContext, SVGMap sVGMap, Shape shape, int n, Field[] fieldArray, Rectangle2D rectangle2D, String string, Style style, String string2, double d, boolean bl, String string3, String[] stringArray, Style style2, String[] stringArray2, String string4, StyleModifiers styleModifiers) throws StyleNotApplicableException {
        return this.applyToSVG(null, sVGMap, shape, n, fieldArray, rectangle2D, string, style, string2, d, bl, string3, styleModifiers);
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public StyleModifiers convertToPixelSize(VisContext visContext) {
        if (this.bean.getLineWidthSize().isPixelUnit() && this.bean.getCenterLineWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getCenterLineDashPatternUnit()) && this.isPixelUnit(this.bean.getWingDashPatternUnit()) && this.bean.getWingWidthSize().isPixelUnit() && this.isPixelUnit(this.bean.getHashMarkUnit()) && this.bean.getMarkerSize2DDef().isPixelUnit() && this.bean.getMpStartingOffsetSize().isPixelUnit() && this.bean.getMpIntervalSize().isPixelUnit() && this.bean.getMpMarkerSize().isPixelUnit()) {
            return null;
        }
        LineStyleModifiers lineStyleModifiers = new LineStyleModifiers();
        if (visContext == null || Util.isFullExtent(visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMinX(), visContext.getQueryWindow().getMaxX(), visContext.getQueryWindow().getMaxY()) || visContext.getQueryWindow().getWidth() == 0.0 && visContext.getQueryWindow().getHeight() == 0.0) {
            SizeDefinition2D sizeDefinition2D;
            SizeDefinition sizeDefinition;
            SizeDefinition sizeDefinition2;
            SizeDefinition2D sizeDefinition2D2;
            int n;
            Object object;
            Object object2;
            float[] fArray;
            SizeDefinition sizeDefinition3;
            SizeDefinition sizeDefinition4 = this.bean.getLineWidthSize();
            if (sizeDefinition4.isPixelUnit()) {
                lineStyleModifiers.setLineWidth((float)sizeDefinition4.getValue());
            }
            if ((sizeDefinition3 = this.bean.getCenterLineWidthSize()).isPixelUnit()) {
                lineStyleModifiers.setCenterLineWidth((float)sizeDefinition3.getValue());
            }
            if (!sizeDefinition4.isPixelUnit() && lineStyleModifiers.getLineWidth() < lineStyleModifiers.getCenterLineWidth()) {
                lineStyleModifiers.setLineWidth(lineStyleModifiers.getCenterLineWidth() + 4.0f);
            }
            if ((fArray = this.bean.getCenterLineDashPattern()) != null && fArray.length > 0 && this.isPixelUnit((String)(object2 = this.bean.getCenterLineDashPatternUnit()))) {
                object = new float[fArray.length];
                for (n = 0; n < fArray.length; ++n) {
                    object[n] = fArray[n];
                }
                lineStyleModifiers.setCenterLineDashPattern((float[])object);
            }
            if ((fArray = this.bean.getWingDashPattern()) != null && fArray.length > 0 && this.isPixelUnit((String)(object2 = this.bean.getWingDashPatternUnit()))) {
                object = new float[fArray.length];
                for (n = 0; n < fArray.length; ++n) {
                    object[n] = fArray[n];
                }
                lineStyleModifiers.setWingDashPattern((float[])object);
            }
            if (((SizeDefinition)(object2 = this.bean.getWingWidthSize())).isPixelUnit()) {
                lineStyleModifiers.setWingWidth((float)((SizeDefinition)object2).getValue());
            } else if (((SizeDefinition)object2).getValue() != 0.0) {
                lineStyleModifiers.setWingWidth(1.0f);
            }
            lineStyleModifiers.setWingPhase(this.bean.getWingPhase());
            if (!sizeDefinition4.isPixelUnit() && lineStyleModifiers.getLineWidth() <= lineStyleModifiers.getWingWidth()) {
                lineStyleModifiers.setLineWidth(lineStyleModifiers.getWingWidth() + 4.0f);
            }
            if (this.isPixelUnit((String)(object = (Object)this.bean.getHashMarkUnit()))) {
                lineStyleModifiers.setHashMarkGap(this.bean.getHashMarkGap());
                lineStyleModifiers.setHashMarkLength(this.bean.getHashMarkLength());
                lineStyleModifiers.setHashMarkWidth(this.bean.getHashMarkWidth());
            }
            if ((sizeDefinition2D2 = this.bean.getMarkerSize2DDef()).isPixelUnit()) {
                lineStyleModifiers.setMarkerWidth((int)this.bean.getMarkerWidth());
                lineStyleModifiers.setMarkerHeight((int)this.bean.getMarkerHeight());
            }
            if ((sizeDefinition2 = this.bean.getMpStartingOffsetSize()).isPixelUnit()) {
                lineStyleModifiers.setMpStartingOffset((float)sizeDefinition2.getValue());
            }
            if ((sizeDefinition = this.bean.getMpIntervalSize()).isPixelUnit()) {
                lineStyleModifiers.setMpInterval((float)sizeDefinition.getValue());
            }
            if ((sizeDefinition2D = this.bean.getMpMarkerSize()).isPixelUnit()) {
                lineStyleModifiers.setMpWidth((int)this.bean.getMpMarkerWidth());
                lineStyleModifiers.setMpHeight((int)this.bean.getMpMarkerHeight());
            }
        } else {
            int n;
            String string;
            Object object;
            float[] fArray;
            double d;
            Rectangle2D rectangle2D = visContext.getDeviceWindow();
            Rectangle2D rectangle2D2 = visContext.getQueryWindow();
            double d2 = rectangle2D2.getWidth() / rectangle2D.getWidth();
            d2 = d = rectangle2D2.getHeight() / rectangle2D.getHeight();
            double d3 = this.getPixelValue(this.bean.getLineWidthSize(), d, visContext);
            if (d3 > 0.0) {
                lineStyleModifiers.setLineWidth((float)d3);
            }
            if ((d3 = this.getPixelValue(this.bean.getCenterLineWidthSize(), d, visContext)) > 0.0) {
                lineStyleModifiers.setCenterLineWidth((float)d3);
            }
            if ((fArray = this.bean.getCenterLineDashPattern()) != null && fArray.length > 0) {
                object = new float[fArray.length];
                string = this.bean.getCenterLineDashPatternUnit();
                if (this.isPixelUnit(string)) {
                    for (n = 0; n < fArray.length; ++n) {
                        object[n] = fArray[n];
                    }
                    lineStyleModifiers.setCenterLineDashPattern((float[])object);
                } else {
                    for (n = 0; n < fArray.length; ++n) {
                        d3 = this.getPixelValue(new SizeDefinition(fArray[n], string), d2, visContext);
                        if (!(d3 > 0.0)) continue;
                        object[n] = (float)d3;
                    }
                    lineStyleModifiers.setCenterLineDashPattern((float[])object);
                }
            }
            if ((fArray = this.bean.getWingDashPattern()) != null && fArray.length > 0) {
                object = new float[fArray.length];
                string = this.bean.getWingDashPatternUnit();
                if (this.isPixelUnit(string)) {
                    for (n = 0; n < fArray.length; ++n) {
                        object[n] = fArray[n];
                    }
                    lineStyleModifiers.setWingDashPattern((float[])object);
                } else {
                    for (n = 0; n < fArray.length; ++n) {
                        d3 = this.getPixelValue(new SizeDefinition(fArray[n], string), d2, visContext);
                        if (!(d3 > 0.0)) continue;
                        object[n] = (float)d3;
                    }
                    lineStyleModifiers.setWingDashPattern((float[])object);
                }
            }
            if ((d3 = this.getPixelValue(this.bean.getWingWidthSize(), d, visContext)) > 0.0) {
                lineStyleModifiers.setWingWidth((float)d3);
            }
            lineStyleModifiers.setWingPhase(this.bean.getWingPhase());
            object = this.bean.getHashMarkUnit();
            if (this.isPixelUnit((String)object)) {
                lineStyleModifiers.setHashMarkGap(this.bean.getHashMarkGap());
                lineStyleModifiers.setHashMarkLength(this.bean.getHashMarkLength());
                lineStyleModifiers.setHashMarkWidth(this.bean.getHashMarkWidth());
            } else {
                d3 = this.getPixelValue(new SizeDefinition(this.bean.getHashMarkGap(), (String)object), d2, visContext);
                if (d3 > 0.0) {
                    lineStyleModifiers.setHashMarkGap((float)d3);
                }
                if ((d3 = this.getPixelValue(new SizeDefinition(this.bean.getHashMarkLength(), (String)object), d, visContext)) > 0.0) {
                    lineStyleModifiers.setHashMarkLength((float)d3);
                }
                if ((d3 = this.getPixelValue(new SizeDefinition(this.bean.getHashMarkWidth(), (String)object), d2, visContext)) > 0.0) {
                    lineStyleModifiers.setHashMarkWidth((float)d3);
                }
            }
            d3 = this.getPixelValue(new SizeDefinition(this.bean.getMarkerWidth(), this.bean.getMarkerSizeUnit()), d2, visContext);
            if (d3 > 0.0) {
                lineStyleModifiers.setMarkerWidth((int)d3);
            }
            if ((d3 = this.getPixelValue(new SizeDefinition(this.bean.getMarkerHeight(), this.bean.getMarkerSizeUnit()), d, visContext)) > 0.0) {
                lineStyleModifiers.setMarkerHeight((int)d3);
            }
            if ((d3 = this.getPixelValue(this.bean.getMpStartingOffsetSize(), d2, visContext)) > 0.0) {
                lineStyleModifiers.setMpStartingOffset((float)d3);
            }
            if ((d3 = this.getPixelValue(this.bean.getMpIntervalSize(), d2, visContext)) > 0.0) {
                lineStyleModifiers.setMpInterval((float)d3);
            }
            if ((d3 = this.getPixelValue(new SizeDefinition(this.bean.getMpMarkerWidth(), this.bean.getMpMarkerUnit()), d2, visContext)) > 0.0) {
                lineStyleModifiers.setMpWidth((int)d3);
            }
            if ((d3 = this.getPixelValue(new SizeDefinition(this.bean.getMpMarkerHeight(), this.bean.getMpMarkerUnit()), d, visContext)) > 0.0) {
                lineStyleModifiers.setMpHeight((int)d3);
            }
        }
        return lineStyleModifiers;
    }

    private double getPixelValue(SizeDefinition sizeDefinition, double d, VisContext visContext) {
        Double d2 = null;
        if (sizeDefinition.getUnit() != null) {
            d2 = SRS.getDistanceConversionFactor(sizeDefinition.getUnit());
        }
        if (sizeDefinition.isPixelUnit()) {
            return sizeDefinition.getValue();
        }
        if (d2 != null) {
            double d3 = sizeDefinition.getValue() * d2;
            if (visContext.getSrs() != null && visContext.getSrs().isGeodetic()) {
                double d4 = SphereCG.convertRadius(0.0, 0.0, d3);
                return d4 / d + 0.5;
            }
            return d3 / d + 0.5;
        }
        return 0.0;
    }

    private boolean isPixelUnit(String string) {
        return string == null || string.equalsIgnoreCase("px") || string.equalsIgnoreCase("pt");
    }
}

