/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.util.Vector;
import oracle.sdovis.style.StyleMarker;

public class MarkerStroke {
    private StyleMarker[] markers;
    private float internalGap;
    private float startingOffset;
    private float offset;
    private static float DEFAULT_WIDTH = 9.0f;

    public MarkerStroke(StyleMarker styleMarker) {
        this(new StyleMarker[]{styleMarker}, 0.0f, 0.0f);
    }

    public MarkerStroke(StyleMarker[] styleMarkerArray, float f, float f2) {
        if (styleMarkerArray == null) {
            throw new IllegalArgumentException("Marker styles cannot be null.");
        }
        this.internalGap = f;
        this.startingOffset = f2;
        this.markers = new StyleMarker[styleMarkerArray.length];
        this.offset = 0.0f;
        for (int i = 0; i < styleMarkerArray.length; ++i) {
            this.markers[i] = styleMarkerArray[i];
            float f3 = styleMarkerArray[i].getDesiredWidth();
            if (f3 <= 0.0f) {
                f3 = DEFAULT_WIDTH;
            }
            this.offset += f3;
            this.offset += f;
        }
    }

    public MarkerPosition[] placeMarkers(Shape shape) {
        Vector<MarkerPosition> vector = new Vector<MarkerPosition>();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float[] fArray = new float[6];
        int n = 0;
        float f7 = 0.0f;
        int n2 = 0;
        int n3 = this.markers.length;
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        while (n2 < n3 && !flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    f7 = this.startingOffset;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    f5 = fArray[0];
                    f6 = fArray[1];
                    float f8 = f5 - f3;
                    float f9 = f6 - f4;
                    float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                    if (f10 >= f7) {
                        float f11 = 1.0f / f10;
                        float f12 = (float)Math.atan2(f9, f8);
                        while (n2 < n3 && f10 >= f7) {
                            float f13 = f3 + f7 * f8 * f11;
                            float f14 = f4 + f7 * f9 * f11;
                            MarkerPosition markerPosition = new MarkerPosition();
                            markerPosition.marker = this.markers[n2];
                            markerPosition.x = f13;
                            markerPosition.y = f14;
                            markerPosition.angle = f12;
                            markerPosition.drawPercentage = 100.0f;
                            vector.add(markerPosition);
                            f7 += (float)(markerPosition.marker.getDesiredWidth() / 2);
                            f7 += this.internalGap;
                            ++n2;
                            f7 += (float)(this.markers[n2 %= n3].getDesiredWidth() / 2);
                        }
                    }
                    f7 -= f10;
                    f3 = f5;
                    f4 = f6;
                }
            }
            flatteningPathIterator.next();
        }
        return vector.toArray(new MarkerPosition[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawMarkers(Graphics2D graphics2D, MarkerPosition[] markerPositionArray) {
        try {
            try {
                for (int i = 0; i < markerPositionArray.length; ++i) {
                    MarkerPosition markerPosition = markerPositionArray[i];
                    StyleMarker styleMarker = markerPosition.marker;
                    styleMarker.setOrientation(markerPosition.angle);
                    styleMarker.apply(null, graphics2D, markerPosition.x, markerPosition.y, null);
                }
                Object var7_7 = null;
            }
            catch (Exception exception) {
                Object var7_8 = null;
                for (int i = 0; i < this.markers.length; ++i) {
                    StyleMarker styleMarker = this.markers[i];
                    styleMarker.resetOrientation();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            int i = 0;
            while (true) {
                if (i >= this.markers.length) {
                    throw throwable;
                }
                StyleMarker styleMarker = this.markers[i];
                styleMarker.resetOrientation();
                ++i;
            }
        }
        for (int i = 0; i < this.markers.length; ++i) {
            StyleMarker styleMarker = this.markers[i];
            styleMarker.resetOrientation();
        }
    }

    public static class MarkerPosition {
        StyleMarker marker;
        float x;
        float y;
        float angle;
        float drawPercentage;
    }
}

