/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.style;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.ds.DataSourceI;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleTable;
import oracle.sdovis.util.Util;

public class AllStyleTable
extends StyleTable
implements StyleStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    String mOwner = null;
    String mName = null;
    int mType = 0;
    String mDescription = null;
    StringBuffer mSVGData = null;
    byte[] mImageData = null;
    JSDOGeometry mGeometry = null;
    Hashtable stylesNotFound = null;
    private Clob mCLOBSVG;
    private Blob mBLOBImage;

    public int getType() {
        return this.mType;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getName() {
        return this.mName;
    }

    public String getLogin() {
        return this.mUser;
    }

    public StringBuffer getDefinition() {
        return this.mSVGData;
    }

    public byte[] getImageData() {
        return this.mImageData;
    }

    public JSDOGeometry getGeometry() {
        return this.mGeometry;
    }

    public AllStyleTable(String string, String string2) throws SQLException {
        super(string, "ALL_SDO_STYLES");
    }

    public Style getStyleObject(String string) throws DataException {
        if (string == null) {
            return null;
        }
        String string2 = this.mUser;
        if (string.indexOf(58) > 0) {
            int n = string.indexOf(58);
            string2 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
            return this.getStyleObject(string, string2, false);
        }
        return this.getStyleObject(string, string2, true);
    }

    public Style getStyleObject(String string, String string2, boolean bl) throws DataException {
        Object object;
        String string3;
        if (string == null) {
            return null;
        }
        if (!this.shouldQueryTheStyle(string, string2)) {
            return null;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(this.mDataSource, null);
            string3 = string2;
            if (bl && (string3 = Util.getCurrentSchema(connection, null)) == null) {
                string3 = string2;
            }
            object = "select * from all_sdo_styles where name=? and owner=?";
            statement = connection.prepareStatement((String)object);
            statement.setString(1, string.toUpperCase());
            statement.setString(2, string3.toUpperCase());
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                log.warning("Cannot find style named " + string + " of " + string3 + " in all_sdo_styles");
                if (this.stylesNotFound == null) {
                    this.stylesNotFound = new Hashtable();
                }
                this.recordMissingEntry(string, string3);
                Style style = null;
                return style;
            }
            this.removeFromStylesNotFound(string, string3);
            this.updateLocalData(resultSet);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DataException(sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        string3 = this.mDescription;
        object = StyleFactory.createStyleObject(this.mType, this.getDefinition().toString(), this.mImageData);
        if (object != null) {
            object.getModel().setDescription(string3);
        }
        return object;
    }

    public TruetypeFont getTTFont(String string) throws DataException {
        if (string == null) {
            return null;
        }
        String string2 = this.mUser;
        Object var3_3 = null;
        if (string.indexOf(58) > 0) {
            int n = string.indexOf(58);
            string2 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
        }
        return this.getTTFont(string, string2);
    }

    public TruetypeFont getTTFont(String string, String string2) throws DataException {
        Object object;
        if (string == null || string2 == null) {
            return null;
        }
        if (!this.shouldQueryTheStyle(string, string2)) {
            return null;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = "select * from all_sdo_styles where name=? and type='TTF' and owner=?";
            connection = DSUtil.getDBConnection(this.mDataSource, null);
            statement = connection.prepareStatement((String)object);
            statement.setString(1, string.toUpperCase());
            statement.setString(2, string2.toUpperCase());
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                log.warning("Cannot find TTF font named " + string + " of " + string2 + " in " + this.mTableName);
                this.recordMissingEntry(string, string2);
                TruetypeFont truetypeFont = null;
                return truetypeFont;
            }
            this.removeFromStylesNotFound(string, string2);
            this.updateLocalData(resultSet);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            throw new DataException(sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        object = new TruetypeFont();
        ((TruetypeFont)object).setName(this.mName);
        ((TruetypeFont)object).setDescription(this.mDescription);
        ((TruetypeFont)object).setFontData(this.mImageData);
        Font font = null;
        try {
            String string3;
            DataSourceI dataSourceI;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mImageData);
            font = Font.createFont(0, byteArrayInputStream);
            ((TruetypeFont)object).setFont(font);
            if (this.mDataSource != null && (dataSourceI = DSManager.get(this.mDataSource)) != null && (string3 = dataSourceI.getTemporaryDirectory()) != null) {
                String string4 = this.mDataSource + "_" + string2 + "_-_";
                String string5 = font.getFontName().replaceAll(" ", "-_-");
                string4 = string3 + string4.toLowerCase() + string5 + ".ttf";
                try {
                    File file = new File(string4);
                    if (!file.exists()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(string4);
                        fileOutputStream.write(this.mImageData);
                        fileOutputStream.close();
                        log.finest("TTF file [" + string5 + "] has been saved on temporary directory [" + string3 + "]");
                    }
                }
                catch (Exception exception) {
                    log.warning("Unable to write temporary TTF file [" + string4 + "]");
                    log.warning(exception.getMessage());
                }
            }
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new DataException(exception.getCause());
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void updateLocalData(ResultSet resultSet) throws SQLException {
        this.mName = resultSet.getString("NAME");
        this.mOwner = resultSet.getString("OWNER");
        String string = resultSet.getString("TYPE");
        this.mType = StyleUtils.getTypeCodeFromName(string);
        this.mDescription = resultSet.getString("DESCRIPTION");
        this.mCLOBSVG = resultSet.getClob("DEFINITION");
        this.mBLOBImage = resultSet.getBlob("IMAGE");
        try {
            this.mSVGData = new StringBuffer(this.mCLOBSVG.getSubString(1L, (int)this.mCLOBSVG.length()));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.mSVGData = null;
        }
        if (this.mBLOBImage == null) {
            this.mImageData = null;
            return;
        }
        try {
            if (this.mBLOBImage.length() < 5L) {
                this.mImageData = null;
                return;
            }
            this.mImageData = this.mBLOBImage.getBytes(1L, (int)this.mBLOBImage.length());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.mImageData = null;
        }
    }

    protected void updateLocalData() throws SQLException {
        this.updateLocalData(this.mResultSet);
    }

    public int update() throws SQLException {
        throw new SQLException("update not supported on ALL_SDO_STYLES");
    }

    public int insert() throws SQLException {
        throw new SQLException("insert not supported on ALL_SDO_STYLES");
    }

    public int delete() throws SQLException {
        throw new SQLException("delete not supported on ALL_SDO_STYLES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getStyleNames(String string) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = DSUtil.getDBConnection(this.mDataSource, null);
            if (connection == null) {
                ArrayList<String> arrayList3 = arrayList2;
                return arrayList3;
            }
            arrayList2 = new ArrayList<String>();
            String string2 = this.mUser;
            String string3 = "select name from all_sdo_styles where owner=? order by name";
            String string4 = "select name from all_sdo_styles where owner=? and type=? order by name";
            String string5 = string == null ? string3 : string4;
            statement = connection.prepareStatement(string5);
            statement.setString(1, string2);
            if (string != null) {
                statement.setString(2, string);
            }
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString(1));
            }
            arrayList = arrayList2;
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            ArrayList<String> arrayList4 = arrayList2;
            return arrayList4;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                log.severe(sQLException.getMessage());
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                log.severe(sQLException.getMessage());
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return arrayList;
    }

    public StyleRowData getStyleData(String string) throws DataException {
        if (string == null) {
            return null;
        }
        String string2 = this.mUser;
        if (string.indexOf(58) > 0) {
            int n = string.indexOf(58);
            string2 = string.substring(0, n);
            string = string.substring(n + 1, string.length());
            return this.getStyleData(string, string2, false);
        }
        return this.getStyleData(string, string2, true);
    }

    public StyleRowData getStyleData(String string, String string2, boolean bl) throws DataException {
        StyleRowData styleRowData;
        if (string == null) {
            return null;
        }
        if (!this.shouldQueryTheStyle(string, string2)) {
            return null;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DSUtil.getDBConnection(this.mDataSource, null);
            String string3 = string2;
            if (bl && (string3 = Util.getCurrentSchema(connection, null)) == null) {
                string3 = string2;
            }
            String string4 = "select * from all_sdo_styles where name=? and owner=?";
            statement = connection.prepareStatement(string4);
            statement.setString(1, string.toUpperCase());
            statement.setString(2, string3.toUpperCase());
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                log.warning("Cannot find style named " + string + " of " + string3 + " in all_sdo_styles");
                this.recordMissingEntry(string, string3);
                StyleRowData styleRowData2 = null;
                return styleRowData2;
            }
            this.removeFromStylesNotFound(string, string3);
            this.updateLocalData(resultSet);
            StyleRowData styleRowData3 = new StyleRowData();
            styleRowData3.name = this.mName;
            styleRowData3.description = this.mDescription;
            styleRowData3.definition = this.mSVGData.toString();
            styleRowData3.geometry = this.mGeometry;
            styleRowData3.image = this.mImageData;
            styleRowData = styleRowData3;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new DataException(sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return styleRowData;
    }

    private String getKey(String string, String string2) {
        return string2 == null ? string.toLowerCase() : string2.toLowerCase() + "__" + string.toLowerCase();
    }

    private boolean shouldQueryTheStyle(String string, String string2) {
        if (this.stylesNotFound == null) {
            return true;
        }
        long l = System.currentTimeMillis();
        String string3 = this.getKey(string, string2);
        Object v = this.stylesNotFound.get(string3);
        if (v == null) {
            return true;
        }
        MissingStyleEntry missingStyleEntry = (MissingStyleEntry)v;
        long l2 = missingStyleEntry.lastAttempt;
        if (l - l2 > 60000L) {
            return true;
        }
        missingStyleEntry.lastAttempt = l;
        return false;
    }

    private void recordMissingEntry(String string, String string2) {
        long l = System.currentTimeMillis();
        String string3 = this.getKey(string, string2);
        MissingStyleEntry missingStyleEntry = new MissingStyleEntry(l);
        this.stylesNotFound.put(string3, missingStyleEntry);
    }

    private void removeFromStylesNotFound(String string, String string2) {
        if (this.stylesNotFound != null) {
            String string3 = this.getKey(string, string2);
            this.stylesNotFound.remove(string3);
        }
    }

    class MissingStyleEntry {
        long lastAttempt;

        public MissingStyleEntry(long l) {
            this.lastAttempt = l;
        }
    }
}

