/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Hit;
import oracle.sdovis.raytracing.Material;
import oracle.sdovis.raytracing.Object3d;
import oracle.sdovis.raytracing.Ray;

public class Sphere
extends Object3d {
    Vector3d center;
    double radius;
    Vector3d normal;

    public Sphere(Vector3d vector3d, double d, Material material) {
        super(material);
        this.center = vector3d;
        this.radius = d;
        this.origin = this.center;
    }

    public Vector3d getTextureCoordinates(Hit hit, Ray ray) {
        Vector3d vector3d = ray.getOrigin();
        Vector3d vector3d2 = ray.getDirection();
        double d = vector3d.x + vector3d2.x * hit.getT();
        double d2 = vector3d.y + vector3d2.y * hit.getT();
        double d3 = vector3d.z + vector3d2.z * hit.getT();
        Vector3d vector3d3 = new Vector3d(d, d2, d3);
        double d4 = Math.acos((d3 - this.center.z) / this.radius);
        double d5 = Math.atan2(d2 - this.center.y, d - this.center.x);
        if (d5 < 0.0) {
            d5 += Math.PI * 2;
        }
        double d6 = d5 / (Math.PI * 2);
        double d7 = (Math.PI - d4) / Math.PI;
        return new Vector3d(d6, d7, 0.0);
    }

    public boolean intersectGeometric(Ray ray, Hit hit, double d) {
        double d2;
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)this.center, (Tuple3d)ray.getOrigin());
        double d3 = vector3d.length();
        double d4 = Math.pow(d3, 2.0);
        double d5 = Math.pow(this.radius, 2.0);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d4 == d5) {
            return false;
        }
        if (d4 > d5) {
            d6 = vector3d.dot(ray.getDirection());
            if (d6 < 0.0) {
                return false;
            }
            d2 = d4 - Math.pow(d6, 2.0);
            if (d2 > d5) {
                return false;
            }
            double d8 = d5 - d2;
            double d9 = Math.sqrt(d8);
            d7 = d6 - d9;
        } else if (d4 < d5) {
            d6 = vector3d.dot(ray.getDirection());
            d2 = Math.pow(d6, 2.0) - d4;
            double d10 = d5 - d2;
            double d11 = Math.sqrt(d10);
            d7 = d6 + d11;
        }
        if (d7 < d) {
            return false;
        }
        d2 = hit.getT();
        if (d7 < d2) {
            hit.set(d7, this.getMaterial());
        }
        return true;
    }

    public boolean intersect(Ray ray, Hit hit, double d) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)ray.getOrigin(), (Tuple3d)this.center);
        double d2 = ray.getDirection().dot(ray.getDirection());
        double d3 = 2.0 * ray.getDirection().dot(vector3d);
        double d4 = vector3d.dot(vector3d) - Math.pow(this.radius, 2.0);
        double d5 = d3 * d3 - 4.0 * d2 * d4;
        double d6 = 0.0;
        if (d5 < 0.0) {
            return false;
        }
        if (d5 == 0.0) {
            d6 = -d3 / 2.0 * d2;
        } else if (d5 > 0.0 && (d6 = (-d3 - Math.sqrt(d5)) / (2.0 * d2)) < 0.0 && (d6 = (-d3 + Math.sqrt(d5)) / (2.0 * d2)) < d) {
            return false;
        }
        if (d6 < d) {
            return false;
        }
        double d7 = hit.getT();
        if (d6 < d7) {
            hit.set(d6, this.getMaterial(), this.calcNormal(d6, ray));
        }
        return true;
    }

    public Vector3d calcNormal(double d, Ray ray) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d(ray.getDirection());
        vector3d2.scale(d);
        vector3d.add((Tuple3d)ray.getOrigin(), (Tuple3d)vector3d2);
        this.normal = new Vector3d();
        this.normal.sub((Tuple3d)vector3d, (Tuple3d)this.center);
        this.normal.scale(2.0);
        return this.normal;
    }
}

