/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.raytracing;

import javax.vecmath.Point2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import oracle.sdovis.raytracing.Camera;
import oracle.sdovis.raytracing.Ray;

public class PerspectiveCamera
implements Camera {
    private Vector3d center;
    private Vector3d proj;
    private Vector3d up;
    private Vector3d horiz;
    private double angle;
    private double focus;
    private double size;

    public Vector3d getHoriz() {
        return this.horiz;
    }

    public Vector3d getUp() {
        return this.up;
    }

    public PerspectiveCamera(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d) {
        this.center = vector3d;
        this.proj = vector3d2;
        this.proj.normalize();
        this.up = vector3d3;
        this.up.normalize();
        this.horiz = new Vector3d();
        this.horiz.cross(this.proj, this.up);
        this.horiz.normalize();
        this.up.cross(this.horiz, this.proj);
        this.up.normalize();
        this.angle = d;
        this.size = 2.0 * Math.tan(this.angle / 2.0);
    }

    public Ray generateRay(Point2d point2d) {
        Vector3d vector3d = new Vector3d();
        vector3d.scale((point2d.x - 0.5) * this.size, (Tuple3d)this.horiz);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.scale((point2d.y - 0.5) * this.size, (Tuple3d)this.up);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.add((Tuple3d)vector3d, (Tuple3d)vector3d2);
        vector3d3.add((Tuple3d)this.proj);
        vector3d3.normalize();
        Ray ray = new Ray(vector3d3, this.center);
        return ray;
    }
}

