/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.query.SpatialOp;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class SDOFilter
implements SpatialOp {
    protected String dataSource;
    protected String targetGeometryColumn;
    protected JGeometry filterGeometry;
    protected double minResolution = Double.NaN;
    protected double maxResolution = Double.NaN;

    public SDOFilter(String string, String string2) {
        this.dataSource = string;
        this.targetGeometryColumn = string2;
    }

    public void setOperationGeometry(JGeometry jGeometry) {
        this.filterGeometry = jGeometry;
    }

    public JGeometry getOperationGeometry() {
        return this.filterGeometry;
    }

    public int getSrid() {
        return this.filterGeometry != null ? this.filterGeometry.getSRID() : 0;
    }

    public void prepare(PreparedStatement preparedStatement) throws SQLException {
        STRUCT sTRUCT = null;
        Connection connection = preparedStatement.getConnection();
        Object[] objectArray = Util.createDBGeomDescriptors(connection);
        sTRUCT = JGeometry.store((JGeometry)this.filterGeometry, (Connection)connection, (Object[])objectArray);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)preparedStatement;
        oraclePreparedStatement.setObjectAtName("svqfilterg", (Object)sTRUCT);
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (abstractDBDataSource == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        if (!abstractDBDataSource.is9i() && !abstractDBDataSource.isPre9i()) {
            if (!Double.isNaN(this.minResolution)) {
                oraclePreparedStatement.setDoubleAtName("svqminres", this.minResolution);
            }
            if (!Double.isNaN(this.maxResolution)) {
                oraclePreparedStatement.setDoubleAtName("svqmaxres", this.maxResolution);
            }
        }
    }

    public String getSpatialPredicate() {
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.dataSource);
        if (abstractDBDataSource == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        if (abstractDBDataSource.is9i() || abstractDBDataSource.isPre9i()) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + "'querytype=WINDOW'" + ") = 'TRUE'");
        } else if (Double.isNaN(this.minResolution) && Double.isNaN(this.maxResolution)) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + this.targetGeometryColumn + ", " + ":svqfilterg" + ") = 'TRUE'");
        } else {
            String string;
            String string2 = string = Double.isNaN(this.minResolution) ? "" : "min_resolution=:svqminres";
            String string3 = Double.isNaN(this.maxResolution) ? "" : (Double.isNaN(this.minResolution) ? "max_resolution=:svqmaxres" : " max_resolution=:svqmaxres");
            String string4 = "'" + string + string3 + "'";
            stringBuffer.append("MDSYS.SDO_FILTER(" + this.targetGeometryColumn + ", " + ":svqfilterg, " + string4 + ") = 'TRUE'");
        }
        return stringBuffer.toString();
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setTargetGeometryColumn(String string) {
        this.targetGeometryColumn = string;
    }

    public String getTargetGeometryColumn() {
        return this.targetGeometryColumn;
    }

    public void setMinResoultion(double d) {
        this.minResolution = d;
    }

    public double getMinResoultion() {
        return this.minResolution;
    }

    public void setMaxResoultion(double d) {
        this.maxResolution = d;
    }

    public double getMaxResoultion() {
        return this.maxResolution;
    }

    public int getNumBindingVariables() {
        return SDOFilter.getNumBindingVariables(this.dataSource, this.minResolution, this.maxResolution);
    }

    public static int getNumBindingVariables(String string, double d, double d2) {
        AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(string);
        if (abstractDBDataSource == null) {
            throw new IllegalArgumentException("invalid data source.");
        }
        if (abstractDBDataSource.is9i() || abstractDBDataSource.isPre9i()) {
            return 1;
        }
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return 1;
        }
        int n = 0;
        if (!Double.isNaN(d)) {
            ++n;
        }
        if (!Double.isNaN(d2)) {
            // empty if block
        }
        int n2 = ++n;
        ++n;
        return n2;
    }
}

