/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.georss;

import java.util.ArrayList;
import java.util.List;
import oracle.mapviewer.share.Field;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.StyledFeature;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.georss.GeoFeedParser;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtomParser
extends GeoFeedParser {
    private Document doc;
    private String dataSrc;

    public AtomParser(String string) {
        this.dataSrc = string;
    }

    public StyledFeatureI[] parse(Document document) throws Exception {
        this.doc = document;
        ArrayList<StyledFeatureI> arrayList = new ArrayList<StyledFeatureI>();
        this.parseRoot(arrayList);
        NodeList nodeList = this.doc.getElementsByTagName("entry");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            StyledFeatureI styledFeatureI = this.extractFeature(node);
            if (styledFeatureI == null) continue;
            arrayList.add(styledFeatureI);
        }
        return arrayList.toArray(new StyledFeatureI[arrayList.size()]);
    }

    protected void parseRoot(List list) {
        NodeList nodeList = this.doc.getElementsByTagName("feed");
        if (nodeList == null) {
            return;
        }
        Node node = nodeList.item(0);
        StyledFeatureI styledFeatureI = this.extractFeature(node);
        if (styledFeatureI != null) {
            list.add(styledFeatureI);
        }
    }

    protected StyledFeatureI extractFeature(Node node) {
        Field field;
        JSDOGeometry jSDOGeometry;
        StyledFeature styledFeature = null;
        String string = null;
        Node node2 = XMLDOMParser.getSubElement(node, "title");
        if (node2 != null) {
            string = XMLDOMParser.getElementValue(node2);
        }
        String string2 = null;
        Node node3 = XMLDOMParser.getSubElement(node, "id");
        if (node3 != null) {
            string2 = XMLDOMParser.getElementValue(node3);
        }
        String string3 = null;
        Node node4 = XMLDOMParser.getSubElement(node, "updated");
        if (node4 != null) {
            string3 = XMLDOMParser.getElementValue(node4);
        }
        String string4 = null;
        Node node5 = XMLDOMParser.getSubElement(node, "summary");
        if (node5 != null) {
            string4 = XMLDOMParser.getElementValue(node5);
        }
        String string5 = null;
        Node node6 = XMLDOMParser.getSubElement(node, "content");
        if (node6 != null) {
            string5 = XMLDOMParser.getElementValue(node6);
        }
        String string6 = null;
        Node node7 = XMLDOMParser.getSubElement(node, "link");
        if (node7 != null) {
            string6 = XMLDOMParser.getElementValue(node7);
        }
        if ((jSDOGeometry = AtomParser.extractLocation(node)) == null) {
            return null;
        }
        styledFeature = new StyledFeature();
        styledFeature.setLabel(string2);
        ArrayList<Field> arrayList = new ArrayList<Field>(5);
        if (string2 != null) {
            field = new Field(string2);
            field.setNameAndKey("Id", true, "Id");
            arrayList.add(field);
        }
        if (string != null) {
            field = new Field(string);
            field.setNameAndKey("Title", false, "Title");
            arrayList.add(field);
        }
        if (string3 != null) {
            field = new Field(string3);
            field.setNameAndKey("Updated", false, "Updated");
            arrayList.add(field);
        }
        if (string4 != null) {
            field = new Field(string4);
            field.setNameAndKey("Summary", false, "Summary");
            arrayList.add(field);
        } else if (string5 != null) {
            field = new Field(string5);
            field.setNameAndKey("Content", false, "Content");
            arrayList.add(field);
        } else if (string6 != null) {
            field = new Field(string6);
            field.setNameAndKey("Link", false, "Link");
            arrayList.add(field);
        }
        styledFeature.setDataSource(this.dataSrc);
        styledFeature.setGeometry(jSDOGeometry);
        styledFeature.setIdentifiableAttributes(arrayList.toArray(new Field[arrayList.size()]));
        return styledFeature;
    }
}

