/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleDataSource;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.Util;

public class NativeOracleDataSource
extends AbstractDBDataSource {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final int ODS_MAXIMUM_OPEN_CONNECTION_LIMIT = 100;
    private OracleDataSource ds;
    private String tnsName;
    private String host;
    private String port;
    private String sid;
    private String user;
    private String passwd;
    private String mode;
    private int maxConnections;
    private static boolean monitoring = false;
    private static int monitoringInterval = 5;
    private MonitorThread monitoringThread = null;

    public NativeOracleDataSource(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n) {
        if (string2 == null && (string3 == null || string4 == null || string5 == null || string6 == null || string7 == null)) {
            throw new IllegalArgumentException("Illegal arguments in new NativeOracleDataSource.");
        }
        try {
            Object object;
            Object object2;
            this.ds = new OracleDataSource();
            this.ds.setConnectionCachingEnabled(true);
            this.ds.setConnectionCacheName(string + "_conncache");
            if (string2 != null) {
                this.ds.setURL("jdbc:oracle:oci8:@" + string2);
            } else {
                object2 = null;
                object = Util.getConnStr(string8, string3, string4, string5);
                try {
                    if (!DriverManager.getDrivers().hasMoreElements()) {
                        DriverManager.registerDriver((Driver)new OracleDriver());
                    }
                    object2 = DriverManager.getConnection((String)object, string6, string7);
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, exception.getMessage(), exception);
                    log.warning("connecting to database using jdbc thin driver...");
                    object = Util.getConnStr("thin", string3, string4, string5);
                    try {
                        if (!DriverManager.getDrivers().hasMoreElements()) {
                            DriverManager.registerDriver((Driver)new OracleDriver());
                        }
                        object2 = DriverManager.getConnection((String)object, string6, string7);
                        string8 = "thin";
                    }
                    catch (SQLException sQLException) {
                        log.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                        throw sQLException;
                    }
                }
                try {
                    object2.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.ds.setURL((String)object);
            }
            this.ds.setUser(string6);
            this.ds.setPassword(string7);
            object2 = new Properties();
            if (n > 0) {
                ((Properties)object2).setProperty("MaxLimit", "" + n);
            } else {
                ((Properties)object2).setProperty("MaxLimit", "100");
            }
            ((Properties)object2).setProperty("InactivityTimeout", "2700");
            ((Properties)object2).setProperty("ConnectionWaitTimeout", "" + DSManager.getConnectionWaitTimeout());
            ((Properties)object2).setProperty("ValidateConnection", "true");
            this.ds.setConnectionCacheProperties((Properties)object2);
            this.name = string;
            if (string2 != null) {
                this.tnsName = string2;
            } else {
                this.host = string3;
                this.port = string4;
                this.sid = string5;
                this.user = string6;
                this.passwd = string7;
                this.mode = string8;
            }
            this.closed = false;
            object = this.ds.getConnection();
            this.dbProductVersion = Util.getDBVersion((Connection)object);
            this.is9i = Util.is9i((Connection)object);
            this.pre9i = Util.isPre9i((Connection)object);
            this.tenG = Util.is10g((Connection)object);
            DSUtil.createArrayTypes((Connection)object, string);
            object.close();
            if (monitoring) {
                log.info("Starting monitoring thread on data source " + string + "...");
                this.monitoringThread = new MonitorThread();
                this.monitoringThread.start();
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            throw new IllegalArgumentException("Error creating NativeOracleDataSource.");
        }
    }

    public boolean matches(String string, String string2, String string3, String string4, String string5, String string6) {
        boolean bl = this.host != null && this.host.equalsIgnoreCase(string) && this.port != null && this.port.equalsIgnoreCase(string2) && this.sid != null && this.sid.equalsIgnoreCase(string3) && this.user != null && this.user.equalsIgnoreCase(string4) && this.passwd != null && this.passwd.equals(string5);
        return bl;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.ds.getConnection();
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.ds.getConnection(string, string2);
    }

    public Connection getProxyConnection(String string, Properties properties) throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.ds.getConnection();
        int n = 1;
        if ("DISTINGUISHED_NAME".equals(string)) {
            n = 2;
        }
        oracleConnection.openProxySession(n, properties);
        return oracleConnection;
    }

    public void close() {
        try {
            log.info("Closing connection cache:" + this.ds.getConnectionCacheName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ds.close();
            this.closed = true;
            this.ds = null;
            if (this.monitoringThread != null) {
                this.monitoringThread.stopIt();
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public boolean supportOLS() {
        return false;
    }

    public DataSource getUnwrappedDataSource() {
        return this.ds;
    }

    public OracleDataSource getOracleDataSource() {
        return this.ds;
    }

    public String report() {
        if (this.ds == null) {
            return null;
        }
        try {
            Properties properties = this.ds.getConnectionCacheProperties();
            StringBuffer stringBuffer = new StringBuffer(1024);
            stringBuffer.append("\n----- NativeDataSrc (" + this.name + ") @ " + new Date() + " -----\n");
            stringBuffer.append("\n");
            stringBuffer.append("Connection Cache properties:" + properties);
            OracleConnectionCacheManager oracleConnectionCacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            stringBuffer.append("\n      # Active connections:" + oracleConnectionCacheManager.getNumberOfActiveConnections(this.name + "_conncache") + "\n");
            stringBuffer.append("      # Total available connections:" + oracleConnectionCacheManager.getNumberOfAvailableConnections(this.name + "_conncache") + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Exception: " + exception.getMessage();
        }
    }

    public static void setMonitoring(boolean bl, int n) {
        monitoring = bl;
        monitoringInterval = n;
    }

    public static boolean getMonitoring() {
        return monitoring;
    }

    public String getTnsName() {
        return this.tnsName;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getSID() {
        return this.sid;
    }

    public String getUser() {
        if (this.ds == null) {
            return null;
        }
        return this.ds.getUser();
    }

    public String getMode() {
        return this.mode;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String getUserInfoPackageName() {
        return this.userInfoPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserInfoPackageName(String string) {
        this.userInfoPackageName = string;
        Connection connection = null;
        try {
            connection = this.getConnection();
            boolean bl = DSUtil.validPLSQLPackage(connection, string);
            this.setUserIfnoPackageValid(bl);
            if (!bl) {
                log.warning("PL/SQL package " + string + " will be ignored.");
            }
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error validating pl/sql package " + string + ".", exception);
            this.setUserIfnoPackageValid(false);
            log.warning("PL/SQL package " + string + " will be ignored.");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    class MonitorThread
    extends Thread {
        boolean stop = false;

        MonitorThread() {
        }

        public void run() {
            while (!this.stop) {
                String string = NativeOracleDataSource.this.report();
                if (string != null) {
                    log.info(string);
                }
                try {
                    MonitorThread.sleep(monitoringInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }

        public void stopIt() {
            this.stop = true;
        }
    }
}

