/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BasemapCache;
import oracle.sdovis.SRSCache;
import oracle.sdovis.StyleCache;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.ds.DataSourceI;

public class FileDataSource
implements DataSourceI {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static String METADATA_ENV = "metadata";
    public static String STYLE_DB = "style";
    public static String THEME_DB = "theme";
    public static String BASEMAP_DB = "basemap";
    public static String TILELAYER_DB = "tilelayer";
    public static String TILETASK_DB = "tiletask";
    public static String GEOMETA_DB = "geometa";
    public static String SRS_DB = "cs_srs";
    public static String CLASS_DB = "classdb";
    public static String CONFIG_FILE = "config.xml";
    public static String DATA_ENV = "data";
    private StyleCache styleCache;
    private ThemeCache themeCache;
    private BasemapCache basemapCache;
    private SRSCache srsCache;
    private String name;
    private String rootFolder;
    private boolean closed = false;
    private Environment metadataEnv = null;
    private Environment dataEnv = null;
    private static Hashtable fileDataSources = new Hashtable(17);
    private Hashtable dbHandles = new Hashtable(23);
    private static Hashtable metaDBNames = new Hashtable(17);
    private String tempDir = null;

    public FileDataSource(String string, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            throw new IllegalArgumentException("Invalid file data source: root folder not found:" + string2 + "!");
        }
        this.name = string;
        this.rootFolder = string2;
        String string3 = null;
        String string4 = null;
        if (string2.endsWith(File.separator)) {
            string3 = string2 + METADATA_ENV;
            string4 = string2 + DATA_ENV;
        } else {
            string3 = string2 + File.separator + METADATA_ENV;
            string4 = string2 + File.separator + DATA_ENV;
        }
        try {
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(false);
            this.metadataEnv = new Environment(new File(string3), environmentConfig);
            environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(false);
            this.dataEnv = new Environment(new File(string4), environmentConfig);
            fileDataSources.put(string.toUpperCase(), this);
            log.info("File-based data source created: " + string + ".");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error opening file data source '" + string + "'.", exception);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            try {
                Enumeration enumeration = this.dbHandles.elements();
                while (enumeration.hasMoreElements()) {
                    Database database = (Database)enumeration.nextElement();
                    database.close();
                }
                this.dbHandles.clear();
                if (this.metadataEnv != null) {
                    this.metadataEnv.close();
                }
                if (this.dataEnv != null) {
                    this.dataEnv.close();
                }
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Error closing a db env.", exception);
                Object var4_5 = null;
                this.closed = true;
                fileDataSources.remove(this.name.toUpperCase());
                return;
            }
            Object var4_4 = null;
            this.closed = true;
            fileDataSources.remove(this.name.toUpperCase());
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closed = true;
            fileDataSources.remove(this.name.toUpperCase());
            throw throwable;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public StyleCache getStyleCache() {
        return this.styleCache;
    }

    public void setStyleCache(StyleCache styleCache) {
        this.styleCache = styleCache;
    }

    public SRSCache getSRSCache() {
        return this.srsCache;
    }

    public void setSRSCache(SRSCache sRSCache) {
        this.srsCache = sRSCache;
    }

    public BasemapCache getBasemapCache() {
        return this.basemapCache;
    }

    public void setBasemapCache(BasemapCache basemapCache) {
        this.basemapCache = basemapCache;
    }

    public ThemeCache getThemeCache() {
        return this.themeCache;
    }

    public void setThemeCache(ThemeCache themeCache) {
        this.themeCache = themeCache;
    }

    public static FileDataSource getDataSource(String string) {
        return (FileDataSource)fileDataSources.get(string.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean createNewRepository(String string, String string2) {
        block25: {
            boolean bl;
            File file = new File(string2);
            if (!file.exists()) {
                throw new IllegalArgumentException("Invalid file data source: root folder not found:" + string2 + "!");
            }
            String string3 = null;
            String string4 = null;
            if (string2.endsWith(File.separator)) {
                string3 = string2 + METADATA_ENV;
                string4 = string2 + DATA_ENV;
            } else {
                string3 = string2 + File.separator + METADATA_ENV;
                string4 = string2 + File.separator + DATA_ENV;
            }
            file = new File(string3);
            if (!file.exists()) {
                try {
                    bl = file.mkdir();
                    if (!bl) {
                        log.severe("Cannot create metadata folder under " + string + ".");
                        return false;
                    }
                }
                catch (Exception exception) {
                    log.log(Level.SEVERE, "cannot create metadata folder under " + string + ".", exception);
                    return false;
                }
            }
            if (!(file = new File(string4)).exists()) {
                try {
                    bl = file.mkdir();
                    if (!bl) {
                        log.severe("Cannot create data folder under " + string + ".");
                        return false;
                    }
                }
                catch (Exception exception) {
                    log.log(Level.SEVERE, "cannot create data folder under " + string + ".", exception);
                    return false;
                }
            }
            Environment environment = null;
            Environment environment2 = null;
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(true);
            environment = new Environment(new File(string3), environmentConfig);
            environmentConfig = new EnvironmentConfig();
            environmentConfig.setAllowCreate(true);
            environment2 = new Environment(new File(string4), environmentConfig);
            FileDataSource.createMetaDatabases(environment);
            Object var10_12 = null;
            try {
                if (environment != null) {
                    environment.close();
                }
                if (environment2 != null) {
                    environment2.close();
                }
                break block25;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "exception closing envs.", exception);
            }
            break block25;
            {
                catch (Exception exception) {
                    log.log(Level.SEVERE, "Exception creating a new local repository.", exception);
                    boolean bl2 = false;
                    Object var10_13 = null;
                    try {
                        if (environment != null) {
                            environment.close();
                        }
                        if (environment2 != null) {
                            environment2.close();
                        }
                    }
                    catch (Exception exception2) {
                        log.log(Level.SEVERE, "exception closing envs.", exception2);
                    }
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    if (environment != null) {
                        environment.close();
                    }
                    if (environment2 != null) {
                        environment2.close();
                    }
                }
                catch (Exception exception) {
                    log.log(Level.SEVERE, "exception closing envs.", exception);
                }
                throw throwable;
            }
        }
        System.out.println("A new file database has been created in " + string2 + ".");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean createMetaDatabases(Environment environment) throws DatabaseException {
        Database database;
        Database database2;
        Database database3;
        Database database4;
        Database database5;
        Database database6;
        Database database7;
        block25: {
            Database database8 = null;
            database7 = null;
            database6 = null;
            database5 = null;
            database4 = null;
            database3 = null;
            database2 = null;
            database = null;
            try {
                try {
                    DatabaseConfig databaseConfig = new DatabaseConfig();
                    databaseConfig.setAllowCreate(true);
                    database8 = environment.openDatabase(null, STYLE_DB, databaseConfig);
                    database7 = environment.openDatabase(null, THEME_DB, databaseConfig);
                    database6 = environment.openDatabase(null, BASEMAP_DB, databaseConfig);
                    database5 = environment.openDatabase(null, TILELAYER_DB, databaseConfig);
                    database4 = environment.openDatabase(null, TILETASK_DB, databaseConfig);
                    database3 = environment.openDatabase(null, GEOMETA_DB, databaseConfig);
                    database2 = environment.openDatabase(null, SRS_DB, databaseConfig);
                    database = environment.openDatabase(null, CLASS_DB, databaseConfig);
                }
                catch (Exception exception) {
                    boolean bl = false;
                    Object var12_12 = null;
                    if (database8 != null) {
                        database8.close();
                    }
                    if (database7 != null) {
                        database7.close();
                    }
                    if (database6 != null) {
                        database6.close();
                    }
                    if (database5 != null) {
                        database5.close();
                    }
                    if (database4 != null) {
                        database4.close();
                    }
                    if (database3 != null) {
                        database3.close();
                    }
                    if (database2 != null) {
                        database2.close();
                    }
                    if (database == null) return bl;
                    database.close();
                    return bl;
                }
                Object var12_11 = null;
                if (database8 == null) break block25;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (database8 != null) {
                    database8.close();
                }
                if (database7 != null) {
                    database7.close();
                }
                if (database6 != null) {
                    database6.close();
                }
                if (database5 != null) {
                    database5.close();
                }
                if (database4 != null) {
                    database4.close();
                }
                if (database3 != null) {
                    database3.close();
                }
                if (database2 != null) {
                    database2.close();
                }
                if (database == null) throw throwable;
                database.close();
                throw throwable;
            }
            database8.close();
        }
        if (database7 != null) {
            database7.close();
        }
        if (database6 != null) {
            database6.close();
        }
        if (database5 != null) {
            database5.close();
        }
        if (database4 != null) {
            database4.close();
        }
        if (database3 != null) {
            database3.close();
        }
        if (database2 != null) {
            database2.close();
        }
        if (database == null) return true;
        database.close();
        return true;
    }

    public void setRootFolder(String string) {
        this.rootFolder = string;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setMetadataEnv(Environment environment) {
        this.metadataEnv = environment;
    }

    public Environment getMetadataEnv() {
        return this.metadataEnv;
    }

    public void setDataEnv(Environment environment) {
        this.dataEnv = environment;
    }

    public Environment getDataEnv() {
        return this.dataEnv;
    }

    public static Hashtable getFileDataSources() {
        return fileDataSources;
    }

    public Database getStyleDb() {
        Database database = (Database)this.dbHandles.get(STYLE_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, STYLE_DB, databaseConfig);
                this.dbHandles.put(STYLE_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open style db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getThemeDb() {
        Database database = (Database)this.dbHandles.get(THEME_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, THEME_DB, databaseConfig);
                this.dbHandles.put(THEME_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open theme db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getBasemapDb() {
        Database database = (Database)this.dbHandles.get(BASEMAP_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, BASEMAP_DB, databaseConfig);
                this.dbHandles.put(BASEMAP_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open basemap db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getTileLayerDb() {
        Database database = (Database)this.dbHandles.get(TILELAYER_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, TILELAYER_DB, databaseConfig);
                this.dbHandles.put(TILELAYER_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open tile layer db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getTiletaskDb() {
        Database database = (Database)this.dbHandles.get(TILETASK_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, TILETASK_DB, databaseConfig);
                this.dbHandles.put(TILETASK_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open tile layer db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getGeometaDb() {
        Database database = (Database)this.dbHandles.get(GEOMETA_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, GEOMETA_DB, databaseConfig);
                this.dbHandles.put(GEOMETA_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open geo-meta db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getSrsDb() {
        Database database = (Database)this.dbHandles.get(SRS_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, SRS_DB, databaseConfig);
                this.dbHandles.put(SRS_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open SRS db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    public Database getClassDb() {
        Database database = (Database)this.dbHandles.get(CLASS_DB);
        if (database == null) {
            try {
                DatabaseConfig databaseConfig = new DatabaseConfig();
                databaseConfig.setAllowCreate(false);
                database = this.metadataEnv.openDatabase(null, CLASS_DB, databaseConfig);
                this.dbHandles.put(CLASS_DB, database);
                return database;
            }
            catch (Exception exception) {
                log.severe("cannot open class db." + exception.getMessage());
                return null;
            }
        }
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDb(String string) {
        Database database = (Database)this.dbHandles.get(string);
        if (database == null) return;
        try {
            try {
                database.close();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "error closing a db: " + string, exception);
                Object var5_4 = null;
                this.dbHandles.remove(string);
                return;
            }
            Object var5_3 = null;
            this.dbHandles.remove(string);
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.dbHandles.remove(string);
            throw throwable;
        }
    }

    public boolean isMetaDatabase(String string) {
        return metaDBNames.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncateDb(String string) {
        block5: {
            this.closeDb(string);
            if (!this.isMetaDatabase(string)) break block5;
            long l = this.metadataEnv.truncateDatabase(null, string, true);
            Object var6_5 = null;
            return l;
        }
        try {
            long l = this.dataEnv.truncateDatabase(null, string, true);
            Object var6_6 = null;
            return l;
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, "Error truncating a database: " + string, exception);
                long l = -1L;
                Object var6_7 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                throw throwable;
            }
        }
    }

    public static void main(String[] stringArray) {
        FileDataSource.createNewRepository("mvdemo", "/ul/file-ds/mvdemo");
    }

    public String getTemporaryDirectory() {
        return this.tempDir;
    }

    public void setTemporaryDirectory(String string) {
        this.tempDir = string;
    }

    public String getOwner() {
        return null;
    }

    static {
        metaDBNames.put(STYLE_DB, STYLE_DB);
        metaDBNames.put(THEME_DB, THEME_DB);
        metaDBNames.put(BASEMAP_DB, BASEMAP_DB);
        metaDBNames.put(TILELAYER_DB, TILELAYER_DB);
        metaDBNames.put(TILETASK_DB, TILETASK_DB);
        metaDBNames.put(GEOMETA_DB, GEOMETA_DB);
        metaDBNames.put(SRS_DB, SRS_DB);
        metaDBNames.put(CLASS_DB, CLASS_DB);
    }
}

