/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.ds;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.util.UserIdentity;
import oracle.sql.ArrayDescriptor;

public class DSUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static String STRING_TABLE_TYPE = "MV_STRINGLIST";
    public static String NUMBER_TABLE_TYPE = "MV_NUMBERLIST";
    public static String DATE_TABLE_TYPE = "MV_DATELIST";
    static String arrayDDL1 = "CREATE or REPLACE type " + STRING_TABLE_TYPE + " as TABLE of VARCHAR2(1000)";
    static String arrayDDL2 = "CREATE or REPLACE type " + NUMBER_TABLE_TYPE + " as TABLE of NUMBER";
    static String arrayDDL3 = "CREATE or REPLACE type " + DATE_TABLE_TYPE + " as TABLE of DATE";

    public static final Connection getDBConnection(String string, VisContext visContext) throws SQLException {
        String string2;
        Connection connection = null;
        DBDataSource dBDataSource = (DBDataSource)DSManager.get(string);
        if (dBDataSource == null) {
            throw new SQLException("data-src object not found.");
        }
        if (visContext == null) {
            return dBDataSource.getConnection();
        }
        UserIdentity userIdentity = visContext.getUserIdentity();
        if (userIdentity == null) {
            return dBDataSource.getConnection();
        }
        Hashtable hashtable = userIdentity.getUserNames();
        String string3 = (String)hashtable.get(string2 = dBDataSource.getWebUserType());
        if (string3 == null) {
            return dBDataSource.getConnection();
        }
        if (dBDataSource.useProxySession()) {
            Properties properties = new Properties();
            properties.put("PROXY_USER_NAME", string3);
            connection = dBDataSource.getProxyConnection(dBDataSource.getProxyType(), properties);
            return connection;
        }
        connection = dBDataSource.getConnection();
        String string4 = dBDataSource.getUserInfoPackageName();
        if (string4 != null && string3 != null && dBDataSource.isUserIfnoPackageValid()) {
            try {
                String string5 = "{CALL " + string4 + ".set_user(?)}";
                CallableStatement callableStatement = connection.prepareCall(string5);
                callableStatement.setString(1, string3);
                callableStatement.executeUpdate();
                callableStatement.close();
                log.finest("package " + string4 + ".set_user called for :" + string3 + ".");
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Error setting web user info in the database.", exception);
            }
        }
        return connection;
    }

    public static final void closeDBConnection(Connection connection, String string) {
        if (connection == null) {
            throw new IllegalArgumentException("Null connection found.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null data source found.");
        }
        try {
            String string2;
            DBDataSource dBDataSource = (DBDataSource)DSManager.get(string);
            if (dBDataSource != null && (string2 = dBDataSource.getUserInfoPackageName()) != null && dBDataSource.isUserIfnoPackageValid()) {
                try {
                    String string3 = "{CALL " + string2 + ".clear_user()}";
                    CallableStatement callableStatement = connection.prepareCall(string3);
                    callableStatement.executeUpdate();
                    callableStatement.close();
                    log.finest("package " + string2 + ".clear_user called.");
                }
                catch (Exception exception) {
                    log.log(Level.WARNING, "Error clearing web user info in the database.", exception);
                }
            }
            if ((string2 = (OracleConnection)connection).isProxySession()) {
                string2.close(1);
            }
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean validPLSQLPackage(Connection connection, String string) {
        if (connection == null) {
            throw new IllegalArgumentException("invalid/null connection.");
        }
        try {
            String string2 = "{CALL " + string + ".clear_user()}";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.executeUpdate();
            callableStatement.close();
            log.finest("package " + string + ".clear_user called. The package is valid.");
            return true;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error clearing web user info in the database.", exception);
            return false;
        }
    }

    public static void createArrayTypes(Connection connection, String string) {
        ArrayDescriptor arrayDescriptor = null;
        ArrayDescriptor arrayDescriptor2 = null;
        ArrayDescriptor arrayDescriptor3 = null;
        arrayDescriptor = DSUtil.getArrayDescriptor(connection, "string", true);
        arrayDescriptor2 = DSUtil.getArrayDescriptor(connection, "number", true);
        arrayDescriptor3 = DSUtil.getArrayDescriptor(connection, "date", true);
        if (arrayDescriptor != null && arrayDescriptor2 != null && arrayDescriptor3 != null) {
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Cannot create a statement.", exception);
        }
        try {
            if (arrayDescriptor == null) {
                statement.executeUpdate(arrayDDL1);
                log.info("SQL array type created by MapViewer: " + STRING_TABLE_TYPE);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Cannot create SQL array type " + STRING_TABLE_TYPE + ".", exception);
            log.log(Level.WARNING, "Make sure you run the following in the schema of " + string + ":\n " + arrayDDL1);
        }
        try {
            if (arrayDescriptor2 == null) {
                statement.executeUpdate(arrayDDL2);
                log.info("SQL array type created by MapViewer: " + NUMBER_TABLE_TYPE);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Cannot create SQL array type " + NUMBER_TABLE_TYPE + ".", exception);
            log.log(Level.WARNING, "Make sure you run the following in the schema of " + string + ":\n " + arrayDDL2);
        }
        try {
            if (arrayDescriptor3 == null) {
                statement.executeUpdate(arrayDDL3);
                log.info("SQL array type created by MapViewer: " + DATE_TABLE_TYPE);
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Cannot create SQL array type " + DATE_TABLE_TYPE + ".", exception);
            log.log(Level.WARNING, "Make sure you run the following in the schema of " + string + ":\n " + arrayDDL3);
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ArrayDescriptor getArrayDescriptor(Connection connection, String string, boolean bl) {
        String string2 = "";
        if ("STRING".equalsIgnoreCase(string)) {
            string2 = STRING_TABLE_TYPE;
        } else if ("NUMBER".equalsIgnoreCase(string)) {
            string2 = NUMBER_TABLE_TYPE;
        } else if ("DATE".equalsIgnoreCase(string)) {
            string2 = DATE_TABLE_TYPE;
        } else {
            log.warning("Invalid array element type: " + string);
            return null;
        }
        try {
            ArrayDescriptor arrayDescriptor = (ArrayDescriptor)((OracleConnection)connection).getDescriptor(string2);
            if (arrayDescriptor == null) {
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)string2, (Connection)connection);
            }
            return arrayDescriptor;
        }
        catch (Exception exception) {
            if (!bl) {
                log.warning("Unable to get or create SQL array type: " + string2);
                log.warning("Make sure you have created the 3 SQL types in your database:\n" + arrayDDL1 + "\n" + arrayDDL2 + "\n" + arrayDDL3 + "\n");
            }
            return null;
        }
    }
}

