/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.internal;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import oracle.sdovis.charts.internal.RoundGradientContext;

public class RoundGradientPaint
implements Paint {
    protected Point2D mPoint;
    protected Point2D mRadius;
    protected Color mPointColor;
    protected Color mBackgroundColor;

    public RoundGradientPaint(double d, double d2, Color color, double d3, double d4, Color color2) {
        this.mRadius = new Point2D.Double(d3, d4);
        if (this.mRadius.distance(0.0, 0.0) <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0");
        }
        this.mPoint = new Point2D.Double(d, d2);
        this.mPointColor = color;
        this.mBackgroundColor = color2;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.mPoint, null);
        Point2D point2D2 = affineTransform.deltaTransform(this.mRadius, null);
        return new RoundGradientContext(point2D, this.mPointColor, point2D2, this.mBackgroundColor);
    }

    public int getTransparency() {
        int n;
        int n2 = this.mPointColor.getAlpha();
        return (n2 & (n = this.mBackgroundColor.getAlpha())) == 255 ? 1 : 3;
    }
}

