/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.internal;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import oracle.sdovis.charts.types.ImageMapAreaDescSingle;

public class LineMarker {
    private static final int LINE_SOLID = 1;
    private static final int LINE_DASHED = 2;
    private static final int LINE_DASHED2 = 3;
    BasicStroke LineStroke = new BasicStroke(2.0f, 0, 2);
    BasicStroke DefaultStroke = new BasicStroke(1.0f, 0, 2);
    BasicStroke LineMarkerStroke = new BasicStroke(1.5f, 0, 2);
    final double LineDeltaD = 5.0f * this.LineStroke.getLineWidth() / 2.0f + 1.0f;
    double QuarterPie = 0.7854;
    final double LineDeltaSquareD = Math.sqrt(this.LineDeltaD * this.LineDeltaD * this.QuarterPie);
    final double LineDeltaDiamondD = Math.sqrt(this.LineDeltaD * this.LineDeltaD * this.QuarterPie * 1.7);

    public LineMarker(BasicStroke basicStroke) {
        this.LineStroke = basicStroke;
    }

    public LineMarker() {
    }

    public int getLineDelta() {
        return (int)Math.round(this.LineDeltaD);
    }

    public BasicStroke getLineStroke(int n, float f) {
        switch (n) {
            case 1: {
                return new BasicStroke(f, 0, 2);
            }
            case 2: {
                return new BasicStroke(f, 0, 2, 1.0f, new float[]{f, f / 2.0f}, 0.0f);
            }
            case 3: {
                return new BasicStroke(f, 0, 2, 1.0f, new float[]{f * 2.0f, f}, 0.0f);
            }
        }
        return new BasicStroke(f, 0, 2);
    }

    public BasicStroke getLineStroke() {
        return this.LineStroke;
    }

    public BasicStroke getLineMarkerStroke(int n) {
        switch (n) {
            case 5: 
            case 6: {
                return this.LineMarkerStroke;
            }
        }
        return this.DefaultStroke;
    }

    public ImageMapAreaDescSingle drawMarker(Graphics2D graphics2D, int n, double d, int n2, int n3) {
        ImageMapAreaDescSingle imageMapAreaDescSingle = new ImageMapAreaDescSingle();
        switch (n) {
            case 1: {
                double d2 = this.LineDeltaD * d;
                int n4 = (int)Math.round(d2);
                int n5 = (int)Math.round(d2 * 0.5);
                int[] nArray = new int[]{n2, n3, n5};
                imageMapAreaDescSingle.setCoords(nArray);
                imageMapAreaDescSingle.setShape(1);
                int n6 = n2 - n5;
                int n7 = n3 - n5;
                Ellipse2D.Double double_ = new Ellipse2D.Double(n6, n7, n4, n4);
                graphics2D.fill(double_);
                break;
            }
            case 10: 
            case 11: {
                double d3 = this.LineDeltaD * d;
                int n8 = (int)Math.round(d3);
                int n9 = (int)Math.round(d3 * 0.5);
                int[] nArray = new int[]{n2, n3, n9};
                imageMapAreaDescSingle.setCoords(nArray);
                imageMapAreaDescSingle.setShape(1);
                if (n == 10) {
                    this.drawStar(graphics2D, n2, n3, 5, d);
                }
                if (n != 11) break;
                this.drawStar(graphics2D, n2, n3, 8, d);
                break;
            }
            case 2: {
                double d4 = this.LineDeltaSquareD * d;
                int n10 = (int)Math.round(d4);
                int n11 = (int)Math.round(d4 * 0.5);
                int n12 = n2 - n11;
                int n13 = n3 - n11;
                graphics2D.fillRect(n12, n13, n10, n10);
                int[] nArray = new int[]{n12, n13, n12 + n10, n13 + n10};
                imageMapAreaDescSingle.setCoords(nArray);
                imageMapAreaDescSingle.setShape(0);
                break;
            }
            case 4: {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                double d5 = this.LineDeltaDiamondD * d;
                int n14 = (int)Math.round(d5 * 0.5);
                nArray[0] = n2 - n14;
                nArray2[0] = n3 + n14;
                nArray[1] = n2 + n14;
                nArray2[1] = n3 + n14;
                nArray[2] = n2;
                nArray2[2] = n3 - n14;
                nArray[3] = nArray[0];
                nArray2[3] = nArray2[0];
                graphics2D.fillPolygon(nArray, nArray2, 3);
                imageMapAreaDescSingle.setShape(2);
                int[] nArray3 = new int[8];
                for (int i = 0; i < 4; ++i) {
                    nArray3[i * 2] = nArray[i];
                    nArray3[i * 2 + 1] = nArray2[i];
                }
                imageMapAreaDescSingle.setCoords(nArray3);
                break;
            }
            case 6: {
                double d6 = this.LineDeltaSquareD * d;
                int n15 = (int)Math.round(d6 * 0.5);
                int n16 = n2 - n15;
                int n17 = n3 - n15;
                int n18 = n2 + n15;
                int n19 = n3 + n15;
                graphics2D.drawLine(n16, n17, n18, n19);
                graphics2D.drawLine(n16, n19, n18, n17);
                int[] nArray = new int[]{n16, n17, n16 + (int)Math.round(d6), n17 + (int)Math.round(d6)};
                imageMapAreaDescSingle.setCoords(nArray);
                imageMapAreaDescSingle.setShape(0);
                break;
            }
            case 5: {
                double d7 = this.LineDeltaD * d;
                int n20 = (int)Math.round(d7 * 0.5);
                int n21 = n2 - n20;
                int n22 = n3 - n20;
                graphics2D.setStroke(this.LineStroke);
                graphics2D.drawLine(n2, n3 - n20, n2, n3 + n20);
                graphics2D.drawLine(n2 - n20, n3, n2 + n20, n3);
                graphics2D.setStroke(this.DefaultStroke);
                int[] nArray = new int[]{n2, n3, n20};
                imageMapAreaDescSingle.setCoords(nArray);
                imageMapAreaDescSingle.setShape(1);
                break;
            }
            case 3: {
                int[] nArray = new int[5];
                int[] nArray4 = new int[5];
                double d8 = this.LineDeltaDiamondD * d;
                int n23 = (int)Math.round(d8 * 0.5);
                nArray[0] = n2;
                nArray4[0] = n3 - n23;
                nArray[1] = n2 - n23;
                nArray4[1] = n3;
                nArray[2] = n2;
                nArray4[2] = n3 + n23;
                nArray[3] = n2 + n23;
                nArray4[3] = n3;
                nArray[4] = nArray[0];
                nArray4[4] = nArray4[0];
                graphics2D.fillPolygon(nArray, nArray4, 5);
                imageMapAreaDescSingle.setShape(2);
                int[] nArray5 = new int[10];
                for (int i = 0; i < 5; ++i) {
                    nArray5[i * 2] = nArray[i];
                    nArray5[i * 2 + 1] = nArray4[i];
                }
                imageMapAreaDescSingle.setCoords(nArray5);
            }
        }
        return imageMapAreaDescSingle;
    }

    private void drawStar(Graphics2D graphics2D, int n, int n2, int n3, double d) {
        int[] nArray = new int[2 * n3 + 1];
        int[] nArray2 = new int[2 * n3 + 1];
        double d2 = this.LineDeltaD * d * 0.78;
        double d3 = this.LineDeltaD * d * 0.3;
        double d4 = -90.0;
        double d5 = 360.0 / (double)n3;
        for (int i = 0; i < 2 * n3; i += 2) {
            double d6 = Math.cos(Math.toRadians(d4)) * d2;
            double d7 = Math.sin(Math.toRadians(d4)) * d2;
            nArray[i] = n + (int)Math.round(d6);
            nArray2[i] = n2 + (int)Math.round(d7);
            d6 = Math.cos(Math.toRadians(d4 + d5 * 0.5)) * d3;
            d7 = Math.sin(Math.toRadians(d4 + d5 * 0.5)) * d3;
            nArray[i + 1] = n + (int)Math.round(d6);
            nArray2[i + 1] = n2 + (int)Math.round(d7);
            d4 += d5;
        }
        nArray[2 * n3] = nArray[0];
        nArray2[2 * n3] = nArray2[0];
        graphics2D.fillPolygon(nArray, nArray2, 2 * n3 + 1);
    }
}

