/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.charts.internal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.text.AttributedString;
import oracle.sdovis.charts.internal.LabelUtil2;
import oracle.sdovis.charts.types.ButtonDesc;
import oracle.sdovis.charts.types.LabelDesc;

public final class Button {
    static final int OffsetMinHilight = 1;
    static final int OffsetMin = 2;

    public static Dimension drawButton(Graphics2D graphics2D, int n, int n2, ButtonDesc buttonDesc) {
        LabelDesc labelDesc = buttonDesc.getLabelDesc();
        Color color = buttonDesc.getBackgroundColor();
        Dimension dimension = Button.getLabelDimensions(graphics2D, buttonDesc);
        Dimension dimension2 = Button.computeEllipseDimensions(graphics2D, buttonDesc);
        int n3 = Button.getOffsetHilight((int)dimension2.getHeight());
        int n4 = Button.getOffset((int)dimension2.getHeight());
        Ellipse2D.Double double_ = new Ellipse2D.Double(n, n2, dimension2.getWidth(), dimension2.getHeight());
        Ellipse2D.Double double_2 = new Ellipse2D.Double(n + n4, n2 + n4, dimension2.getWidth(), dimension2.getHeight());
        Ellipse2D.Double double_3 = new Ellipse2D.Double(n + n3, n2 + n3, dimension2.getWidth(), dimension2.getHeight());
        Color color2 = color.darker();
        Color color3 = color.brighter();
        Area area = new Area(double_);
        Area area2 = new Area(double_3);
        Area area3 = new Area(double_2);
        area2.exclusiveOr(area);
        area2.intersect(area);
        graphics2D.setColor(color2);
        graphics2D.fill(area3);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setColor(color);
        graphics2D.fill(area);
        graphics2D.setColor(color3);
        graphics2D.fill(area2);
        int n5 = (int)Math.round((double)n + dimension2.getWidth() / 2.0 - dimension.getWidth() / 2.0 + 2.0);
        int n6 = (int)Math.round((double)n2 + dimension2.getHeight() / 2.0 + dimension.getHeight() / 3.0);
        if (labelDesc != null) {
            graphics2D.setColor(labelDesc.getColor());
            int n7 = 0;
            if (labelDesc.getTextAttributes() != null) {
                AttributedString attributedString = new AttributedString(labelDesc.getText(), labelDesc.getTextAttributes());
                TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
                textLayout.draw(graphics2D, n5 + n7, n6);
            } else {
                graphics2D.setColor(labelDesc.getColor());
                graphics2D.drawString(labelDesc.getText(), n5 + n7, n6);
            }
        }
        return new Dimension((int)dimension2.getWidth() + n3, (int)dimension2.getHeight() + n3);
    }

    public static Dimension getButtonDimensions(Graphics2D graphics2D, ButtonDesc buttonDesc) {
        Dimension dimension = Button.computeEllipseDimensions(graphics2D, buttonDesc);
        int n = Button.getOffsetHilight((int)dimension.getHeight());
        return new Dimension((int)dimension.getWidth() + n, (int)dimension.getHeight() + n);
    }

    private static Dimension computeEllipseDimensions(Graphics2D graphics2D, ButtonDesc buttonDesc) {
        LabelDesc labelDesc = buttonDesc.getLabelDesc();
        int n = buttonDesc.getWidth();
        int n2 = buttonDesc.getHeight();
        Dimension dimension = Button.getLabelDimensions(graphics2D, buttonDesc);
        double d = 1.2;
        if (n < 0) {
            n = (int)Math.round(d * dimension.getWidth());
        }
        if (n2 < 0) {
            n2 = (int)Math.round(d * dimension.getHeight());
        }
        return new Dimension(n, n2);
    }

    private static int getOffsetHilight(int n) {
        int n2 = (int)Math.round((double)n * 0.015);
        if (n2 <= 1) {
            n2 = 1;
        }
        return n2;
    }

    private static int getOffset(int n) {
        int n2 = (int)Math.round((double)n * 0.03);
        if (n2 <= 2) {
            n2 = 2;
        }
        return n2;
    }

    private static Dimension getLabelDimensions(Graphics2D graphics2D, ButtonDesc buttonDesc) {
        LabelDesc labelDesc = buttonDesc.getLabelDesc();
        int n = 0;
        int n2 = 0;
        if (labelDesc != null) {
            labelDesc.fontmet = graphics2D.getFontMetrics(labelDesc.getFont());
            n = LabelUtil2.getLabelHeight(labelDesc, graphics2D.getFontRenderContext());
            n2 = LabelUtil2.getLabelWidth(labelDesc, graphics2D.getFontRenderContext());
        }
        return new Dimension(n2, n);
    }
}

