/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.cache;

import java.util.Map;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.cache.MVLinkedHashMap;

public class CacheGroup
extends MVLinkedHashMap {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String name = null;
    private long memSize = 0L;

    public CacheGroup(String string) {
        this.name = string;
    }

    public CacheGroup(String string, int n, float f) {
        super(n, f);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public long getMemorySize() {
        return this.memSize;
    }

    public boolean isPinned() {
        return false;
    }

    public void put(Object object, Object object2, long l) {
        CacheMgr2.increaseSize(l);
        this.memSize += l;
        int n = this._put(object, object2, (int)l);
        if (n != 0) {
            this.memSize -= (long)n;
        }
    }

    public void clear() {
        super.clear();
        CacheMgr2.decreaseSize(this.memSize);
        this.memSize = 0L;
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        boolean bl;
        boolean bl2 = bl = !CacheMgr2.hasRoom(0);
        if (bl) {
            MVLinkedHashMap.Entry entry2 = (MVLinkedHashMap.Entry)entry;
            CacheMgr2.decreaseSize(entry2.getSize());
            this.memSize -= (long)entry2.getSize();
        }
        return bl;
    }

    public String report(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string + "Cache group " + this.name + " statistics:\n" + super.report(n);
    }
}

