/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class XFViewPort
implements Serializable,
Cloneable {
    boolean strict = false;
    int can_xl = 0;
    int can_yl = 0;
    int can_xh = 0;
    int can_yh = 0;
    int can_bits = 8;
    int can_xoff = 0;
    int can_yoff = 0;
    int scale_axis;
    double zoom_level = 1.0;
    double x_scalef = 1.0;
    double y_scalef = 1.0;
    double rotation = 0.0;
    double dview_xl;
    double dview_yl;
    double dview_xh;
    double dview_yh;
    boolean selecting = false;
    int select_sx = -1;
    int select_sy = -1;
    int select_ex = -1;
    int select_ey = -1;
    double scale_data_x = 1.0;
    double scale_data_y = 1.0;
    AffineTransform affXF;

    public Object clone() throws CloneNotSupportedException {
        XFViewPort xFViewPort = (XFViewPort)super.clone();
        if (this.affXF != null) {
            xFViewPort.affXF = (AffineTransform)this.affXF.clone();
        }
        return xFViewPort;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public boolean forward(Point2D point2D, Point2D point2D2) {
        point2D2.setLocation((point2D.getX() - this.dview_xl) * this.x_scalef + (double)this.can_xoff, (this.dview_yh - point2D.getY()) * this.y_scalef + (double)this.can_yoff);
        return true;
    }

    public boolean inverse(Point2D point2D, Point2D point2D2) {
        point2D2.setLocation((point2D.getX() - (double)this.can_xoff) / this.x_scalef + this.dview_xl, this.dview_yh - (point2D.getY() - (double)this.can_yoff) / this.y_scalef);
        return true;
    }

    public boolean inverse(int[] nArray, double[] dArray) {
        dArray[0] = (double)(nArray[0] - this.can_xoff) / this.x_scalef + this.dview_xl;
        dArray[1] = this.dview_yh - (double)(nArray[1] - this.can_yoff) / this.y_scalef;
        return true;
    }

    public double getScaleFactor() {
        return this.x_scalef;
    }

    public void setDeviceView(int n, int n2, int n3, int n4) {
        this.can_xl = n;
        this.can_yl = n2;
        this.can_xh = n3;
        this.can_yh = n4;
        if (this.strict) {
            this.setupXForm2();
        } else {
            this.setupXForm();
        }
    }

    public void setDeviceView(Rectangle2D rectangle2D) {
        this.setDeviceView((int)rectangle2D.getMinX(), (int)rectangle2D.getMinY(), (int)rectangle2D.getMaxX(), (int)rectangle2D.getMaxY());
    }

    public void setupXForm() {
        double d = (this.dview_xh - this.dview_xl) * this.scale_data_x;
        double d2 = (double)(this.can_xh - this.can_xl - 2) / d;
        double d3 = this.dview_yh - this.dview_yl;
        double d4 = (double)(this.can_yh - this.can_yl - 2) / d3;
        if (d2 <= d4) {
            this.x_scalef = this.y_scalef = d2;
            this.scale_axis = 0;
            this.can_xoff = this.can_xl + 1;
            this.can_yoff = (int)(((double)(this.can_yh - this.can_yl + 1) - d3 * d2) / 2.0) + this.can_yl + 1;
        } else {
            this.x_scalef = this.y_scalef = d4;
            this.scale_axis = 1;
            this.can_xoff = (int)(((double)(this.can_xh - this.can_xl + 1) - d * d4) / 2.0) + this.can_xl + 1;
            this.can_yoff = this.can_yl + 1;
        }
        this.setupAffineTransform();
    }

    public void setupAffineTransform() {
        int n = this.can_xl;
        int n2 = this.can_yl;
        int n3 = this.can_xh;
        int n4 = this.can_yh;
        double d = this.dview_xh - this.dview_xl;
        double d2 = this.dview_yh - this.dview_yl;
        double d3 = 0.0;
        double d4 = (double)(n3 - n) / d;
        double d5 = (double)(n4 - n2) / d2;
        d3 = this.scale_data_x != 1.0 ? d5 : (d4 > d5 ? d5 : d4);
        double d6 = (double)n - this.dview_xl * d3 * this.scale_data_x;
        double d7 = (double)n2 + this.dview_yl * d3;
        this.affXF = new AffineTransform(d3 * this.scale_data_x, 0.0, 0.0, -d3, d6 += ((double)(n3 - n) - d * d3 * this.scale_data_x) / 2.0, d7 += (double)(n4 - n2) - ((double)(n4 - n2) - d2 * d3) / 2.0);
    }

    public void setupXForm2() {
        double d = (this.dview_xh - this.dview_xl) * this.scale_data_x;
        double d2 = this.dview_yh - this.dview_yl;
        this.x_scalef = (double)(this.can_xh - this.can_xl - 2) / d;
        this.y_scalef = (double)(this.can_yh - this.can_yl - 2) / d2;
        this.scale_axis = 0;
        this.can_xoff = this.can_xl + 1;
        this.can_yoff = this.can_yl + 1;
        this.setupAffineTransform2();
    }

    public void setupAffineTransform2() {
        int n = this.can_xl;
        int n2 = this.can_yl;
        int n3 = this.can_xh;
        int n4 = this.can_yh;
        double d = this.dview_xh - this.dview_xl;
        double d2 = this.dview_yh - this.dview_yl;
        double d3 = (double)(n3 - n) / d;
        double d4 = (double)(n4 - n2) / d2;
        double d5 = (double)n - this.dview_xl * d3;
        double d6 = (double)n2 + this.dview_yl * d4;
        this.affXF = new AffineTransform(d3, 0.0, 0.0, -d4, d5 += ((double)(n3 - n) - d * d3) / 2.0, d6 += (double)(n4 - n2) - ((double)(n4 - n2) - d2 * d4) / 2.0);
    }

    public AffineTransform getAffineTransform() {
        return this.affXF;
    }

    public void setDataScaleOnX(double d) {
        this.scale_data_x = d;
    }

    public void setDataScaleOnY(double d) {
        this.scale_data_y = d;
    }

    public boolean setDataView(double d, double d2, double d3, double d4) {
        if (d3 - d < 0.0 || d4 - d2 < 0.0) {
            return false;
        }
        if (d == d3 && d2 == d4) {
            d -= Math.abs(d) * 0.005;
            d2 -= Math.abs(d2) * 0.005;
            d3 += Math.abs(d3) * 0.005;
            d4 += Math.abs(d2) * 0.005;
        }
        this.dview_xl = d;
        this.dview_yl = d2;
        this.dview_xh = d3;
        this.dview_yh = d4;
        if (this.strict) {
            this.setupXForm2();
        } else {
            this.setupXForm();
        }
        return true;
    }

    public void setDataView(Rectangle2D rectangle2D) {
        this.setDataView(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    public int getDeviceMinX() {
        return this.can_xl;
    }

    public int getDeviceMinY() {
        return this.can_yl;
    }

    public int getDeviceMaxX() {
        return this.can_xh;
    }

    public int getDeviceMaxY() {
        return this.can_yh;
    }

    public int getDeviceOffsetX() {
        return this.can_xoff;
    }

    public int getDeviceOffsetY() {
        return this.can_yoff;
    }

    public int getScaleAxis() {
        return this.scale_axis;
    }

    public void printAll() {
        System.out.println("XFViewPort:");
        System.out.println("device_view=(" + this.can_xl + "," + this.can_yl + ", " + this.can_xh + "," + this.can_yh + ")");
        System.out.println("data_view=(" + this.dview_xl + "," + this.dview_yl + ", " + this.dview_xh + "," + this.dview_yh + ")");
        System.out.println("dev_off=(" + this.can_xoff + "," + this.can_yoff + ")");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XFViewPort:").append("device_view=(" + this.can_xl + "," + this.can_yl + ", " + this.can_xh + "," + this.can_yh + ") ");
        stringBuffer.append("data_view=(" + this.dview_xl + "," + this.dview_yl + ", " + this.dview_xh + "," + this.dview_yh + ") ");
        stringBuffer.append("dev_off=(" + this.can_xoff + "," + this.can_yoff + ")\n" + this.affXF);
        return stringBuffer.toString();
    }
}

