/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.CacheMgr2;
import oracle.sdovis.RSBundle;
import oracle.sdovis.ThemeStore;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.style.StylingRule;
import oracle.sdovis.theme.AnnotationTextThemeDefinition;
import oracle.sdovis.theme.CommonThemeAttrs;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.DynGeomThemeDefinition;
import oracle.sdovis.theme.GeoRasterThemeDefinition;
import oracle.sdovis.theme.ImageThemeDefinition;
import oracle.sdovis.theme.NetworkThemeDefinition;
import oracle.sdovis.theme.PredGeomThemeDefinition;
import oracle.sdovis.theme.ShadedReliefThemeDefinition;
import oracle.sdovis.theme.ThemeDefinition;
import oracle.sdovis.theme.TopologyThemeDefinition;
import oracle.sdovis.theme.VectorThemeDefinition;
import oracle.sdovis.theme.WFSThemeDefinition;
import oracle.sdovis.theme.WMSMapThemeDefinition;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import oracle.sql.CLOB;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThemeTable
extends DBTable
implements ThemeStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String mName = null;
    private String mDescription = null;
    private String mBaseTable = null;
    private String mBaseTableOwner;
    private String mSpatialColumn = null;
    private StringBuffer mStylingRulesData;
    private int mSRID = 0;
    CommonThemeAttrs commonAttrs = new CommonThemeAttrs();

    public ThemeTable(String string, String string2) {
        super(string, string2);
        this.mStylingRulesData = new StringBuffer(4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getThemeNames() {
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>(32);
        try {
            AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = abstractDBDataSource.getConnection();
            statement = this.mConnection.prepareStatement("select name from " + this.mTableName);
            this.query((PreparedStatement)statement);
            while (this.mResultSet.next()) {
                String string = this.mResultSet.getString(1);
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            sQLException.printStackTrace(System.err);
            List list = null;
            return list;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        return arrayList;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public String getBaseTable() {
        return this.mBaseTable;
    }

    public void setBaseTable(String string) {
        this.mBaseTable = string;
    }

    public String getSpatialColumn() {
        return this.mSpatialColumn;
    }

    public void setSpatialColumn(String string) {
        this.mSpatialColumn = string;
    }

    public String getStylingRules() {
        return this.mStylingRulesData == null ? null : this.mStylingRulesData.toString();
    }

    public void setStylingRules(String string) {
        this.mStylingRulesData = new StringBuffer(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeDefinition getThemeDefinition(String string) {
        Object object;
        Object object2;
        Statement statement = null;
        try {
            object2 = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            this.mConnection = ((AbstractDBDataSource)object2).getConnection();
            object = "SELECT * FROM " + this.mTableName + " WHERE upper(name)=?";
            statement = this.mConnection.prepareStatement((String)object);
            statement.setString(1, string.toUpperCase());
            this.query((PreparedStatement)statement);
            if (!this.next()) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01015") + " [" + string + "]");
                ThemeDefinition themeDefinition = null;
                return themeDefinition;
            }
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            ThemeDefinition themeDefinition = null;
            return themeDefinition;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        object2 = this.mStylingRulesData.toString().toLowerCase();
        if (((String)object2).indexOf("theme_type=\"wfs\"") < 0 && ((String)object2).indexOf("theme_type=\"wms\"") < 0 && ((String)object2).indexOf("theme_type=\"geom_custom\"") < 0 && !this.getSrid(string)) {
            this.getSridFromUser(string);
        }
        try {
            object = new XMLDOMParser();
            if (!((XMLDOMParser)object).parse(this.mStylingRulesData.toString())) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01014") + " [" + string + "]");
                return null;
            }
            Node node = ((XMLDOMParser)object).getElementNode("styling_rules");
            if (node == null) {
                log.severe(RSBundle.getMsg("MAPVIEWER-01016") + " [" + string + "]");
                return null;
            }
            this.commonAttrs.getAttributes(string, (XMLDOMParser)object, node, this.mBaseTable, this.mSpatialColumn);
            String string2 = XMLDOMParser.getAttribute(node, "theme_type");
            string2 = string2 == null || string2.length() == 0 ? "GEOMETRY" : string2.toUpperCase();
            ThemeDefinition themeDefinition = null;
            if (string2.equals("GEOMETRY")) {
                themeDefinition = this.getGeometryTheme(string, (XMLDOMParser)object, node);
                if (themeDefinition != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)themeDefinition).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            } else if (string2.equals("IMAGE")) {
                themeDefinition = this.getImageTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("GEORASTER")) {
                themeDefinition = this.getGeoRasterTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("NETWORK")) {
                themeDefinition = this.getNetworkTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("SHADED_RELIEF")) {
                themeDefinition = this.getShadedReliefTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("TOPOLOGY")) {
                themeDefinition = this.getTopologyTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("WFS")) {
                themeDefinition = this.getWFSTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("GEOM_CUSTOM")) {
                themeDefinition = ThemeTable.getCustomGeomTheme(string, (XMLDOMParser)object, node, this.commonAttrs);
            } else if (string2.equals("ANNOTATION")) {
                themeDefinition = this.getAnnotationTheme(string, (XMLDOMParser)object, node);
            } else if (string2.equals("WMS")) {
                themeDefinition = this.getWMSTheme(string, (XMLDOMParser)object);
            } else {
                log.warning("Invalid theme type specified: " + string2 + ". Will treat as geometry theme.");
                themeDefinition = this.getGeometryTheme(string, (XMLDOMParser)object, node);
                if (themeDefinition != null && this.commonAttrs.highlightStyleName != null) {
                    ((VectorThemeDefinition)themeDefinition).setHighlightStyleName(this.commonAttrs.highlightStyleName);
                }
            }
            if (themeDefinition != null) {
                themeDefinition.setDescription(this.mDescription);
                themeDefinition.setFetchSize(this.commonAttrs.fetchSize);
            }
            return themeDefinition;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThemeDefinition getGeometryTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        Field[] fieldArray;
        for (int i = 0; i < this.commonAttrs.styleRules.length; ++i) {
            if (!this.commonAttrs.styleRules[i].isCompleteSQLQuery()) continue;
            return this.convertToJDBCTheme(string, this.mSpatialColumn, this.mSRID, this.commonAttrs.styleRules[i], this.commonAttrs.keyColumn);
        }
        PredGeomThemeDefinition predGeomThemeDefinition = new PredGeomThemeDefinition(string, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID);
        predGeomThemeDefinition.setCachingMode(this.commonAttrs.cacheMode);
        predGeomThemeDefinition.setTableAlias(this.commonAttrs.table_Alias);
        if (this.commonAttrs.identifiableColumns != null) {
            fieldArray = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                field.setDisplayName(this.commonAttrs.identifiableNames[i]);
                fieldArray[i] = field;
            }
            predGeomThemeDefinition.setIdentifiableColumns(fieldArray);
        }
        fieldArray = null;
        Connection connection = null;
        try {
            connection = DSUtil.getDBConnection(this.mDataSource, null);
            fieldArray = CacheMgr2.getSubRegionName(connection);
            predGeomThemeDefinition.setCacheSubRegionName((String)fieldArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        boolean bl = this.commonAttrs.cacheMode == 2;
        try {
            CacheMgr2.createGeomGroup((String)fieldArray, predGeomThemeDefinition.getCacheGroupName(), 0, bl);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage(), exception);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(predGeomThemeDefinition);
        predGeomThemeDefinition.setResourceClassName(this.commonAttrs.resourceClass);
        return predGeomThemeDefinition;
    }

    private ThemeDefinition convertToJDBCTheme(String string, String string2, int n, StylingRule stylingRule, String string3) {
        String string4 = stylingRule.getFeatureCond();
        boolean bl = stylingRule.isQueryPassThrough();
        DynGeomThemeDefinition dynGeomThemeDefinition = new DynGeomThemeDefinition(string, this.mDataSource, string4, string2, n);
        dynGeomThemeDefinition.setPassthrough(bl);
        dynGeomThemeDefinition.setFeatureStyleName(stylingRule.getFeatureStyleName());
        dynGeomThemeDefinition.setLabelColumn(stylingRule.getLabelColumn());
        dynGeomThemeDefinition.setLabelStyleName(stylingRule.getLabelStyleName());
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] fieldArray = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                field.setDisplayName(this.commonAttrs.identifiableNames[i]);
                fieldArray[i] = field;
            }
            dynGeomThemeDefinition.setIdentifiableColumns(fieldArray);
        }
        if (string3 != null) {
            dynGeomThemeDefinition.setKeyColumn(string3);
        }
        dynGeomThemeDefinition.setRenderingRules(stylingRule.getRenderingRules());
        return dynGeomThemeDefinition;
    }

    private ThemeDefinition getImageTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = XMLDOMParser.getAttribute(node, "image_column");
        String string7 = XMLDOMParser.getAttribute(node, "image_format");
        string4 = XMLDOMParser.getAttribute(node, "image_unit");
        string5 = XMLDOMParser.getAttribute(node, "image_resolution");
        if (string6 == null || string6.length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01017") + " [" + string + "]");
        }
        if (string7 == null || string7.length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01018") + " [" + string + "]");
        }
        if (string7 == null || string7.length() <= 0 || string6 == null || string6.length() <= 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01019") + " [" + string + "]");
            return null;
        }
        bl = true;
        string2 = string6;
        string3 = string7;
        log.finest("Loading image theme " + string + "[image_column is: " + string2 + "] " + "[image_resolution is: " + string5 + "].");
        ImageThemeDefinition imageThemeDefinition = new ImageThemeDefinition(string, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, string2, string3, this.commonAttrs.styleRules, this.mSRID);
        if (string4 != null) {
            try {
                imageThemeDefinition.setImageResolution(string4, Double.parseDouble(string5));
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(imageThemeDefinition);
        return imageThemeDefinition;
    }

    private ThemeDefinition getShadedReliefTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        String string2;
        String string3;
        String string4;
        GeoRasterThemeDefinition geoRasterThemeDefinition = (GeoRasterThemeDefinition)this.getGeoRasterTheme(string, xMLDOMParser, node);
        String string5 = XMLDOMParser.getAttribute(node, "camera_coordinate_x");
        if (string5 != null && string5.trim().length() < 1) {
            string5 = null;
        }
        if ((string4 = XMLDOMParser.getAttribute(node, "camera_coordinate_y")) != null && string4.trim().length() < 1) {
            string4 = null;
        }
        if ((string3 = XMLDOMParser.getAttribute(node, "camera_coordinate_z")) != null && string3.trim().length() < 1) {
            string3 = null;
        }
        if ((string2 = XMLDOMParser.getAttribute(node, "camera_degrees")) != null && string2.trim().length() < 1) {
            string2 = null;
        }
        if (string5 == null || string4 == null || string3 == null) {
            // empty if block
        }
        if (string2 == null) {
            // empty if block
        }
        string5 = string5.trim();
        string4 = string4.trim();
        string3 = string3.trim();
        Vector3d vector3d = new Vector3d(Double.parseDouble(string5), Double.parseDouble(string4), Double.parseDouble(string3));
        ShadedReliefThemeDefinition shadedReliefThemeDefinition = new ShadedReliefThemeDefinition(string, geoRasterThemeDefinition, vector3d, Double.parseDouble(string2), 1, 1);
        System.out.println("ThemeTable.getShadedReliefTheme. here");
        return shadedReliefThemeDefinition;
    }

    private ThemeDefinition getGeoRasterTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        NodeList nodeList;
        Object object;
        Object object2;
        String string2;
        Node node2;
        String[] stringArray;
        Object object3;
        Object object4;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        boolean bl = false;
        String string14 = XMLDOMParser.getAttribute(node, "raster_table");
        if (string14 != null && string14.trim().length() < 1) {
            string14 = null;
        }
        if ((string9 = XMLDOMParser.getAttribute(node, "raster_id")) != null && string9.trim().length() < 1) {
            string9 = null;
        }
        if ((string8 = XMLDOMParser.getAttribute(node, "raster_pyramid")) != null && string8.trim().length() < 1) {
            string8 = null;
        }
        if ((string7 = XMLDOMParser.getAttribute(node, "raster_bands")) != null && string7.trim().length() < 1) {
            string7 = null;
        }
        if ((string6 = XMLDOMParser.getAttribute(node, "image_unit")) != null && string6.trim().length() < 1) {
            string6 = null;
        }
        if ((string5 = XMLDOMParser.getAttribute(node, "image_resolution")) != null && string5.trim().length() < 1) {
            string5 = null;
        }
        if ((string4 = XMLDOMParser.getAttribute(node, "transparent_nodata")) != null && string4.trim().length() > 0) {
            bl = string4.trim().equalsIgnoreCase("true");
        }
        String string15 = XMLDOMParser.getAttribute(node, "alpha_band");
        if (string14 != null) {
            string10 = string14.trim();
        }
        if (string9 != null) {
            string11 = string9.trim();
        }
        if (string8 != null) {
            string12 = string8.trim();
        }
        if (string7 != null) {
            string13 = string7.trim();
        }
        GeoRasterThemeDefinition geoRasterThemeDefinition = new GeoRasterThemeDefinition(string, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, string10, string11, string12, string13, this.commonAttrs.styleRules, this.mSRID);
        if (string15 != null && string15.trim().length() > 0) {
            try {
                geoRasterThemeDefinition.setAlphaBand(Integer.parseInt(string15));
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        if (string6 != null) {
            try {
                geoRasterThemeDefinition.setImageResolution(string6, Double.parseDouble(string5));
            }
            catch (Exception exception) {
                log.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        int n = this.mSRID;
        String string16 = XMLDOMParser.getAttribute(node, "polygon_mask_srid");
        if (string16 != null && string16.trim().length() > 0) {
            try {
                n = Integer.parseInt(string16);
            }
            catch (Exception exception) {
                n = this.mSRID;
            }
        }
        if ((string3 = XMLDOMParser.getAttribute(node, "polygon_mask")) != null && string3.trim().length() > 1) {
            object4 = Util.splitBy(string3, ",");
            object3 = new double[((ArrayList)object4).size()];
            boolean bl2 = true;
            for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                try {
                    object3[i] = Double.parseDouble((String)((ArrayList)object4).get(i));
                    continue;
                }
                catch (Exception exception) {
                    log.warning("Invalid GeoRaster polygon mask coordinates.");
                    bl2 = false;
                    break;
                }
            }
            if (bl2) {
                geoRasterThemeDefinition.setPolygonMask((double[])object3, n);
            }
        } else {
            String string17;
            String string18;
            object4 = XMLDOMParser.getAttribute(node, "polygon_mask_table");
            if (object4 != null && ((String)object4).length() < 1) {
                object4 = null;
            }
            if ((object3 = (Object)XMLDOMParser.getAttribute(node, "polygon_mask_geomcolumn")) != null && ((String)object3).length() < 1) {
                object3 = null;
            }
            if ((string18 = XMLDOMParser.getAttribute(node, "polygon_mask_condition")) != null && string18.trim().length() < 1) {
                string18 = null;
            }
            if ((string17 = XMLDOMParser.getAttribute(node, "polygon_mask_joingeomcolumn")) != null && string17.length() < 1) {
                string17 = null;
            }
            if ((stringArray = XMLDOMParser.getAttribute(node, "polygon_mask_joingeorcolumn")) != null && stringArray.length() < 1) {
                stringArray = null;
            }
            geoRasterThemeDefinition.setPolygonMaskFromTable((String)object4, (String)object3, string18, string17, (String)stringArray);
        }
        object4 = xMLDOMParser.getElementNode("operations");
        if (object4 != null && (object3 = xMLDOMParser.getElementNodes("operation")).getLength() > 0) {
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            for (int i = 0; i < object3.getLength(); ++i) {
                node2 = object3.item(i);
                string2 = XMLDOMParser.getAttribute(node2, "name");
                if (string2 == null || string2.trim().length() < 1) {
                    log.info("Theme operation name must be defined.");
                    continue;
                }
                log.finer("Operation name: " + string2);
                vector.add(string2);
                NodeList nodeList2 = node2.getChildNodes();
                if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
                object2 = new Hashtable();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    object = nodeList2.item(j);
                    String string19 = XMLDOMParser.getAttribute((Node)object, "name");
                    if (string19 == null || string19.trim().length() < 1) continue;
                    String string20 = XMLDOMParser.getAttribute((Node)object, "value");
                    if (string20 == null || string20.trim().length() < 1) continue;
                    log.finer("Parameter name: " + string19.trim());
                    log.finer("Parameter value: " + string20.trim());
                    ((Hashtable)object2).put(string19.trim().toLowerCase(), string20.trim());
                }
                if (((Hashtable)object2).size() <= 0) continue;
                hashtable.put(string2, object2);
            }
            stringArray = null;
            if (vector.size() > 0) {
                stringArray = vector.toArray(new String[vector.size()]);
            }
            if (hashtable.size() == 0) {
                hashtable = null;
            }
            geoRasterThemeDefinition.setImageProcess(stringArray, hashtable);
        }
        if ((object3 = xMLDOMParser.getElementNode("bitmap_masks")) != null && (nodeList = xMLDOMParser.getElementNodes("mask")).getLength() > 0) {
            Vector<GeoRasterBitmapMask> vector = new Vector<GeoRasterBitmapMask>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node2 = nodeList.item(i);
                string2 = XMLDOMParser.getAttribute(node2, "raster_id");
                if (string2 == null || string2.trim().length() < 1) {
                    log.warning("Image mask raster id must be defined. Mask " + i + " ignored.");
                    continue;
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    log.warning("Image mask raster id must be numeric. Mask " + i + " ignored.");
                    continue;
                }
                object2 = XMLDOMParser.getAttribute(node2, "raster_table");
                if (object2 == null || ((String)object2).trim().length() < 1) {
                    log.warning("Image mask raster data table name must be defined. Mask " + i + " ignored.");
                    continue;
                }
                GeoRasterBitmapMask geoRasterBitmapMask = new GeoRasterBitmapMask();
                geoRasterBitmapMask.setRasterId(n2);
                geoRasterBitmapMask.setRasterDataTableName(((String)object2).trim());
                object = null;
                int n3 = 0;
                int n4 = 255;
                String string21 = XMLDOMParser.getAttribute(node2, "layers");
                if (string21 != null && string21.trim().length() > 0) {
                    ArrayList arrayList = Util.splitBy(string21, ",");
                    object = new int[arrayList.size()];
                    for (int j = 0; j < arrayList.size(); ++j) {
                        try {
                            object[j] = Integer.parseInt((String)arrayList.get(j));
                            continue;
                        }
                        catch (Exception exception) {
                            log.warning("Invalid GeoRaster image mask layers.");
                            object = null;
                            break;
                        }
                    }
                    if (object != null) {
                        String string22;
                        geoRasterBitmapMask.setLayers((int[])object);
                        String string23 = XMLDOMParser.getAttribute(node2, "zeromapping");
                        if (string23 != null && string23.trim().length() > 0) {
                            try {
                                int n5 = Integer.parseInt(string23);
                                if (n5 < 0 || n5 > 255) {
                                    log.warning("Invalid zero mapping value. Must be between 0-255. Assuming value equal 0.");
                                    n5 = 0;
                                }
                                n3 = n5;
                            }
                            catch (Exception exception) {
                                log.warning("Invalid zero mapping value. Assuming value equal 0.");
                                n3 = 0;
                            }
                        }
                        if ((string22 = XMLDOMParser.getAttribute(node2, "onemapping")) != null && string22.trim().length() > 0) {
                            try {
                                int n6 = Integer.parseInt(string22);
                                if (n6 < 0 || n6 > 255) {
                                    log.warning("Invalid one mapping value. Must be between 0-255. Assuming value equal 255.");
                                    n6 = 255;
                                }
                                n4 = n6;
                            }
                            catch (Exception exception) {
                                log.warning("Invalid one mapping value. Assuming value equal 255.");
                                n4 = 255;
                            }
                        }
                        geoRasterBitmapMask.setZeroMapping(n3);
                        geoRasterBitmapMask.setOneMapping(n4);
                        vector.add(geoRasterBitmapMask);
                        continue;
                    }
                    log.warning("Mask layers must be defined. Mask ignored.");
                    continue;
                }
                log.warning("Mask layers must be defined. Mask ignored.");
            }
            if (vector.size() > 0) {
                geoRasterThemeDefinition.setBitmapMasks(vector.toArray(new GeoRasterBitmapMask[vector.size()]));
            }
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(geoRasterThemeDefinition);
        geoRasterThemeDefinition.setNODATATransparent(bl);
        return geoRasterThemeDefinition;
    }

    private ThemeDefinition getNetworkTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        int n = 1;
        String string2 = null;
        string2 = XMLDOMParser.getAttribute(node, "network_name");
        String string3 = XMLDOMParser.getAttribute(node, "network_level");
        if (string2 == null || string2.length() < 1) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01020") + " [" + string + "]");
            return null;
        }
        if (string3 != null && string3.length() > 0) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n = 1;
            }
        }
        NetworkThemeDefinition networkThemeDefinition = new NetworkThemeDefinition(string, this.mDataSource, string2, n, this.commonAttrs.styleRules, this.mSRID, this.commonAttrs.cacheMode);
        this.commonAttrs.updateThemeDefinitionCustomTags(networkThemeDefinition);
        return networkThemeDefinition;
    }

    private ThemeDefinition getTopologyTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        String string2 = XMLDOMParser.getAttribute(node, "topology_name");
        if (string2 == null || string2.length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01021") + " [" + string + "]");
            return null;
        }
        TopologyThemeDefinition topologyThemeDefinition = new TopologyThemeDefinition(string, this.mDataSource, string2, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID, this.commonAttrs.cacheMode);
        Node node2 = xMLDOMParser.getElementNode("topo_view_info");
        if (node2 != null) {
            NodeList nodeList;
            Object object;
            String string3 = null;
            String string4 = null;
            Node node3 = xMLDOMParser.getElementNode("topo_view_name");
            if (node3 != null && (object = node3.getChildNodes()) != null && (string3 = object.item(0).getNodeValue()) != null && string3.trim().length() < 1) {
                string3 = null;
            }
            if ((object = xMLDOMParser.getElementNode("topo_view_column_name")) != null && (nodeList = object.getChildNodes()) != null && (string4 = nodeList.item(0).getNodeValue()) != null && string4.trim().length() < 1) {
                string4 = null;
            }
            if (string3 != null && string4 != null) {
                topologyThemeDefinition.setTopoViewParameters(string3.trim(), string4.trim());
            }
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(topologyThemeDefinition);
        return topologyThemeDefinition;
    }

    private ThemeDefinition getWFSTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        Serializable serializable;
        String string2 = XMLDOMParser.getAttribute(node, "service_url");
        if (string2 == null || string2.trim().length() == 0) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01022") + " [" + string + "]");
            return null;
        }
        string2 = string2.trim();
        String string3 = XMLDOMParser.getAttribute(node, "key_column");
        if (string3 != null && string3.length() > 0) {
            this.commonAttrs.keyColumn = string3;
            log.finest("WFS key_column specified by user: " + this.commonAttrs.keyColumn);
        } else {
            log.finest("WFS key_column using default: fid");
            this.commonAttrs.keyColumn = "fid";
        }
        String string4 = XMLDOMParser.getAttribute(node, "srs");
        if (string4 != null) {
            string4 = string4.trim();
        }
        String string5 = XMLDOMParser.getAttribute(node, "feature_ids");
        String[] stringArray = null;
        if (string5 != null && string5.trim().length() > 0) {
            serializable = Util.splitBy(string5.trim(), ",");
            stringArray = ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
        }
        serializable = new WFSThemeDefinition(string, this.mDataSource, string2, string4, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.styleRules, stringArray, this.commonAttrs.keyColumn);
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] fieldArray = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                field.setDisplayName(this.commonAttrs.identifiableNames[i]);
                fieldArray[i] = field;
            }
            ((VectorThemeDefinition)serializable).setIdentifiableColumns(fieldArray);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags((ThemeDefinition)serializable);
        return serializable;
    }

    private ThemeDefinition getWMSTheme(String string, XMLDOMParser xMLDOMParser) {
        WMSMapThemeDefinition wMSMapThemeDefinition = ThemeTable.getWMSThemeDefinition(string, xMLDOMParser);
        if (wMSMapThemeDefinition == null) {
            return null;
        }
        wMSMapThemeDefinition.setDataSourceName(this.mDataSource);
        this.commonAttrs.updateThemeDefinitionCustomTags(wMSMapThemeDefinition);
        return wMSMapThemeDefinition;
    }

    public static WMSMapThemeDefinition getWMSThemeDefinition(String string, XMLDOMParser xMLDOMParser) {
        Serializable serializable;
        Node node;
        String string2 = null;
        String string3 = "1.1.1";
        boolean bl = true;
        String string4 = "EPSG:4326";
        String string5 = "image/png";
        String string6 = "0xffffff";
        String string7 = "application/vnd.ogc.se_inimage";
        String[][] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "service_url");
        if (string8 == null) {
            log.severe("WMS service URL parameter must be defined");
            return null;
        }
        string2 = string8;
        string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "layers");
        if (string8 == null) {
            log.severe("Layers parameter must be defined");
            return null;
        }
        stringArray3 = ThemeTable.parseCommaSeparatedList(string8);
        if (stringArray3 == null) {
            log.severe("Layers parameters must be defined");
            return null;
        }
        string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "version");
        if (string8 != null) {
            string3 = string8;
        }
        if ((string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "format")) != null) {
            string5 = string8;
        }
        if ((string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "srs")) != null) {
            string4 = string8;
        }
        if ((string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "transparent")) != null && string8.trim().equalsIgnoreCase("false")) {
            bl = false;
        }
        if ((string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "exceptions")) != null) {
            string7 = string8;
        }
        if ((string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "bgcolor")) != null) {
            string6 = string8;
        }
        if ((string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "styles")) != null) {
            stringArray2 = ThemeTable.parseCommaSeparatedList(string8);
        }
        if ((node = xMLDOMParser.getElementNode("vendor_specific_parameters")) != null && (serializable = XMLDOMParser.getRealChildNodes(node)) != null) {
            String[][] stringArray4 = new String[2][((ArrayList)serializable).size()];
            for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                Node node2 = (Node)((ArrayList)serializable).get(i);
                String string9 = XMLDOMParser.getElementValue(XMLDOMParser.getSubElement(node2, "name"));
                String string10 = XMLDOMParser.getElementValue(XMLDOMParser.getSubElement(node2, "value"));
                stringArray4[0][i] = string9 != null && string9.trim().length() > 0 ? string9 : "";
                stringArray4[1][i] = string10 != null && string10.trim().length() > 0 ? string10 : "";
            }
            stringArray = stringArray4;
        }
        serializable = new WMSMapThemeDefinition(string, string2, string3, stringArray3, stringArray2, string4, string5, bl, string6, string7, stringArray);
        string8 = ThemeTable.getElementNodeValue(xMLDOMParser, "capabilities_url");
        if (string8 != null && string8.trim().length() > 0 && serializable != null) {
            ((WMSMapThemeDefinition)serializable).setCapabilitiesUrlPrefix(string8.trim());
        }
        return serializable;
    }

    private static String getElementNodeValue(XMLDOMParser xMLDOMParser, String string) {
        String string2;
        if (xMLDOMParser == null || string == null) {
            return null;
        }
        Node node = xMLDOMParser.getElementNode(string);
        if (node != null && (string2 = XMLDOMParser.getElementValue(node)) != null && string2.trim().length() > 0) {
            return string2.trim();
        }
        return null;
    }

    private static String[] parseCommaSeparatedList(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            ArrayList arrayList = Util.splitBy(string.trim(), ",");
            if (arrayList != null && arrayList.size() > 0) {
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }

    public static ThemeDefinition getCustomGeomTheme(String string, XMLDOMParser xMLDOMParser, Node node, CommonThemeAttrs commonThemeAttrs) {
        Object object;
        Serializable serializable;
        String string2 = XMLDOMParser.getAttribute(node, "key_column");
        if (string2 != null && string2.trim().length() > 0) {
            string2 = string2.trim();
            log.finest("key_column specified by user: " + string2 + " for Custom Geom theme.");
        } else {
            string2 = null;
        }
        String string3 = XMLDOMParser.getAttribute(node, "provider_id");
        string3 = string3 != null && string3.trim().length() > 0 ? string3.trim() : null;
        int n = 0;
        String string4 = XMLDOMParser.getAttribute(node, "srid");
        if (string4 != null && string4.trim().length() > 0) {
            try {
                n = Integer.parseInt(string4);
                if (n < 0) {
                    n = 0;
                }
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        Node node2 = XMLDOMParser.getSubElement(node, "parameters");
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        if (node2 != null && (serializable = XMLDOMParser.getSubElements(node2, "parameter")) != null) {
            for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                Node node3 = (Node)((ArrayList)serializable).get(i);
                object = XMLDOMParser.getAttribute(node3, "name");
                String string5 = XMLDOMParser.getAttribute(node3, "value");
                if (object == null || ((String)object).trim().length() <= 0 || string5 == null || string5.trim().length() <= 0) continue;
                properties2.put(((String)object).trim(), string5.trim());
            }
        }
        serializable = new CustomGeomThemeDefinition(string, string3, properties, n, commonThemeAttrs.styleRules, string2);
        ((CustomGeomThemeDefinition)serializable).setRuntimeProperties(properties2);
        if (commonThemeAttrs.identifiableColumns != null) {
            Field[] fieldArray = new Field[commonThemeAttrs.identifiableColumns.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                object = new Field("").setName(commonThemeAttrs.identifiableColumns[i]);
                ((Field)object).setDisplayName(commonThemeAttrs.identifiableNames[i]);
                fieldArray[i] = object;
            }
            ((VectorThemeDefinition)serializable).setIdentifiableColumns(fieldArray);
        }
        commonThemeAttrs.updateThemeDefinitionCustomTags((ThemeDefinition)serializable);
        return serializable;
    }

    private ThemeDefinition getAnnotationTheme(String string, XMLDOMParser xMLDOMParser, Node node) {
        AnnotationTextThemeDefinition annotationTextThemeDefinition = new AnnotationTextThemeDefinition(string, this.mDataSource, this.mBaseTable, this.mSpatialColumn, this.commonAttrs.keyColumn, this.commonAttrs.styleRules, this.mSRID);
        if (this.commonAttrs.identifiableColumns != null) {
            Field[] fieldArray = new Field[this.commonAttrs.identifiableColumns.length];
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = new Field("").setName(this.commonAttrs.identifiableColumns[i]);
                field.setDisplayName(this.commonAttrs.identifiableNames[i]);
                fieldArray[i] = field;
            }
            annotationTextThemeDefinition.setIdentifiableColumns(fieldArray);
        }
        this.commonAttrs.updateThemeDefinitionCustomTags(annotationTextThemeDefinition);
        return annotationTextThemeDefinition;
    }

    public int update() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        this.initUpdateStatement();
        boolean bl = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.mUpdateStatement.setString(4, this.mName.toUpperCase());
        this.mUpdateStatement.setString(1, this.mDescription);
        this.mUpdateStatement.setString(2, this.mBaseTable);
        this.mUpdateStatement.setString(3, this.mSpatialColumn);
        int n = this.mUpdateStatement.executeUpdate();
        Statement statement = this.mConnection.createStatement();
        this.mResultSet = statement.executeQuery("SELECT * FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE");
        if (!this.mResultSet.next()) {
            statement.close();
            this.mConnection.setAutoCommit(bl);
            this.close();
            return n;
        }
        Clob clob = this.mResultSet.getClob("STYLING_RULES");
        try {
            Util.putClobContents(clob, this.mStylingRulesData.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mConnection.commit();
        this.mResultSet.close();
        statement.close();
        this.mConnection.setAutoCommit(bl);
        this.close();
        return n;
    }

    public int insert() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean bl = this.mConnection.getAutoCommit();
        this.initInsertStatement();
        this.mConnection.setAutoCommit(false);
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, this.mDescription);
        this.mInsertStatement.setString(3, this.mBaseTable);
        this.mInsertStatement.setString(4, this.mSpatialColumn);
        int n = this.mInsertStatement.executeUpdate();
        this.mConnection.commit();
        Statement statement = this.mConnection.createStatement();
        this.mResultSet = statement.executeQuery("SELECT * FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE");
        if (!this.mResultSet.next()) {
            statement.close();
            this.mConnection.setAutoCommit(bl);
            this.close();
            return n;
        }
        CLOB cLOB = (CLOB)this.mResultSet.getObject("STYLING_RULES");
        try {
            Util.putClobContents((Clob)cLOB, this.mStylingRulesData.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mConnection.commit();
        this.mResultSet.close();
        statement.close();
        this.mConnection.setAutoCommit(bl);
        this.close();
        return n;
    }

    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int n = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.mName = null;
        this.mDescription = null;
        this.mBaseTable = null;
        this.mSpatialColumn = null;
        this.mSRID = 0;
        this.mStylingRulesData.delete(0, this.mStylingRulesData.length());
        this.close();
        return n;
    }

    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + " VALUES (?, ?, ?, ?,  empty_clob()) ");
        }
    }

    protected void initUpdateStatement() throws SQLException {
        if (this.mUpdateStatement == null) {
            this.mUpdateStatement = this.mConnection.prepareStatement("UPDATE " + this.mTableName + " set DESCRIPTION=?, BASE_TABLE =?,  " + " GEOMETRY_COLUMN = ?, " + " STYLING_RULES = empty_clob() WHERE name = ?");
        }
    }

    protected void updateLocalData() throws SQLException {
        this.mBaseTableOwner = null;
        this.mName = this.mResultSet.getString("NAME");
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        this.mBaseTable = this.mResultSet.getString("BASE_TABLE");
        int n = this.mBaseTable.indexOf(46);
        if (n > 0) {
            this.mBaseTableOwner = this.mBaseTable.substring(0, n);
            this.mBaseTableOwner = this.mBaseTableOwner != null && this.mBaseTableOwner.length() > 0 ? this.mBaseTableOwner.toUpperCase() : null;
        }
        this.mSpatialColumn = this.mResultSet.getString("GEOMETRY_COLUMN");
        Clob clob = this.mResultSet.getClob("STYLING_RULES");
        try {
            this.mStylingRulesData = new StringBuffer(clob.getSubString(1L, (int)clob.length()));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.mStylingRulesData = null;
        }
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSrid(String string) {
        boolean bl;
        String string2 = this.mSpatialColumn.toUpperCase();
        Object object = this.mBaseTableOwner == null ? this.mUser : this.mBaseTableOwner;
        String string3 = this.mBaseTableOwner == null ? this.mBaseTable.toUpperCase() : this.mBaseTable.substring(this.mBaseTable.indexOf(46) + 1).toUpperCase();
        String string4 = "select SRID from ALL_SDO_GEOM_METADATA where TABLE_NAME=? and (COLUMN_NAME=? OR COLUMN_NAME=? or COLUMN_NAME=?) and OWNER=?";
        Statement statement = null;
        try {
            Object object2;
            AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            String string5 = ((String)object).toUpperCase() + "_" + string3 + "_" + string2;
            Hashtable hashtable = abstractDBDataSource.getOwnerTableSridCache();
            if (hashtable != null && (object2 = (Integer)hashtable.get(string5)) != null) {
                this.mSRID = (Integer)object2;
                log.finer("Got SRID for base table " + string3 + " from data source cache");
                boolean bl2 = true;
                return bl2;
            }
            this.mConnection = abstractDBDataSource.getConnection();
            if (this.mBaseTableOwner == null && (object2 = Util.getCurrentSchema(this.mConnection, null)) != null) {
                object = object2;
            }
            statement = this.mConnection.prepareStatement(string4);
            statement.setString(1, string3);
            statement.setString(2, string2);
            statement.setString(3, string2 + ".SPATIALEXTENT");
            statement.setString(4, string2 + ".PRIVATEENVELOPE");
            statement.setString(5, (String)object);
            this.query((PreparedStatement)statement);
            this.mResultSet.next();
            this.mSRID = this.mResultSet.getInt(1);
            hashtable.put(string5, new Integer(this.mSRID));
            bl = true;
        }
        catch (Exception exception) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01023") + " [" + string + "]\n" + string4);
            log.log(Level.SEVERE, exception.getMessage(), exception);
            this.mSRID = 0;
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSridFromUser(String string) {
        log.finer("looking at USER_SDO_GEOM_METADATA for srid of theme: " + string);
        String string2 = this.mSpatialColumn.toUpperCase();
        Statement statement = null;
        try {
            Integer n;
            String string3 = "select SRID from USER_SDO_GEOM_METADATA where TABLE_NAME=? and (COLUMN_NAME=? OR COLUMN_NAME=? or COLUMN_NAME=?)";
            AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(this.mDataSource);
            String string4 = this.mUser.toUpperCase() + "_" + this.mBaseTable.toUpperCase() + "_" + string2;
            Hashtable hashtable = abstractDBDataSource.getOwnerTableSridCache();
            if (hashtable != null && (n = (Integer)hashtable.get(string4)) != null) {
                this.mSRID = n;
                log.finer("Got SRID for base table " + this.mBaseTable.toUpperCase() + " from data source cache");
                return;
            }
            this.mConnection = abstractDBDataSource.getConnection();
            statement = this.mConnection.prepareStatement(string3);
            statement.setString(1, this.mBaseTable.toUpperCase());
            statement.setString(2, string2);
            statement.setString(3, string2 + ".SPATIALEXTENT");
            statement.setString(4, string2 + ".PRIVATEENVELOPE");
            this.query((PreparedStatement)statement);
            this.mResultSet.next();
            this.mSRID = this.mResultSet.getInt(1);
            hashtable.put(string4, new Integer(this.mSRID));
        }
        catch (Exception exception) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01023") + " [" + string + "]");
            log.log(Level.SEVERE, exception.getMessage(), exception);
            this.mSRID = 0;
            return;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.closeQuery();
            }
            catch (Exception exception) {}
        }
        return;
    }
}

