/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.sdovis.DataException;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.NsDpHandler;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.VisContext;
import oracle.sdovis.theme.ThemeDataProducer;
import oracle.sdovis.theme.ThemeDefinition;

public abstract class Theme
implements Cloneable {
    protected ThemeDecorator decorator = new ThemeDecorator();
    protected ThemeDefinition definition = null;
    protected ThemeDataProducer producer = null;
    int[] userClick = null;
    String[] selectList = null;
    String highlightStyleName = null;
    String report = null;
    boolean isClickable = false;
    boolean needLegend = false;
    boolean showLabels = true;
    int windowBuffer = 0;

    public int prepareData(Rectangle2D rectangle2D, VisContext visContext) throws DataException {
        if (visContext.isInterrupted()) {
            return 0;
        }
        return this.getProducer().prepareData(rectangle2D, visContext);
    }

    public void postPreparation(VisContext visContext) {
        this.getProducer().postPreparation(visContext);
    }

    public void abortPreparation() {
        this.getProducer().abort();
    }

    public abstract void destroy();

    public abstract boolean isTextLabelPresent();

    public String getName() {
        return this.definition.getName();
    }

    public void setName(String string) {
        this.definition.setName(string);
    }

    public String getDataSourceName() {
        return this.definition.getDataSourceName();
    }

    public void setDataSourceName(String string) {
        this.definition.setDataSourceName(string);
    }

    public ThemeDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(ThemeDecorator themeDecorator) {
        if (themeDecorator != null) {
            this.decorator = themeDecorator.clone();
        }
    }

    public ThemeDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ThemeDefinition themeDefinition) {
        this.definition = themeDefinition;
    }

    public ThemeDataProducer getProducer() {
        return this.producer;
    }

    public void setProducer(ThemeDataProducer themeDataProducer) {
        this.producer = themeDataProducer;
    }

    public int getSRID() {
        if (this.definition == null) {
            return 0;
        }
        return this.definition.getSrid();
    }

    public void setSRID(int n) {
        if (this.definition != null) {
            this.definition.setSrid(n);
        }
    }

    public int size() {
        return this.getProducer().size();
    }

    public StyledFeatureI getStyledFeature(int n) {
        return this.getProducer().getStyledFeature(n);
    }

    public StyledFeatureI[] getStyledFeatures() {
        return this.getProducer().getStyledFeatures();
    }

    public LocalTheme getSelectedFeaturesAsTheme(Rectangle2D rectangle2D, String string) {
        return this.getProducer().getSelectedFeaturesAsTheme(rectangle2D, string);
    }

    public StyledFeatureI[] getSelectedFeatures(Rectangle2D rectangle2D) {
        return this.getProducer().getSelectedFeatures(rectangle2D);
    }

    public double[] getDataMBR() {
        return this.getProducer().getDataMBR();
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public String[] getRenderingStyles() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getRenderingStyles();
    }

    public String[] getLabelingStyles() {
        if (this.definition == null) {
            return null;
        }
        return this.definition.getLabelingStyles();
    }

    public int getFetchSize() {
        if (this.decorator == null && this.definition == null) {
            return 100;
        }
        if (this.decorator != null && this.decorator.getFetchSize() != 100) {
            return this.decorator.getFetchSize();
        }
        if (this.definition != null) {
            return this.definition.getFetchSize();
        }
        return 100;
    }

    public static NsDpHandler getNsdpHandler(VisContext visContext, String string) {
        if (visContext == null) {
            return null;
        }
        Vector vector = visContext.getNsDpHandlers();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            NsDpHandler nsDpHandler = (NsDpHandler)vector.get(i);
            NsDpInfo nsDpInfo = nsDpHandler.getDef();
            String string2 = nsDpInfo.getTheme();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return nsDpHandler;
        }
        return null;
    }
}

