/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.SRS;
import oracle.sdovis.SRSConstants;
import oracle.sdovis.SRSRowData;
import oracle.sdovis.SRSStore;
import oracle.sdovis.Spheroid;
import oracle.sdovis.util.IntHashtable;
import oracle.sdovis.util.Util;

public class SRSCache {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    protected String mDataSource;
    protected IntHashtable geodeticSrids = new IntHashtable(31);
    protected Hashtable srsList = new Hashtable(41);
    protected SRSStore srsStore = null;
    private static String LSB = "[";
    private static String RSB = "]";

    public SRSCache(String string, SRSStore sRSStore) {
        this.mDataSource = string;
        this.srsList.put(new Integer(0), new SRS());
        this.srsStore = sRSStore;
        if (this.srsStore != null) {
            this.srsStore.loadGeodeticSrids(this.geodeticSrids);
        }
    }

    public SRS get(int n) {
        if (n < 0) {
            return null;
        }
        SRS sRS = (SRS)this.srsList.get(new Integer(n));
        if (sRS != null) {
            return sRS;
        }
        if (this.srsStore == null) {
            log.warning("srsStore is null!");
            return null;
        }
        SRSRowData sRSRowData = this.srsStore.getSRSRowData(n);
        if (sRSRowData == null) {
            log.warning("Cannot find SRS definition for srid " + n + ".");
            return null;
        }
        sRS = this.register(n, sRSRowData, this.mDataSource);
        return sRS;
    }

    public SRS put(int n, SRS sRS) {
        return this.srsList.put(new Integer(n), sRS);
    }

    public void setSrsStore(SRSStore sRSStore) {
        this.srsStore = sRSStore;
    }

    public SRSStore getSrsStore() {
        return this.srsStore;
    }

    private SRS register(int n, SRSRowData sRSRowData, String string) {
        if (n == 0) {
            return null;
        }
        Integer n2 = new Integer(n);
        if (this.srsList.get(n2) != null) {
            return (SRS)this.srsList.get(n2);
        }
        this.parseAndAdd(n, sRSRowData.wktext, string);
        return (SRS)this.srsList.get(n2);
    }

    public static boolean isValidWKT(String string) {
        if (string == null) {
            return true;
        }
        int n = 0;
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c == '[') {
                ++n;
                continue;
            }
            if (c != ']') continue;
            --n;
        }
        return n == 0;
    }

    private void parseAndAdd(int n, String string, String string2) {
        if (string == null || string.length() == 0) {
            if (n == 999999) {
                SRS sRS = new SRS();
                sRS.set(n, null, 1.0, 0, null);
                if (this.srsList.get(new Integer(n)) == null) {
                    log.finer("Registering srs " + n);
                    this.srsList.put(new Integer(n), sRS);
                }
            }
            return;
        }
        SRS sRS = new SRS(string2);
        int n2 = 0;
        String string3 = string.toUpperCase();
        if (string3.indexOf("PROJCS") >= 0) {
            n2 = 2;
        } else if (string3.indexOf("GEOGCS") >= 0) {
            n2 = 1;
            this.geodeticSrids.put(n, (Object)"");
        } else if (string3.indexOf("LOCAL_CS") >= 0) {
            n2 = 3;
        }
        Spheroid spheroid = this.extractSpheroidInfo(string3);
        int n3 = string3.lastIndexOf("UNIT");
        int n4 = 0;
        if (n3 < 0) {
            log.severe("cannot find UNIT parameter in wkt.");
            return;
        }
        double d = 0.0;
        String string4 = null;
        try {
            while (string3.charAt(n3) != '[') {
                ++n3;
            }
            while (string3.charAt(n3) != '\"') {
                ++n3;
            }
            n4 = ++n3;
            while (string3.charAt(n4) != '\"') {
                ++n4;
            }
            string4 = string3.substring(n3, n4);
            if (string4 == null || string4.length() == 0) {
                log.severe("no unit name.");
                return;
            }
            n3 = n4;
            while (string3.charAt(n3) != ',') {
                ++n3;
            }
            n4 = ++n3;
            while (string3.charAt(n4) != ']') {
                ++n4;
            }
            try {
                d = Double.valueOf(string3.substring(n3, n4));
            }
            catch (Exception exception) {
                log.severe("cannot parse unit conversion factor.");
                return;
            }
        }
        catch (Exception exception) {
            log.severe("error parsing UNIT parameter in wkt.");
            return;
        }
        if (n2 == 1) {
            Hashtable hashtable = SRSConstants.getAngularUnitList();
            if (hashtable.get(string4) == null) {
                hashtable.put(string4, new Double(d));
            }
        } else {
            Hashtable hashtable = SRSConstants.getDistanceUnitList();
            if (hashtable.get(string4) == null) {
                hashtable.put(string4, new Double(d));
            }
        }
        sRS.set(n, string4, d, n2, spheroid);
        if (this.srsList.get(new Integer(n)) == null) {
            log.finer("Registering srs " + n + ", isGeodetic=" + sRS.isGeodetic() + ", unit=" + string4);
            this.srsList.put(new Integer(n), sRS);
        }
    }

    private Spheroid extractSpheroidInfo(String string) {
        int n = string.indexOf("GEOGCS");
        if (n < 0) {
            return null;
        }
        if ((n = string.indexOf("SPHEROID", n)) < 0) {
            return null;
        }
        try {
            n = string.indexOf("[", n);
            n = string.indexOf("\"", n);
            int n2 = string.indexOf("\"", n + 1);
            String string2 = string.substring(n + 1, n2);
            n = string.indexOf(",", n2);
            n2 = string.indexOf("]", n);
            String string3 = string.substring(n + 1, n2);
            ArrayList arrayList = Util.splitBy(string3, ", ");
            double d = Double.parseDouble((String)arrayList.get(0));
            double d2 = 1.0 / Double.parseDouble((String)arrayList.get(1));
            Spheroid spheroid = new Spheroid(string2, d, d2);
            return spheroid;
        }
        catch (Exception exception) {
            log.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    public boolean isGeodetic(int n) {
        return this.geodeticSrids.get(n) != null;
    }
}

