/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.xdo.generator.graphics2d.XDOGraphics2D;

public class PDFTTFcache {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    static String ttfTempDir = null;
    static Hashtable<String, String> ttfRegs = new Hashtable();

    public static void setTemporaryDirectory(String string) {
        ttfTempDir = string == null ? null : (!string.endsWith("" + File.separator) ? string + File.separator : string);
    }

    public static String getTemporaryDirectory() {
        return ttfTempDir;
    }

    public static void cleanCache() {
        File file;
        ttfRegs.clear();
        if (ttfTempDir != null && (file = new File(ttfTempDir)) != null && file.isDirectory()) {
            try {
                File[] fileArray = file.listFiles();
                if (fileArray != null && fileArray.length > 0) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (fileArray[i].isDirectory() || !fileArray[i].canWrite() || !fileArray[i].getName().endsWith(".ttf")) continue;
                        fileArray[i].delete();
                    }
                }
            }
            catch (Exception exception) {
                log.warning("Unable to delete all temporary TTFs.\n" + exception.getMessage());
            }
        }
    }

    public static void cleanCacheForDataSource(String string) {
        File file;
        File[] fileArray;
        if (string == null) {
            return;
        }
        ArrayList<File[]> arrayList = new ArrayList<File[]>();
        Enumeration<String> enumeration = ttfRegs.keys();
        while (enumeration.hasMoreElements()) {
            fileArray = enumeration.nextElement();
            String string2 = ttfRegs.get(fileArray);
            if (!string2.startsWith(string.toLowerCase() + "_")) continue;
            arrayList.add(fileArray);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ttfRegs.remove(arrayList.get(i));
        }
        if (ttfTempDir != null && (file = new File(ttfTempDir)) != null && file.isDirectory()) {
            try {
                fileArray = file.listFiles();
                if (fileArray != null && fileArray.length > 0) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        if (fileArray[i].isDirectory() || !fileArray[i].canWrite() || !fileArray[i].getName().startsWith(string.toLowerCase() + "_") || !fileArray[i].getName().endsWith(".ttf")) continue;
                        fileArray[i].delete();
                    }
                }
            }
            catch (Exception exception) {
                log.warning("Unable to delete all temporary TTFs for data source [" + string + "].\n" + exception.getMessage());
            }
        }
    }

    public static String getFilePathForTTF(String string) {
        if (string == null) {
            return null;
        }
        return ttfRegs.get(string);
    }

    public static boolean registerTTF(String string, String string2, XDOGraphics2D xDOGraphics2D) {
        if (string == null || ttfTempDir == null || string2 == null || xDOGraphics2D == null) {
            return false;
        }
        ttfRegs.put(string, ttfTempDir + string2);
        log.finest("TTF font [" + string + "] registered with temporary file [" + ttfTempDir + string2 + "] for PDF graphics.");
        xDOGraphics2D.registerFont(string, ttfTempDir + string2);
        return true;
    }
}

