/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.theme.ThemeDecorator;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.BaseMap;
import oracle.sdovis.BaseMap2;
import oracle.sdovis.BasemapStore;
import oracle.sdovis.RSBundle;
import oracle.sdovis.ds.DSUtil;
import oracle.sdovis.util.DBTable;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import oracle.sql.CLOB;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapTable
extends DBTable
implements BasemapStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String DEF_TABLE_NAME = "USER_SDO_MAPS";
    String mName;
    String mDescription;
    StringBuffer mDefinition;

    public MapTable(String string, String string2) {
        super(string, string2);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getMapDefinition() {
        return this.mDefinition == null ? null : this.mDefinition.toString();
    }

    public void setMapDefinition(String string) {
        this.mDefinition = new StringBuffer(string);
    }

    public int update() throws SQLException {
        String string = this.mName;
        StringBuffer stringBuffer = this.mDefinition;
        this.delete();
        this.mName = string;
        this.mDefinition = stringBuffer;
        int n = this.insert();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        boolean bl = this.mConnection.getAutoCommit();
        this.mConnection.setAutoCommit(false);
        this.initInsertStatement();
        this.mInsertStatement.setString(1, this.mName.toUpperCase());
        this.mInsertStatement.setString(2, this.mDescription);
        int n = this.mInsertStatement.executeUpdate();
        this.mConnection.commit();
        Statement statement = this.mConnection.createStatement();
        this.mResultSet = statement.executeQuery("SELECT * FROM " + this.mTableName + " WHERE name='" + this.mName.toUpperCase() + "' FOR UPDATE");
        if (!this.mResultSet.next()) {
            log.warning("Unable to select " + this.mName.toUpperCase() + " from table " + this.mTableName + " for update definition.");
        }
        CLOB cLOB = (CLOB)this.mResultSet.getObject("DEFINITION");
        try {
            Util.putClobContents((Clob)cLOB, this.mDefinition.toString());
            this.mConnection.commit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
            this.close();
        }
        return n;
    }

    public int delete() throws SQLException {
        this.mConnection = DSUtil.getDBConnection(this.mDataSource, null);
        this.initDeleteStatement();
        this.mDeleteStatement.setString(1, this.mName.toUpperCase());
        int n = this.mDeleteStatement.executeUpdate();
        this.mConnection.commit();
        this.close();
        this.mName = null;
        this.mDefinition = null;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseMap loadBasemapDefinition(String string) {
        try {
            this.query("select * from " + this.mTableName + " where name='" + string.toUpperCase() + "'");
            if (!this.next()) {
                BaseMap baseMap = null;
                return baseMap;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            BaseMap baseMap = null;
            return baseMap;
        }
        finally {
            try {
                this.closeQuery();
            }
            catch (SQLException sQLException) {}
        }
        BaseMap baseMap = null;
        XMLDOMParser xMLDOMParser = new XMLDOMParser();
        if (!xMLDOMParser.parse(this.mDefinition.toString())) {
            log.severe(RSBundle.getMsg("MAPVIEWER-01013"));
            return null;
        }
        Document document = xMLDOMParser.getDocument();
        if (document == null) {
            return null;
        }
        Node node = xMLDOMParser.getElementNode("map_definition");
        String string2 = XMLDOMParser.getAttribute(node, "type");
        if (string2 != null && "2".equals(string2)) {
            baseMap = new BaseMap2();
            MapTable.parseType2(xMLDOMParser, (BaseMap2)baseMap);
        } else {
            baseMap = new BaseMap();
            NodeList nodeList = xMLDOMParser.getElementNodes("theme");
            BaseMap.PredefinedThemeDesc[] predefinedThemeDescArray = new BaseMap.PredefinedThemeDesc[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                BaseMap.PredefinedThemeDesc predefinedThemeDesc = new BaseMap.PredefinedThemeDesc();
                predefinedThemeDesc.name = XMLDOMParser.getAttribute(node2, "name");
                predefinedThemeDesc.mods = MapTable.extractThemeModifiers(xMLDOMParser, node2);
                predefinedThemeDescArray[i] = predefinedThemeDesc;
            }
            baseMap.setThemes(predefinedThemeDescArray);
        }
        baseMap.setCustomTags(MapTable.parseCustomTags(xMLDOMParser));
        baseMap.setName(this.mName);
        baseMap.setDescription(this.mDescription);
        try {
            baseMap.setInitX(Double.parseDouble(XMLDOMParser.getAttribute(node, "initx")));
        }
        catch (Exception exception) {
            baseMap.setInitX(0.0);
        }
        try {
            baseMap.setInitY(Double.parseDouble(XMLDOMParser.getAttribute(node, "inity")));
        }
        catch (Exception exception) {
            baseMap.setInitY(0.0);
        }
        xMLDOMParser.close();
        return baseMap;
    }

    public static void parseType2(XMLDOMParser xMLDOMParser, BaseMap2 baseMap2) {
        NodeList nodeList = xMLDOMParser.getElementNodes("zoom_level");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new RuntimeException("invalid type 2 basemap definition.");
        }
        Vector<BaseMap2.ZoomLevel> vector = new Vector<BaseMap2.ZoomLevel>();
        Vector<BaseMap.PredefinedThemeDesc> vector2 = new Vector<BaseMap.PredefinedThemeDesc>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(57);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            BaseMap2.ZoomLevel zoomLevel = new BaseMap2.ZoomLevel();
            try {
                zoomLevel.id = Integer.parseInt(XMLDOMParser.getAttribute(node, "id"));
            }
            catch (Exception exception) {
                zoomLevel.id = i;
            }
            try {
                zoomLevel.srid = Integer.parseInt(XMLDOMParser.getAttribute(node, "srid"));
            }
            catch (Exception exception) {
                zoomLevel.srid = 0;
            }
            try {
                zoomLevel.scale = Double.parseDouble(XMLDOMParser.getAttribute(node, "scale"));
            }
            catch (Exception exception) {
                zoomLevel.scale = 0.0;
            }
            ArrayList arrayList = XMLDOMParser.getSubElements(node, "theme");
            BaseMap.PredefinedThemeDesc[] predefinedThemeDescArray = new BaseMap.PredefinedThemeDesc[arrayList.size()];
            for (int j = 0; j < arrayList.size(); ++j) {
                Node node2 = (Node)arrayList.get(j);
                BaseMap.PredefinedThemeDesc predefinedThemeDesc = new BaseMap.PredefinedThemeDesc();
                predefinedThemeDesc.name = XMLDOMParser.getAttribute(node2, "name");
                predefinedThemeDesc.mods = MapTable.extractThemeModifiers(xMLDOMParser, node2);
                ThemeDecorator cfr_ignored_0 = predefinedThemeDesc.mods;
                predefinedThemeDesc.mods.minScale = Double.POSITIVE_INFINITY;
                ThemeDecorator cfr_ignored_1 = predefinedThemeDesc.mods;
                predefinedThemeDesc.mods.maxScale = Double.NEGATIVE_INFINITY;
                ThemeDecorator cfr_ignored_2 = predefinedThemeDesc.mods;
                predefinedThemeDesc.mods.minLabelScale = Double.POSITIVE_INFINITY;
                ThemeDecorator cfr_ignored_3 = predefinedThemeDesc.mods;
                predefinedThemeDesc.mods.maxLabelScale = Double.NEGATIVE_INFINITY;
                predefinedThemeDescArray[j] = predefinedThemeDesc;
                String string = hashtable.put(predefinedThemeDesc.name.toUpperCase(), "v");
                if (string != null) continue;
                vector2.add(predefinedThemeDesc);
            }
            zoomLevel.themes = predefinedThemeDescArray;
            vector.add(zoomLevel);
        }
        baseMap2.setZoomLevels(vector.toArray(new BaseMap2.ZoomLevel[nodeList.getLength()]));
        baseMap2.setThemes(vector2.toArray(new BaseMap.PredefinedThemeDesc[vector2.size()]));
    }

    public static ThemeDecorator extractThemeModifiers(XMLDOMParser xMLDOMParser, Node node) {
        Object object;
        ArrayList arrayList;
        ThemeDecorator themeDecorator = new ThemeDecorator();
        String string = XMLDOMParser.getAttribute(node, "min_scale");
        if (string != null && string.length() > 0) {
            try {
                themeDecorator.setMinScale(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLDOMParser.getAttribute(node, "max_scale")) != null && string.length() > 0) {
            try {
                themeDecorator.setMaxScale(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLDOMParser.getAttribute(node, "label_min_scale")) != null && string.length() > 0) {
            try {
                themeDecorator.setLabelMinScale(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLDOMParser.getAttribute(node, "label_max_scale")) != null && string.length() > 0) {
            try {
                themeDecorator.setLabelMaxScale(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLDOMParser.getAttribute(node, "scale_mode")) != null && string.trim().length() > 0 && string.trim().equalsIgnoreCase("RATIO")) {
            themeDecorator.setScaleType("RATIO");
        }
        if ((string = XMLDOMParser.getAttribute(node, "info_columns")) != null && string.length() > 0 && (arrayList = Util.splitBy(string, ",\n")).size() > 0) {
            object = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = ((String)arrayList.get(i)).trim();
            }
            themeDecorator.setInfoColumns((String[])object);
        }
        if ((string = XMLDOMParser.getAttribute(node, "label_always_on")) != null && string.equalsIgnoreCase("TRUE")) {
            themeDecorator.setLabelAlwaysOn(true);
        }
        if ((string = XMLDOMParser.getAttribute(node, "fast_unpickle")) != null && string.equalsIgnoreCase("TRUE")) {
            themeDecorator.setFastUnpickle(true);
        } else if (string != null && string.equalsIgnoreCase("FALSE")) {
            themeDecorator.setFastUnpickle(false);
        }
        string = XMLDOMParser.getAttribute(node, "upside_down_labels");
        if (string != null && string.equalsIgnoreCase("TRUE")) {
            themeDecorator.upsideDownLabels = true;
        }
        if ((string = XMLDOMParser.getAttribute(node, "min_dist")) != null) {
            try {
                themeDecorator.setMinDistBetweenPoints(Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = XMLDOMParser.getAttribute(node, "fixed_svglabel")) != null && string.equalsIgnoreCase("true")) {
            themeDecorator.setFixedSVGLabel(true);
        }
        if ((string = XMLDOMParser.getAttribute(node, "selectable_in_svg")) != null && string.equalsIgnoreCase("true")) {
            themeDecorator.setSelectableInSVG(true);
        }
        if ((string = XMLDOMParser.getAttribute(node, "onclick")) != null) {
            themeDecorator.setOnClickInSVG(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "onmouseover")) != null) {
            themeDecorator.setOnMouseOverInSVG(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "onmousemove")) != null) {
            themeDecorator.setOnMouseMoveInSVG(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "onmouseout")) != null) {
            themeDecorator.setOnMouseOutInSVG(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "workspace_name")) != null && string.length() > 0) {
            themeDecorator.setWorkspaceName(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "workspace_savepoint")) == null || string.length() == 0) {
            string = XMLDOMParser.getAttribute(node, "workspace_savedpoint");
        }
        if (string != null && string.length() > 0) {
            themeDecorator.setWorkspaceSavedPoint(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "workspace_date")) != null && string.length() > 0) {
            themeDecorator.setWorkspaceDate(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "workspace_date_format")) != null && string.length() > 0) {
            themeDecorator.setWorkspaceDateFormat(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "workspace_date_nlsparam")) != null && string.length() > 0) {
            themeDecorator.setWorkspaceDateNlsParam(string);
        }
        if ((string = XMLDOMParser.getAttribute(node, "workspace_date_tswtz")) != null && string.length() > 0 && string.equalsIgnoreCase("true")) {
            themeDecorator.setWorkspaceDateTsWtz(true);
        }
        string = XMLDOMParser.getAttribute(node, "minimum_pixels");
        int n = 0;
        if (string != null && string.trim().length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        themeDecorator.setMinimumFeatureSizePx(n);
        object = XMLDOMParser.getAttribute(node, "transparency");
        float f = 1.0f;
        if (object != null && ((String)object).trim().length() > 0) {
            try {
                f = Float.parseFloat((String)object);
                if (f < 0.0f || f > 1.0f) {
                    f = 1.0f;
                }
            }
            catch (Exception exception) {
                f = 1.0f;
            }
        }
        themeDecorator.setOpacity(f);
        String string2 = XMLDOMParser.getAttribute(node, "simplify_shapes");
        if (string2 != null && string2.trim().length() > 0 && "false".equalsIgnoreCase(string2)) {
            themeDecorator.setSimplifiedShapes(false);
        }
        string = XMLDOMParser.getAttribute(node, "fetch_size");
        int n2 = 100;
        if (string != null && string.trim().length() > 0) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n2 = 100;
            }
        }
        themeDecorator.setFetchSize(n2);
        string = XMLDOMParser.getAttribute(node, "timeout");
        long l = 0L;
        if (string != null && string.trim().length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                l = 0L;
            }
        }
        themeDecorator.setRequestTimeout(l);
        string = XMLDOMParser.getAttribute(node, "no_repetitive_label");
        if (string != null && string.trim().length() > 0 && "true".equalsIgnoreCase(string)) {
            themeDecorator.noRepetitiveLabel = true;
        }
        if ((string = XMLDOMParser.getAttribute(node, "allow_naked_points")) != null && string.trim().length() > 0 && "false".equalsIgnoreCase(string)) {
            themeDecorator.allowNakedPoints = false;
        }
        return themeDecorator;
    }

    public static Hashtable parseCustomTags(XMLDOMParser xMLDOMParser) {
        NodeList nodeList;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (xMLDOMParser == null) {
            return hashtable;
        }
        Node node = xMLDOMParser.getElementNode("custom_tags");
        if (node != null && (nodeList = xMLDOMParser.getElementNodes("tag")) != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                NodeList nodeList2 = node2.getChildNodes();
                if (nodeList2 == null) continue;
                String string = null;
                String string2 = null;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    if (node3 != null && node3.getNodeName().equalsIgnoreCase("name")) {
                        string = node3.getChildNodes().item(0).getNodeValue();
                        if (string == null || string.trim().length() >= 1) continue;
                        string = null;
                        continue;
                    }
                    if (node3 == null || !node3.getNodeName().equalsIgnoreCase("value") || (string2 = node3.getChildNodes().item(0).getNodeValue()) == null || string2.trim().length() >= 1) continue;
                    string2 = null;
                }
                if (string == null || string2 == null) continue;
                hashtable.put(string.trim(), string2.trim());
            }
        }
        return hashtable;
    }

    protected void initDeleteStatement() throws SQLException {
        if (this.mDeleteStatement == null) {
            this.mDeleteStatement = this.mConnection.prepareStatement("DELETE FROM " + this.mTableName + " WHERE name = ?");
        }
    }

    protected void initInsertStatement() throws SQLException {
        if (this.mInsertStatement == null) {
            this.mInsertStatement = this.mConnection.prepareStatement("INSERT INTO " + this.mTableName + " VALUES(?,  ?, empty_clob())");
        }
    }

    protected void initUpdateStatement() throws SQLException {
    }

    protected void updateLocalData() throws SQLException {
        Object var1_1 = null;
        this.mName = this.mResultSet.getString("NAME");
        this.mDescription = this.mResultSet.getString("DESCRIPTION");
        Clob clob = this.mResultSet.getClob("DEFINITION");
        try {
            this.mDefinition = new StringBuffer(clob.getSubString(1L, (int)clob.length()));
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.mDefinition = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBasemapNames() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = DSUtil.getDBConnection(this.mDataSource, null);
            if (connection == null) {
                ArrayList<String> arrayList3 = arrayList2;
                return arrayList3;
            }
            arrayList2 = new ArrayList<String>();
            String string = "SELECT name from USER_SDO_MAPS order by name";
            statement = connection.prepareStatement(string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString(1));
            }
            arrayList = arrayList2;
        }
        catch (Exception exception) {
            log.severe(exception.getMessage());
            ArrayList<String> arrayList4 = arrayList2;
            return arrayList4;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                log.severe(sQLException.getMessage());
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                log.severe(sQLException.getMessage());
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return arrayList;
    }
}

