/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.LegendColumn;
import oracle.sdovis.LegendEntry;
import oracle.sdovis.StyleCache;
import oracle.sdovis.Theme;
import oracle.sdovis.ThemeCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.AbstractDBDataSource;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.theme.ThemeDefinition;

public class Legend {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    public static final String NORTH = "NORTH";
    public static final String EAST = "EAST";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String NORTH_EAST = "NORTH_EAST";
    public static final String SOUTH_EAST = "SOUTH_EAST";
    public static final String SOUTH_WEST = "SOUTH_WEST";
    public static final String NORTH_WEST = "NORTH_WEST";
    public static final String CENTER = "CENTER";
    public static final int S = 0;
    public static final int M = 1;
    public static final int L = 2;
    Vector cols = new Vector(2);
    String[] POSITIONS = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTH_EAST", "SOUTH_EAST", "SOUTH_WEST", "NORTH_WEST", "CENTER"};
    LegendColumn currentLC = null;
    Color background = Color.white;
    Color borderColor = Color.black;
    Color textColor = Color.black;
    int borderWidth = 1;
    String position = "SOUTH_WEST";
    Point location = null;
    String fontFamily = null;
    public int profile = 1;
    int offset_x = 10;
    int offset_y = 10;
    String[] themes = null;

    public Legend() {
    }

    public Legend(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid legend profile");
        }
        this.profile = n;
    }

    public int getOffsetX() {
        return this.offset_x;
    }

    public void setOffsetX(int n) {
        this.offset_x = n;
    }

    public int getOffsetY() {
        return this.offset_y;
    }

    public void setOffsetY(int n) {
        this.offset_y = n;
    }

    public void setProfile(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid legend profile");
        }
        this.profile = n;
    }

    public int getProfile() {
        return this.profile;
    }

    public void setPositionHint(String string) {
        boolean bl = false;
        for (int i = 0; i < this.POSITIONS.length; ++i) {
            if (!this.POSITIONS[i].equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.position = string;
        } else {
            log.severe("Invalid legend positioning hint given.");
        }
    }

    public String getPositionHint() {
        return this.position;
    }

    public int getNumColumns() {
        return this.cols.size();
    }

    public LegendColumn getCurrentLegendColumn() {
        return this.currentLC;
    }

    public LegendColumn addColumn() {
        this.currentLC = new LegendColumn(this);
        this.cols.add(this.currentLC);
        return this.currentLC;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = Math.max(1, n);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public LegendEntry setTitle(String string) {
        return this.currentLC.setTitle(string);
    }

    public void addEntry(LegendEntry legendEntry) {
        this.currentLC.addEntry(legendEntry);
    }

    public LegendEntry addStyle(String string, String string2) {
        return this.currentLC.addStyle(string, string2);
    }

    public void addSeparator() {
        this.currentLC.addSeparator();
    }

    public void deleteAllEntries() {
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn legendColumn = (LegendColumn)this.cols.get(i);
            legendColumn.deleteAllEntries();
        }
    }

    public void deleteAllColumns() {
        this.cols.removeAllElements();
    }

    public void destroy() {
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn legendColumn = (LegendColumn)this.cols.get(i);
            legendColumn.destroy();
        }
        this.cols.removeAllElements();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void prepare(VisContext visContext) {
        if (this.cols.size() > 0) {
            for (int i = 0; i < this.cols.size(); ++i) {
                LegendColumn legendColumn = (LegendColumn)this.cols.get(i);
                legendColumn.prepare(visContext);
            }
        } else if (this.themes != null && this.themes.length > 0 && visContext != null && visContext.getMasterDataSourceName() != null) {
            StyleCache styleCache = DSManager.getStyleCache(visContext.getMasterDataSourceName());
            if (styleCache == null) {
                return;
            }
            ThemeCache themeCache = null;
            AbstractDBDataSource abstractDBDataSource = (AbstractDBDataSource)DSManager.get(visContext.getMasterDataSourceName());
            themeCache = abstractDBDataSource.getThemeCache();
            if (themeCache == null) {
                return;
            }
            ArrayList<ThemeDefinition> arrayList = new ArrayList<ThemeDefinition>();
            for (int i = 0; i < this.themes.length; ++i) {
                Theme theme = null;
                ThemeDefinition themeDefinition = null;
                if (visContext.getThemeList() != null) {
                    for (int j = 0; j < visContext.getThemeList().size(); ++j) {
                        Theme theme2 = visContext.getThemeList().getTheme(j);
                        if (!theme2.getName().equalsIgnoreCase(this.themes[i])) continue;
                        theme = theme2;
                        themeDefinition = theme.getDefinition();
                        break;
                    }
                }
                if (themeDefinition == null) {
                    themeDefinition = themeCache.getOrLoadThemeDefinition(this.themes[i]);
                }
                if (themeDefinition == null) continue;
                arrayList.add(themeDefinition);
            }
            if (arrayList.size() > 0) {
                ThemeDefinition[] themeDefinitionArray = new ThemeDefinition[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    themeDefinitionArray[i] = (ThemeDefinition)arrayList.get(i);
                }
                this.prepare(themeDefinitionArray, visContext);
            }
        }
    }

    public void prepare(ThemeDefinition[] themeDefinitionArray, VisContext visContext) {
        if (themeDefinitionArray == null || themeDefinitionArray.length == 0 || visContext == null) {
            return;
        }
        StyleCache styleCache = DSManager.getStyleCache(visContext.getMasterDataSourceName());
        if (styleCache == null) {
            return;
        }
        this.cols.clear();
        int n = 5;
        int n2 = 0;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> hashtable2 = new Hashtable<String, Boolean>();
        Hashtable<String, Boolean> hashtable3 = new Hashtable<String, Boolean>();
        for (int i = 0; i < themeDefinitionArray.length; ++i) {
            Object object;
            String string;
            Object object2;
            hashtable.clear();
            String[] stringArray = themeDefinitionArray[i].getRenderingStyles();
            if (stringArray == null || stringArray.length == 0) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                Style style = styleCache.get(stringArray[j]);
                if (style == null || (!(style instanceof AdvancedStyle) ? hashtable.get(stringArray[j].toUpperCase()) != null : hashtable2.get(stringArray[j].toUpperCase()) != null)) continue;
                if (n2 == n) {
                    n2 = 0;
                    this.addColumn();
                }
                if (this.getCurrentLegendColumn() == null) {
                    this.addColumn();
                }
                object2 = themeDefinitionArray[i].getName();
                string = themeDefinitionArray[i].getDescription();
                if (style instanceof AdvancedStyle) {
                    object2 = null;
                } else if (string != null && string.trim().length() > 0) {
                    object2 = string.trim();
                }
                object = this.addStyle(stringArray[j], (String)object2);
                ((LegendEntry)object).addTab();
                ++n2;
                if (style instanceof AdvancedStyle) {
                    hashtable2.put(stringArray[j].toUpperCase(), new Boolean(true));
                    continue;
                }
                hashtable.put(stringArray[j].toUpperCase(), new Boolean(true));
            }
            String[] stringArray2 = themeDefinitionArray[i].getLabelingStyles();
            if (stringArray2 == null || stringArray2.length == 0) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                object2 = styleCache.get(stringArray2[j]);
                if (object2 == null || object2 instanceof StyleText || hashtable3.get(stringArray2[j].toUpperCase()) != null || object2 instanceof AdvancedStyle && hashtable2.get(stringArray2[j].toUpperCase()) != null) continue;
                if (n2 == n) {
                    n2 = 0;
                    this.addColumn();
                }
                if (this.getCurrentLegendColumn() == null) {
                    this.addColumn();
                }
                string = stringArray2[j];
                object = object2.getModel().getDescription();
                if (object2 instanceof AdvancedStyle) {
                    string = null;
                } else if (object != null && ((String)object).trim().length() > 0) {
                    string = ((String)object).trim();
                }
                LegendEntry legendEntry = this.addStyle(stringArray2[j], string);
                legendEntry.addTab();
                ++n2;
                hashtable3.put(stringArray2[j].toUpperCase(), new Boolean(true));
            }
        }
        if (this.getNumColumns() < 1) {
            return;
        }
        this.prepare(visContext);
    }

    public Rectangle2D computeMBR() {
        int n = 3;
        double d = n;
        double d2 = n;
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn legendColumn = (LegendColumn)this.cols.get(i);
            Rectangle2D rectangle2D = legendColumn.getMBR();
            d += rectangle2D.getWidth() + (double)n;
            if (!(d2 < rectangle2D.getHeight())) continue;
            d2 = rectangle2D.getHeight();
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d2 + (double)(2 * n));
        return double_;
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        int n3 = 3;
        Rectangle2D rectangle2D = this.computeMBR();
        if (this.background != null) {
            graphics2D.setColor(this.background);
            graphics2D.fillRect(n, n2, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        graphics2D.translate(n, n2);
        graphics2D.setColor(this.textColor);
        int n4 = n3;
        int n5 = n3;
        for (int i = 0; i < this.cols.size(); ++i) {
            LegendColumn legendColumn = (LegendColumn)this.cols.get(i);
            legendColumn.paint(graphics2D, n4, n5);
            Rectangle2D rectangle2D2 = legendColumn.getMBR();
            n4 = (int)((double)n4 + (rectangle2D2.getWidth() + (double)n3));
        }
        graphics2D.setColor(this.borderColor);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.translate(-n, -n2);
        graphics2D.drawRect(n, n2, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public Rectangle2D getMBR() {
        return this.computeMBR();
    }

    public LegendColumn getColumn(int n) {
        if (n >= this.cols.size()) {
            return null;
        }
        return (LegendColumn)this.cols.get(n);
    }

    public void setLocation(Point point) {
        this.location = point;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setThemes(String[] stringArray) {
        this.themes = stringArray;
    }

    public String[] getThemes() {
        return this.themes;
    }
}

