/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.StyleStore;
import oracle.sdovis.ds.FileDataSource;
import oracle.sdovis.style.Style;

public class FileStyleStore
implements StyleStore {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private String dataSource = null;
    private FileDataSource fds = null;

    public FileStyleStore(String string) {
        this.dataSource = string;
        this.fds = FileDataSource.getDataSource(this.dataSource);
        if (this.fds == null) {
            throw new IllegalArgumentException("Local data source environment not initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleRowData getStyleData(String string) {
        DatabaseEntry databaseEntry;
        SerialBinding serialBinding;
        block5: {
            Database database = this.fds.getStyleDb();
            Database database2 = this.fds.getClassDb();
            StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
            serialBinding = new SerialBinding((ClassCatalog)storedClassCatalog, StyleRowData.class);
            DatabaseEntry databaseEntry2 = new DatabaseEntry(string.toUpperCase().getBytes("UTF-8"));
            databaseEntry = new DatabaseEntry();
            OperationStatus operationStatus = database.get(null, databaseEntry2, databaseEntry, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.SUCCESS) break block5;
            log.fine("No style named " + string + " found.");
            StyleRowData styleRowData = null;
            Object var11_12 = null;
            return styleRowData;
        }
        try {
            StyleRowData styleRowData = (StyleRowData)serialBinding.entryToObject(databaseEntry);
            Object var11_13 = null;
            return styleRowData;
        }
        catch (Exception exception) {
            try {
                log.log(Level.SEVERE, "Exception getting style '" + string + "'.", exception);
                serialBinding = null;
                Object var11_14 = null;
                return serialBinding;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                throw throwable;
            }
        }
    }

    public Style getStyleObject(String string) throws DataException {
        if (string == null) {
            throw new IllegalArgumentException("style name cannot be null.");
        }
        StyleRowData styleRowData = this.getStyleData(string);
        if (styleRowData == null) {
            throw new DataException("cannot get style definition for '" + string + "'.");
        }
        try {
            Style style = StyleFactory.createStyleObject(StyleUtils.getTypeCodeFromName(styleRowData.type), styleRowData.definition, styleRowData.image);
            if (style != null) {
                style.getModel().setDescription(styleRowData.description);
            }
            return style;
        }
        catch (Exception exception) {
            log.warning(exception.getMessage());
            return null;
        }
    }

    public TruetypeFont getTTFont(String string) throws DataException {
        return null;
    }

    public void open() throws Exception {
        int n = 0;
        log.info("MapViewer file-based styles store opened with " + n + " style objects.");
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public long removeAllStyles() {
        return this.fds.truncateDb(FileDataSource.STYLE_DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getStyleNames(String string) {
        Object object;
        Cursor cursor = null;
        ArrayList<Object> arrayList = new ArrayList<Object>(250);
        Database database = this.fds.getStyleDb();
        Database database2 = this.fds.getClassDb();
        try {
            try {
                StoredClassCatalog storedClassCatalog = new StoredClassCatalog(database2);
                SerialBinding serialBinding = new SerialBinding((ClassCatalog)storedClassCatalog, StyleRowData.class);
                cursor = database.openCursor(null, null);
                DatabaseEntry databaseEntry = new DatabaseEntry();
                DatabaseEntry databaseEntry2 = new DatabaseEntry();
                while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    object = new String(databaseEntry.getData(), "UTF-8");
                    if (string != null) {
                        StyleRowData styleRowData = (StyleRowData)serialBinding.entryToObject(databaseEntry2);
                        if (!string.equalsIgnoreCase(styleRowData.type)) continue;
                        arrayList.add(object);
                        continue;
                    }
                    arrayList.add(object);
                }
                object = arrayList;
                Object var13_14 = null;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "cannot list styles.", exception);
                List list = null;
                Object var13_15 = null;
                try {
                    if (cursor == null) return list;
                    cursor.close();
                    return list;
                }
                catch (Exception exception3) {
                    log.warning("error closing cursor." + exception3.getMessage());
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {}
            catch (Exception exception2) {
                log.warning("error closing cursor." + exception2.getMessage());
                throw throwable;
            }
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            log.warning("error closing cursor." + exception.getMessage());
            return object;
        }
        if (cursor == null) return object;
        cursor.close();
        return object;
    }

    public static void main(String[] stringArray) throws Exception {
        FileDataSource fileDataSource = new FileDataSource("mvdemo", "/tmp/mvdemo");
        FileStyleStore fileStyleStore = new FileStyleStore("mvdemo");
        fileStyleStore.getStyleNames("COLOR");
        fileDataSource.close();
    }
}

