/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Image;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.ImageUtils;

class CustomLogo {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private WeakReference logo;
    private String file;
    private String positionHint;
    public static final String NORTH = "NORTH";
    public static final String EAST = "EAST";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String NORTH_EAST = "NORTH_EAST";
    public static final String SOUTH_EAST = "SOUTH_EAST";
    public static final String SOUTH_WEST = "SOUTH_WEST";
    public static final String NORTH_WEST = "NORTH_WEST";
    public static final String CENTER = "CENTER";
    static String[] POSITIONS = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTH_EAST", "SOUTH_EAST", "SOUTH_WEST", "NORTH_WEST", "CENTER"};

    public CustomLogo(String string, String string2) {
        Image image;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("no such logo image file.");
        }
        URL uRL = null;
        try {
            if (string.toUpperCase().startsWith("HTTP:")) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("malformed logo image url.");
        }
        Image image2 = image = uRL != null ? ImageUtils.blockingLoad(uRL) : ImageUtils.blockingLoad(string);
        if (image == null) {
            log.severe("cannot load logo image from " + string);
            throw new IllegalArgumentException("no such logo image file.");
        }
        this.positionHint = string2 == null || !this.validPosition(string2) ? SOUTH_EAST : string2;
        this.file = string;
        this.logo = new WeakReference<Image>(image);
    }

    private boolean validPosition(String string) {
        for (int i = 0; i < POSITIONS.length; ++i) {
            if (!POSITIONS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public Image getLogo() {
        Image image = (Image)this.logo.get();
        if (image != null) {
            return image;
        }
        URL uRL = null;
        try {
            if (this.file.toUpperCase().startsWith("HTTP:")) {
                uRL = new URL(this.file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            log.log(Level.SEVERE, malformedURLException.getMessage(), malformedURLException);
            return null;
        }
        log.finest("reloading logo image...");
        Image image2 = image = uRL != null ? ImageUtils.blockingLoad(uRL) : ImageUtils.blockingLoad(this.file);
        if (image != null) {
            this.logo = new WeakReference<Image>(image);
            return image;
        }
        log.severe("cannot load logo image from " + this.file);
        return null;
    }

    public String getPositionHint() {
        return this.positionHint;
    }
}

