/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;
import oracle.mapviewer.share.stylex.PieSliceInfo;

public class VariablePieChartStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = 4360058909925091486L;
    SizeDefinition2D pieSize = new SizeDefinition2D(10.0, 5.0, null);
    int numSlices = 0;
    PieSliceInfo[] pieSlices = null;

    public VariablePieChartStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
    }

    public VariablePieChartStyleModel(BucketSeries bucketSeries) {
        this.type = 9;
        this.bucketSeries = bucketSeries;
    }

    public Object clone() {
        VariablePieChartStyleModel variablePieChartStyleModel = (VariablePieChartStyleModel)super.clone();
        variablePieChartStyleModel.setSizes(this.pieSize);
        return variablePieChartStyleModel;
    }

    public void setSizes(SizeDefinition2D sizeDefinition2D) {
        this.pieSize = new SizeDefinition2D(10.0, 5.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.pieSize.setSize(sizeDefinition2D.getWidth(), sizeDefinition2D.getHeight());
        this.pieSize.setUnit(sizeDefinition2D.getUnit());
    }

    public String getTypeName() {
        return "ADVANCED";
    }

    public String toXMLString() {
        String string = "";
        if (this.pieSize.getUnit() != null && !this.pieSize.getUnit().equalsIgnoreCase("px")) {
            string = this.pieSize.getUnit();
        }
        String string2 = StyleUtils.getUSLocaleFormat(this.pieSize.getWidth());
        string2 = StyleUtils.cleanDecimalZeros(string2, 1);
        String string3 = StyleUtils.getUSLocaleFormat(this.pieSize.getHeight());
        string3 = StyleUtils.cleanDecimalZeros(string3, 1);
        if (this.pieSize.isPixelUnit()) {
            string2 = String.valueOf((int)this.pieSize.getWidth());
            string3 = String.valueOf((int)this.pieSize.getHeight());
        }
        String string4 = "<?xml version=\"1.0\" ?>\n";
        string4 = string4 + "<AdvancedStyle>\n  <VariablePieChartStyle";
        string4 = string4 + " startradius=\"" + string2 + string + "\"";
        string4 = string4 + " increment=\"" + string3 + string + "\">\n";
        if (this.pieSlices != null) {
            for (int i = 0; i < this.pieSlices.length; ++i) {
                PieSliceInfo pieSliceInfo = this.pieSlices[i];
                string4 = string4 + "       <PieSlice name=\"" + XMLUtil.replaceXMLEntities(pieSliceInfo.name) + "\"";
                if (pieSliceInfo.color != null) {
                    string4 = string4 + " color=\"" + StyleUtils.getHexidecimalString(pieSliceInfo.color) + "\"";
                }
                string4 = string4 + " />\n";
            }
        }
        string4 = string4 + this.bucketSeries.toXMLString();
        string4 = string4 + "\n   </VariablePieChartStyle>\n</AdvancedStyle>\n";
        return string4;
    }

    public void setStartRadius(int n) {
        this.pieSize.setWidth(n);
    }

    public void setStartRadius(double d) {
        this.pieSize.setWidth(d);
    }

    public int getStartRadius() {
        return (int)this.pieSize.getWidth();
    }

    public double getDoubleStartRadius() {
        return this.pieSize.getWidth();
    }

    public void setIncrement(int n) {
        this.pieSize.setHeight(n);
    }

    public void setIncrement(double d) {
        this.pieSize.setHeight(d);
    }

    public int getIncrement() {
        return (int)this.pieSize.getHeight();
    }

    public double getDoubleIncrement() {
        return this.pieSize.getHeight();
    }

    public String getRadiusUnit() {
        return this.pieSize.getUnit();
    }

    public void setRadiusUnit(String string) {
        this.pieSize.setUnit(string);
    }

    public void setNumSlices(int n) {
        this.numSlices = n;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public void setPieSlices(PieSliceInfo[] pieSliceInfoArray) {
        this.pieSlices = pieSliceInfoArray;
        this.numSlices = pieSliceInfoArray == null ? 0 : pieSliceInfoArray.length;
    }

    public PieSliceInfo[] getPieSlices() {
        return this.pieSlices;
    }

    public PieSliceInfo getPieSlice(int n) {
        return this.pieSlices != null ? this.pieSlices[n] : null;
    }
}

