/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.mapviewer.share.stylex.CollectionBucket;
import oracle.mapviewer.share.stylex.RangedBucket;

public class BucketSeries
implements Cloneable,
Serializable {
    static final long serialVersionUID = -7483215977788946390L;
    public static final int SCHEME_CUSTOM = 1;
    public static final int SCHEME_EQUAL_INTERVAL = 2;
    public static final int SCHEME_NATURAL_BREAKS = 3;
    public static final int SCHEME_QUANTILE = 4;
    public final int SCHEME_STANDARD_DEVIATION = 5;
    ArrayList buckets = new ArrayList();
    int scheme = 1;
    String defaultRenderStyleName;
    String defaultLabelStyleName;
    transient Object defaultRenderStyle;
    transient Object defaultLabelStyle;

    public Object clone() {
        try {
            BucketSeries bucketSeries = (BucketSeries)super.clone();
            if (this.buckets != null && this.buckets.size() > 0) {
                bucketSeries.buckets = new ArrayList();
                for (int i = 0; i < this.buckets.size(); ++i) {
                    Bucket bucket = (Bucket)this.buckets.get(i);
                    bucketSeries.buckets.add(bucket.clone());
                }
            }
            return bucketSeries;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void setBuckets(ArrayList arrayList) {
        this.buckets = arrayList;
    }

    public ArrayList getBuckets() {
        return this.buckets;
    }

    public void setScheme(int n) {
        this.scheme = n;
    }

    public int getScheme() {
        return this.scheme;
    }

    public void add(Bucket bucket) {
        if (bucket == null) {
            return;
        }
        this.buckets.add(bucket);
        this.setLastBucket();
    }

    public void remove(Bucket bucket) {
        if (bucket == null) {
            return;
        }
        this.buckets.remove(bucket);
        this.setLastBucket();
    }

    public void removeAll() {
        this.buckets.clear();
    }

    public int size() {
        return this.buckets.size();
    }

    public Bucket getBucketById(String string) {
        if (this.buckets == null || this.buckets.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket bucket = (Bucket)this.buckets.get(i);
            if (!bucket.getBucketId().equalsIgnoreCase(string)) continue;
            return bucket;
        }
        return null;
    }

    public Bucket getBucket(Field field) {
        if (this.buckets == null || this.buckets.size() == 0) {
            return null;
        }
        Bucket bucket = null;
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket bucket2 = (Bucket)this.buckets.get(i);
            if (bucket2.isDefaultBucket()) {
                bucket = bucket2;
            }
            if (field == null || !bucket2.contains(field)) continue;
            return bucket2;
        }
        return bucket;
    }

    public int getBucketIndex(Field field) {
        if (this.buckets == null || this.buckets.size() == 0) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket bucket = (Bucket)this.buckets.get(i);
            if (bucket.isDefaultBucket()) {
                n = i;
            }
            if (field == null || !bucket.contains(field)) continue;
            return i;
        }
        return n;
    }

    public Bucket getBucket(int n) {
        return (Bucket)this.buckets.get(n);
    }

    public void setDefaultRenderStyleName(String string) {
        this.defaultRenderStyleName = string;
    }

    public String getDefaultRenderStyleName() {
        return this.defaultRenderStyleName;
    }

    public void setDefaultLabelStyleName(String string) {
        this.defaultLabelStyleName = string;
    }

    public String getDefaultLabelStyleName() {
        return this.defaultLabelStyleName;
    }

    public void setDefaultRenderStyle(Object object) {
        this.defaultRenderStyle = object;
    }

    public Object getDefaultRenderStyle() {
        return this.defaultRenderStyle;
    }

    public void setDefaultLabelStyle(Object object) {
        this.defaultLabelStyle = object;
    }

    public Object getDefaultLabelStyle() {
        return this.defaultLabelStyle;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        switch (this.scheme) {
            case 2: {
                int n;
                int n2;
                stringBuffer.append("    <Buckets ");
                int n3 = this.buckets.size();
                RangedBucket rangedBucket = (RangedBucket)this.buckets.get(0);
                RangedBucket rangedBucket2 = (RangedBucket)this.buckets.get(n3 - 1);
                Field field = rangedBucket.getLowerBoundValue();
                Field field2 = rangedBucket2.getUpperBoundValue();
                stringBuffer.append("low=\"").append(field.toString()).append("\" high=\"").append(field2.toString()).append("\"");
                stringBuffer.append(" nbuckets=\"").append(n3).append("\"");
                boolean bl = false;
                int n4 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (((Bucket)this.buckets.get(n2)).getRenderStyleName() == null) continue;
                    bl = true;
                    n4 = n2;
                    break;
                }
                if (bl) {
                    String string = ((Bucket)this.buckets.get(n4)).getRenderStyleName();
                    stringBuffer.append(" styles=\"").append(XMLUtil.replaceXMLEntities(string));
                    for (n = n4 + 1; n < this.buckets.size(); ++n) {
                        if (((Bucket)this.buckets.get(n)).getRenderStyleName() == null) continue;
                        String string2 = ((Bucket)this.buckets.get(n)).getRenderStyleName();
                        stringBuffer.append(",").append(XMLUtil.replaceXMLEntities(string2));
                    }
                    stringBuffer.append("\"");
                }
                n2 = 0;
                n = 0;
                for (int i = 0; i < this.buckets.size(); ++i) {
                    if (((Bucket)this.buckets.get(i)).getLabelStyleName() == null) continue;
                    n2 = 1;
                    n = i;
                    break;
                }
                if (n2 != 0) {
                    String string = ((Bucket)this.buckets.get(n)).getLabelStyleName();
                    stringBuffer.append(" label_styles=\"").append(XMLUtil.replaceXMLEntities(string));
                    for (int i = n + 1; i < this.buckets.size(); ++i) {
                        if (((Bucket)this.buckets.get(i)).getLabelStyleName() == null) continue;
                        String string3 = ((Bucket)this.buckets.get(i)).getLabelStyleName();
                        stringBuffer.append(",").append(XMLUtil.replaceXMLEntities(string3));
                    }
                    stringBuffer.append("\"");
                }
                if (this.defaultRenderStyleName != null) {
                    stringBuffer.append(" default_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultRenderStyleName)).append("\"");
                }
                if (this.defaultLabelStyleName != null) {
                    stringBuffer.append(" default_label_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultLabelStyleName)).append("\"");
                }
                stringBuffer.append("/>");
                return stringBuffer.toString();
            }
            case 1: {
                if (this.buckets.size() == 0) {
                    return "";
                }
                Bucket bucket = (Bucket)this.buckets.get(0);
                if (bucket instanceof RangedBucket) {
                    return this.getRangedBucketsXml(stringBuffer);
                }
                if (bucket instanceof CollectionBucket) {
                    return this.getCollectionBucketsXml(stringBuffer);
                }
                return "Unknown bucket type.";
            }
        }
        return "Unsupported bucket classification scheme.";
    }

    private String getRangedBucketsXml(StringBuffer stringBuffer) {
        stringBuffer.append("    <Buckets");
        if (this.defaultRenderStyleName != null) {
            stringBuffer.append(" default_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultRenderStyleName)).append("\"");
        }
        if (this.defaultLabelStyleName != null) {
            stringBuffer.append(" default_label_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultLabelStyleName)).append("\"");
        }
        stringBuffer.append(">\n");
        for (int i = 0; i < this.buckets.size(); ++i) {
            Field field;
            Field field2;
            stringBuffer.append("      <RangedBucket seq=\"").append(i).append("\"");
            RangedBucket rangedBucket = (RangedBucket)this.buckets.get(i);
            if (rangedBucket.getBucketLabel() != null) {
                stringBuffer.append(" label=\"").append(XMLUtil.replaceXMLEntities(rangedBucket.getBucketLabel())).append("\"");
            }
            if ((field2 = rangedBucket.getLowerBoundValue()) != null) {
                stringBuffer.append(" low=\"").append(field2.toString()).append("\"");
            }
            if ((field = rangedBucket.getUpperBoundValue()) != null) {
                stringBuffer.append(" high=\"").append(field.toString()).append("\"");
            }
            if (rangedBucket.getRenderStyleName() != null) {
                stringBuffer.append(" style=\"").append(XMLUtil.replaceXMLEntities(rangedBucket.getRenderStyleName())).append("\"");
            }
            if (rangedBucket.getLabelStyleName() != null) {
                stringBuffer.append(" label_style=\"").append(XMLUtil.replaceXMLEntities(rangedBucket.getLabelStyleName())).append("\"");
            }
            stringBuffer.append(" />\n");
        }
        stringBuffer.append("    </Buckets>");
        return stringBuffer.toString();
    }

    private String getCollectionBucketsXml(StringBuffer stringBuffer) {
        stringBuffer.append("    <Buckets");
        if (this.defaultRenderStyleName != null) {
            stringBuffer.append(" default_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultRenderStyleName)).append("\"");
        }
        if (this.defaultLabelStyleName != null) {
            stringBuffer.append(" default_label_style=\"").append(XMLUtil.replaceXMLEntities(this.defaultLabelStyleName)).append("\"");
        }
        stringBuffer.append(">\n");
        for (int i = 0; i < this.buckets.size(); ++i) {
            stringBuffer.append("      <CollectionBucket seq=\"").append(i).append("\"");
            CollectionBucket collectionBucket = (CollectionBucket)this.buckets.get(i);
            if (collectionBucket.getBucketLabel() != null) {
                stringBuffer.append(" label=\"").append(XMLUtil.replaceXMLEntities(collectionBucket.getBucketLabel())).append("\"");
            }
            if (collectionBucket.keepWhiteSpace()) {
                stringBuffer.append(" keep_white_space=\"true\"");
            }
            if (collectionBucket.getType() != null) {
                stringBuffer.append(" type=\"" + XMLUtil.replaceXMLEntities(collectionBucket.getType().toLowerCase()) + "\"");
            }
            if (!collectionBucket.getDelimiter().equals(",")) {
                stringBuffer.append(" delimiter=\"").append(XMLUtil.replaceXMLEntities(collectionBucket.getDelimiter())).append("\"");
            }
            if (collectionBucket.getRenderStyleName() != null) {
                stringBuffer.append(" style=\"").append(XMLUtil.replaceXMLEntities(collectionBucket.getRenderStyleName())).append("\"");
            }
            if (collectionBucket.getLabelStyleName() != null) {
                stringBuffer.append(" label_style=\"").append(XMLUtil.replaceXMLEntities(collectionBucket.getLabelStyleName())).append("\"");
            }
            stringBuffer.append(">");
            Collection collection = collectionBucket.getMembers();
            if (collection != null) {
                int n = 0;
                for (Field field : collection) {
                    if (n == 0) {
                        stringBuffer.append(XMLUtil.replaceXMLEntities(field.toString()));
                    } else {
                        stringBuffer.append(XMLUtil.replaceXMLEntities(collectionBucket.getDelimiter() + field.toString()));
                    }
                    ++n;
                }
            }
            stringBuffer.append("</CollectionBucket>\n");
        }
        stringBuffer.append("    </Buckets>");
        return stringBuffer.toString();
    }

    public void setupEqualRangedBuckets(double d, double d2, int n) {
        this.buckets.clear();
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        for (int i = 0; i < n; ++i) {
            RangedBucket rangedBucket = new RangedBucket("" + i, new Field(d4), new Field(d4 + d3));
            this.buckets.add(rangedBucket);
            d4 += d3;
            if (i != n - 1) continue;
            rangedBucket.setAsLastBucket(true);
        }
        this.scheme = 2;
    }

    public void setupEqualRangedBuckets(long l, long l2, int n) {
        this.buckets.clear();
        long l3 = (l2 - l) / (long)n;
        long l4 = l;
        for (int i = 0; i < n; ++i) {
            RangedBucket rangedBucket = new RangedBucket("" + i, new Field(l4), new Field(l4 + l3));
            this.buckets.add(rangedBucket);
            l4 += l3;
            if (i != n - 1) continue;
            rangedBucket.setAsLastBucket(true);
        }
        this.scheme = 2;
    }

    public double getEqualRangedMinValue() {
        if (this.scheme != 2 || this.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            RangedBucket rangedBucket = (RangedBucket)this.getBucket(i);
            Field field = rangedBucket.getLowerBoundValue();
            if (field == null || field.getValue() == null) continue;
            String string = field.getValue().toString();
            double d2 = Double.parseDouble(string);
            if (i == 0) {
                d = d2;
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getEqualRangedMaxValue() {
        if (this.scheme != 2 || this.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            RangedBucket rangedBucket = (RangedBucket)this.getBucket(i);
            Field field = rangedBucket.getUpperBoundValue();
            if (field == null || field.getValue() == null) continue;
            String string = field.getValue().toString();
            double d2 = Double.parseDouble(string);
            if (i == 0) {
                d = d2;
                continue;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private void setLastBucket() {
        Cloneable cloneable;
        int n;
        if (this.size() < 1) {
            return;
        }
        for (n = 0; n < this.size(); ++n) {
            cloneable = this.getBucket(n);
            ((Bucket)cloneable).setAsLastBucket(false);
        }
        if (this.scheme != 1) {
            return;
        }
        n = -1;
        cloneable = null;
        Field field = null;
        for (int i = 0; i < this.size(); ++i) {
            Bucket bucket = this.getBucket(i);
            if (!(bucket instanceof RangedBucket)) continue;
            Field field2 = ((RangedBucket)bucket).getLowerBoundValue();
            Field field3 = ((RangedBucket)bucket).getUpperBoundValue();
            if (cloneable == null && field == null) {
                n = i;
                cloneable = field2;
                field = field3;
                continue;
            }
            if (field == null || field3 != null && (field2 == null || cloneable != null && ((Field)cloneable).compareTo(field2) > 0 || field.compareTo(field2) > 0)) continue;
            n = i;
            cloneable = field2;
            field = field3;
        }
        if (n > -1) {
            Bucket bucket = this.getBucket(n);
            bucket.setAsLastBucket(true);
        }
    }
}

