/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class LineStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 5937298410199783196L;
    Color fillColor = null;
    SizeDefinition lineWidth = new SizeDefinition(1.0, null);
    int cap = 1;
    int join = 1;
    float[] wingDashPattern = null;
    String wingDashPatternUnit = null;
    SizeDefinition wingWidth = new SizeDefinition(0.0, null);
    float wingPhase = 0.0f;
    Color wingColor = null;
    Color centerLineColor = null;
    float[] centerLineDashPattern = null;
    String centerLineDashPatternUnit = null;
    float centerLinePhase = 0.0f;
    SizeDefinition centerLineWidth = new SizeDefinition(1.0, null);
    boolean hashMarkEnabled = false;
    Color hashMarkColor = Color.black;
    float hashMarkGap = 8.5f;
    float hashMarkLength = 3.0f;
    float hashMarkWidth = 1.0f;
    String hashMarkUnit = null;
    double markerPosition = 0.75;
    String markerStyleName = null;
    SizeDefinition2D markerSize = new SizeDefinition2D(-1.0, -1.0, null);
    public static String MULTIMARKER_NONE = "NONE";
    public static String MULTIMARKER_ALONG_PATH = "ALONG_PATH";
    public static String MULTIMARKER_END_POINTS = "END_POINTS";
    public static String MULTIMARKER_ALL_POINTS = "ALL_POINTS";
    String multipleMarkerPosition = MULTIMARKER_NONE;
    boolean cased = false;
    String[] mpMarkerStyles = null;
    SizeDefinition mpStartingOffset = new SizeDefinition(0.0, null);
    SizeDefinition mpInterval = new SizeDefinition(5.0, null);
    SizeDefinition2D mpMarkerSize = new SizeDefinition2D(-1.0, -1.0, null);

    public LineStyleModel() {
        this.type = 3;
    }

    public Object clone() {
        LineStyleModel lineStyleModel = (LineStyleModel)super.clone();
        if (this.centerLineDashPattern != null) {
            lineStyleModel.centerLineDashPattern = (float[])this.centerLineDashPattern.clone();
        }
        if (this.wingDashPattern != null) {
            lineStyleModel.wingDashPattern = (float[])this.wingDashPattern.clone();
        }
        lineStyleModel.setLineWidth(this.lineWidth);
        lineStyleModel.setCenterLineWidth(this.centerLineWidth);
        lineStyleModel.setWingWidth(this.wingWidth);
        lineStyleModel.setMarkerSize(this.markerSize);
        lineStyleModel.setMpStartingOffsetSize(this.mpStartingOffset);
        lineStyleModel.setMpIntervalSize(this.mpInterval);
        lineStyleModel.setMpMarkerSize(this.mpMarkerSize);
        return lineStyleModel;
    }

    public String getTypeName() {
        return "LINE";
    }

    public String toXMLString() {
        String string;
        String string2;
        String string3;
        String string4 = this.cased ? " cased=\"true\" " : "";
        String string5 = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n<desc></desc>\n<g class=\"line\" " + string4 + "style=\"";
        if (this.fillColor != null) {
            string5 = string5 + "fill:" + StyleUtils.getHexidecimalString(this.fillColor);
            if (this.fillColor.getAlpha() > 0 && this.fillColor.getAlpha() <= 254) {
                string5 = string5 + ";fill-opacity:" + this.fillColor.getAlpha();
            }
        }
        if (this.lineWidth.getValue() > 0.0) {
            string3 = "";
            if (this.lineWidth.getUnit() != null && !this.lineWidth.getUnit().equalsIgnoreCase("px")) {
                string3 = this.lineWidth.getUnit();
            }
            string2 = StyleUtils.getUSLocaleFormat(this.lineWidth.getValue());
            String string6 = StyleUtils.cleanDecimalZeros(string2, 1);
            if (this.lineWidth.isPixelUnit()) {
                string6 = StyleUtils.cleanDecimalZeros(string2, 0);
            }
            string5 = this.fillColor != null ? string5 + ";stroke-width:" + string6 + string3 : string5 + "stroke-width:" + string6 + string3;
        }
        if (this.cap != 1) {
            if (this.cap == 2) {
                string5 = string5 + ";stroke-linecap:SQUARE";
            } else if (this.cap == 0) {
                string5 = string5 + ";stroke-linecap:BUTT";
            }
        }
        if (this.join != 1) {
            if (this.join == 2) {
                string5 = string5 + ";stroke-linejoin:BEVEL";
            } else if (this.join == 0) {
                string5 = string5 + ";stroke-linejoin:MITER";
            }
        }
        if (this.markerStyleName != null) {
            String string7;
            string3 = "";
            string2 = "";
            if (this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_END_POINTS) || this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_ALL_POINTS)) {
                string3 = "";
                string2 = this.multipleMarkerPosition.toLowerCase();
            } else {
                if (this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_ALONG_PATH)) {
                    string3 = ";multiple-marker:true";
                }
                string2 = "" + this.markerPosition;
            }
            double d = this.markerSize.getWidth();
            double d2 = this.markerSize.getHeight();
            String string8 = "";
            if (this.markerSize.getUnit() != null && !this.markerSize.getUnit().equalsIgnoreCase("px")) {
                string8 = this.markerSize.getUnit();
            }
            if (d == d2) {
                string7 = StyleUtils.getUSLocaleFormat(d);
                string7 = StyleUtils.cleanDecimalZeros(string7, 1);
                if (this.markerSize.isPixelUnit()) {
                    string7 = String.valueOf((int)d);
                }
                string5 = string5 + ";marker-name:" + XMLUtil.replaceXMLEntities(this.markerStyleName) + ";marker-position:" + string2 + ";marker-size:" + string7 + string8;
            } else {
                string7 = StyleUtils.getUSLocaleFormat(d);
                string7 = StyleUtils.cleanDecimalZeros(string7, 1);
                if (this.markerSize.isPixelUnit()) {
                    string7 = String.valueOf((int)d);
                }
                String string9 = StyleUtils.getUSLocaleFormat(d2);
                string9 = StyleUtils.cleanDecimalZeros(string9, 1);
                if (this.markerSize.isPixelUnit()) {
                    string9 = String.valueOf((int)d2);
                }
                string5 = string5 + ";marker-name:" + XMLUtil.replaceXMLEntities(this.markerStyleName) + ";marker-position:" + string2 + ";marker-width:" + string7 + string8 + ";marker-height:" + string9 + string8;
            }
            string5 = string5 + string3;
        }
        string5 = string5 + "\">\n";
        int n = 0;
        if (this.wingColor != null) {
            ++n;
            string5 = string5 + "<line class=\"parallel\" style=\"";
            string5 = string5 + "fill:" + StyleUtils.getHexidecimalString(this.wingColor);
            if (this.wingColor.getAlpha() < 255) {
                string5 = string5 + ";fill-opacity:" + this.wingColor.getAlpha();
            }
            string2 = "";
            if (this.wingWidth.getUnit() != null && !this.wingWidth.getUnit().equalsIgnoreCase("px")) {
                string2 = this.wingWidth.getUnit();
            }
            String string10 = StyleUtils.getUSLocaleFormat(this.wingWidth.getValue());
            string = StyleUtils.cleanDecimalZeros(string10, 1);
            if (this.wingWidth.isPixelUnit()) {
                string = StyleUtils.cleanDecimalZeros(string10, 0);
            }
            string5 = this.wingWidth.getValue() > 0.0 ? string5 + ";stroke-width:" + string + string2 + "\"" : string5 + ";stroke-width:1" + string2 + "\"";
            if (this.wingDashPattern != null && this.wingDashPattern.length > 0) {
                string2 = "";
                if (this.wingDashPatternUnit != null && !this.wingDashPatternUnit.equalsIgnoreCase("px")) {
                    string2 = this.wingDashPatternUnit;
                }
                string5 = string5 + " dash=\"" + this.arrayToString(this.wingDashPattern) + string2 + "\"";
            }
            string5 = string5 + " />\n";
        }
        if (this.centerLineColor != null) {
            ++n;
            string5 = string5 + "<line class=\"base\" style=\"";
            string5 = string5 + "fill:" + StyleUtils.getHexidecimalString(this.centerLineColor);
            if (this.centerLineColor.getAlpha() < 255) {
                string5 = string5 + ";fill-opacity:" + this.centerLineColor.getAlpha();
            }
            string2 = "";
            if (this.centerLineWidth.getUnit() != null && !this.centerLineWidth.getUnit().equalsIgnoreCase("px")) {
                string2 = this.centerLineWidth.getUnit();
            }
            String string11 = StyleUtils.getUSLocaleFormat(this.centerLineWidth.getValue());
            string = StyleUtils.cleanDecimalZeros(string11, 1);
            if (this.centerLineWidth.isPixelUnit()) {
                string = StyleUtils.cleanDecimalZeros(string11, 0);
            }
            string5 = this.centerLineWidth.getValue() > 0.0 ? string5 + ";stroke-width:" + string + string2 + "\"" : string5 + ";stroke-width:1" + string2 + "\"";
            if (this.centerLineDashPattern != null && this.centerLineDashPattern.length > 0) {
                string2 = "";
                if (this.centerLineDashPatternUnit != null && !this.centerLineDashPatternUnit.equalsIgnoreCase("px")) {
                    string2 = this.centerLineDashPatternUnit;
                }
                string5 = string5 + " dash=\"" + this.arrayToString(this.centerLineDashPattern) + string2 + "\"";
            }
            string5 = string5 + " />\n";
        }
        if (this.hashMarkEnabled) {
            ++n;
            string5 = string5 + "<line class=\"hashmark\" style=\"";
            if (this.hashMarkColor != null) {
                string5 = string5 + "fill:" + StyleUtils.getHexidecimalString(this.hashMarkColor);
                if (this.hashMarkColor.getAlpha() < 255) {
                    string5 = string5 + ";fill-opacity:" + this.hashMarkColor.getAlpha();
                }
            } else {
                string5 = string5 + "fill:black";
            }
            string2 = "";
            if (this.hashMarkUnit != null && !this.hashMarkUnit.equalsIgnoreCase("px")) {
                string2 = this.hashMarkUnit;
            }
            string5 = string5 + "\" ";
            string5 = string5 + " dash=\"" + this.hashMarkGap + "," + this.hashMarkLength + string2 + "\"";
            string5 = string5 + " />\n";
        }
        if (n == 0) {
            string5 = string5 + "<line class=\"base\" />";
        }
        if (this.mpMarkerStyles != null) {
            string5 = string5 + "<marker-pattern ";
            string2 = "";
            if (this.mpMarkerSize.getWidth() > 0.0) {
                if (this.mpMarkerSize.getUnit() != null && !this.mpMarkerSize.getUnit().equalsIgnoreCase("px")) {
                    string2 = this.mpMarkerSize.getUnit();
                }
                String string12 = StyleUtils.getUSLocaleFormat(this.mpMarkerSize.getWidth());
                string12 = StyleUtils.cleanDecimalZeros(string12, 1);
                if (this.mpMarkerSize.isPixelUnit()) {
                    string12 = String.valueOf((int)this.mpMarkerSize.getWidth());
                }
                string5 = string5 + "width=\"" + string12 + string2 + "\" ";
            }
            if (this.mpMarkerSize.getHeight() > 0.0) {
                if (this.mpMarkerSize.getUnit() != null && !this.mpMarkerSize.getUnit().equalsIgnoreCase("px")) {
                    string2 = this.mpMarkerSize.getUnit();
                }
                String string13 = StyleUtils.getUSLocaleFormat(this.mpMarkerSize.getHeight());
                string13 = StyleUtils.cleanDecimalZeros(string13, 1);
                if (this.mpMarkerSize.isPixelUnit()) {
                    string13 = String.valueOf((int)this.mpMarkerSize.getHeight());
                }
                string5 = string5 + "height=\"" + string13 + string2 + "\" ";
            }
            string2 = "";
            if (this.mpStartingOffset.getUnit() != null && !this.mpStartingOffset.getUnit().equalsIgnoreCase("px")) {
                string2 = this.mpStartingOffset.getUnit();
            }
            String string14 = StyleUtils.getUSLocaleFormat(this.mpStartingOffset.getValue());
            string14 = StyleUtils.cleanDecimalZeros(string14, 1);
            if (this.mpStartingOffset.isPixelUnit()) {
                string14 = String.valueOf((int)this.mpStartingOffset.getValue());
            }
            string5 = string5 + "offset=\"" + string14 + string2 + "\" ";
            string2 = "";
            if (this.mpInterval.getUnit() != null && !this.mpInterval.getUnit().equalsIgnoreCase("px")) {
                string2 = this.mpInterval.getUnit();
            }
            string = StyleUtils.getUSLocaleFormat(this.mpInterval.getValue());
            string = StyleUtils.cleanDecimalZeros(string, 1);
            if (this.mpInterval.isPixelUnit()) {
                string = String.valueOf((int)this.mpInterval.getValue());
            }
            string5 = string5 + "interval=\"" + string + string2 + "\">\n";
            for (int i = 0; i < this.mpMarkerStyles.length; ++i) {
                string5 = string5 + "  <marker>" + this.mpMarkerStyles[i].toUpperCase() + "</marker>\n";
            }
            string5 = string5 + "</marker-pattern>\n";
        }
        string5 = string5 + "</g>\n</svg>\n";
        return string5;
    }

    private String arrayToString(float[] fArray) {
        if (fArray == null || fArray.length == 0) {
            return "";
        }
        String string = "" + fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            string = string + "," + fArray[i];
        }
        return string;
    }

    public void setOverallStyle(Color color, float f, int n, int n2) {
        this.fillColor = color;
        this.lineWidth.setValue(f);
        this.cap = n;
        this.join = n2;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineWidth(SizeDefinition sizeDefinition) {
        this.lineWidth = new SizeDefinition(1.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.lineWidth.setValue(sizeDefinition.getValue());
        this.lineWidth.setUnit(sizeDefinition.getUnit());
    }

    public void setLineWidth(float f) {
        this.lineWidth.setValue(f);
    }

    public float getLineWidth() {
        return (float)this.lineWidth.getValue();
    }

    public void setLineWidthUnit(String string) {
        this.lineWidth.setUnit(string);
    }

    public String getLineWidthUnit() {
        return this.lineWidth.getUnit();
    }

    public SizeDefinition getLineWidthSize() {
        return this.lineWidth;
    }

    public void setCap(int n) {
        this.cap = n;
    }

    public int getCap() {
        return this.cap;
    }

    public void setJoin(int n) {
        this.join = n;
    }

    public int getJoin() {
        return this.join;
    }

    public void setWingLineStyle(Color color, float f, float[] fArray, float f2) {
        this.wingColor = color;
        this.wingWidth.setValue(f);
        this.wingDashPattern = fArray;
        this.wingPhase = f2;
    }

    public void setWingDashPattern(float[] fArray) {
        this.wingDashPattern = fArray;
    }

    public float[] getWingDashPattern() {
        return this.wingDashPattern;
    }

    public String getWingDashPatternUnit() {
        return this.wingDashPatternUnit;
    }

    public void setWingDashPatternUnit(String string) {
        this.wingDashPatternUnit = string;
    }

    public void setWingWidth(SizeDefinition sizeDefinition) {
        this.wingWidth = new SizeDefinition(0.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.wingWidth.setValue(sizeDefinition.getValue());
        this.wingWidth.setUnit(sizeDefinition.getUnit());
    }

    public void setWingWidth(float f) {
        this.wingWidth.setValue(f);
    }

    public float getWingWidth() {
        return (float)this.wingWidth.getValue();
    }

    public String getWingWidthUnit() {
        return this.wingWidth.getUnit();
    }

    public void setWingWidthUnit(String string) {
        this.wingWidth.setUnit(string);
    }

    public SizeDefinition getWingWidthSize() {
        return this.wingWidth;
    }

    public void setWingPhase(float f) {
        this.wingPhase = f;
    }

    public float getWingPhase() {
        return this.wingPhase;
    }

    public void setWingColor(Color color) {
        this.wingColor = color;
    }

    public Color getWingColor() {
        return this.wingColor;
    }

    public void setCenterLineStyle(Color color, float f, float[] fArray, float f2) {
        this.centerLineColor = color;
        this.centerLineWidth.setValue(f);
        this.centerLineDashPattern = fArray;
        this.centerLinePhase = f2;
    }

    public void setCenterLineColor(Color color) {
        this.centerLineColor = color;
    }

    public Color getCenterLineColor() {
        return this.centerLineColor;
    }

    public void setCenterLineDashPattern(float[] fArray) {
        this.centerLineDashPattern = fArray;
    }

    public float[] getCenterLineDashPattern() {
        return this.centerLineDashPattern;
    }

    public String getCenterLineDashPatternUnit() {
        return this.centerLineDashPatternUnit;
    }

    public void setCenterLineDashPatternUnit(String string) {
        this.centerLineDashPatternUnit = string;
    }

    public void setCenterLinePhase(float f) {
        this.centerLinePhase = f;
    }

    public float getCenterLinePhase() {
        return this.centerLinePhase;
    }

    public void setCenterLineWidth(SizeDefinition sizeDefinition) {
        this.centerLineWidth = new SizeDefinition(1.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.centerLineWidth.setValue(sizeDefinition.getValue());
        this.centerLineWidth.setUnit(sizeDefinition.getUnit());
    }

    public void setCenterLineWidth(float f) {
        this.centerLineWidth.setValue(f);
    }

    public float getCenterLineWidth() {
        return (float)this.centerLineWidth.getValue();
    }

    public String getCenterLineWidthUnit() {
        return this.centerLineWidth.getUnit();
    }

    public void setCenterLineWidthUnit(String string) {
        this.centerLineWidth.setUnit(string);
    }

    public SizeDefinition getCenterLineWidthSize() {
        return this.centerLineWidth;
    }

    public void setHashMarkStyle(Color color, float f, float f2, float f3) {
        this.hashMarkColor = color;
        this.hashMarkWidth = f;
        this.hashMarkLength = f2;
        this.hashMarkGap = f3;
    }

    public void setHashMarkEnabled(boolean bl) {
        this.hashMarkEnabled = bl;
    }

    public boolean isHashMarkEnabled() {
        return this.hashMarkEnabled;
    }

    public void setHashMarkColor(Color color) {
        this.hashMarkColor = color;
    }

    public Color getHashMarkColor() {
        return this.hashMarkColor;
    }

    public void setHashMarkGap(float f) {
        this.hashMarkGap = f;
    }

    public float getHashMarkGap() {
        return this.hashMarkGap;
    }

    public void setHashMarkLength(float f) {
        this.hashMarkLength = f;
    }

    public float getHashMarkLength() {
        return this.hashMarkLength;
    }

    public void setHashMarkWidth(float f) {
        this.hashMarkWidth = f;
    }

    public float getHashMarkWidth() {
        return this.hashMarkWidth;
    }

    public String getHashMarkUnit() {
        return this.hashMarkUnit;
    }

    public void setHashMarkUnit(String string) {
        this.hashMarkUnit = string;
    }

    public void setMarkerPosition(double d) {
        this.markerPosition = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
    }

    public double getMarkerPosition() {
        return this.markerPosition;
    }

    public void setMarkerStyleName(String string) {
        this.markerStyleName = string;
    }

    public String getMarkerStyleName() {
        return this.markerStyleName;
    }

    public void setMarkerSize(int n) {
        this.markerSize.setWidth(n);
        this.markerSize.setHeight(n);
    }

    public int getMarkerSize() {
        return (int)this.markerSize.getWidth();
    }

    public void setMarkerSizeValue(double d) {
        this.markerSize.setWidth(d);
        this.markerSize.setHeight(d);
    }

    public double getMarkerSizeValue() {
        return this.markerSize.getWidth();
    }

    public void setMarkerWidth(double d) {
        this.markerSize.setWidth(d);
    }

    public double getMarkerWidth() {
        return this.markerSize.getWidth();
    }

    public void setMarkerHeight(double d) {
        this.markerSize.setHeight(d);
    }

    public double getMarkerHeight() {
        return this.markerSize.getHeight();
    }

    public String getMarkerSizeUnit() {
        return this.markerSize.getUnit();
    }

    public void setMarkerSizeUnit(String string) {
        this.markerSize.setUnit(string);
    }

    public SizeDefinition getMarkerSizeDef() {
        return new SizeDefinition(this.markerSize.getWidth(), this.markerSize.getUnit());
    }

    public SizeDefinition2D getMarkerSize2DDef() {
        return this.markerSize;
    }

    public void setMarkerSize(SizeDefinition sizeDefinition) {
        this.markerSize = new SizeDefinition2D(-1.0, -1.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.markerSize.setWidth(sizeDefinition.getValue());
        this.markerSize.setHeight(sizeDefinition.getValue());
        this.markerSize.setUnit(sizeDefinition.getUnit());
    }

    public void setMarkerSize(SizeDefinition2D sizeDefinition2D) {
        this.markerSize = new SizeDefinition2D(-1.0, -1.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.markerSize.setWidth(sizeDefinition2D.getWidth());
        this.markerSize.setHeight(sizeDefinition2D.getHeight());
        this.markerSize.setUnit(sizeDefinition2D.getUnit());
    }

    public boolean isMultipleMarker() {
        return !this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_NONE);
    }

    public void setMultipleMarker(boolean bl) {
        if (!bl) {
            this.multipleMarkerPosition = MULTIMARKER_NONE;
        } else {
            if (this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_END_POINTS) || this.multipleMarkerPosition.equalsIgnoreCase(MULTIMARKER_ALL_POINTS)) {
                return;
            }
            this.multipleMarkerPosition = MULTIMARKER_ALONG_PATH;
        }
    }

    public void setMultipleMarkerPosition(String string) {
        this.multipleMarkerPosition = string == null || !string.equalsIgnoreCase(MULTIMARKER_NONE) && !string.equalsIgnoreCase(MULTIMARKER_ALONG_PATH) && !string.equalsIgnoreCase(MULTIMARKER_END_POINTS) && !string.equalsIgnoreCase(MULTIMARKER_ALL_POINTS) ? MULTIMARKER_NONE : string;
    }

    public String getMultipleMarkerPosition() {
        return this.multipleMarkerPosition;
    }

    public void setCased(boolean bl) {
        this.cased = bl;
    }

    public boolean isCased() {
        return this.cased;
    }

    public void setMpMarkerStyles(String[] stringArray) {
        this.mpMarkerStyles = stringArray;
    }

    public String[] getMpMarkerStyles() {
        return this.mpMarkerStyles;
    }

    public void setMpStartingOffsetSize(SizeDefinition sizeDefinition) {
        this.mpStartingOffset = new SizeDefinition(0.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.mpStartingOffset.setValue(sizeDefinition.getValue());
        this.mpStartingOffset.setUnit(sizeDefinition.getUnit());
    }

    public void setMpStartingOffset(float f) {
        this.mpStartingOffset.setValue(f);
    }

    public float getMpStartingOffset() {
        return (float)this.mpStartingOffset.getValue();
    }

    public String getMpStartingOffsetUnit() {
        return this.mpStartingOffset.getUnit();
    }

    public void setMpStartingOffsetUnit(String string) {
        this.mpStartingOffset.setUnit(string);
    }

    public SizeDefinition getMpStartingOffsetSize() {
        return this.mpStartingOffset;
    }

    public void setMpInterval(float f) {
        this.mpInterval.setValue(f);
    }

    public float getMpInterval() {
        return (float)this.mpInterval.getValue();
    }

    public String getMpIntervalUnit() {
        return this.mpInterval.getUnit();
    }

    public void setMpIntervalUnit(String string) {
        this.mpInterval.setUnit(string);
    }

    public SizeDefinition getMpIntervalSize() {
        return this.mpInterval;
    }

    public void setMpIntervalSize(SizeDefinition sizeDefinition) {
        this.mpInterval = new SizeDefinition(5.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.mpInterval.setValue(sizeDefinition.getValue());
        this.mpInterval.setUnit(sizeDefinition.getUnit());
    }

    public void setMpMarkerSize(SizeDefinition2D sizeDefinition2D) {
        this.mpMarkerSize = new SizeDefinition2D(-1.0, -1.0, null);
        if (sizeDefinition2D == null) {
            return;
        }
        this.mpMarkerSize.setWidth(sizeDefinition2D.getWidth());
        this.mpMarkerSize.setHeight(sizeDefinition2D.getHeight());
        this.mpMarkerSize.setUnit(sizeDefinition2D.getUnit());
    }

    public SizeDefinition2D getMpMarkerSize() {
        return this.mpMarkerSize;
    }

    public void setMpMarkerWidth(double d) {
        if (d <= 0.0) {
            return;
        }
        this.mpMarkerSize.setWidth(d);
    }

    public double getMpMarkerWidth() {
        return this.mpMarkerSize.getWidth();
    }

    public void setMpMarkerHeight(double d) {
        if (d <= 0.0) {
            return;
        }
        this.mpMarkerSize.setHeight(d);
    }

    public double getMpMarkerHeight() {
        return this.mpMarkerSize.getHeight();
    }

    public void setMpMarkerUnit(String string) {
        this.mpMarkerSize.setUnit(string);
    }

    public String getMpMarkerUnit() {
        return this.mpMarkerSize.getUnit();
    }
}

