/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Date;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmMember;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmValueHierarchy;

public class MdmTimeMember
extends MdmSource
implements MdmMember {
    public MdmTimeMember(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        Mdm10_1_0_3_ObjectVisitor mdm10_1_0_3_ObjectVisitor = null;
        try {
            mdm10_1_0_3_ObjectVisitor = (Mdm10_1_0_3_ObjectVisitor)mdmObjectVisitor;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return mdm10_1_0_3_ObjectVisitor.visitMdmTimeMember(this, object);
    }

    protected String getXMLTagName() {
        return "MdmTimeMember";
    }

    public Date getEndDate() {
        return new Date(this.getPropertyIntegerValue("EndDate", 0) * 1000);
    }

    public int getTimeSpan() {
        return this.getPropertyIntegerValue("Timespan", 0);
    }

    public int getPrecedence() {
        return this.getPropertyIntegerValue("Precedence", 10);
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "Parent") {
            this.createStringProperty(string, string2);
            return true;
        }
        if (string == "LevelRef" || string == "ValueHierRef" || string == "ParentLevelRef") {
            this.createObjectProperty(string, string2);
            return true;
        }
        if (string == "Timespan" || string == "EndDate" || string == "Precedence") {
            this.createIntegerProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public void setPrecedence(int n) {
        this.setPropertyIntegerValue("Precedence", n);
    }

    public void setEndDate(Date date) {
        if (null != date) {
            this.setPropertyIntegerValue("EndDate", (int)(date.getTime() / 1000L));
        }
    }

    public void setTimeSpan(int n) {
        if (n > 0) {
            this.setPropertyIntegerValue("Timespan", n);
        }
    }

    public MdmPrimaryDimension getOwnerDimension() {
        if (this.getLevel() != null) {
            return this.getLevel().getPrimaryDimension();
        }
        return this.getValueHierarchy().getPrimaryDimension();
    }

    public String getValue() {
        String string = this.getLocalValue();
        MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
        if (mdmMetadataProvider.usingUniqueValues()) {
            if (this.getLevel() != null) {
                return mdmMetadataProvider.getValueConverter().convertLocalValueToUniqueValue(mdmMetadataProvider, this.getLevel(), string);
            }
            return mdmMetadataProvider.getValueConverter().convertLocalValueToUniqueValue(mdmMetadataProvider, this.getValueHierarchy(), string);
        }
        return string;
    }

    public String getLocalValue() {
        return this.getName();
    }

    public MdmLevel getLevel() {
        return (MdmLevel)this.getPropertyObjectValue("LevelRef");
    }

    public void setLevel(MdmLevel mdmLevel) {
        this.setPropertyObjectValue("LevelRef", mdmLevel);
    }

    public MdmValueHierarchy getValueHierarchy() {
        return (MdmValueHierarchy)this.getPropertyObjectValue("ValueHierRef");
    }

    public void setValueHierarchy(MdmValueHierarchy mdmValueHierarchy) {
        this.setPropertyObjectValue("ValueHierRef", mdmValueHierarchy);
    }

    public int getLevelDepth() {
        if (this.getLevel() == null) {
            return 0;
        }
        return this.getLevel().getLevelDepth();
    }

    public String getParentValue() {
        String string = this.getParentLocalValue();
        if (string == null || !this.getMetadataProvider().usingUniqueValues()) {
            return string;
        }
        MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
        if (mdmMetadataProvider.usingUniqueValues()) {
            return mdmMetadataProvider.getValueConverter().convertLocalValueToUniqueValue(mdmMetadataProvider, this.getParentLevel(), string);
        }
        return string;
    }

    public String getParentLocalValue() {
        return this.getPropertyStringValue("Parent");
    }

    public void setParentLocalValue(String string) {
        this.setPropertyStringValue("Parent", string);
    }

    public MdmLevel getParentLevel() {
        return (MdmLevel)this.getPropertyObjectValue("ParentLevelRef");
    }

    public void setParentLevel(MdmLevel mdmLevel) {
        this.setPropertyObjectValue("ParentLevelRef", mdmLevel);
    }
}

