/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.olapi.ArraySet;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.HiddenDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.transaction.Transaction;

public final class MdmSourceDefinition
extends HiddenDefinition {
    MdmSource m_MdmSource;

    MdmSourceDefinition(MdmMetadataProvider mdmMetadataProvider, MdmSource mdmSource, DataProvider dataProvider) {
        super(mdmMetadataProvider, mdmSource.getID(), dataProvider._getSourceIDProvider().createHiddenID(mdmMetadataProvider.getID(), mdmSource.getID(), dataProvider), dataProvider);
        this.m_MdmSource = mdmSource;
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        if (this.getMdmSource() instanceof MdmPrimaryDimension) {
            return ((MdmPrimaryDimension)this.getMdmSource()).getExtractModel();
        }
        return null;
    }

    protected final Set getExtractionInputDefinitions() {
        return Collections.EMPTY_SET;
    }

    protected final Set getInputDefinitions() {
        return this.getRegularInputDefinitions();
    }

    public MdmSource getMdmSource() {
        return this.m_MdmSource;
    }

    public final Model getModel() {
        return this.getMdmSource().getModel();
    }

    protected final List getOutputDefinitions() {
        return Collections.EMPTY_LIST;
    }

    protected final Set getRegularInputDefinitions() {
        ArraySet arraySet = new ArraySet();
        if (this.getMdmSource() instanceof MdmDimensionedObject) {
            MdmDimensionedObject mdmDimensionedObject = (MdmDimensionedObject)this.getMdmSource();
            Iterator iterator = mdmDimensionedObject.getDimensions().iterator();
            while (iterator.hasNext()) {
                MdmDimension mdmDimension = (MdmDimension)iterator.next();
                arraySet.add(mdmDimension.getSource().getDefinition());
            }
        }
        return arraySet;
    }

    protected final SourceDefinition getTypeDefinition() {
        MetadataObject metadataObject = this.getMdmSource().getType();
        if (metadataObject instanceof MdmSource) {
            return ((MdmSource)metadataObject).getSource().getDefinition();
        }
        return ((FundamentalMetadataObject)metadataObject).getSource().getDefinition();
    }

    private void setMdmSource(MdmSource mdmSource) {
        this.m_MdmSource = mdmSource;
    }

    public final Transaction getActiveTransaction() {
        return this.getMdmSource().getActiveTransaction();
    }

    public Object getTransactionalState(Transaction transaction) {
        return this;
    }
}

