/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.List;
import oracle.express.ObjectClosedException;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.ClientXMLMetadataFetcher;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.metadata.mdm.Mdm9iNamingConvention;
import oracle.olapi.metadata.mdm.MdmCustomObjectFactory;
import oracle.olapi.metadata.mdm.MdmDefaultValueConverter;
import oracle.olapi.metadata.mdm.MdmNamingConvention;
import oracle.olapi.metadata.mdm.MdmODBOValueConverter;
import oracle.olapi.metadata.mdm.MdmObject;
import oracle.olapi.metadata.mdm.MdmObjectFactory;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmValueConverter;
import oracle.olapi.metadata.mtm.MtmCustomObjectFactory;
import oracle.olapi.metadata.mtm.MtmObjectFactory;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;

public class MdmMetadataProvider
extends BaseMetadataProvider
implements MetadataProvider {
    private static final String DEFAULT_TRANSIENT_OWNER_NAME = "TRANSIENT";
    private MdmObjectFactory m_MdmObjectFactory = null;
    private MtmObjectFactory m_MtmObjectFactory = null;
    private MdmCustomObjectFactory m_MdmCustomObjectFactory = null;
    private MtmCustomObjectFactory m_MtmCustomObjectFactory = null;
    private List m_MtmPartitionedCubes = new ArrayList();
    private MdmValueConverter m_valueConverter = null;
    private MdmNamingConvention m_MdmNamingConvention = null;
    private int m_exprCounter = 0;

    public MdmMetadataProvider(DataProvider dataProvider) throws ObjectClosedException {
        this(dataProvider, null);
    }

    public MdmMetadataProvider(DataProvider dataProvider, ClientXMLMetadataFetcher clientXMLMetadataFetcher) throws ObjectClosedException {
        super(dataProvider, clientXMLMetadataFetcher);
        dataProvider.registerMetadataProvider(this);
        this.m_MdmObjectFactory = new MdmObjectFactory(this);
        this.m_MtmObjectFactory = new MtmObjectFactory(this);
        this.m_MdmCustomObjectFactory = new MdmCustomObjectFactory(this);
        this.m_MtmCustomObjectFactory = new MtmCustomObjectFactory(this);
        this.setMdmNamingConvention(null);
    }

    public final MdmObject getMetadataObject(String string) throws ObjectClosedException {
        return (MdmObject)this.fetchMetadataObject(string);
    }

    public final List getMetadataObjects(String[] stringArray) throws ObjectClosedException {
        return this.fetchMetadataObjects(stringArray);
    }

    public MdmSchema getRootSchema() {
        return (MdmSchema)this.getMetadataObject("RootSchema");
    }

    public final Source getSource(String string) throws ObjectClosedException {
        MetadataObject metadataObject = this.fetchMetadataObject(string);
        if (metadataObject instanceof MdmSource) {
            return ((MdmSource)metadataObject).getSource();
        }
        return null;
    }

    public List getPartitionedCubes() {
        return this.m_MtmPartitionedCubes;
    }

    public void registerCube(MtmPartitionedCube mtmPartitionedCube) {
        this.m_MtmPartitionedCubes.add(mtmPartitionedCube);
    }

    public void unregisterCube(MtmPartitionedCube mtmPartitionedCube) {
        this.m_MtmPartitionedCubes.remove(mtmPartitionedCube);
    }

    public final MdmCustomObjectFactory getMdmCustomObjectFactory() {
        return this.m_MdmCustomObjectFactory;
    }

    public final MtmCustomObjectFactory getMtmCustomObjectFactory() {
        return this.m_MtmCustomObjectFactory;
    }

    public final MdmObjectFactory getMdmObjectFactory() {
        return this.m_MdmObjectFactory;
    }

    public final MtmObjectFactory getMtmObjectFactory() {
        return this.m_MtmObjectFactory;
    }

    MdmValueConverter getValueConverter() {
        if (this.m_valueConverter == null && this.getDataProvider() instanceof ExpressDataProvider) {
            this.m_valueConverter = "YES".equals(((ExpressDataProvider)this.getDataProvider()).getProperty("ODBOMode")) ? new MdmODBOValueConverter() : new MdmDefaultValueConverter();
        }
        return this.m_valueConverter;
    }

    boolean usingUniqueValues() {
        if (!(this.getDataProvider() instanceof ExpressDataProvider)) {
            return false;
        }
        return "unique".equals(((ExpressDataProvider)this.getDataProvider()).getProperty("HierarchyValueType")) || "YES".equals(((ExpressDataProvider)this.getDataProvider()).getProperty("ODBOMode"));
    }

    MdmNamingConvention getMdmNamingConvention() {
        return this.m_MdmNamingConvention;
    }

    public void setMdmNamingConvention(MdmNamingConvention mdmNamingConvention) {
        this.m_MdmNamingConvention = null == mdmNamingConvention ? new Mdm9iNamingConvention(DEFAULT_TRANSIENT_OWNER_NAME) : mdmNamingConvention;
    }

    public String getUniqueNumberString() {
        ++this.m_exprCounter;
        Integer n = new Integer(this.m_exprCounter);
        return n.toString();
    }

    public boolean supportsBulkSend() {
        if (this.getDataProvider() instanceof ExpressDataProvider) {
            ExpressDataProvider expressDataProvider = (ExpressDataProvider)this.getDataProvider();
            return expressDataProvider.supportsBulkSend();
        }
        return false;
    }

    public void bulkSend() {
        if (!this.supportsBulkSend()) {
            return;
        }
        if (this.getDataProvider() instanceof ExpressDataProvider) {
            ExpressDataProvider expressDataProvider = (ExpressDataProvider)this.getDataProvider();
            expressDataProvider.bulkSendMetadata();
        }
    }
}

