/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.source.FundamentalMetadataObject;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.metadata.mdm.MdmDimensionCalculationModel;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmSchema;
import oracle.olapi.transaction.Transaction;

public final class MdmMeasureDimension
extends MdmPrimaryDimension {
    MdmMeasureDimension(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmMeasureDimension(this, object);
    }

    public final List getMeasures() {
        return this.getPropertyListValues("MeasRef");
    }

    final List getMembers() {
        return this.getMeasures();
    }

    protected String getXMLTagName() {
        return "MdmMeasureDimension";
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "MeasRef") {
            this.createListProperty(string, string2);
            return true;
        }
        if (string == "ValueCalcModel") {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public void addMeasure(MdmMeasure mdmMeasure) {
        this.addToListProperty("MeasRef", mdmMeasure);
    }

    public void removeMeasure(MdmMeasure mdmMeasure) {
        this.removeFromListProperty("MeasRef", mdmMeasure);
    }

    final SourceDefinition getElementType(Transaction transaction) {
        SourceDefinition sourceDefinition = null;
        Iterator iterator = this.getMeasures().iterator();
        while (iterator.hasNext()) {
            MdmMeasure mdmMeasure = (MdmMeasure)iterator.next();
            FundamentalMetadataObject fundamentalMetadataObject = (FundamentalMetadataObject)mdmMeasure.getType();
            SourceDefinition sourceDefinition2 = fundamentalMetadataObject.getSource().getDefinition();
            if (sourceDefinition == null) {
                sourceDefinition = sourceDefinition2;
                continue;
            }
            sourceDefinition = sourceDefinition.getCommonType(sourceDefinition2, transaction);
        }
        return sourceDefinition;
    }

    public final MdmDimensionCalculationModel getValueCalcModel() {
        return (MdmDimensionCalculationModel)this.getPropertyObjectValue("ValueCalcModel");
    }

    public final void setValueCalcModel(MdmDimensionCalculationModel mdmDimensionCalculationModel) {
        this.setPropertyObjectValue("ValueCalcModel", mdmDimensionCalculationModel);
    }

    public MdmMeasure createCustomMeasure(String string, Source source, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createCustomMeasure(string, this, source, n);
    }

    public MdmMeasure createCustomMeasure(String string, MdmSchema mdmSchema, Source source, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createCustomMeasure(string, this, mdmSchema, source, n);
    }

    final MdmDimensionCalculationModel getExtractModel() {
        MdmDimensionCalculationModel mdmDimensionCalculationModel = null;
        MdmDimensionCalculationModel mdmDimensionCalculationModel2 = this.getNumberCalcModel();
        if (mdmDimensionCalculationModel2.getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if ((mdmDimensionCalculationModel2 = this.getStringCalcModel()).getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            if (mdmDimensionCalculationModel != null) {
                return this.getValueCalcModel();
            }
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if ((mdmDimensionCalculationModel2 = this.getDateCalcModel()).getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            if (mdmDimensionCalculationModel != null) {
                return this.getValueCalcModel();
            }
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if ((mdmDimensionCalculationModel2 = this.getBooleanCalcModel()).getAssignments().size() > 0 || mdmDimensionCalculationModel2.getAutoAssignments().size() > 0) {
            if (mdmDimensionCalculationModel != null) {
                return this.getValueCalcModel();
            }
            mdmDimensionCalculationModel = mdmDimensionCalculationModel2;
        }
        if (null == mdmDimensionCalculationModel) {
            mdmDimensionCalculationModel = this.getValueCalcModel();
        }
        return mdmDimensionCalculationModel;
    }
}

