/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.Iterator;
import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDimensionMemberInfo;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmInvalidValueException;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmExpression;
import oracle.olapi.metadata.mtm.MtmLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmLevelMap;
import oracle.olapi.metadata.mtm.MtmSourceMap;
import oracle.olapi.metadata.mtm.MtmValueExpression;

public final class MdmLevelHierarchy
extends MdmHierarchy {
    protected MdmLevelHierarchy(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        return mdmObjectVisitor.visitMdmLevelHierarchy(this, object);
    }

    public MdmLevel addLevel(String string, MtmExpression mtmExpression) {
        String string2 = this.getMetadataProvider().getMdmNamingConvention().generateLevelID(this, string);
        MdmLevel mdmLevel = this.getMetadataProvider().getMdmObjectFactory().createLevel(string2);
        mdmLevel.setName(string);
        MtmLevelMap mtmLevelMap = this.getMetadataProvider().getMtmObjectFactory().createLevelMap();
        mtmLevelMap.setLevelExpression(mtmExpression);
        mdmLevel.setSourceMap(mtmLevelMap);
        this.addToListProperty("LevelRef", mdmLevel);
        return mdmLevel;
    }

    public final MdmAttribute getLevelAttribute() {
        if (this.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            return this.getPrimaryDimension().getLevelAttribute();
        }
        return (MdmAttribute)this.getPropertyObjectValue("LevelAttribute");
    }

    public final MdmAttribute getLevelDepthAttribute() {
        if (this.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0})) {
            return this.getPrimaryDimension().getLevelDepthAttribute();
        }
        return (MdmAttribute)this.getPropertyObjectValue("LevelDepthAttribute");
    }

    public MtmLevelHierarchyMap getLevelHierarchyMap() throws MetadataNotFoundException {
        return (MtmLevelHierarchyMap)this.getSourceMap();
    }

    public final List getLevels() {
        return this.getPropertyListValues("LevelRef");
    }

    public MdmDimensionMemberInfo getDefaultMember() throws MetadataNotFoundException {
        String string = this.getPropertyStringValue("DefaultMember");
        MdmLevel mdmLevel = (MdmLevel)this.getPropertyObjectValue("DefaultMemberLevel");
        if (string != null && mdmLevel != null) {
            return new MdmDimensionMemberInfo(mdmLevel, (Object)string);
        }
        throw new MetadataNotFoundException();
    }

    public void setDefaultMember(MdmDimensionMemberInfo mdmDimensionMemberInfo) throws MetadataNotFoundException, MdmInvalidValueException {
        if (mdmDimensionMemberInfo.getHierarchy() != this || mdmDimensionMemberInfo.getLevel() == null || mdmDimensionMemberInfo.getLevel().getLevelHierarchy() != this) {
            throw new MdmInvalidValueException("Default member must be a member of this hierarchy.");
        }
        this.setPropertyStringValue("DefaultMember", mdmDimensionMemberInfo.getLocalValue().toString());
        this.setPropertyObjectValue("DefaultMemberLevel", mdmDimensionMemberInfo.getLevel());
    }

    protected String getXMLTagName() {
        return "MdmLevelHierarchy";
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "LevelRef") {
            this.createListProperty(string, string2);
            return true;
        }
        if (string == "DefaultMemberLevel") {
            this.createObjectProperty(string, string2);
            return true;
        }
        if (!(this.isServerVersionLaterThan(new int[]{9, 2, 0, 3, 0}) || string != "LevelAttribute" && string != "LevelDepthAttribute")) {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    private void regenerate() {
        BaseMetadataObject baseMetadataObject;
        Object object;
        this.getPrimaryDimension().setDescription(this.getPrimaryDimension().getDescription());
        Iterator iterator = this.getPrimaryDimension().getAttributes().iterator();
        while (iterator.hasNext()) {
            object = (MdmAttribute)iterator.next();
            baseMetadataObject = ((MdmAttribute)object).getAttributeMap();
            ((MtmSourceMap)baseMetadataObject).setMdmSource(((MtmSourceMap)baseMetadataObject).getMdmSource());
        }
        object = this.getLevels().iterator();
        while (object.hasNext()) {
            baseMetadataObject = (MdmLevel)object.next();
            MtmLevelMap mtmLevelMap = ((MdmLevel)baseMetadataObject).getLevelMap();
            mtmLevelMap.setLevelExpression(mtmLevelMap.getLevelExpression());
        }
        baseMetadataObject = this.getLevelHierarchyMap();
        ((MtmLevelHierarchyMap)baseMetadataObject).setTable(((MtmLevelHierarchyMap)baseMetadataObject).getTable());
    }

    void addLevel(MdmLevel mdmLevel, int n) {
        this.addToListProperty("LevelRef", mdmLevel, n);
        this.regenerate();
    }

    public void removeLevel(MdmLevel mdmLevel) {
        this.removeFromListProperty("LevelRef", mdmLevel);
        this.regenerate();
    }

    public MdmLevel createNumericLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createNumericLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createNumericLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createNumericLevel(string, this, string2, n);
    }

    public MdmLevel createNumericLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createNumericLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createNumericLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createNumericLevel(string, this, string2, mdmLevel);
    }

    public MdmLevel createStringLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createStringLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createStringLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createStringLevel(string, this, string2, n);
    }

    public MdmLevel createStringLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createStringLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createStringLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createStringLevel(string, this, string2, mdmLevel);
    }

    public MdmLevel createDateLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createDateLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createDateLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createDateLevel(string, this, string2, n);
    }

    public MdmLevel createDateLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createDateLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createDateLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createDateLevel(string, this, string2, mdmLevel);
    }

    public MdmLevel createBooleanLevel(String string, MtmValueExpression mtmValueExpression, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createBooleanLevel(string, this, mtmValueExpression, n);
    }

    public MdmLevel createBooleanLevel(String string, String string2, int n) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createBooleanLevel(string, this, string2, n);
    }

    public MdmLevel createBooleanLevel(String string, MtmValueExpression mtmValueExpression, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createBooleanLevel(string, this, mtmValueExpression, mdmLevel);
    }

    public MdmLevel createBooleanLevel(String string, String string2, MdmLevel mdmLevel) {
        return ((MdmMetadataProvider)this.m_MetadataProvider).getMdmCustomObjectFactory().createBooleanLevel(string, this, string2, mdmLevel);
    }
}

