/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.LiteralQualification;
import oracle.olapi.data.source.Qualification;
import oracle.olapi.data.source.Source;
import oracle.olapi.metadata.mdm.Mdm10_1_0_3_ObjectVisitor;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDimensionedObject;
import oracle.olapi.metadata.mdm.MdmDimensionedObjectModel;
import oracle.olapi.metadata.mdm.MdmMember;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmObjectVisitor;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmTimeDimension;
import oracle.olapi.metadata.mdm.MdmTimeMember;

public class MdmAttributeModel
extends MdmDimensionedObjectModel {
    public MdmAttributeModel(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    protected String getXMLTagName() {
        return "MdmAttributeModel";
    }

    public Object acceptVisitor(MdmObjectVisitor mdmObjectVisitor, Object object) {
        Mdm10_1_0_3_ObjectVisitor mdm10_1_0_3_ObjectVisitor = null;
        try {
            mdm10_1_0_3_ObjectVisitor = (Mdm10_1_0_3_ObjectVisitor)mdmObjectVisitor;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return mdm10_1_0_3_ObjectVisitor.visitMdmAttributeModel(this, object);
    }

    public final MdmAttribute getMdmAttribute() {
        return (MdmAttribute)this.getPropertyObjectValue("AttRef");
    }

    public final MdmDimensionedObject getMdmDimensionedObject() {
        return this.getMdmAttribute();
    }

    public final List getParentModels() {
        return new ArrayList();
    }

    public final void setMdmAttribute(MdmAttribute mdmAttribute) {
        this.setPropertyObjectValue("AttRef", mdmAttribute);
    }

    protected boolean initializeProperty(String string, String string2) {
        if (string == "AttRef") {
            this.createObjectProperty(string, string2);
            return true;
        }
        return super.initializeProperty(string, string2);
    }

    public List getAutoAssignments() {
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        DataProvider dataProvider = this.getType().getDataProvider();
        MdmPrimaryDimension mdmPrimaryDimension = (MdmPrimaryDimension)this.getDimensions().get(0);
        if (!this.hasAutoAssignments(mdmPrimaryDimension)) {
            return arrayList;
        }
        Iterator iterator = mdmPrimaryDimension.getMembers().iterator();
        while (iterator.hasNext()) {
            MdmMember mdmMember = (MdmMember)iterator.next();
            LiteralQualification literalQualification = new LiteralQualification(mdmPrimaryDimension.getSource(), mdmMember.getValue());
            Assignment assignment = new Assignment(this, new Qualification[]{literalQualification}, this.createAssignedSource(dataProvider, mdmPrimaryDimension, mdmMember), mdmMember.getPrecedence());
            arrayList.add(assignment);
        }
        return arrayList;
    }

    private boolean hasAutoAssignments(MdmPrimaryDimension mdmPrimaryDimension) {
        boolean bl;
        boolean bl2 = bl = this.getMdmAttribute() == mdmPrimaryDimension.getShortValueDescriptionAttribute() || this.getMdmAttribute() == mdmPrimaryDimension.getValueDescriptionAttribute() || this.getMdmAttribute() == mdmPrimaryDimension.getLocalValueAttribute() || this.getMdmAttribute() == mdmPrimaryDimension.getLevelAttribute() || this.getMdmAttribute() == mdmPrimaryDimension.getLevelDepthAttribute() || this.getMdmAttribute() == mdmPrimaryDimension.getParentAttribute();
        if (!bl && mdmPrimaryDimension instanceof MdmTimeDimension) {
            MdmTimeDimension mdmTimeDimension = (MdmTimeDimension)mdmPrimaryDimension;
            bl = this.getMdmAttribute() == mdmTimeDimension.getEndDateAttribute() || this.getMdmAttribute() == mdmTimeDimension.getTimeSpanAttribute();
        }
        return bl;
    }

    private Source createAssignedSource(DataProvider dataProvider, MdmPrimaryDimension mdmPrimaryDimension, MdmMember mdmMember) {
        if (this.getMdmAttribute() == mdmPrimaryDimension.getShortValueDescriptionAttribute()) {
            return dataProvider.createConstantSource(mdmMember.getShortDescription());
        }
        if (this.getMdmAttribute() == mdmPrimaryDimension.getValueDescriptionAttribute()) {
            return dataProvider.createConstantSource(mdmMember.getDescription());
        }
        if (this.getMdmAttribute() == mdmPrimaryDimension.getLocalValueAttribute()) {
            return dataProvider.createConstantSource(mdmMember.getLocalValue());
        }
        if (this.getMdmAttribute() == mdmPrimaryDimension.getLevelAttribute()) {
            return dataProvider.createConstantSource(mdmMember.getLevel().getID());
        }
        if (this.getMdmAttribute() == mdmPrimaryDimension.getLevelDepthAttribute()) {
            return dataProvider.createConstantSource(mdmMember.getLevelDepth());
        }
        if (this.getMdmAttribute() == mdmPrimaryDimension.getParentAttribute()) {
            return dataProvider.createConstantSource(mdmMember.getParentValue());
        }
        if (mdmPrimaryDimension instanceof MdmTimeDimension) {
            MdmTimeDimension mdmTimeDimension = (MdmTimeDimension)mdmPrimaryDimension;
            MdmTimeMember mdmTimeMember = (MdmTimeMember)mdmMember;
            if (this.getMdmAttribute() == mdmTimeDimension.getEndDateAttribute()) {
                return dataProvider.createConstantSource(mdmTimeMember.getEndDate());
            }
            if (this.getMdmAttribute() == mdmTimeDimension.getTimeSpanAttribute()) {
                return dataProvider.createConstantSource(mdmTimeMember.getTimeSpan());
            }
        }
        return null;
    }
}

