/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.List;
import oracle.express.olapi.data.full.ExpressDataProvider;
import oracle.olapi.internal.CopyException;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.metadata.BaseMetadataObjectState;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataUpdateNotSupportedException;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObject;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.metadataStateManager.MetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseMetadataObject
implements MetadataObject,
TransactionalObject {
    private BaseMetadataObjectState m_PersistentState = null;
    private MetadataStateManager m_MetadataStateManager = null;
    public BaseMetadataProvider m_MetadataProvider = null;
    private String m_ID = null;
    private boolean m_Deleted = false;
    private MetadataObjectHolder m_Holder = null;
    private short m_PersistenceType = 0;
    private static final String TRUE = "True";
    private static final String FALSE = "False";

    protected BaseMetadataObject(BaseMetadataProvider baseMetadataProvider) {
        this.m_MetadataProvider = baseMetadataProvider;
    }

    final boolean addChildrenToXMLWriter(MetadataToXMLConverter metadataToXMLConverter, List list) {
        return ((BaseMetadataObjectState)this.getCurrentStateForRead(metadataToXMLConverter.getTransaction())).addChildrenToXMLWriter(metadataToXMLConverter, list);
    }

    protected final void addToListProperty(String string, BaseMetadataObject baseMetadataObject) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.addToListProperty(string, baseMetadataObject.getHolder());
    }

    protected final void addToListProperty(String string, BaseMetadataObject baseMetadataObject, int n) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.addToListProperty(string, baseMetadataObject.getHolder(), n);
    }

    protected final void removeFromListProperty(String string, BaseMetadataObject baseMetadataObject) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.removeFromListProperty(string, baseMetadataObject.getHolder());
    }

    final void appendXMLString(MetadataToXMLConverter metadataToXMLConverter) {
        metadataToXMLConverter.beginElement(this.getXMLTagName());
        metadataToXMLConverter.appendAttribute("MdmID", this.getID());
        this.appendAdditionalXMLAttributes(metadataToXMLConverter);
        this.getCurrentStateForRead().appendXMLString(metadataToXMLConverter);
        this.appendAdditionalXMLSubobjects(metadataToXMLConverter);
        metadataToXMLConverter.endElement(this.getXMLTagName());
    }

    protected void appendAdditionalXMLSubobjects(MetadataToXMLConverter metadataToXMLConverter) {
    }

    protected void appendAdditionalXMLAttributes(MetadataToXMLConverter metadataToXMLConverter) {
    }

    protected final void createStringProperty(String string, String string2) {
        this.m_PersistentState.setPropertyStringValue(string, string2);
    }

    protected final void createIntegerProperty(String string, String string2) {
        int n;
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return;
        }
        this.m_PersistentState.setPropertyIntegerValue(string, n);
    }

    protected final void createBooleanProperty(String string, String string2) {
        this.m_PersistentState.setPropertyStringValue(string, string2);
    }

    protected final void createMapProperty(String string, String string2, String string3) {
        MetadataObjectHolder metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(string2);
        MetadataObjectHolder metadataObjectHolder2 = this.m_MetadataProvider.getObjectHolder(string3);
        this.m_PersistentState.mapObject(string, metadataObjectHolder, metadataObjectHolder2);
    }

    protected final void createValueMapProperty(String string, String string2, String string3) {
        MetadataObjectHolder metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(string2);
        this.m_PersistentState.mapValue(string, metadataObjectHolder, string3);
    }

    protected final void createListProperty(String string, String string2) {
        MetadataObjectHolder metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(string2);
        this.m_PersistentState.addToListProperty(string, metadataObjectHolder);
    }

    protected final void createObjectProperty(String string, String string2) {
        MetadataObjectHolder metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(string2);
        this.m_PersistentState.setPropertyObjectValue(string, metadataObjectHolder);
    }

    private final Transaction getWriteTransaction() {
        return this.m_MetadataProvider.getDataProvider().getTransactionProvider().getCurrentTransactionForMetadataWrite();
    }

    private final Transaction getReadTransaction() {
        return this.m_MetadataProvider.getDataProvider().getTransactionProvider().getCurrentTransactionForMetadataRead();
    }

    private final void createMetadataStateManager() {
        BaseMetadataObjectState baseMetadataObjectState = this.m_PersistentState;
        if (null != baseMetadataObjectState) {
            this.setMetadataStateManager(new MetadataStateManager(baseMetadataObjectState, null));
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState2 = new BaseMetadataObjectState();
        Transaction transaction = this.getReadTransaction();
        this.setMetadataStateManager(new MetadataStateManager(baseMetadataObjectState2, transaction));
    }

    public final BaseMetadataProvider getBaseMetadataProvider() {
        return this.m_MetadataProvider;
    }

    final Object getCurrentStateForRead(Transaction transaction) {
        MetadataState metadataState;
        if (null != this.m_PersistentState && null == this.m_MetadataStateManager) {
            return this.m_PersistentState;
        }
        if (null == this.m_MetadataStateManager) {
            this.createMetadataStateManager();
        }
        if (null == (metadataState = this.m_MetadataStateManager.getCurrentStateForRead(transaction, false))) {
            metadataState = this.m_PersistentState;
        }
        if (null == metadataState) {
            throw new TransactionalObjectInvalidException();
        }
        return metadataState;
    }

    private final BaseMetadataObjectState getCurrentStateForRead() {
        Transaction transaction = this.getReadTransaction();
        return (BaseMetadataObjectState)this.getCurrentStateForRead(transaction);
    }

    private final BaseMetadataObjectState getCurrentStateForWrite() {
        if (!this.m_MetadataProvider.supportsMetadataUpdate()) {
            throw new MetadataUpdateNotSupportedException();
        }
        if (null == this.m_MetadataStateManager) {
            this.createMetadataStateManager();
        }
        return (BaseMetadataObjectState)this.m_MetadataStateManager.findOrCreateCurrentStateForWrite(this.getWriteTransaction());
    }

    final MetadataObjectHolder getHolder() {
        return this.m_Holder;
    }

    public final String getID() {
        return this.m_ID;
    }

    public Transaction getActiveTransaction() {
        if (null == this.m_MetadataStateManager) {
            return null;
        }
        return this.m_MetadataStateManager.getActiveTransaction();
    }

    final BaseMetadataObjectState getPersistentState() {
        return this.m_PersistentState;
    }

    protected final synchronized List getPropertyListValues(String string) {
        return this.getCurrentStateForRead().getPropertyListValues(string, this.m_MetadataProvider);
    }

    protected final synchronized MetadataObject getPropertyObjectValue(String string) {
        return this.getCurrentStateForRead().getPropertyObjectValue(string, this.m_MetadataProvider);
    }

    protected final synchronized String getPropertyStringValue(String string) {
        return this.getCurrentStateForRead().getPropertyStringValue(string);
    }

    protected final synchronized int getPropertyIntegerValue(String string, int n) {
        return this.getCurrentStateForRead().getPropertyIntegerValue(string, n);
    }

    protected final synchronized boolean getPropertyBooleanValue(String string) {
        String string2 = this.getCurrentStateForRead().getPropertyStringValue(string);
        return string2.equals(TRUE);
    }

    protected abstract String getXMLTagName();

    final void initializeProperties(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        String string = null;
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            string = attributes.getLocalName(i);
            string2 = attributes.getValue(i);
            bl = this.initializeProperty(string, string2);
        }
    }

    protected boolean initializeProperty(String string, String string2) {
        return string == "MdmID";
    }

    protected boolean initializePairProperty(String string, String string2, String string3) {
        return false;
    }

    public void invalidate() {
    }

    public final boolean isDeleted() {
        return this.m_Deleted;
    }

    protected boolean isModified(Object object, Object object2, Transaction transaction) {
        return object != this.m_PersistentState && object != object2;
    }

    public final boolean isPersistent() {
        return this.getPersistenceType() != 0;
    }

    final short getPersistenceType() {
        return this.m_PersistenceType;
    }

    final boolean isPersistent(Transaction transaction) {
        if (null == this.m_PersistentState) {
            return false;
        }
        return this.getCurrentStateForRead() == this.m_PersistentState;
    }

    protected final synchronized void mapObject(String string, MetadataObject metadataObject, MetadataObject metadataObject2) {
        if (null == metadataObject) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        MetadataObjectHolder metadataObjectHolder = null;
        MetadataObjectHolder metadataObjectHolder2 = this.m_MetadataProvider.getObjectHolder(metadataObject.getID());
        if (null != metadataObject2) {
            metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(metadataObject2.getID());
        }
        baseMetadataObjectState.mapObject(string, metadataObjectHolder2, metadataObjectHolder);
    }

    protected final synchronized void mapValue(String string, MetadataObject metadataObject, String string2) {
        if (null == metadataObject) {
            return;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        MetadataObjectHolder metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(metadataObject.getID());
        baseMetadataObjectState.mapValue(string, metadataObjectHolder, string2);
    }

    protected final MetadataObject getMappedObject(String string, MetadataObject metadataObject) {
        if (null == metadataObject) {
            return null;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        return baseMetadataObjectState.getMappedObject(string, metadataObject, this.m_MetadataProvider);
    }

    protected final String getMappedValue(String string, MetadataObject metadataObject) {
        if (null == metadataObject) {
            return null;
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        return baseMetadataObjectState.getMappedValue(string, metadataObject, this.m_MetadataProvider);
    }

    protected boolean hasPairProperty(String string) {
        return false;
    }

    protected boolean isServerVersionLaterThan(int[] nArray) {
        ExpressDataProvider expressDataProvider = (ExpressDataProvider)this.m_MetadataProvider.getDataProvider();
        return expressDataProvider.isServerVersionLaterThan(nArray);
    }

    final void setPersistenceType(short s) {
        if (s == 2) {
            this.setPersistentState(this.getCurrentStateForRead());
        } else if (this.m_PersistenceType == 0 && s != 0) {
            this.setPersistentState(new BaseMetadataObjectState());
        }
        this.m_PersistenceType = s;
    }

    private final void setDeleted(boolean bl) {
        this.m_Deleted = bl;
    }

    final void setHolder(MetadataObjectHolder metadataObjectHolder) {
        this.m_Holder = metadataObjectHolder;
    }

    final void setID(String string) {
        this.m_ID = string;
    }

    private final void setMetadataProvider(BaseMetadataProvider baseMetadataProvider) {
        this.m_MetadataProvider = baseMetadataProvider;
    }

    private final void setMetadataStateManager(MetadataStateManager metadataStateManager) {
        this.m_MetadataStateManager = metadataStateManager;
    }

    private final void setPersistentState(BaseMetadataObjectState baseMetadataObjectState) {
        this.m_PersistentState = baseMetadataObjectState;
    }

    protected final synchronized void setPropertyObjectValue(String string, MetadataObject metadataObject) {
        MetadataObjectHolder metadataObjectHolder = null;
        if (null != metadataObject) {
            metadataObjectHolder = this.m_MetadataProvider.getObjectHolder(metadataObject.getID());
        }
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.setPropertyObjectValue(string, metadataObjectHolder);
    }

    protected final synchronized void setPropertyStringValue(String string, String string2) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.setPropertyStringValue(string, string2);
    }

    protected final synchronized void setPropertyIntegerValue(String string, int n) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        baseMetadataObjectState.setPropertyIntegerValue(string, n);
    }

    protected final synchronized void setPropertyBooleanValue(String string, boolean bl) {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForWrite();
        if (bl) {
            baseMetadataObjectState.setPropertyStringValue(string, TRUE);
        } else {
            baseMetadataObjectState.setPropertyStringValue(string, FALSE);
        }
    }

    public void copyPropertyTo(BaseMetadataObject baseMetadataObject, String string, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        BaseMetadataObjectState baseMetadataObjectState2 = baseMetadataObject.getCurrentStateForWrite();
        baseMetadataObjectState.copyPropertyTo(baseMetadataObjectState2, string, this.m_MetadataProvider, copyPolicy, copyReferenceType);
    }

    public void copyAllPropertiesTo(BaseMetadataObject baseMetadataObject, CopyPolicy copyPolicy, CopyPolicy.CopyReferenceType copyReferenceType) throws CopyException {
        BaseMetadataObjectState baseMetadataObjectState = this.getCurrentStateForRead();
        BaseMetadataObjectState baseMetadataObjectState2 = baseMetadataObject.getCurrentStateForWrite();
        baseMetadataObjectState.copyAllPropertiesTo(baseMetadataObjectState2, this.m_MetadataProvider, copyPolicy, copyReferenceType);
    }

    public void gatherReferencedSources(List list, Transaction transaction) {
    }

    public void gatherReferencedSources(List list) {
        this.gatherReferencedSources(list, this.getActiveTransaction());
    }

    public Object getTransactionalState(Transaction transaction) {
        return this.getCurrentStateForRead(transaction);
    }
}

