/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.log;

import java.io.IOException;
import java.util.Properties;
import oracle.olapi.log.LogEvent;
import oracle.olapi.log.LogHandler;
import oracle.olapi.log.LogHandlerFactory;
import oracle.olapi.log.LogNestedHandler;
import oracle.olapi.log.Queue;
import oracle.olapi.log.VectorQueue;

public class ThreadedLogHandler
implements LogHandlerFactory {
    public LogHandler createLogHandler(Properties properties) {
        try {
            LogHandler logHandler = LogNestedHandler.createNestedInstance(properties);
            return logHandler != null ? new Handler(logHandler) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public class Handler
    extends LogNestedHandler {
        private Thread writer = null;
        private Queue queue = new VectorQueue();

        public Handler(LogHandler logHandler) throws IOException {
            super(logHandler);
        }

        public void addMessage(LogEvent logEvent) {
            this.queue.put(logEvent);
        }

        public synchronized void start() {
            if (this.writer != null && this.writer.isAlive()) {
                return;
            }
            this.writer = new Thread(new Runnable(this){
                private final /* synthetic */ Handler this$1;
                {
                    this.this$1 = handler;
                }

                public void run() {
                    Handler.access$000(this.this$1);
                }
            });
            this.writer.setDaemon(false);
            this.writer.start();
        }

        public synchronized void stop() {
            if (this.writer == null) {
                return;
            }
            try {
                this.queue.interruptGet();
                this.writer.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.writer = null;
        }

        private void execute() {
            try {
                LogEvent logEvent;
                super.start();
                while ((logEvent = this.queue.get()) != null) {
                    super.addMessage(logEvent);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            super.stop();
        }

        static /* synthetic */ void access$000(Handler handler) {
            handler.execute();
        }
    }
}

