/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.olapi.ArraySet;
import oracle.olapi.data.source.CursorLock;
import oracle.olapi.data.source.CursorLockException;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DynamicDefinition;
import oracle.olapi.data.source.SourceGenerator;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionInactiveException;
import oracle.olapi.transaction.TransactionTypeUnavailableException;
import oracle.olapi.transaction.TransactionalObjectInvalidException;
import oracle.olapi.transaction.WriteLockException;
import oracle.olapi.transaction.metadataStateManager.MetadataState;
import oracle.olapi.transaction.metadataStateManager.MetadataStateManager;

public abstract class Template {
    private MetadataStateManager _stateManager;
    private DataProvider _dataProvider;
    private ArrayList _dynamicDefinitions;
    private ArraySet _cursorLocks;

    protected Template(MetadataState metadataState, DataProvider dataProvider) throws TransactionTypeUnavailableException, TransactionInactiveException {
        this(metadataState, dataProvider, dataProvider.getTransactionProvider().getCurrentTransactionForMetadataWrite());
    }

    protected Template(MetadataState metadataState, DataProvider dataProvider, Transaction transaction) throws TransactionTypeUnavailableException, TransactionInactiveException {
        this._stateManager = new MetadataStateManager(metadataState, transaction);
        this._dataProvider = dataProvider;
        this._dynamicDefinitions = new ArrayList();
        this._cursorLocks = new ArraySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _registerDynamicDefinition(DynamicDefinition dynamicDefinition) {
        ArrayList arrayList = this._dynamicDefinitions;
        synchronized (arrayList) {
            this._dynamicDefinitions.add(dynamicDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCursorLock(CursorLock cursorLock) throws CursorLockException {
        ArraySet arraySet = this._cursorLocks;
        synchronized (arraySet) {
            if (this._stateManager.getWriteLockTransaction() != null && cursorLock.getTransaction() != null && !cursorLock.getTransaction().isAncestorOf(this._stateManager.getWriteLockTransaction()) && !this._stateManager.getWriteLockTransaction().isAncestorOf(cursorLock.getTransaction())) {
                throw new CursorLockException();
            }
            this._cursorLocks.add(cursorLock);
        }
    }

    protected DynamicDefinition createDynamicDefinition(SourceGenerator sourceGenerator) {
        return new DynamicDefinition(this, sourceGenerator, this._dataProvider);
    }

    protected DynamicDefinition createDynamicDefinition(SourceGenerator sourceGenerator, Transaction transaction) {
        return new DynamicDefinition(this, sourceGenerator, this._dataProvider, transaction);
    }

    protected MetadataState getCurrentState() throws TransactionalObjectInvalidException, TransactionTypeUnavailableException, TransactionInactiveException {
        return this.getCurrentStateForWrite();
    }

    protected MetadataState getCurrentStateForRead() throws TransactionalObjectInvalidException, TransactionTypeUnavailableException, TransactionInactiveException {
        return this._stateManager.getCurrentStateForRead(this._dataProvider.getTransactionProvider().getCurrentTransactionForMetadataRead());
    }

    protected MetadataState getCurrentStateForWrite() throws TransactionalObjectInvalidException, TransactionTypeUnavailableException, TransactionInactiveException {
        return this._stateManager.getCurrentStateForWrite(this._dataProvider.getTransactionProvider().getCurrentTransactionForMetadataRead());
    }

    public DataProvider getDataProvider() {
        return this._dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursorLock(CursorLock cursorLock) {
        ArraySet arraySet = this._cursorLocks;
        synchronized (arraySet) {
            this._cursorLocks.remove(cursorLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCurrentState(MetadataState metadataState) throws CursorLockException, WriteLockException, TransactionTypeUnavailableException, TransactionInactiveException {
        Iterator iterator;
        Transaction transaction = this._dataProvider.getTransactionProvider().getCurrentTransactionForMetadataWrite();
        ArrayList arrayList = this._cursorLocks;
        synchronized (arrayList) {
            iterator = this._cursorLocks.iterator();
            while (iterator.hasNext()) {
                CursorLock cursorLock = (CursorLock)iterator.next();
                if (cursorLock.getTransaction() == null || cursorLock.getTransaction().isAncestorOf(transaction)) continue;
                throw new CursorLockException();
            }
            this._stateManager.setCurrentState(metadataState, transaction);
        }
        arrayList = this._dynamicDefinitions;
        synchronized (arrayList) {
            iterator = this._dynamicDefinitions.iterator();
            while (iterator.hasNext()) {
                ((DynamicDefinition)iterator.next()).templateStateChanged(transaction);
            }
        }
    }
}

