/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.olapi.UnsupportedOperationException;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.DerivedDefinition;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.transaction.Transaction;

public final class RecursiveJoinDefinition
extends DerivedDefinition {
    private SourceDefinition m_Joined = null;
    private SourceDefinition m_Comparison = null;
    private SourceDefinition m_Parent = null;
    private int m_ComparisonRule = 0;
    private boolean m_Visible = true;
    private boolean m_ParentsFirst = true;
    private boolean m_ParentsRestrictedToBase = true;
    private int m_MaxRecursions = -1;

    RecursiveJoinDefinition(SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, SourceDefinition sourceDefinition3, SourceDefinition sourceDefinition4, int n, boolean bl, boolean bl2, int n2, boolean bl3, Transaction transaction) {
        super(sourceDefinition.getDataProvider()._getSourceIDProvider().createJoinID(), sourceDefinition, transaction);
        this.setJoined(sourceDefinition2);
        this.setComparison(sourceDefinition3);
        this.setParent(sourceDefinition4);
        this.setParentsFirst(bl);
        this.setParentsRestrictedToBase(bl2);
        this.setMaxRecursions(n2);
        this.setComparisonRule(n);
        this.setVisible(bl3);
    }

    public final Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitRecursiveJoinDefinition(this, object);
    }

    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
        this.getBase().accumulateInputs(set, transaction, false, true);
        this.accumulateUnmatchedInputs(this.getJoined(), this.getBase(), set, bl, bl2, transaction);
        this.getComparison().accumulateInputs(set, transaction, bl, bl2);
    }

    final void accumulateOutputs(List list, Transaction transaction) {
        if (this.isVisible()) {
            list.add(this.getJoined().findOrCreateSource(transaction));
        }
        this.getBase().accumulateOutputs(list, transaction);
    }

    private void accumulateUnmatchedInputs(SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, Set set, boolean bl, boolean bl2, Transaction transaction) {
        SourceDefinition sourceDefinition3;
        Source source;
        HashSet hashSet = new HashSet();
        sourceDefinition.accumulateInputs(hashSet, transaction, false, true);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            source = (Source)iterator.next();
            sourceDefinition3 = sourceDefinition2.findMatchFor(source.getDefinition(), transaction);
            if (sourceDefinition3 != null) {
                throw new UnsupportedOperationException("Extraction input matched");
            }
            if (bl2) {
                // empty if block
            }
            set.add(source);
        }
        if (!bl) {
            return;
        }
        hashSet.clear();
        sourceDefinition.accumulateInputs(hashSet, transaction, true, false);
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            source = (Source)iterator.next();
            sourceDefinition3 = sourceDefinition2.findMatchFor(source.getDefinition(), transaction);
            if (sourceDefinition3 != null) continue;
            set.add(source);
        }
    }

    public final SourceDefinition getComparison() {
        return this.m_Comparison;
    }

    public final int getComparisonRule() {
        return this.m_ComparisonRule;
    }

    public final SourceDefinition getJoined() {
        return this.m_Joined;
    }

    public final boolean isVisible() {
        return this.m_Visible;
    }

    public SourceDefinition getParent() {
        return this.m_Parent;
    }

    public boolean isParentsFirst() {
        return this.m_ParentsFirst;
    }

    public boolean isParentsRestrictedToBase() {
        return this.m_ParentsRestrictedToBase;
    }

    public int getMaxRecursions() {
        return this.m_MaxRecursions;
    }

    private void matchInputsToOutputs(SourceDefinition sourceDefinition, SourceDefinition sourceDefinition2, Transaction transaction) {
        Set set = sourceDefinition.getInputs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Source source = (Source)iterator.next();
        }
    }

    private void setComparison(SourceDefinition sourceDefinition) {
        this.m_Comparison = sourceDefinition;
    }

    private void setComparisonRule(int n) {
        this.m_ComparisonRule = n;
    }

    private void setJoined(SourceDefinition sourceDefinition) {
        this.m_Joined = sourceDefinition;
    }

    private void setVisible(boolean bl) {
        this.m_Visible = bl;
    }

    private void setParent(SourceDefinition sourceDefinition) {
        this.m_Parent = sourceDefinition;
    }

    private void setParentsFirst(boolean bl) {
        this.m_ParentsFirst = bl;
    }

    private void setParentsRestrictedToBase(boolean bl) {
        this.m_ParentsRestrictedToBase = bl;
    }

    private void setMaxRecursions(int n) {
        this.m_MaxRecursions = n;
    }
}

