/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.source.Assignment;
import oracle.olapi.data.source.CustomModel;
import oracle.olapi.data.source.DataDescriptorDefinitionVisitor;
import oracle.olapi.data.source.ImmutableDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.transaction.Transaction;

public final class ModelSolutionDefinition
extends ImmutableDefinition {
    private Model m_Model = null;
    private SourceDefinition m_DefaultValues = null;

    ModelSolutionDefinition(Model model, SourceDefinition sourceDefinition, Transaction transaction) {
        super(sourceDefinition.getDataProvider()._getSourceIDProvider().createModelSolutionID(), sourceDefinition.getDataProvider(), transaction);
        this.m_Model = model;
        this.m_DefaultValues = sourceDefinition;
    }

    public final Object acceptVisitor(DataDescriptorDefinitionVisitor dataDescriptorDefinitionVisitor, Object object) {
        return dataDescriptorDefinitionVisitor.visitModelSolutionDefinition(this, object);
    }

    final void accumulateInputs(Set set, Transaction transaction, boolean bl, boolean bl2) {
        set.addAll(this.getModel().getInputs());
        this.getDefaultValuesDefinition().accumulateInputs(set, transaction, bl, bl2);
    }

    final void accumulateOutputs(List list, Transaction transaction) {
        list.addAll(this.getModel().getOutputs());
    }

    protected SourceDefinition getType() {
        return this.getModel().getType().getDefinition();
    }

    public Model findOrCreateExtractModel(Source source, Transaction transaction) {
        CustomModel customModel = this.getDataProvider().createModel(source, this.getModel().getType());
        Iterator iterator = this.getModel().getAssignments().iterator();
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            Model model = assignment.getAssignedSource().getDefinition().findOrCreateExtractModel(source, transaction);
            Iterator iterator2 = model.getAssignments().iterator();
            while (iterator2.hasNext()) {
                Assignment assignment2 = (Assignment)iterator2.next();
                assignment2.assign(customModel, assignment.getAssignedSource(), source);
            }
        }
        return customModel;
    }

    public final Model getModel() {
        return this.m_Model;
    }

    public final SourceDefinition getDefaultValuesDefinition() {
        return this.m_DefaultValues;
    }
}

